/*	DESKTOP.C	13-11-2001 John Elliott		*/
/*
*       Copyright 2001 John Elliott                                     
*       This software is licenced under the GNU Public License.         
*       Please see LICENSE.TXT for further information.                 
*                                                                       
*/

#include "ppddesk.h"


char *scasb(char *s, char b)
{
	char *t = strchr(s, b);

	if (t) return t;
	return s + strlen(s);
}



WORD wmax(WORD a, WORD b)
{
	return (a > b) ? a : b;
}

WORD wmin(WORD a, WORD b)
{
	return (a < b) ? a : b;
}

extern VOID dos_lpvoid(UWORD, LPVOID);


VOID dos_label(BYTE drive, BYTE *plabel)
{
	BYTE		label_buf[128];
	BYTE		ex_fcb[40];

	dos_sdta(ADDR(&label_buf[0]));
	ex_fcb[0] = -1;
	memset(ex_fcb + 1, 0, 5);
	ex_fcb[6] = 0x08;		/* volume label	*/
	ex_fcb[7] = drive;
	memset(ex_fcb + 8, '?', 11);
	memset(ex_fcb +19, 0,   21);

	dos_lpvoid(0x1100, ADDR(&ex_fcb[0]));

	if ( (DOS_AX & 0x00ff) == 0xff )
	  *plabel = 0;
	else
	{
	  label_buf[19] = 0x0;
	  strcpy(plabel, label_buf + 8);
	}
}


WORD LSTCPY(LPBYTE d, LPBYTE s)
{
	while (*s) 
	{
		 *(d++) = *(s++);
	}
	*d = 0;
	return 1;
}

VOID r_get(GRECT *pxywh, WORD *px, WORD *py, WORD *pw, WORD *ph)
{
	*px = pxywh->g_x;
	*py = pxywh->g_y;
	*pw = pxywh->g_w;
	*ph = pxywh->g_h;
}



VOID r_set(GRECT *pxywh, WORD x, WORD y, WORD w, WORD h)
{
	pxywh->g_x = x;
	pxywh->g_y = y;
	pxywh->g_w = w;
	pxywh->g_h = h;
}

	UWORD
inside(x, y, pt)		/* determine if x,y is in rectangle	*/
	WORD		x, y;
	GRECT		*pt;
	{
	if ( (x >= pt->g_x) && (y >= pt->g_y) &&
	    (x < pt->g_x + pt->g_w) && (y < pt->g_y + pt->g_h) )
		return(TRUE);
	else
		return(FALSE);
	} /* inside */


VOID rc_union(LPGRECT p1, LPGRECT p2)
	{
	WORD		tx, ty, tw, th;

	tw = wmax(p1->g_x + p1->g_w, p2->g_x + p2->g_w);
	th = wmax(p1->g_y + p1->g_h, p2->g_y + p2->g_h);
	tx = wmin(p1->g_x, p2->g_x);
	ty = wmin(p1->g_y, p2->g_y);
	p2->g_x = tx;
	p2->g_y = ty;
	p2->g_w = tw - tx;
	p2->g_h = th - ty;
	}
	


#if DEBUG
static char buf[4096];

WORD form_valert(WORD button, BYTE *str, ...)
{
	va_list ap;
	va_start(ap, str);
	vsprintf(buf, str, ap);
	va_end(ap);
	return form_alert(button, ADDR(buf));
}

WORD dbg(BYTE *str, ...)
{
	FILE *fp = fopen("d:/gemapp.log", "a");
	
	va_list ap;
	va_start(ap, str);
	vfprintf(fp, str, ap);
	va_end(ap);

	fclose(fp);
}

#endif


