

/************************************************************************/
/*                                                                      */
/*                  ****   *     *  ***  *   *  ****                    */
/*                  *   *  *     *   *   **  *  *   *                   */
/*                  ****   *     *   *   * * *  *   *                   */
/*                  *   *  *  *  *   *   *  **  *   *                   */
/*                  ****    ** **   ***  *   *  ****                    */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                           Window functions                           */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "bench.h"       /* GEM and workbench bindings */
LONG_GRECT __previous_area;





/***************************************************************************/
/*                                                                         */
/*                          __grect_assign                                 */
/*                                                                         */
/*                  Sets object to equal the value of source               */
/*                                                                         */
/***************************************************************************/

__grect_assign (object, source)
GRECT *object, *source;

{

  object -> g_x = source -> g_x;
  object -> g_y = source -> g_y;
  object -> g_w = source -> g_w;
  object -> g_h = source -> g_h;

}



/***************************************************************************/
/*                                                                         */
/*               __intersect combines the second and                       */
/*              third rectangles to produce the first                      */
/*                                                                         */
/***************************************************************************/

BOOLEAN __intersect (target, subject)
GRECT *target, *subject;

{ WORD x, y;

  x = __max (target -> g_x, subject -> g_x);
  y = __max (target -> g_y, subject -> g_y);

  target -> g_w = __min (target  -> g_x + target  -> g_w,
                         subject -> g_x + subject -> g_w) - x;
  target -> g_h = __min (target  -> g_y + target  -> g_h,
                         subject -> g_y + subject -> g_h) - y;

  target -> g_x = x;
  target -> g_y = y;

  return ((target -> g_w > 0) && (target -> g_h > 0));

}



/***************************************************************************/
/*                                                                         */
/*                 __union combines the second and                         */
/*              third rectangles to produce the first                      */
/*                                                                         */
/***************************************************************************/

__union (target, subject) 
GRECT *target, *subject;

{ WORD x, y;

  x = __min (target -> g_x, subject -> g_x);
  y = __min (target -> g_y, subject -> g_y);

  target -> g_w = __max (target -> g_x + target -> g_w,
                         subject -> g_x + subject -> g_w) - x;
  target -> g_h = __max (target -> g_y + target -> g_h,
                         subject -> g_y + subject -> g_h) - y;

  target -> g_x = x;
  target -> g_y = y;

}




/***************************************************************************/
/*                                                                         */
/*                          __getarea                                      */
/*                                                                         */
/*          Returns the absolute dimensions of an item from a tree         */
/*                                                                         */
/***************************************************************************/

__getarea (tree, item, target)
LONG tree;
WORD item;
GRECT *target;

{

  objc_offset (tree, item, &(target -> g_x), &(target -> g_y));
  target -> g_w = LWGET (OB_WIDTH (item));
  target -> g_h = LWGET (OB_HEIGHT (item));

}




/***************************************************************************/
/*                                                                         */
/*                          __preserve_area                                */
/*                                                                         */
/*                   Preserves current theoretical area                    */
/*                                                                         */
/***************************************************************************/

__preserve_area (which)
WORD        which;  /* Workbench's window handle */

{

  __previous_area.l_x = (__window [which]._theoretical_area).l_x;
  __previous_area.l_y = (__window [which]._theoretical_area).l_y;
  __previous_area.l_w = (__window [which]._theoretical_area).l_w;
  __previous_area.l_h = (__window [which]._theoretical_area).l_h;

}



/***************************************************************************/
/*                                                                         */
/*                          __get_window                                   */
/*                                                                         */
/*             Does a wind_get into a GRECT variable                       */
/*                                                                         */
/***************************************************************************/

__get_window (which, option, rectangle)
WORD   which,       /* Workbench's window handler */
       option;      /* the key wind_get parameter */
GRECT *rectangle;   /* the rectangle being got */

{

  wind_get (__window [which]._handler, option, &(rectangle -> g_x), 
            &(rectangle -> g_y), &(rectangle -> g_w), &(rectangle -> g_h));

           /* (pain this; half the C compilers I know would let me get
               away with rectangle.g_? above, instead of having to use 
               both '&' and '->'). */
}



/***************************************************************************/
/*                                                                         */
/*                          __set_window                                   */
/*                                                                         */
/*             Does a wind_set from a GRECT variable                       */
/*                                                                         */
/***************************************************************************/

__set_window (which, option, rectangle)
WORD   which,       /* Workbench's window handler */
       option;      /* the key wind_get parameter */
GRECT *rectangle;   /* the rectangle being got */

{

  wind_set (__window [which]._handler, option, rectangle -> g_x, 
            rectangle -> g_y, rectangle -> g_w, rectangle -> g_h);

}




/***************************************************************************/
/*                                                                         */
/*                          __calc_window                                  */
/*                                                                         */
/*             Does a wind_calc using GRECT variables                      */
/*                                                                         */
/***************************************************************************/

__calc_window (calculation, components, source, object)
WORD   calculation,     /* zero or one as defined in manual */
       components;      /* windows components */
GRECT *source, *object; /* start and finish states of calculation */ 

{

  wind_calc (calculation, components, source -> g_x, source -> g_y, 
             source -> g_w, source -> g_h, &(object -> g_x), 
             &(object -> g_y), &(object -> g_w), &(object -> g_h));

}



/***************************************************************************/
/*                                                                         */
/*                          __aesbench                                     */
/*                                                                         */
/*       Given an AES window handler, returns the workbench's handler      */
/*                                                                         */
/***************************************************************************/

WORD __aesbench (hndlr)
WORD hndlr;       /* GEM AES handler */

{ int x;

  /* OK, lets find the thing */

  for (x = 0; x < QUANTITY_WINDOWS; x++)
    if (__window [x]._handler == hndlr)
      return (x);

  /* what thing ? */

  return (-1);

}





/***************************************************************************/
/*                                                                         */
/*                         __doslide                                       */
/*                                                                         */
/*   This function calculates the new size and position of a slider bar.   */
/*                                                                         */
/***************************************************************************/

__doslide (which, objc_position, objc_size, wind_position, wind_size, 
          WF_position_constant, WF_size_constant)
WORD which,                /* which window are we working on? */
     wind_position,        /* window x or y */
     wind_size,            /* window width or height */
     WF_position_constant, /* either WF_HSLIDE or WF_VSLIDE */
     WF_size_constant;     /* either WF_HSLSIZ or WF_VSLSIZ */
LONG objc_position,        /* object's x or y */
     objc_size;            /* object's width or height */

{ LONG n;        /* temporary variable */
  WORD size,     /* the actual slider size */
       position, /* the actual slider position */
       v;        /* temporary variable */

  /* consider size first ... */

  if ((LONG) wind_size >= objc_size)
    size = 1000;

  else {

    /* calculate size of slider as a comparision of the object's and
       window's size. */

    n = (LONG) wind_size * 1000L / objc_size;
    size = (WORD) n;

  }

  /* then position ... */

  if ((LONG) wind_position <= objc_position)
    position = 1;

  else {

    /* calculate position of slider as position of window edge within 
       space available for window movement (eg difference between 
       window size and object size). */

    n = (LONG) (wind_position - objc_position) *
                1000L / (objc_size - wind_size);
    position = (WORD) n;

  }

  /* set slider bar in window */

  wind_get (__window [which]._handler, WF_position_constant, &v, 0, 0, 0);

  if (v != position)
    wind_set (__window [which]._handler, WF_position_constant, 
              position, 0, 0, 0);

  wind_get (__window [which]._handler, WF_size_constant, &v, 0, 0, 0);

  if (v != size)
    wind_set (__window [which]._handler, WF_size_constant, size, 0, 0, 0);

}




/***************************************************************************/
/*                                                                         */
/*                            __slider                                     */
/*                                                                         */
/*   This function calulates the size and position of the window's slider  */
/* bars. It assumes that the window's object tree contains the entire      */
/* contents of the window.                                                 */
/*                                                                         */
/***************************************************************************/

BOOLEAN __slider (which)
WORD which; /* which window (workbench number) */

{ GRECT window_position; /* Go on, have a guess ... */

  __get_window (which, WF_WXYWH, &window_position);

  /* if the window has a horizontal slider, reposition accordingly */

  if (__window [which]._components & HSLIDE)
    __doslide (which, (__window [which]._theoretical_area).l_x, 
                      (__window [which]._theoretical_area).l_w, 
               window_position.g_x, window_position.g_w,
               WF_HSLIDE, WF_HSLSIZ);

  /* ditto for vertical slider */

  if (__window [which]._components & VSLIDE)
    __doslide (which, (__window [which]._theoretical_area).l_y, 
                      (__window [which]._theoretical_area).l_h, 
               window_position.g_y, window_position.g_h,
               WF_VSLIDE, WF_VSLSIZ);

}




/***************************************************************************/
/*                                                                         */
/*                        __gredraw                                        */
/*                                                                         */
/*        Draws the area of the window defined by the GRECT parameter      */
/*                                                                         */
/***************************************************************************/

__gredraw (element, redraw_area)
WORD   element;     /* Workbench window handler */
GRECT *redraw_area; /* area of window to redraw */ 

{ GRECT temp,         /* just in case area is NULL */
        window_area;  /* current redraw rectangle of window */
  LONG  tree;         /* window zero tree */

  /* NOTE: this code is strangely similiar to the redraw specification
           found in the manual (under the window library). This is not
           entirely a coincidence. */

  /* if no redraw area provided, make it the window's work area */

  if (redraw_area == NULL) {

    __get_window (element, WF_WXYWH, &temp);
    redraw_area = &temp;

  }

  /* lock the window and get it's first rectangle */

  wind_update (1);
  __get_window (element, WF_FIRSTXYWH, &window_area);

  /* consider all the window's rectangles */

  while (window_area.g_w && window_area.g_h) {

    /* if there is a common area, draw it */

    if (__intersect (&window_area, redraw_area))
      (*__window [element]._drawer) (element, &window_area);

    /* and get the next rectangle */

    __get_window (element, WF_NEXTXYWH, &window_area);

  }

  /* finished */

  wind_update (0);

  /* redraw desktop */

  if ((! __window [0]._handler) && 
      ((tree = __window [0]._contents) != GEM_NULL))
    wind_set (0, WF_NEWDESK, LLOWD (tree), LHIWD (tree), 0, 0);

}





/***************************************************************************/
/*                                                                         */
/*                              __redraw                                   */
/*                                                                         */
/*        This function responds to instructions from GEM                  */
/*                   to redraw a window's contents                         */
/*                                                                         */
/***************************************************************************/

__redraw (aes_handler, x, y, w, h)
WORD aes_handler, /* GEM's AES window handler */
     x, y, w, h;  /* the rectangle on the screen to redraw */

{ GRECT redraw_area;  /* Ian Botham's average run rate */
  WORD  element;      /* the workbench's window handler */

  /* If the window belongs to this program ... */

  if ((element = __aesbench (aes_handler)) >= 0) {

    /* redraw it */

    GFILL (redraw_area, x, y, w, h);
    __gredraw (element, &redraw_area);

  }

}




/**********************************************************************/
/*                                                                    */
/*                           Wb_redraw                                */
/*                                                                    */
/*   This functions redraws the specified window. It takes one        */
/* parameter, the window handler.                                     */
/*                                                                    */
/**********************************************************************/

wb_redraw (which)
WORD which;

{ 

  /* wb_redraw redraws and sets sliders! */

  __gredraw (which, NULL);
  __slider (which);

}



/**********************************************************************/
/*                                                                    */
/*                             wb_qdraw                               */
/*                                                                    */
/*   This functions is a simple drawing function for use when drawing */
/* windows. It lifts the x, y position of the theoretical window      */
/* contents, and sets _contents to be that value, and then does an    */
/* objc_draw. If the window's display tree is a dialogue or free tree */
/* generated by the RCS, then this routine can be fed to WB_OPEN as   */
/* the display routine, provided that the dialogue contains the       */
/* entire "contents" of the windows.                                  */
/*                                                                    */
/**********************************************************************/

wb_qdraw (which, area)
WORD   which;  /* workbench window handler */
GRECT *area;   /* area on screen to redraw (clip) */ 

{ WORD x, y;
  LONG tree;

  if ((tree = __window [which]._contents) != GEM_NULL) {

    /* get contents' x, y position */

    x = (WORD) (__window [which]._theoretical_area).l_x;
    y = (WORD) (__window [which]._theoretical_area).l_y;

    /* position tree there */

    LWSET (OB_X (0), x);
    LWSET (OB_Y (0), y);

    /* and do the draw */

    objc_draw (tree, ROOT, MAX_DEPTH, area -> g_x, area -> g_y, area -> g_w,
               area -> g_h);

  }

}



/***************************************************************************/
/*                                                                         */
/*                        __calc_scroll                                    */
/*                                                                         */
/*  Calculates scroll area in either x or y dimension                      */
/*                                                                         */
/***************************************************************************/

__calc_scroll (old_position, new_position, limit, vdi_area, start_position, 
               start_size, finish_position, finish_size, window_position,
               window_size)
LONG old_position,      /* previous position of contents (x or y) */
     new_position;      /* current position (x or y) */
WORD limit,             /* maximum movement for scroll (otherwise redraw) -
                           included because vertical transformations are
                           much faster than horizontal */
     vdi_area [],       /* copy source and destination (VDI format) */
     start_position,    /* index in array for source x or y co-ordinate */
     start_size,        /* ditto, except source width or height */
     finish_position,   /* ditto, except destination x or y */
     finish_size,       /* ditto, except destination width or height */
     *window_position,  /* redraw area x or y (initiallly window work area */
     *window_size;      /* redraw area width or height */

{ LONG difference;      /* difference between new and old positions */

  /* if there is a change ... */

  if ((difference = new_position - old_position) != 0) {

    /* if movement to the right (down) ... */

    if ((difference > 0) && 
        (difference < (LONG) ((*window_size - 1)/limit))) {

      vdi_area [finish_position] += (WORD) difference;
      vdi_area [start_size] -= (WORD) difference;
      *window_size = (WORD) difference;

    } else

    /* perhaps movement was in the other direction ... */

    if ((difference < 0) && 
        (-1 * difference < (LONG) ((*window_size - 1)/limit))) {

      vdi_area [start_position] -= (WORD) difference;
      vdi_area [finish_size] += (WORD) difference;
      *window_position += *window_size + (WORD) difference;
      *window_size = -1 * (WORD) difference;

    }

   /* otherwise there was no movement, so shut up and bail out. */

  }

}



/***************************************************************************/
/*                                                                         */
/*                        __scroll                                         */
/*                                                                         */
/*  "Scrolls" the screen following slider or incremental movement, by      */
/*  raster copying, avoiding unecessary redrawing (hopefully).             */
/*                                                                         */
/***************************************************************************/

__scroll (which)
WORD    which;      /* Workbench's window handler (must be current window) */

{ GRECT work,        /* window's work (and redraw) area */
        full;
  MFDB  the_MFDB;    /* part of screen to be scrolled */
  WORD  vdi_area [8];  /* parts of the screen being moved */
  LONG  difference;  /* contents movement */

  /* Get window's work area and use it to set starting and terminating
     copy areas on the screen */

  __get_window (which, WF_WXYWH, &work);
  __get_window (0, WF_WXYWH, &full);

  /* do not scroll if window is large, since that looks untidy 
     (redraw instead) */

  if ((work.g_w < (2 * full.g_w/3)) && (work.g_h < (2 * full.g_h/3))) {

    the_MFDB.mp = 0L;
    vdi_area [0] = vdi_area [4] = work.g_x;
    vdi_area [1] = vdi_area [5] = work.g_y;
    vdi_area [2] = vdi_area [6] = work.g_x + work.g_w - 1;
    vdi_area [3] = vdi_area [7] = work.g_y + work.g_h - 1;

    /* calculate transformation and redraw areas */

    __calc_scroll (__previous_area.l_x, 
                   (__window [which]._theoretical_area).l_x,
                   4, vdi_area, 0, 2, 4, 6, &(work.g_x), &(work.g_w));
    __calc_scroll (__previous_area.l_y,
                   (__window [which]._theoretical_area).l_y,
                   1, vdi_area, 1, 3, 5, 7, &(work.g_y), &(work.g_h));

    /* do raster copy, redraw and sort out sliders */

    graf_mouse (M_OFF, GEM_NULL);
    vro_cpyfm (__vdi_handle, 3, vdi_area, &the_MFDB, &the_MFDB);
    graf_mouse (M_ON, GEM_NULL);
  
  }

  (*__window [which]._drawer) (which, &work);
  __slider (which);

}




/***************************************************************************/
/*                                                                         */
/*                        __bringtop                                       */
/*                                                                         */
/*        Responds to user's request to bring a window to the top,         */
/*                 or when a window is put on top                          */
/*                                                                         */
/***************************************************************************/

__bringtop (aes_handler, ontop, reply)
WORD  aes_handler,  /* GEM AES's window handler */
     *reply,        /* those workbench events which occured */
      ontop;        /* TRUE is window has been put on top */

{ WORD win;

  /* if it's a workbench window ... */

  if ((win = __aesbench (aes_handler)) <= 0)
    return;

  /* put it on top if its not already there */

  if (! ontop) {

    __itemrelease (win, reply);
    wind_set (aes_handler, WF_TOP, aes_handler, 0, 0, 0);

  }

  /* and set the global current window variable */
 
  __curwin = win;

}




/***************************************************************************/
/*                                                                         */
/*                        __do_increment                                   */
/*                                                                         */
/*    This function adjusts the position of a window's contents as a       */
/*       result of an arrow click or click on a shaded slider bar.         */
/*          It returns true if movement is necessary                       */
/*                                                                         */
/***************************************************************************/

BOOLEAN __do_increment (distance, position, length, window_position,
                        window_length, unit_length)
WORD  distance,        /* what the user clicked */
      window_position, /* current window position (x or y) */
      window_length,   /* current window width or height */
      unit_length;     /* arrow movement distance */
LONG *position,        /* current and modified position of object (x or y) */
      length;          /* current length of object (width or height) */

{ LONG    old;         /* previous position of contents */

  /* NOTE: this function uses vertical dimension constants, even if it
     is working in the horizontal direction.                           */

  /* pretend working in vertical dimension */

  if (distance > WA_DNLINE)
    distance -= (WA_DNLINE + 1); /* assumes DR constants keep same order */

  old = *position;

  /* Modify position according to the movement chosen */

  switch (distance) {

    /* page up */

    case WA_UPPAGE :
      *position += window_length;
      break;

    /* page down */

    case WA_DNPAGE :
      *position -= window_length;
      break;

    /* line up */

    case WA_UPLINE :
      *position += unit_length;
      break;

    /* line down */

    case WA_DNLINE :
      *position -= unit_length;
      break;

  }

  /* make sure revised position still fits under the window */

  if (*position > window_position)
    *position = window_position;

  else
  if (*position + length < window_position + window_length)
    *position = window_position + window_length - length;

  return (old != position);

}




/***************************************************************************/
/*                                                                         */
/*                         __increment                                     */
/*                                                                         */
/*        This function is called when the user selects one of             */
/*       the window movement components, such as an arrow or the           */
/*        shaded area of the slider bar. It does not handle the            */
/*         movement of the slider bar by the user.                         */
/*                                                                         */
/***************************************************************************/

__increment (aes_handler, direction)
WORD aes_handler, /* GEM's AES window handler */
     direction;   /* what was selected (defined in manual) */

{ GRECT window_area;  /* window's dimensions */
  BOOLEAN changed;    /* TRUE if movement actually occurs */
  WORD which;         /* Workbench window handler */

  /* NOTE: when the user selects a movement component, the program does */
  /* not move the window, it moves the object tree underneath in the    */
  /* opposite direction. An arrow moves by one character (eg line in    */
  /* the vertical direction), and clicking on the slider bar moves the  */
  /* full width of the window.                                          */

  /* get details of the window */

  if ((which = __aesbench (aes_handler)) <= 0)
    return;

  __get_window (which, WF_WXYWH, &window_area);
  __preserve_area (which);

  /* if moving horizontally ... */

  if (direction > 3)
    changed = __do_increment ( direction, 
                              &(__window [which]._theoretical_area).l_x,
                               (__window [which]._theoretical_area).l_w,
                               window_area.g_x, window_area.g_w, 
                               __window [which]._across_move);

  else
    changed = __do_increment ( direction, 
                              &(__window [which]._theoretical_area).l_y,
                               (__window [which]._theoretical_area).l_h,
                               window_area.g_y, window_area.g_h, 
                               __window [which]._up_move);


  /* if a change made, modify sliders and redraw object tree */

  if (changed)
    __scroll (which);

}




/***************************************************************************/
/*                                                                         */
/*                      __do_absolute_slide                                */
/*                                                                         */
/*        This function is called when the user moves the                  */
/*            either the horizontal or vertical slider.                    */
/*                                                                         */
/***************************************************************************/

__do_absolute_slide (which, object_position, object_size, 
                     window_position, window_size, amount)
LONG *object_position, /* object x for horizontal, y otherwise */
      object_size;     /* ditto for width or height */
WORD  which,           /* workbench's window handler */
      window_position, /* window x or y */
      window_size,     /* window width or height */
      amount;          /* selected position of slider */

{ LONG old_position;   /* new position of object x or y */

  __preserve_area (which);
  old_position = *object_position;
  *object_position = (LONG) (object_size - window_size) * amount;
  *object_position = window_position - *object_position/1000;

  if (old_position != *object_position)
    __scroll (which);

}



/***************************************************************************/
/*                                                                         */
/*                           __hslide                                      */
/*                                                                         */
/*        This function is called when the user moves the                  */
/*                the horizontal slider by some amount.                    */
/*                                                                         */
/***************************************************************************/

__hslide (aes_handler, amount)
WORD aes_handler, /* GEM's AES window handler */
     amount;      /* new position of slider */

{ GRECT window_area;  /* current dimension of window */
  LONG_GRECT old_area;/* theoretical size at before movement */
  WORD  which;        /* the workbench's window handler */
  LONG  newx;         /* new position of contents */

  /* get window details */

  if ((which = __aesbench (aes_handler)) <= 0)
    return;

  __get_window (which, WF_WXYWH, &window_area);

  /* calculate new position of tree */

  __do_absolute_slide (which, &((__window [which]._theoretical_area).l_x),
                       (__window [which]._theoretical_area).l_w,
                       window_area.g_x, window_area.g_w, amount);

}



/***************************************************************************/
/*                                                                         */
/*                             __vslide                                    */
/*                                                                         */
/*        This function is called when the user moves the                  */
/*                  the vertical slider by some amount.                    */
/*                                                                         */
/*      This function is identical to that above, apart from dimension     */
/*                   so I'm not going to comment it (lazy)                 */
/*                                                                         */
/***************************************************************************/

__vslide (aes_handler, amount)
WORD aes_handler, /* GEM's AES window handler */
     amount;      /* new position of slider */

{ GRECT window_area;  /* current dimension of window */
  WORD  which;        /* the workbench's window handler */
  LONG  newy;         /* new position of contents */

  /* get window details */

  if ((which = __aesbench (aes_handler)) <= 0)
    return;

  __get_window (which, WF_WXYWH, &window_area);

  /* calculate new position of tree */

  __do_absolute_slide (which, &((__window [which]._theoretical_area).l_y),
                       (__window [which]._theoretical_area).l_h,
                       window_area.g_y, window_area.g_h, amount); 

}




/***************************************************************************/
/*                                                                         */
/*                             __resize                                    */
/*                                                                         */
/*        This function is called when the user selects a new              */
/*                       size for the window.                              */
/*                                                                         */
/***************************************************************************/

__resize (aes_handler, x, y, w, h)
WORD aes_handler, /* GEM's AES window handler */
     x, y, w, h;  /* the new size chosen by the user */

{ WORD  element;       /* Workbench window handler */
  GRECT chosen_area,   /* GRECT version of parameters */
        old_area,      /* work area prior to resize */ 
        extra_area,    /* rectangle in new window not in old area */
        work_area;     /* current object dimensions */
  LONG  tree;          /* the window's object tree */
  BOOLEAN moved;       /* TRUE if need to move object under window */

  /* get current object details */

  if ((element = __aesbench (aes_handler)) <= 0)
    return;

  /* calculate new work area */

  __get_window (element, WF_WXYWH, &old_area);
  GFILL (chosen_area, x, y, w, h);

  __calc_window (1, __window [element]._components, 
                 &chosen_area, &work_area);

  /* if contents doesn't fit, move it */

  if (moved = ((LONG) work_area.g_x + (LONG) work_area.g_w >
      (__window [element]._theoretical_area).l_x +
      (__window [element]._theoretical_area).l_w))

    (__window [element]._theoretical_area).l_x = 
      (LONG) work_area.g_x + (LONG) work_area.g_w - 
      (__window [element]._theoretical_area).l_w;

  if (moved |= ((LONG) work_area.g_y + (LONG) work_area.g_h >
      (__window [element]._theoretical_area).l_y +
      (__window [element]._theoretical_area).l_h))

    (__window [element]._theoretical_area).l_y = 
      (LONG) work_area.g_y + (LONG) work_area.g_h - 
      (__window [element]._theoretical_area).l_h;

  /* change size of window (and the slider positions) */

  __set_window (element, WF_CXYWH, &chosen_area);

  if ((! moved) && (__window [element]._contents != GEM_NULL)) {

    /* if the object hasn't moved, attempt to draw in extra area of window
       directly without redrawing the entire contents */

    /* note that the redraw supression flag is not set if both areas are
       unreal - eg if both the width and height is negative, since GEM
       will not issue a redraw message in these circumstances. */

    /* work out new part of window on the right */

    extra_area.g_x = old_area.g_x + old_area.g_w;
    extra_area.g_w = work_area.g_w - old_area.g_w;
    extra_area.g_y = old_area.g_y;
    extra_area.g_h = __min (old_area.g_h, work_area.g_h);

    /* if its real, redraw it */
 
    if (extra_area.g_w > 0) {

      __wb_flags |= WB_SUPRESS_REDRAW;
      __gredraw (element, &extra_area);

    }

    /* ditto for below area (which includes area to the bottom right) */

    extra_area.g_x = work_area.g_x;
    extra_area.g_w = work_area.g_w;
    extra_area.g_y = old_area.g_y + old_area.g_h;
    extra_area.g_h = work_area.g_h - old_area.g_h;

    /* again, if real do a redraw */

    if (extra_area.g_h > 0) {

      __wb_flags |= WB_SUPRESS_REDRAW;
      __gredraw (element, &extra_area);

    }

  }

  __slider (element);

}



/***************************************************************************/
/*                                                                         */
/*                          __reposition                                   */
/*                                                                         */
/*        This function is called when the user selects a new              */
/*                   position for the window.                              */
/*                                                                         */
/***************************************************************************/

__reposition (aes_handler, x, y, w, h)
WORD aes_handler, /* GEM's AES window handler */
     x, y, w, h;  /* new position of window */

{ WORD  element,      /* Workbench window handler */
        position,     /* current position of contents */
        xdiff, ydiff; /* content's movement */
  GRECT chosen_area,  /* GRECTified parameters */
        new_area,     /* new window dimensions */
        old_area;     /* current window dimensions */
  LONG  tree;         /* contents of window */

  /* get existing window and object dimensions etc. */

  if ((element = __aesbench (aes_handler)) <= 0)
    return;

  GFILL (chosen_area, x, y, w, h);
  __get_window (element, WF_WXYWH, &old_area);

  /* calculate new work area */

  __calc_window (1, __window [element]._components, &chosen_area, &new_area);

  /* adjust position of object so it moves with the window */

  xdiff = (new_area.g_x - old_area.g_x);
  ydiff = (new_area.g_y - old_area.g_y);
  (__window [element]._theoretical_area).l_x += (LONG) xdiff;
  (__window [element]._theoretical_area).l_y += (LONG) ydiff;

  /* ditto for contents of window (redraw may not be forced) */

  if ((tree = __window [element]._contents) != GEM_NULL) {

    position = LWGET (OB_X (0)) + xdiff;
    LWSET (OB_X (0), position);
    position = LWGET (OB_Y (0)) + ydiff;
    LWSET (OB_Y (0), position);

  }

  /* and reposition window */

  wind_set (aes_handler, WF_CXYWH, x, y, w, h);

}



/***************************************************************************/
/*                                                                         */
/*                           __fulled                                      */
/*                                                                         */
/*        This function is called when the user selects the full           */
/*       window toggle from the window's components. It toggles the        */
/*         size of a window, remembering the small size if need be.        */
/*                                                                         */
/***************************************************************************/

__fulled (aes_handler)
WORD aes_handler;   /* GEM's AES window handler */

{ GRECT new,    /* new size of window */
        old,    /* old work area */
        work;   /* work area of new window */
  WORD  which;  /* the workbench's window handler */
  LONG  tree;   /* window's object tree */

  /* get the work bench's window handler */

  if ((which = __aesbench (aes_handler)) <= 0)
    return;

  __get_window (which, WF_WXYWH, &old);

  if (__window [which]._full_size = ! __window [which]._full_size) {

    /* if not full window, remember old window size and get new one */

    __get_window (which, WF_CXYWH, &(__window [which]._old));
    __get_window (which, WF_FXYWH, &new);

  } else

  /* if a full window, recall old window size */

    __grect_assign (&new, &__window [which]._old);

  /* reposition the contents */

  (__window [which]._theoretical_area).l_x = (LONG) (new.g_x - old.g_x);
  (__window [which]._theoretical_area).l_y = (LONG) (new.g_y - old.g_y);
  __calc_window (1, __window [which]._components, &new, &work);

  /* check contents fits under window */

  if ((__window [which]._theoretical_area).l_x > (LONG) work.g_x)
      (__window [which]._theoretical_area).l_x = (LONG) work.g_x;

  if ((__window [which]._theoretical_area).l_x +
      (__window [which]._theoretical_area).l_w <
                   (LONG) (work.g_x + work.g_w))
      (__window [which]._theoretical_area).l_x =
                   (LONG) (work.g_x + work.g_w) - 
      (__window [which]._theoretical_area).l_w;

  if ((__window [which]._theoretical_area).l_y > (LONG) work.g_y)
      (__window [which]._theoretical_area).l_y = (LONG) work.g_y;

  if ((__window [which]._theoretical_area).l_y +
      (__window [which]._theoretical_area).l_h <
                   (LONG) (work.g_y + work.g_h))
      (__window [which]._theoretical_area).l_y =
                   (LONG) (work.g_y + work.g_h) - 
      (__window [which]._theoretical_area).l_h;

  /* and adjust the window */

  __set_window (which, WF_CXYWH, &new);
  __slider (which);

}





/**********************************************************************/
/*                                                                    */
/*                           Wb_dstate                                */
/*                                                                    */
/*   This functions modifies the specified state of an item in a      */
/* tree, and then can do something simple or something rather nifty.  */
/* It can simply redraw the item, or build up a rectangle from a      */
/* sequence of items to do one grand redraw, still within the minimum */
/* area necessary, when they've all been modified. It takes the       */
/* following parameters:                                              */
/*                                                                    */
/*        WORD redrawcon        One of the following:                 */
/*                                WB_DISPLAY Modify & redraw item     */
/*                                WB_NEXT    Modify, add to draw area */
/*                                WB_FINISH  Display draw area        */
/*                                WB_INCLUDE Just add to draw area    */ 
/*        WORD which            the item's window (for redraw)        */
/*        LONG tree             the tree with the object in it        */
/*        WORD item             The object in question                */
/*        WORD state            The state being changed               */
/*        WORD new_state        One of the following constants        */
/*                                WB_SET     set the state            */
/*                                WB_RESET   reset the state          */
/*                                WB_TOGGLE  toggle the state         */
/*                                                                    */
/*   The function returns nowt.                                       */
/*                                                                    */
/**********************************************************************/

wb_dstate (redrawcon, which, item, state, new_state)
WORD redrawcon, which, item, state, new_state;

{        GRECT working;        /* a working rectangle */
  static GRECT draw_area;      /* current draw area */
  static WORD  strtd = FALSE;  /* TRUE if working on a rectangle */
         LONG  tree;           /* usual guff */

  tree = __window [which]._contents;

  /* if simply drawing rectangle, make sure there is one */

  if (redrawcon == WB_FINISH) {

    if (! strtd)
      return;

  } else

  /* otherwise, if need be, update the object's state */

    if (redrawcon != WB_INCLUDE)
      wb_state (tree, item, state, new_state);

  /* handle the redraw instructions */

  switch (redrawcon) {

    case WB_DISPLAY : /* fill the rectangle with the object details ... */
      __getarea (tree, item, &draw_area); 

    case WB_FINISH : /* draw the current working rectangle, and zap it */
      __gredraw (which, &draw_area);
      strtd = FALSE;
      break;

    case WB_INCLUDE :
    case WB_NEXT :

      /* if not working on a rectangle, simply set the working rectangle
         to be the current object */

      if (! strtd) {

        __getarea (tree, item, &draw_area);
        strtd = TRUE;

      } else {

        /* otherwise, calculate the new working rectangle */

        __getarea (tree, item, &working);
        __union (&draw_area, &working);

      }

  }

}




/**********************************************************************/
/*                                                                    */
/*                           Wb_open                                  */
/*                                                                    */
/*   This functions opens a window. It takes these parameters:        */
/*                                                                    */
/*        WORD components       The window's components               */
/*        WORD control          A word consisting of a number of      */
/*                              of the following control options:     */
/*                               WB_HIDDEN   do not display window    */
/*                               WB_LOWMOUSE disable mouse functions  */
/*                               WB_LOWSUPPORT disable window support */
/*                               WB_ACTIVATE Permit activation (double*/
/*                                           click) in this window    */
/*                               WB_SELECT   Permit object selection  */
/*                                           in this window           */
/*                               WB_DRAGSELF Permit dragging within   */
/*                                           window                   */
/*                               WB_DRAGANY  Permit dragging between  */
/*                                           this and other windows   */ 
/*        LONG window_tree      The tree displayed in the window (can */
/*                                be NULL which will disable drags)   */
/*        LONG width, height    The full width and height of the      */
/*                              contents of the window (-1= tree's)   */
/*        WORD *redraw_function Pointer to the window's redraw funct  */
/*        GRECT *open_area      Opening size of window (NULL=default) */
/*        GRECT *full_area      Full size of window (NULL=default)    */
/*        WORD horizontal_unit  Arrow movement distance (0=char cell) */
/*        WORD vertical_unit    Arrow movement distance (0=char cell) */
/*        BYTE *title           static title of window                */
/*        BYTE *info            static information line               */
/*                                                                    */
/*   The function returns the workbench window handler, or -1.        */
/*                                                                    */
/**********************************************************************/

WORD wb_open (components, control, window_tree, width, height, 
              redraw_function, open_area, full_area, horizontal_unit, 
              vertical_unit, title, info_line)
LONG   window_tree, width, height;
WORD   components, control, (*redraw_function) (), horizontal_unit,
       vertical_unit;
GRECT *open_area, *full_area;
BYTE  *title, *info_line;

{ WORD  i,          /* found mostly in loops */
        difference, /* difference between current and work window size */
        free;       /* Workbench window handler */
  GRECT work,       /* working window area */
        full,       /* default full area */
        open;       /* default opening area */
  LONG  tree;       /* useful for trees */
  BYTE  rope [128];

  /* check there's a free window */

  free = -1;

  for (i = 1 /* window zero is desktop */;
       (i < QUANTITY_WINDOWS) && (free == -1); i++)
    if (__window [i]._handler == -1)
      free = i;

  if (free == -1)
    return (-1);

  /* get full area of screen ... used in quite a few defaults */

  __get_window (0, WF_WXYWH, &full);
  __calc_window (1, components, &full, &work);

  /* see if default width and height wanted */

  if ((tree = window_tree) != GEM_NULL) {

    /* yes ... set it to be the size of the window's contents */

    if (width < 0x0L)
      width = (LONG) LWGET (OB_WIDTH (0));

    if (height < 0x0L)
      height = (LONG) LWGET (OB_HEIGHT (0));

  } else {

    /* yes, but there's no tree, so set it to be the work area of
       the screen */
 
    if (width < 0x0L)
      width = (LONG) work.g_w;

    if (height < 0x0L)
      height = (LONG) work.g_h;

  }

  /* if full or actual defaults wanted */

  if (full_area == NULL) {

    /* make sure default ain't bigger than contents */

    if ((LONG) full.g_w > width) {

      difference = full.g_w - work.g_w;
      full.g_x += (WORD) ((full.g_w - (WORD) width - difference) / 2);
      full.g_w = (WORD) width + difference;

    }

    if ((LONG) full.g_h > height) {

      difference = full.g_h - work.g_h;
      full.g_y += (WORD) ((full.g_h - (WORD) height - difference) /2);
      full.g_h = (WORD) height + difference;

    }

    full_area = &full;

  }

  if (open_area == NULL) {

    /* default open area required ... quarter full area */

    open.g_w = full_area -> g_w / 2;
    open.g_h = full_area -> g_h / 2;
    open.g_x = full_area -> g_x + (full_area -> g_w - open.g_w) / 2;
    open.g_y = full_area -> g_y + (full_area -> g_h - open.g_h) / 2;
    open_area = &open;

  } else
    __intersect (open_area, full_area);

  /* create window */

  __window [free]._handler = wind_create (components, 
                                          full_area -> g_x, full_area -> g_y,
                                          full_area -> g_w, full_area -> g_h);

  if (__window [free]._handler == -1)
    return (-1);

  /* fill up the window's record */

  __window [free]._control = control;
  __window [free]._components = components;
  __window [free]._contents = window_tree;
  __window [free]._full_size = FALSE;
  __window [free]._drawer = redraw_funct;
  __window [free]._across_move = (horizontal_unit ? horizontal_unit : __cellw);
  __window [free]._up_move = (vertical_unit ? vertical_unit : __cellh);

  /* set window title and information line */

  if (components & NAME)
    wind_set (__window [free]._handler, WF_NAME, (WORD) LLOWD (ADDR (title)),
              (WORD) LHIWD (ADDR (title)), 0, 0);

  if (components & INFO)
    wind_set (__window [free]._handler, WF_INFO, 
              (WORD) LLOWD (ADDR (info_line)), 
              (WORD) LHIWD (ADDR (info_line)), 0, 0);

  /* display window boundries (not contents) - or not if window is hidden */

  if (! (control & WB_HIDDEN))
    wind_open (__window [free]._handler, open_area -> g_x, open_area -> g_y,
               open_area -> g_w, open_area -> g_h);

  else
    __grect_assign (&__window [free]._old, open_area);

  /* set the (theoretical!) size of the window's contents */

  __calc_window (1, components, open_area, &work);
  (__window [free]._theoretical_area).l_x = (LONG) work.g_x;
  (__window [free]._theoretical_area).l_y = (LONG) work.g_y;
  (__window [free]._theoretical_area).l_w = width;
  (__window [free]._theoretical_area).l_h = height;

  /* fix window's sliders and exit */

  __slider (free);
  return (free);

}




/**********************************************************************/
/*                                                                    */
/*                           Wb_qopen                                 */
/*                                                                    */
/*   This functions opens a window with very few parameters. They are */
/*                                                                    */
/*        LONG tree             The tree displayed in the window (can */
/*                                be NULL; must be for text windows)  */
/*        BYTE *title           static title of window                */
/*                                                                    */
/*   The function returns the wb window handler, or -1.               */
/*                                                                    */
/**********************************************************************/

wb_qopen (tree, title)
LONG tree;
BYTE *title;

{ 

  return (wb_open ((NAME | CLOSER | FULLER | SIZER | MOVER | VSLIDE | HSLIDE),
                   (WB_ACTIVATE | WB_SELECT), 0, tree, 0L, 0L, wb_qdraw, NULL,
                   NULL, 0, 0, title, 0));

}




/**********************************************************************/
/*                                                                    */
/*                           Wb_close                                 */
/*                                                                    */
/*   This functions closes a window. It only takes one parameter,     */
/* the wb's window handler.                                           */
/*                                                                    */
/**********************************************************************/

wb_close (which)
WORD which;

{

  /* if the window really is open ... */

  if (__window [which]._handler >= 0) {

    /* if window is currently displayed, remove it */

    if (! (__window [which]._control & WB_HIDDEN))
      wind_close (__window [which]._handler);

    /* zap it */

    wind_delete (__window [which]._handler);
    __window [which]._handler = -1;

    /* if window is current window, it ain't any more */

    if (__curwin == which)
      __curwin = -1;

  }

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_hide                                  */
/*                                                                    */
/*   This functions removes a window from the screen. It only takes   */
/* one parameter, the window handler.                                 */
/*                                                                    */
/**********************************************************************/

wb_hide (which)
WORD which;

{

  /* check the window's not hidden ... */

  if ((__window [which]._handler >= 0) &&
      ! (__window [which]._control & WB_HIDDEN)) {

    /* and hide it by closing it. */

    __get_window (which, WF_CXYWH, &__window [which]._old); 
    wind_close (__window [which]._handler);
    __window [which]._control |= WB_HIDDEN;

  }

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_show                                  */
/*                                                                    */
/*   This functions redraws a once hidden window. It only takes       */
/* one parameter, the window handler.                                 */
/*                                                                    */
/**********************************************************************/

wb_show (which)
WORD which;

{

  /* check the window's hidden ... */

  if ((__window [which]._handler >= 0) &&
    (__window [which]._control & WB_HIDDEN)) {

    /* and show it by re-opening it. */

    __window [which]._control &= ~ WB_HIDDEN;
    wind_open (__window [which]._handler, (__window [which]._old).g_x, 
               (__window [which]._old).g_y, (__window [which]._old).g_w, 
               (__window [which]._old).g_h);

  }

}



/**********************************************************************/
/*                                                                    */
/*                           Wb_desktop                               */
/*                                                                    */
/*   This functions changes the desktop tree. It takes two parameters,*/
/* a control word (as per wb_open control), and, well, of course,     */
/* a pointer to the new tree. It returns the wb window handler for    */
/* the AES's window zero.                                             */
/*                                                                    */
/**********************************************************************/

WORD wb_desktop (control, tree)
WORD control;
LONG tree;

{ GRECT area;

  /* set up window zero as the background window (so that bench recognizes
     it) */

  __window [0]._handler = 0;
  __window [0]._components = INFO;
  __window [0]._contents = tree;
  __window [0]._drawer = wb_qdraw;
  __window [0]._control = control;

  /* make sure tree fits onto the screen precisely */

  __get_window (0, WF_WXYWH, &area);
  (__window [0]._theoretical_area).l_x = (LONG) area.g_x;
  (__window [0]._theoretical_area).l_y = (LONG) area.g_y;

  if (tree != NULL) {

    LWSET (OB_WIDTH (0), area.g_w);
    LWSET (OB_HEIGHT (0), area.g_h);

  }

  /* and draw it */

  __gredraw (0, &area);

}



/**********************************************************************/
/*                                                                    */
/*                       wb_rectangle                                 */
/*                                                                    */
/*   This functions defines a rectangle associated with the specified */
/* window, subsequently used in an await. It takes the following      */
/* parameters:                                                        */
/*                                                                    */
/*      WORD which      Which wb window                               */
/*      WORD rectangle  Is this rectangle one or two.                 */
/*      WORD choice     Which rectangle, out of the following:        */
/*                        WB_WORK    window's work area               */
/*                        WB_CURRENT window's current area            */
/*                        WB_OBJECT  An item in the window's tree     */
/*                        WB_ROOT    An area relative to the root     */
/*                                      of the window's tree          */
/*                        WB_ABSOLUTE A location on the screen        */
/*      GRECT area      Relative area for above; NULL meaning entire  */
/*                      area - for WB_OBJECT, 'pointer' is actually   */
/*                      the object number.                            */
/*      BOOLEAN do_intersect  Yes is area is to intersect window's    */
/*                            work area at runtime                    */ 
/*      WORD mouse_in   Mouse form when inside rectangle              */
/*                                                                    */
/**********************************************************************/

VOID wb_rectangle (which, quel_rectangle, choice, area, do_intersect,
                   mouse_in)
WORD   which, quel_rectangle, choice, do_intersect, mouse_in;
GRECT *area;

{

  /* store the parameters in the record */

  __window [which]._which_rectangle [quel_rectangle] = choice;

  if (area != NULL)
    __grect_assign (&(__window [which]._rectangle [quel_rectangle]), area);

  else
    GFILL ((__window [which]._rectangle [quel_rectangle]), -1, 0, 0, 0);

  __window [which]._intersect [quel_rectangle] = do_intersect;
  __window [which]._mouseform [quel_rectangle] = mouse_in;

}


