@echo off
set rasm=i:\tools\rasm86.exe
set lc1=i:\tools\lc1.exe
set lc2=i:\tools\lc2.exe
set link=c:\system\link86.exe
ECHO Checking for RASM86
if not exist %rasm% goto badtool
ECHO Checking for LC1
if not exist %lc1% goto badtool
ECHO Checking for LC2
if not exist %lc2% goto badtool
ECHO Checking for LINK86
if not exist %link% goto badtool
rem -------------------------------------------------------------------------
cls
echo Compile script for SVGA Vesa screen driver
echo       
echo If you haven't read README.TXT please stop and read the file.
echo If you haven't patched this file for your config please stop
echo     
echo For compiling you need RASM86,LINK86,LC1,LC2
echo     
echo Tested with RASM86 1.4, LINK86 2.02, LINK86 1.3, LC1 2.15,LC 2.15
echo             (should also work with other versions of this programs)
echo     
echo     
echo 
echo Ctrl+C for exit or any other key to continue
echo     
pause
rem --------------------------------------------------------------------------
copy names.vrf names.inc
copy externs.vrf externs.a86
copy gsxdef.ehc gsxdef.h
copy devdata.ehc devdata.a86
copy 8x16.obc 8x16.obj
rem -------------------------------------------------------------------------
%rasm% zyxg $pz
%rasm% entry $pz
%lc1% jmptbl
%lc2% jmptbl -sCODE -v 
%lc1% monobj
%lc2% monobj -sCODE -v 
%lc1% monout
%lc2% monout -sCODE -v 
%lc1% opttext -mD -s
%lc2% opttext -sCODE -v 
%lc1% isin
%lc2% isin -sCODE -v 
%lc1% dummy
%lc2% dummy -sCODE -v 
%rasm% eopttxt1 $pz
%rasm% eopttxt2 $pz
%rasm% eoptdraw $pz
%rasm% egamblit $pz
%rasm% egablit $pz
%rasm% hirespat $pz
%rasm% enddseg $pz
%rasm% verticmf $pz
rem -------------------------------------------------------------------------
del names.inc
del externs.a86
del gsxdef.h
del devdata.a86
del *.sym
copy verticmf.obj vf.obj
copy hirespat.obj hs.obj
rem -------------------------------------------------------------------------
%link% vga.vga=zyxg,entry,jmptbl,monobj,monout,opttext,isin,dummy,vf,egamblit,egablit,eopttxt1,eopttxt2,eoptdraw,hs,enddseg,8x16[NOPREFIX]
rem -------------------------------------------------------------------------
copy vga.vga sdpsc8.vga
del vga.vga
del *.obj
del vga.sym
goto exit
:badtool
echo Tool is not found please check comp.bat
goto exit
:exit
echo Ready...sdpsc8.vga created
