/************************************************************************

    INSTALL 2.0.1 - GEM installer

    Copyright (C) 1985,2000  Caldera Inc. / John Elliott 
                             <jce@seasip.demon.co.uk>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*************************************************************************/


#include "ppdgem.h"
#include "install.h"

BYTE *parse_alert(BYTE *src, BYTE *dest, WORD a, WORD *defbut)
{
	WORD done;
	BYTE curch;
	
	while (*src == ' ') ++src;
	*dest = 0;

	if (a)
	{
		*defbut = a;

		if (*src != '[')
		{
			*defbut = (*(src++)) - '0';
		}
	}
	done = 0;
	while(!done)
	{
		curch = *src;
		switch (curch)
		{
			case ']':
						(*(dest++)) = (*(src++));
						if (*src != '\r') break;
						src += 2;
						while (*src == ' ' || *src == 9) ++src; 
						if (*src == '[') break;
						done = 1;
						break;
									
			case '|':
						(*(dest++)) = (*(src++));
						if (*src != '\r') break;
						src += 2;
						while (*src == ' ' || *src == 9) ++src; 
						break;

			case '\r':
						src += 2;
						done = 1;
						break;

			default:	(*(dest++)) = (*(src++));
						break;
		}
	}
	*dest = 0;
	return src;
}


WORD script_match(VOID)
{
	WORD cmdno;
	BYTE *src, *match;

	for (cmdno = 0; cmdno < CMD_MAX; cmdno++)
	{
		match = script_words[cmdno];
		src   = script_pointer;

		while ((*match) && (*src == *match))
		{
			++src;
			++match;
		}
		if (!(*match))
		{
			script_pointer = src;
			return cmdno;
		}
	}
	return cmdno;
}


VOID check_fixed(VOID)
{
	if (global[14]) have_fixed_drive = 1;
	else			have_fixed_drive = 0;
}


WORD load_script(VOID)
{
	WORD hfile;

/* XXX This is a simplistic version that loads 16k of script. 
 *    The original INSTALL.APP tried to read 1Mb of script; but it
 *    could not have accessed more than the first 60k or so. */
	
	dos_sdrv(0);	/* A: */
	dos_chdir(ADDR("A:\\"));


	hfile = dos_open(ADDR("INSTALL.TXT"), 0);
	if (DOS_ERR)
	{
		form_alert(0, ADDR("[3][INSTALL can't find the|"
		                       "INSTALL.TXT file. Insert the|"
		                       "disk containing INSTALL.TXT|"
		                       "and try again.][ Cancel ]")); 
		return 0;
	}

	script_pointer = script_base = script_buf;
	dos_read(hfile, BUFLEN-1, ADDR(script_buf));
	dos_close(hfile);
	
	return 1;
}


WORD next_line(VOID)
{
	while (*script_pointer != 0x0D && 
	       *script_pointer != 0x1A &&
	       *script_pointer != 0)
	{
		++script_pointer;
	} 
	if (*script_pointer == 0x1A || *script_pointer == 0) return 0;
	if (*script_pointer == 0x0D) script_pointer += 2;
	return 1;
}


BYTE *get_word(BYTE *src, BYTE *dest)
{
	while (*src == ' ') ++src;

	while (*src != '\r' && *src != '\n' && *src != ' ')
	{
		*(dest++) = *(src++);
	}
	*dest = 0;
	return src;
}


VOID script_goto(VOID)
{
	WORD match, bp4;
	BYTE findbuf[80];
	BYTE labelbuf[80];
	BYTE *matchp;
	
	get_word(line_pointer, findbuf);	/* Label */

	if (!findbuf[0]) return;
	match = 0;
	bp4 = 0;
	matchp = script_base;

	while (!match)
	{
		/* End of file, no match found. Go back to where we were */
		if (*matchp == 0x1A || *matchp == 0)
		{
			match = 1;
			matchp = line_pointer;
			continue;
		}
		if (*matchp++ != ':') continue;
		get_word(matchp, labelbuf);

		match = !strcmp(findbuf, labelbuf);
	}
	matchp += 2;
	script_pointer = matchp;
}


WORD xtoi(BYTE *s)
{
	WORD result, mult, n;
	BYTE curch;

	result = 0;
	if (!s) return 0;
	mult = 1; 
	for (n = 3; n >= 0; n--)
	{
		curch = s[n];

		if      (curch >= 'A' && curch <= 'F') result += mult * (curch - '7');
		else if (curch >= '0' && curch <= '9') result += mult * (curch - '0');		

		mult = mult << 4;
	}
	return result;
}

BYTE *skip_spaces(BYTE *s)
{
	while (*s == ' ') ++s;
	return s;
}


WORD atow(BYTE *s)
{
	WORD n, num, sign;

	n = 0;
	while (s[n] == ' ' || s[n] == 9 || s[n] == '\n') ++n;

	sign = 1;
	if (s[n] == '+' || s[n] == '-')
	{
		++n;
		sign = (s[n-1] == '+') ? 1 : -1; 
	}
	num = 0;
	while (s[n] >= '0' && s[n] <= '9')
	{
		num *= 10;
		num += s[n] - '0';
		
		++n;
	}
	return num * sign;
}


LONG free_space(WORD drive)
{
	LONG total, avail;
	dos_space(drive, &total, &avail);
	return avail;
}


VOID fix_error(VOID)
{
	if (!DOS_ERR) script_error = 0;
	else		  script_error = DOS_AX;
}



VOID inc_pointer(LPBYTE *pptr, LONG *plong, LONG incr)
{
	WORD fpseg, fpoff;
	
	*plong -= incr;

	/* Normalise the pointer, so its offset is 0-15 */
	
	fpseg  =  FP_SEG(*pptr);
	fpseg += (FP_OFF(*pptr) >> 4);	/* Segment */
	fpoff  =  FP_OFF(*pptr) & 0x0F;	/* Offset */

	/* Add on the increment */
	
	fpseg += (incr >> 4);
	fpoff += (incr & 0x0F);

	*pptr = MK_FP(fpseg, fpoff);
}


VOID repaint_ctrl(LPTREE tree, WORD ctl)
{
	GRECT rcCtrl;
	
	ob_xywh(gl_tree, ctl, &rcCtrl);
	objc_draw(gl_tree, ROOT, MAX_DEPTH, rcCtrl.g_x, rcCtrl.g_y, rcCtrl.g_w, rcCtrl.g_h);
}


VOID get_file_dir(char *src, char *dst)
{
	char *last_sep = dst;

	while (*src)
	{
		if (*src == ':' || *src == '\\' || *src == '/')
		{
			last_sep = dst + 1;
		}
		*(dst++) = *(src++);
	}
	*last_sep = 0;
}



