REM -------------------------
REM ------- Biorhythm -------
REM -- (W) U.Ehlers (1988) --
REM -------------------------

REM -------------------------
REM -- adjusted to run in ---
REM ---- Basic 2 Plus by ----
REM -- Davey Brain (2001) ---
REM -------------------------

REM --------------------
REM --- Make Windows ---
REM --------------------

REM CLEAR not allowed in Basic 2 Plus
DIM motage (12)
FOR t= 1 TO 12
  READ motage(t)
NEXT t
DATA 31,28,31,30,31,30,31,31,30,31,30,31
LABEL anfang
eiflag$=""
partflag$=""

REM Close All Channels
CLOSE #1, #2, #3, #4

REM Close All Windows
CLOSE WINDOW 1: CLOSE WINDOW 2: CLOSE WINDOW 3: CLOSE WINDOW 4

REM ------------------
REM --- Window #1 ----
REM ------------------

REM Open Channel for Window #1 (Graphic)
OPEN #1, WINDOW 1

REM Now Open The Window Itself
WINDOW #1, OPEN

REM This is the Scale for Graphics-Window (420*420) On The Screen
SCREEN #1 GRAPHICS 420 FIXED,420 FIXED

REM Position The Window On The Desktop
WINDOW #1 PLACE 213,15

REM Print Title Of The Window
WINDOW #1 TITLE "Biorhythm  (W) U.Ehlers (1988)"

REM --------------------------
REM --- Window #2 (Dialog) ---
REM --------------------------
OPEN #2, WINDOW 2
WINDOW #2, OPEN
SCREEN #2, TEXT 25 FIXED, 20 FIXED
WINDOW #2 PLACE 5,60

REM --------------------------------
REM -------- Main Program ----------
REM --------------------------------

GOTO menu

REM
REM
REM --------------------------------
REM ----- Subroutine Data-Input ----
REM --------------------------------
REM
REM

LABEL eingabe
CLS #2
WINDOW #2 TITLE "Enter Data"
WINDOW #2 CURSOR ON
TEXT #2 FEED 1
PRINT #2, "Year of birth  (JJJJ)"
INPUT #2 "               ";gebjahr$
TEXT #2 FEED 1
PRINT #2, "Month of birth (MM)"
INPUT #2 "               ";gebmonat$
TEXT #2 FEED 1
PRINT #2, "Day of birth   (DD)"
INPUT #2 "               ";gebtag$
TEXT #2 FEED 1
PRINT #2, "_________________________"
TEXT #2 FEED 1
PRINT #2, "Year of analysis  (JJJJ)"
INPUT #2 "                  ";anajahr$
TEXT #2 FEED 1
PRINT #2, "Month of analysis (MM)"
INPUT #2 "                  ";anamonat$
WINDOW #2 CURSOR OFF

REM ----- Plausibility-Test -----
gebjahr = VAL(gebjahr$)
gebmonat= VAL(gebmonat$)
gebtag= VAL(gebtag$)
anajahr= VAL(anajahr$)
anamonat= VAL(anamonat$)
IF gebtag <1 OR gebtag >31 THEN GOTO eingabe
IF gebmonat <1 OR gebmonat > 12 THEN GOTO eingabe
IF anamonat <1 OR anamonat > 12 THEN GOTO eingabe
IF anajahr < gebjahr THEN GOTO eingabe
eiflag$="OK"
GOTO menu

REM
REM
REM ---------------------------------
REM --------- Biorhythm -------------
REM ---------------------------------
REM
REM

LABEL bio
CLS #2

REM --- Data already entered ? ---
IF eiflag$<>"OK" THEN GOTO einok ELSE GOTO kalktage

LABEL einok
CLS #2
WINDOW #2 TITLE "Message"
TEXT #2 FEED 6
PRINT #2, "   To show the bio-"
TEXT #2 FEED 1
PRINT #2, "   rhythm, data must"
TEXT #2 FEED 1
PRINT #2, "   first be entered !"
TEXT #2 FEED 5
PRINT #2, "   Press <Esc>-Key"

REPEAT
  taste$=UPPER$(INKEY$)
UNTIL taste$ = CHR$(27)

GOTO menu

REM ----------------------------
REM -- Compute Days Of Your Life
REM ----------------------------

LABEL kalktage
tage = (anajahr-1-gebjahr)*365.25
tage = tage + ((12-gebmonat)*30.4375)
tage = tage + (motage(gebmonat)-gebtag+1)
tage = tage + ((anamonat-1)*30.4375)
tage = tage + 1
tage = ROUND(tage)

REM ----------------
REM Select Biorhythm
REM -----------------

LABEL biomenu
CLS #2
WINDOW #2 TITLE "Select Biorhythm"
geburtstag$= gebtag$+"."+gebmonat$+"."+gebjahr$
TEXT #2 FEED 1
PRINT #2, " Birthdate: "+geburtstag$
analysedat$= anamonat$+"."+anajahr$
TEXT #2 FEED 1
PRINT #2, " Biodate  : "+analysedat$
TEXT #2 FEED 1
PRINT #2, "_________________________"
PRINT #2, " <P>hysical Rhythm"
TEXT #2 FEED 1
PRINT #2, " <E>motional Rhythm"
TEXT #2 FEED 1
PRINT #2, " <M>ental Rhythm"
TEXT #2 FEED 1
PRINT #2, " <I>nstinctive Rhythm"
PRINT #2, "_________________________"
TEXT #2 FEED 1
PRINT #2, "   <ESC> = Main Menu"
REPEAT
  taste$=UPPER$(INKEY$)
UNTIL taste$<>""
IF taste$=CHR$(27) THEN GOTO back
IF taste$=CHR$(112) OR taste$=CHR$(80) THEN GOTO koerper
IF taste$=CHR$(109) OR taste$=CHR$(77) THEN GOTO geist
IF taste$=CHR$(101) OR taste$=CHR$(69) THEN GOTO seele
IF taste$=CHR$(105) OR taste$=CHR$(73) THEN GOTO intuit
GOTO biomenu

REM =====================
REM ====== Back =========
REM =====================

LABEL back
CLS #1
CLS #2
GOTO menu

REM ================================
REM --------  Biorhythmics ---------
REM ================================

REM ---------------------------
REM ----- Biorhythm Physis ----
REM ---------------------------

LABEL koerper
CLS #1
WINDOW #1 TITLE "Physical Biorhythm"
GOSUB biosystem

REM --- Draw Physical Biorhythm ----
xbio = 0
ybio = 0
biox = 0
bioy = 0
zyklang = 23

REM Which Bioday Is On The First Day Of The Biomonth ?
biotag = tage MOD zyklang

REM Y-increment for one bioday
bioy= INT(2000/5.75)

REM Distance of the days on x-axis
biox= ROUND((4925-830)/31)

REM Determine Y-position of bioday on the first day of biomonth
REM Cause adding start at 1, one  day must be subtracted
ymitte = 2700 - bioy
FOR t = 1 TO biotag
  IF t = 1 THEN ybio = ymitte + bioy
  IF t>1 AND t<7 THEN ybio = ybio +  bioy
  IF ybio > 4700 THEN ybio = 4700
  IF t>6 AND t<12 THEN ybio = ybio - bioy
  IF t= 12 THEN ybio = 2700
  IF t>12 AND t<18 THEN ybio = ybio - bioy
  IF t=17 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF t>17 THEN ybio = ybio + bioy
  IF t=23 THEN ybio = 2700
  IF t>4700 THEN t=4700
NEXT t

REM ====== Set bioday on the first of biomonth =========
xbio = 830
LINE #1, xbio-25;2700,xbio-25;ybio
LINE #1, xbio-25;ybio,xbio+25;ybio
LINE #1, xbio+25;ybio,xbio+25;2700

REM Starting-Point on x-axis
xbio = 830

REM Determine new Y-Position
anfang = 2
ende = motage(anamonat)
FOR t = anfang TO ende
  IF biotag = 23 THEN biotag = 1
  IF biotag = 1 THEN ybio = 2700
  IF biotag>1 AND biotag<7 THEN ybio = ybio + bioy
  IF biotag = 6 THEN ybio = 4700
  IF ybio > 4700 THEN ybio = 4700
  IF biotag>6 AND biotag<12 THEN ybio = ybio - bioy

  REM IF biotag = 12 THEN ybio = 2700
  IF biotag>12 AND biotag <18 THEN ybio = ybio - bioy
  IF biotag = 17 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF biotag>17 THEN ybio = ybio + bioy
  IF biotag = 23 THEN ybio = 2700
  xbio = xbio + biox
  biotag = biotag + 1
  LINE #1, xbio-25;2700,xbio-25;ybio
  LINE #1, xbio-25;ybio,xbio+25;ybio
  LINE #1, xbio+25;ybio,xbio+25;2700
NEXT t
GOTO biomenu

REM ---------------------------------------
REM ----- Psychic/Emotional Biorhythm -----
REM ---------------------------------------

LABEL seele
CLS #1
WINDOW #1 TITLE "Emotional Biorhythm"
GOSUB biosystem

REM --- Draw emotional rhythm ----
xbio = 0
ybio = 0
biox = 0
bioy = 0
zyklang = 28
biotag = tage MOD zyklang
bioy= INT(2000/7)
biox= ROUND((4925-830)/31)
ymitte = 2700 - bioy
FOR t = 1 TO biotag
  IF t = 1 THEN ybio = ymitte + bioy
  IF t>1 AND t<8 THEN ybio = ybio +  bioy
  IF ybio > 4700 THEN ybio = 4700
  IF t>7 AND t<15 THEN ybio = ybio - bioy
  IF t= 14 THEN ybio = 2700
  IF t>14 AND t<22 THEN ybio = ybio - bioy
  IF t=21 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF t>21 THEN ybio = ybio + bioy
  IF t=28 THEN ybio = 2700
NEXT t

REM ====== Set bioday on the first of the biomonth =========
xbio = 830
LINE #1, xbio-25;2700,xbio-25;ybio
LINE #1, xbio-25;ybio,xbio+25;ybio
LINE #1, xbio+25;ybio,xbio+25;2700

REM Anfang auf Xachse
xbio = 830
anfang = 2
ende = motage(anamonat)
FOR t = anfang TO ende
  IF biotag = 28 THEN biotag = 1
  IF biotag = 1 THEN ybio = 2700
  IF biotag>1 AND biotag<8 THEN ybio = ybio + bioy
  IF biotag = 7 THEN ybio = 4700
  IF ybio > 4700 THEN ybio = 4700
  IF biotag>7 AND biotag<15 THEN ybio = ybio - bioy
  IF biotag>14 AND biotag <22 THEN ybio = ybio - bioy
  IF biotag = 21 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF biotag>21 THEN ybio = ybio + bioy
  IF biotag = 28 THEN ybio = 2700
  xbio = xbio + biox
  biotag = biotag + 1
  LINE #1, xbio-25;2700,xbio-25;ybio
  LINE #1, xbio-25;ybio,xbio+25;ybio
  LINE #1, xbio+25;ybio,xbio+25;2700
NEXT t
GOTO biomenu

REM ----------------------------
REM ----- Mental Biorhythm -----
REM ----------------------------

LABEL geist
CLS #1
WINDOW #1 TITLE "Mental Biorhythm"
GOSUB biosystem

REM --- Draw mental rhythm ----
xbio = 0
ybio = 0
biox = 0
bioy = 0
zyklang = 33
biotag = tage MOD zyklang
bioy= INT(2000/8.25)
biox= ROUND((4925-830)/31)
ymitte = 2700 - bioy
FOR t = 1 TO biotag
  IF t = 1 THEN ybio = ymitte + bioy
  IF t>1 AND t<9 THEN ybio = ybio +  bioy
  IF ybio > 4700 THEN ybio = 4700
  IF t>8 AND t<17 THEN ybio = ybio - bioy
  IF t= 16 THEN ybio = 2700
  IF t>16 AND t<25 THEN ybio = ybio - bioy
  IF t=25 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF t>25 THEN ybio = ybio + bioy
  IF t=33 THEN ybio = 2700
NEXT t

REM ====== Set bioday on the first of biomonth =========
xbio = 830
LINE #1, xbio-25;2700,xbio-25;ybio
LINE #1, xbio-25;ybio,xbio+25;ybio
LINE #1, xbio+25;ybio,xbio+25;2700
xbio = 830
anfang = 2
ende = motage(anamonat)
FOR t = anfang TO ende
  IF biotag = 33 THEN biotag = 1
  IF biotag = 1 THEN ybio = 2700
  IF biotag>1 AND biotag<9 THEN ybio = ybio + bioy
  IF biotag = 8 THEN ybio = 4700
  IF ybio > 4700 THEN ybio = 4700
  IF biotag>8 AND biotag<17 THEN ybio = ybio - bioy
  IF biotag>16 AND biotag <25 THEN ybio = ybio - bioy
  IF biotag = 25 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF biotag>25 THEN ybio = ybio + bioy
  IF biotag = 33 THEN ybio = 2700
  xbio = xbio + biox
  biotag = biotag + 1
  LINE #1, xbio-25;2700,xbio-25;ybio
  LINE #1, xbio-25;ybio,xbio+25;ybio
  LINE #1, xbio+25;ybio,xbio+25;2700
NEXT t
GOTO biomenu

REM -------------------------------------
REM ---- Biorhythm Intuition/Instinct ---
REM -------------------------------------

LABEL intuit
CLS #1
WINDOW #1 TITLE "Instictive Biorhythm"
GOSUB biosystem

REM --- Draw instinctive Biorhythm ----
xbio = 0
ybio = 0
biox = 0
bioy = 0
zyklang = 38
biotag = tage MOD zyklang
bioy= INT(2000/9.5)
biox= ROUND((4925-830)/31)
ymitte = 2700 - bioy
FOR t = 1 TO biotag
  IF t = 1 THEN ybio = ymitte + bioy
  IF t>1 AND t<10 THEN ybio = ybio +  bioy
  IF ybio > 4700 THEN ybio = 4700
  IF t>9 AND t<20 THEN ybio = ybio - bioy
  IF t= 19 THEN ybio = 2700
  IF t>19 AND t<29 THEN ybio = ybio - bioy
  IF t=28 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF t>28 THEN ybio = ybio + bioy
  IF t=38 THEN ybio = 2700
NEXT t

REM ====== Set bioday on the first of biomonth =========
xbio = 830
LINE #1, xbio-25;2700,xbio-25;ybio
LINE #1, xbio-25;ybio,xbio+25;ybio
LINE #1, xbio+25;ybio,xbio+25;2700
xbio = 830
anfang = 2
ende = motage(anamonat)
FOR t = anfang TO ende
  IF biotag = 38 THEN biotag = 1
  IF biotag = 1 THEN ybio = 2700
  IF biotag>1 AND biotag<10 THEN ybio = ybio + bioy
  IF biotag = 9 THEN ybio = 4700
  IF ybio > 4700 THEN ybio = 4700
  IF biotag>9 AND biotag<20 THEN ybio = ybio - bioy
  IF biotag>19 AND biotag <29 THEN ybio = ybio - bioy
  IF biotag = 28 THEN ybio = 700
  IF ybio<700 THEN ybio=700
  IF biotag>28 THEN ybio = ybio + bioy
  IF biotag = 38 THEN ybio = 2700
  xbio = xbio + biox
  biotag = biotag + 1
  LINE #1, xbio-25;2700,xbio-25;ybio
  LINE #1, xbio-25;ybio,xbio+25;ybio
  LINE #1, xbio+25;ybio,xbio+25;2700
NEXT t
GOTO biomenu

REM --------------------------------
REM ---- Analysis of partnership ---
REM --------------------------------

LABEL partner
CLS #2
WINDOW #2 TITLE "Partner Analysis"
IF partflag$="OK" THEN GOTO partdraw
WINDOW #2 CURSOR ON
TEXT #2 FEED 3
PRINT #2, " Own birthday:"
TEXT #2 FEED 1
PRINT #2, " (TT.MM.JJJJ)"
INPUT #2 " ";gebeigen$
TEXT #2 FEED 2
PRINT #2, "_________________________"
TEXT #2 FEED 1
PRINT #2, " Birthday of partner:"
TEXT #2 FEED 1
PRINT #2, " (TT.MM.JJJJ)"
INPUT #2 " ";gebpart$
WINDOW #2 CURSOR OFF
IF LEN(gebeigen$)<>10 THEN GOTO partner
IF LEN(gebpart$)<>10 THEN GOTO partner
dummy$ = MID$(gebeigen$,1,2)
eigentag = VAL(dummy$)
dummy$ = MID$(gebeigen$,4,2)
eigenmonat = VAL(dummy$)
dummy$ = MID$(gebeigen$,7,4)
eigenjahr = VAL(dummy$)
dummy$ = MID$(gebpart$,1,2)
parttag = VAL(dummy$)
dummy$ = MID$(gebpart$,4,2)
partmonat = VAL(dummy$)
dummy$ = MID$(gebpart$,7,4)
partjahr = VAL(dummy$)

REM ----- Check plausibility -------
IF eigentag <1 OR eigentag >31 THEN GOTO partner
IF eigenmonat <1 OR eigenmonat > 12 THEN GOTO partner
IF parttag <1 OR parttag > 31 THEN GOTO partner
IF partmonat <1 OR partmonat > 12 THEN GOTO partner
partflag$="OK"

REM ----- Relation-Point for computing the difference -------
bezugjahr = 2100
bezugmonat = 1
bezugtag = 1

REM --- Own age in days ------
mydays = (bezugjahr-1-eigenjahr)*365.25
mydays = mydays + ((12-eigenmonat)*30.4375)
mydays = mydays + (motage(eigenmonat)-eigentag+1)
mydays = mydays + ((bezugmonat-1)*30.4375)
mydays = mydays + 1
mydays = ROUND(mydays)

REM ---- Age of partner in days ----
padays = (bezugjahr-1-partjahr)*365.25
padays = padays + ((12-partmonat)*30.4375)
padays = padays + (motage(partmonat)-parttag+1)
padays = padays + ((bezugmonat-1)*30.4375)
padays = padays + 1
padays = ROUND(padays)

REM --- Difference of days between partners -----
differenz = ABS(mydays-padays)

REM --- Harmonies in percent ------

REM Physis
harmk = differenz MOD 23
harmk = ROUND(harmk / 23 * 100)
IF harmk<50 THEN harmk=100-(harmk*2)
IF harmk=50 THEN harmk=0
IF harmk>50 THEN harmk=(harmk-50)*2
IF harmk>100 THEN harmk=100
IF harmk<0 THEN harmk=0

REM Emotions
harms = differenz MOD 28
harms = ROUND(harms / 28 * 100)
IF harms<50 THEN harms=100-(harms*2)
IF harms=50 THEN harms=0
IF harms>50 THEN harms=(harms-50)*2
IF harms>100 THEN harms=100
IF harms<0 THEN harms=0

REM Mental
harmg = differenz MOD 33
harmg = ROUND(harmg / 33 * 100)
IF harmg<50 THEN harmg=100-(harmg*2)
IF harmg=50 THEN harmg=0
IF harmg>50 THEN harmg=(harmg-50)*2
IF harmg>100 THEN harmg=100
IF harmg<0 THEN harmg=0

REM Intuition/Instinct
harmi = differenz MOD 38
harmi = ROUND(harmi / 38 * 100)
IF harmi<50 THEN harmi=100-(harmi*2)
IF harmi=50 THEN harmi=0
IF harmi>50 THEN harmi=(harmi-50)*2
IF harmi>100 THEN harmi=100
IF harmi<0 THEN harmi=0

REM Average of harmonies
harmm = ROUND((harmk + harms + harmg + harmi) / 4)

REM ----------------------------------------------
REM --- Draw chart of partnership compability ----
REM ----------------------------------------------
REM --- Set text to window #2 ----

LABEL partdraw
CLS #2
TEXT #2 FEED 1
PRINT #2, " Own birthday:"
TEXT #2 FEED 1
PRINT #2, " ";gebeigen$
TEXT #2 FEED 1
PRINT #2, "_________________________"
TEXT #2 FEED 1
PRINT #2, " Partners birthday:"
TEXT #2 FEED 1
PRINT #2, " ";gebpart$
TEXT #2 FEED 1
PRINT #2, "_________________________"
TEXT #2 FEED 2
PRINT #2, "   <Esc> = Main Menu"

REM ------------------------------------------------
REM ----- Now show the graphics of harmonies -------
REM ------------------------------------------------
REM vertical axis
REM --------------------------------------------------
REM -- Coordinates:      x1  y1      x2  y2  --
REM -- Vertical   : from 700,700 to  700,4700 --
REM -- Horizontal : from 830,700 to  4725,700 --
REM --------------------------------------------------

CLS #1
WINDOW #1 TITLE "Bio-Harmonogramm"
LINE #1, 700;300,700;4900

REM Vertical axis
FOR t = 4700 TO 700 STEP -400
  LINE #1, 660;t,700;t
NEXT t

REM Vertical numbers
ywert = 100
FOR t = 4700 TO 700 STEP -400
  ywert$=STR$(ywert)
  ywert$ = MID$(ywert$,2,3)
  IF ywert > 0 THEN ywert$ = "+"+ywert$+"%"
  IF ywert < 0 THEN ywert$ = "-"+ywert$+"%"
  IF ywert = 0 THEN ywert$ = " "+ywert$+"%"
  IF ywert < 100 AND ywert > 0 THEN adapt=100
  IF ywert < 0 THEN adapt= 100
  IF ywert = 0 THEN adapt=100
  MOVE #1,100+adapt;t-70
  PRINT #1, ywert$
  ywert = ywert - 10
NEXT t

REM Horizontal axis
LINE #1,700;300,4925;300

REM Scale xaxis
FOR t = 700 TO 4925 STEP 845
  LINE #1,t;300,t;700
NEXT t
LINE #1,700;700,4925;700

REM Set realms for x-axis
MOVE #1, 850;450
PRINT #1, "Physis"
MOVE #1, 1730;450
PRINT #1, "Emotion"
MOVE #1, 2570;450
PRINT #1, "Mental"
MOVE #1, 3280;450
PRINT #1, "Instinct"
MOVE #1, 4200;450
PRINT #1, "Average"

REM Draw borders
LINE #1,700;4900,4925;4900
LINE #1,4925;4900,4925;300

REM ----------------------
REM --- Draw harmonies ---
REM ----------------------
REM y begins with 700
REM y-maximum is  4700
REM ---------------------------

einproz = (4700 - 700)/100

REM for physis
harmonie = (harmk * einproz)+700
FOR t = 900 TO 1300
  LINE #1, t;700,t;harmonie
NEXT t

REM For emotions
harmonie = (harms * einproz)+700
FOR t = 1760 TO 2160
  LINE #1, t;700,t;harmonie
NEXT t

REM Fr mentality
harmonie = (harmg * einproz)+700
FOR t = 2620 TO 3020
  LINE #1, t;700,t;harmonie
NEXT t

REM For instinct
harmonie = (harmi * einproz)+700
FOR t = 3470 TO 3870
  LINE #1, t;700,t;harmonie
NEXT t

REM For average
harmonie = (harmm * einproz)+700
FOR t = 4300 TO 4700
  LINE #1, t;700,t;harmonie
NEXT t

REM ----- Menu of partnership analysis -----

LABEL partmenu
REPEAT
  taste$=INKEY$
UNTIL taste$<>""
IF taste$ = CHR$(27) THEN GOTO menu
GOTO partmenu

REM --------------
REM ---- Help ----
REM --------------

LABEL hilfe
CLS #1
CLS #2
WINDOW #2 TITLE "Help"
TEXT #2 FEED 8
PRINT #2, "  <Esc> = Main menu"
WINDOW #1 TITLE "Biorhythm Help"
TEXT #1 FEED 1
PRINT #1, " To draw your biorhythms first select 'Enter data'."
PRINT #1, " Then type in your personal dates. After this select"
PRINT #1, " 'Biorhythm' to draw your biorhythms.
PRINT #1, " For example now type 'p' for physical rhythm."
TEXT #1 FEED 1
PRINT #1, " To print your harmonogramm, i.e. the harmonies of"
PRINT #1, " two persons in their rhythm-coincidence, select"
PRINT #1, " 'p' from mainmenu. Enter your birthday and the"
PRINT #1, " birthday of the partner. Then the graphics will"
PRINT #1, " be draw."
TEXT #1 FEED 1
PRINT #1, " 'New' in mainmenu starts the program again."
PRINT #1, " 'System' in mainmenu exits the program."
PRINT #1, " 'Help' displays this screen and text."
TEXT #1 FEED 1
PRINT #1, " The biological disposition of your biorhythms is"
PRINT #1, " on a scale between +100% (very good) and -100%"
PRINT #1, " which means bad bio-disposition in this realm."
PRINT #1, " For example if your mental rhythm indicates -90%"
PRINT #1, " avoid mental stress on this day if possible."
TEXT #1 FEED 1
PRINT #1, " The partnership harmonies can vary between"
PRINT #1, " 100% (full harmony) and 0% (no harmony)."
PRINT #1, " But don't forget: Opportunities attract each other."

LABEL helpmenu
REPEAT
  taste$=INKEY$
UNTIL taste$<>""
IF taste$=CHR$(27) THEN GOTO menu
GOTO helpmenu

REM --------------------------
REM -- Subroutine mainmenu ---
REM --------------------------
REM
REM

LABEL menu
CLS #2
CLS #1
WINDOW #1 TITLE "Biorhythm  (W) U.Ehlers (1988)"
WINDOW #2 CURSOR OFF
WINDOW #2 TITLE "Menu"
TEXT #2 FEED 2
PRINT #2, "   <E>nter data"
TEXT #2 FEED 2
PRINT #2, "   <B>iorhythm"
TEXT #2 FEED 2
PRINT #2, "   <P>artneranalysis"
TEXT #2 FEED 2
PRINT #2, "   <N>ew"
TEXT #2 FEED 2
PRINT #2, "   <S>ystem"
TEXT #2 FEED 2
PRINT #2, "   <H>elp"
REPEAT
   taste$=UPPER$(INKEY$)
UNTIL taste$<>""
IF taste$ = CHR$(101) OR taste$=CHR$(69) THEN GOTO eingabe
IF taste$ = CHR$(98) OR taste$=CHR$(66) THEN GOTO bio
IF taste$ = CHR$(110) OR taste$=CHR$(78) THEN GOTO anfang
IF taste$ = CHR$(115) OR taste$=CHR$(83) THEN GOTO ende
IF taste$ = CHR$(112) OR taste$=CHR$(80) THEN GOTO partner
IF taste$ = CHR$(104) OR taste$=CHR$(72) THEN GOTO hilfe
GOTO menu

REM
REM
REM -----------------------------------------
REM -- Subroutine system of biocoordinates --
REM -----------------------------------------

LABEL biosystem
REM vertical axis
REM --------------------------------------------------
REM -- Coordinates       :      x1  y1      x2  y2  --
REM -- Vertical          : from 700,700 to  700,4700 --
REM -- Horizontal        : from 830,700 to  4725,700 --
REM --------------------------------------------------

LINE #1, 700;500,700;4900

REM vertical scaling
FOR t = 4700 TO 700 STEP -400
  LINE #1, 660;t,700;t
NEXT t

REM vertical numbers
ywert = 100
FOR t = 4700 TO 700 STEP -400
  ywert$=STR$(ywert)
  ywert$ = MID$(ywert$,2,3)
  IF ywert > 0 THEN ywert$ = "+"+ywert$+"%"
  IF ywert < 0 THEN ywert$ = "-"+ywert$+"%"
  IF ywert = 0 THEN ywert$ = " "+ywert$+"%"
  IF ywert < 100 AND ywert > 0 THEN adapt=100
  IF ywert < 0 THEN adapt= 100
  IF ywert = 0 THEN adapt=100
  IF ywert = -100 THEN adapt = 0
  MOVE #1,100+adapt;t-70
  PRINT #1, ywert$
  ywert = ywert - 20
NEXT t

REM horizontal axis
LINE #1,700;500,4925;500

REM scale x-axis
FOR t = 830 TO 4750 STEP 130
  LINE #1,t;500,t;460
NEXT t

REM set days on x-axis
xwert = 1
FOR t = 700 TO 4750 STEP 520
  IF xwert<10 THEN adapt = 0
  IF xwert >9 THEN adapt = 50
  MOVE #1,t-adapt;300
  PRINT #1, xwert
  xwert = xwert + 4
NEXT t

REM Draw the "zero-line"
LINE #1,700;2700,4925;2700

REM Draw border lines
LINE #1,700;4900,4925;4900
LINE #1,4925;4900,4925;500
RETURN

REM ---------------------
REM -- Subroutine End ---
REM ---------------------
REM
REM

LABEL ende
CLS #1
CLS #2
CLOSE #1
CLOSE #2
CLOSE WINDOW 1
CLOSE WINDOW 2
CLEAR RESET
SYSTEM
END
