{
   DESTROY file destroyer program V2.4, dedicated for FreeDOS
   Copyright (C) 2003-2009 MegaBrutal

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
}

{
   This source code should be compiled with Turbo Pascal 5.5 or newer.

   Version history:
   DESTROY 1.0   2003.08.28.
   DESTROY 2.0   2003.12.30.
   DESTROY 2.1   2004.04.12.
   DESTROY 2.2   2004.06.12.
   DESTROY 2.3   2007.09.22.
   DESTROY 2.4   2009.08.16.
}

program destroy;
uses Crt, Dos;

const

     Author: string[10] = 'MegaBrutal';
     VerHigh: byte = 2;
     VerLow: byte = 4;
     LogicalAnswers = ['Y', 'y', 'N', 'n'];


type

    TFilters = record
               Size_Bigger: longint;
               Size_Less: longint;
               Time_Older: longint;
               Time_Newer: longint;
    end;


var

   FilesDestroyed: integer;     { This stores how many files have we
                                  destroyed yet. }
   FilesFailed: integer;        { How many files have we tried to destroy,
                                  but the operation failed. }
   FileData: SearchRec;         { Stores the data of a found file, it's
                                  used by DestroyFirst and DestroyNext. }
   Files: string;               { The filemask specified in the parameter. }
   FilesPath: string;           { The path of the filemask specified in the
                                  parameter. }
   BufferSize: word;            { Simply stores the actual buffer size. }
   DestroyLevel: word;          { Current destroy level. }
   SearchAttr: byte;            { Which types of files we have to destroy?
                                  It's set by ProcessModes. }
   Brute: boolean;              { It's true, if nobody's interested how
                                  dangerous is our program. (Skip warning.) }
   YesToAll: boolean;           { Just destroy, don't ask. }
   TestOnly: boolean;           { Indicates test-mode. }
   SubDirs: boolean;            { True, if we need to destroy subdirs. }
   HideEnter: boolean;          { Hide *** Entering directory events. }
   KeepFiles: boolean;          { Don't delete wiped files. }
   FileFilters: TFilters;       { File filters. }
   Reporting: boolean;          { True, if we have to write a report. }
   ReportName: string;          { Name of the reportfile. }
   ReportFile: text;            { The reportfile itself. }


   { Forward declarations (prototypes): }
   procedure DestroyFirst; forward;
   procedure DestroyNext; forward;
   procedure DestroyDir; forward;
   procedure FileDestroy(DestroyFile: string; FSize: longint); forward;
   procedure StartReport; forward;
   procedure StopReport; forward;


procedure InitVars;
{ Initialize those ugly global variables declared above. }
begin
     FilesDestroyed:= 0;
     FilesFailed:= 0;
     Files:= '';
     FilesPath:= '';
     BufferSize:= 512; { The default buffer size is 512. }
     DestroyLevel:= 1;
     { SearchAttr will be initialized by ProcessModes, which is forced to run. }
     Brute:= false;
     YesToAll:= false;
     TestOnly:= false;
     SubDirs:= false;
     HideEnter:= false;
     KeepFiles:= false;
     FillChar(FileFilters, SizeOf(TFilters), #00);
     Reporting:= false;
     ReportName:= '';
end;

procedure halterr(msg: string);
{ Exit in case of error, msg is printed as the error message. }
begin
     { Log error - don't call ReportLn here, because that calls Report, and
       that calls halterr on error. }
     if Reporting then begin
        {$I-}
        writeln(ReportFile, 'Runtime error: '+msg);
        {$I+}
        StopReport;
     end;
     writeln('Runtime error: ', msg);
     writeln('Program terminated!');
     halt(1);
end;

function ToUpper(Str: string): string;
{ Small util to convert a string to uppercase. }
var i: integer;
begin
     for i:=1 to Length(Str) do Str[i]:=UpCase(Str[i]);
     ToUpper:=Str;
end;

function ToString(Value: longint): string;
{ Convert a longint to string. }
var Result: string;
begin
     Str(Value, Result);
     ToString:=Result;
end;

procedure PutAsNumber(Source: string; var Target: longint);
{ Stores the input string in a longint. Generate a runtime error, if
  the conversion fails. }
var Code: integer;
begin
     Val(Source, Target, Code);
     if Code <> 0 then halterr('String -> longint conversion failure! Please check parameters!');
end;

procedure PutAsWord(Source: string; var Target: word);
{ Does the same as PutAsNumber, but it stores the result in a word. }
var Code: integer;
begin
     Val(Source, Target, Code);
     if Code <> 0 then halterr('String -> word conversion failure! Please check parameters!');
end;

procedure PutAsTime(Source: string; var Target: longint);
{ Store the input string in packed time format. The string is supposed
  to be in the correct format. (MM.DD.YYYY-HH:mm:ss) }
var
   SeparatedStrings: array[1..6] of string[4];
   Converted: array [1..6] of Word;
   TimeRecord: DateTime;
   Code, i: integer;
begin
     if Length(Source) = 0 then halterr('PutAsTime - Source is a NULLSTRING!');
     if Length(Source) <> 19 then halterr('PutAsTime - Invalid time format! Please check parameters!');
     if not((Source[3] = '.') and (Source[6] = '.') and (Source[11] = '-')
        and (Source[14] = ':') and (Source[17] = ':')) then
        halterr('Invalid time format! The correct is MM.DD.YYYY-HH:mm:ss !');

     SeparatedStrings[1]:=Copy(Source, 1, 2);
     SeparatedStrings[2]:=Copy(Source, 4, 2);
     SeparatedStrings[3]:=Copy(Source, 7, 4);
     SeparatedStrings[4]:=Copy(Source, 12, 2);
     SeparatedStrings[5]:=Copy(Source, 15, 2);
     SeparatedStrings[6]:=Copy(Source, 18, 2);

     for i:=1 to 6 do begin
         Val(SeparatedStrings[i], Converted[i], Code);
         if Code <> 0 then halterr('PutAsTime - Invalid time format! Numbers required!');
     end;

     with TimeRecord do begin
          Day:= Converted[2];
          Month:= Converted[1];
          Year:= Converted[3];
          Hour:= Converted[4];
          Min:= Converted[5];
          Sec:= Converted[6];
     end;

     PackTime(TimeRecord, Target);
end;

procedure PrintHelp;
{ Print out how to use the program, if it's started with /? parameter.
  Called by ParamCheck. }
var ch: char; { TP 5.5 requires to always store function return values. }
begin
     writeln;
     writeln('Usage: DESTROY <file(s)> [(options)] [(modes)] [/RD|/RG|/R <reportfile>]');
     writeln;
     writeln('     /B  - don''t show the security warning before run');
     writeln('     /H  - hide "*** Entering directory" events (with +d)');
     writeln('     /K  - don''t delete wiped files');
     writeln('     /T  - test only (show which files found by the program)');
     writeln('     /Y  - don''t ask before destroy files');
     writeln('     /?  - show this screen');
     writeln;
     writeln('Reporting:');
     writeln('     /RD - report to DESTROY.LOG');
     writeln('     /RG - report to root''s DESTROY.LOG (use /RD instead in root!)');
     writeln('     /R  - specify other reportfile');
     writeln;
     writeln('File filters:');
     writeln('     /SB <size>  - only destroy files with bigger size than this value');
     writeln('     /SL <size>  - only destroy files with less size than this value');
     writeln('     /TO <time>  - only destroy older files than this time');
     writeln('     /TN <time>  - only destroy newer files than this time');
     writeln;
     writeln('Note: The "time" format is MM.DD.YYYY-HH:mm:ss');
     writeln;
     write('Press any key to continue!');
     ch:= ReadKey;
     writeln(#13#10);
     writeln('Options for smarter performance:');
     writeln('     /BS <size>  - buffer size (must between 512 and 8192, and multiple of 512)');
     writeln('     /DL <level> - destroy level');
     writeln;
     writeln('Note: For best performance, the buffer size should be equal with the');
     writeln('      cluster size of your drive.');
     writeln('      Destroy level is a number between 0 and 8, it indicates how many times');
     writeln('      to overwrite a file before deleting it. Use minimum 5 for governmental');
     writeln('      mode, thus your files can''t even be recovered by jerks of the government.');
     writeln;
     write('Press any key to continue!');
     ch:= ReadKey;
     writeln(#13#10);
     writeln('Modes:');
     writeln('     +  set mode');
     writeln('     -  unset mode');
     writeln('     a  destroy archive files');
     writeln('     r  destroy read-only files');
     writeln('     h  destroy hidden files');
     writeln('     s  destroy system files');
     writeln('     d  destroy subdirectories');
     writeln;
     writeln('Example: DESTROY c?a*.bsp +rhd-s /Y /R destroy.log');
     writeln('Note: If you don''t give modes, the default mode set is +a !');
     writeln;
     writeln('For additional help:');
     writeln('     /?D - gives further information about destroy levels');
     writeln('     /?L - show license details');
     writeln;
     write('Press any key to exit!');
     ch:= ReadKey;
     halt;
end;

procedure PrintHelp_DestroyLevels;
var ch: char;
begin
     writeln;
     writeln('There are 9 destroy levels supported by this software:');
     writeln;
     writeln('Level 0:');
     writeln('  Doesn''t wipe files, only deletes them. It''s supposed to be used in');
     writeln('  situations, when a simple ''del'' command doesn''t do the work,');
     writeln('  because you need filtering options that DESTROY supports.');
     writeln;
     writeln('Level 1:');
     writeln('  Overwrites files with #$00 characters, and deletes them. It''s quite');
     writeln('  enough, if you want to prevent your curious daddy from undeleting and');
     writeln('  reading your love letters.');
     writeln;
     writeln('Level 2:');
     writeln('  In addition to level 1, it also overwrites files with #$55 characters.');
     writeln;
     write('Press any key to continue!');
     ch:= ReadKey;
     writeln(#13#10);
     writeln('Level 3:');
     writeln('  In addition to level 2, it also overwrites files with #$AA characters.');
     writeln;
     writeln('Level 4:');
     writeln('  In addition to level 3, it also overwrites files with #$FF characters.');
     writeln;
     writeln('Levels 5-8:');
     writeln('  In addition to level 4, it also overwrites files with random characters.');
     writeln('  If the level is 5, your files will be overwritten 5 times altogether, and');
     writeln('  of course, if the level is 8, they will be overwritten 8 times.');
     writeln('  Note, that these levels even prevent governments from spying on you...');
     writeln;
     halt;
end;

procedure PrintHelp_License;
begin
     writeln('Copyright (C) 2003-2009 MegaBrutal');
     writeln;
     writeln('   This program is free software: you can redistribute it and/or modify');
     writeln('   it under the terms of the GNU General Public License as published by');
     writeln('   the Free Software Foundation, either version 3 of the License, or');
     writeln('   (at your option) any later version.');
     writeln;
     writeln('   This program is distributed in the hope that it will be useful,');
     writeln('   but WITHOUT ANY WARRANTY; without even the implied warranty of');
     writeln('   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the');
     writeln('   GNU General Public License for more details.');
     writeln;
     writeln('   You should have received a copy of the GNU General Public License');
     writeln('   along with this program.  If not, see <http://www.gnu.org/licenses/>.');
     writeln;
     halt;
end;

procedure StartReport;
{ Start logging: write out header. It's called by ParamCheck. }
var Year, Month, Day, DayOfWeek: Word;
    Hour, Minute, Second, Sec100: Word;
    i: integer;
begin
     GetDate(Year, Month, Day, DayOfWeek);
     GetTime(Hour, Minute, Second, Sec100);
     write(ReportFile, '*** DESTROY ', VerHigh, '.', VerLow, ' log started: ',
      Month, '-', Day, '-', Year, ' ', Hour, ':');
     { If the minutes/seconds are less than 10, put a 0 in front of it. :) }
     if Minute < 10 then write(ReportFile, 0); write(ReportFile, Minute, ':');
     if Second < 10 then write(ReportFile, 0); writeln(ReportFile, Second);
     { Log parameters: }
     writeln(ReportFile, '*** Command-line execution: ', ParamStr(0));
     write(ReportFile, '*** Command-line parameters:');
     for i:=1 to ParamCount do write(ReportFile, ' '+ParamStr(i));
     writeln(ReportFile);
     writeln(ReportFile);
end;

procedure StopReport;
{ Close logfile. }
var i: integer;
    Year, Month, Day, DayOfWeek: Word;
    Hour, Minute, Second, Sec100: Word;
begin
     if not Reporting then exit;
     GetDate(Year, Month, Day, DayOfWeek);
     GetTime(Hour, Minute, Second, Sec100);
     {$I-}
     writeln(ReportFile);
     write(ReportFile, '*** DESTROY ', VerHigh, '.', VerLow, ' log finished: ',
      Month, '-', Day, '-', Year, ' ', Hour, ':');
     { Ha a perc s/vagy msodperc kisebb, mint 10, el runk egy nullt. }
     { "J! Ez ismers... mintha mr csinltam volna ilyet! ..." }
     if Minute < 10 then write(ReportFile, 0); write(ReportFile, Minute, ':');
     if Second < 10 then write(ReportFile, 0); writeln(ReportFile, Second);
     writeln(ReportFile);
     close(ReportFile);
     {$I+}
     i:=IOResult;
end;

procedure Report(msg: string);
{ Add msg to the log. }
begin
     write(msg);
     if Reporting then begin
        {$I-}
        write(ReportFile, msg);
        {$I+}
        if IOResult <> 0 then halterr('Reportfile I/O failure!');
     end;
end;

procedure ReportLn(msg: string);
{ Log msg + CR/LF. }
begin
     Report(msg); Report(#13+#10);
end;

procedure ShowWarning;
{ Print out a warning. }
var AnswerChar: char;
begin
     ReportLn('');
     ReportLn('*** WARNING!!! THIS PROGRAM WILL DELETE THE SPECIFIED FILES PERMANENTLY!');
     ReportLn('*** IF YOU ARE NOT SURE WHICH FILES ARE IN THE SPECIFIED RANGE, IT''S WISER');
     ReportLn('*** TO RUN WITH /T FIRST!');
     Report('ARE YOU SURE YOU WANT TO RUN THIS PROGRAM? [Y/N] ');
     AnswerChar:=ReadKey;
     ReportLn(AnswerChar);
     { It's not fair to call Halt. But it's called in several locations
       in this messy code, so +1 takes nothing. }
     if not(Upcase(AnswerChar) = 'Y') then begin StopReport; halt(1); end;
end;

procedure ProcessKey;
var ch: char;

    procedure AskUserQuit;
    var AnswerChar: char;
    begin
         write(#13#10'Are you sure you want to quit? [Y/N] ');
         AnswerChar:= ReadKey;
         writeln(AnswerChar);
         if UpCase(AnswerChar) = 'Y' then begin
            ReportLn('*** INTERRUPTED BY USER!');
            halterr('Interrupted after ' + ToString(FilesDestroyed) + ' destroyed files.');
         end;
    end;

begin
     ch:=ReadKey;
     case ch of
          { Did the user press ESC? }
          #27: AskUserQuit;
     end;
end;

procedure ProcessModes(ModeString: string);
{ This procedure processes the string that tells the program which
  types of files should be destroyed. This string is specified by
  the user in a parameter.
  Here's an example mode string to show the syntax: +rh-sd }
var
   ModeChar: char;
   OpChar: char;
   i: integer;
   Plus: boolean;
   SetA: boolean;
   SetR: boolean;
   SetH: boolean;
   SetS: boolean;
   SetD: boolean;

begin
     { Set defaults: }
     {SearchAttr:=AnyFile-Directory-VolumeID-ReadOnly-Hidden-SysFile;}
     SetA:=true;
     SetR:=false;
     SetH:=false;
     SetS:=false;
     SetD:=false;

     OpChar:='?';

     for i:=1 to Length(ModeString) do begin
         ModeChar:=ModeString[i];
         case ModeChar of
              '+': begin Plus:= true; OpChar:=ModeChar; end;
              '-': begin Plus:= false; OpChar:=ModeChar; end;
              'a', 'A': SetA:=Plus;
              'r', 'R': SetR:=Plus;
              'h', 'H': SetH:=Plus;
              's', 'S': SetS:=Plus;
              'd', 'D': SetD:=Plus;
              else begin
                   halterr('Invalid mode set! (' + OpChar + ModeChar + ')');
              end;
         end;
     end;

     { Set up SearchAttr: }
     SearchAttr:=AnyFile-VolumeID-Directory;
     if not SetA then SearchAttr:=SearchAttr-Archive;
     if not SetR then SearchAttr:=SearchAttr-ReadOnly;
     if not SetH then SearchAttr:=SearchAttr-Hidden;
     if not SetS then SearchAttr:=SearchAttr-SysFile;
     { Set up SubDirs - must we exterminate subdirs as well? }
     SubDirs:= SetD;
end;

procedure ParamCheck;
{ Check parameters. }
var
   i: integer;
   TempStr: string;
   RSpecified: boolean;      { True, if we have a report file open. }
   ModeSet: boolean;         { True, if we already have a mode set. }

   procedure OpenReport(RN: string);
   begin
        if RSpecified then halterr('Multiple reportfile specification!');
        Reporting:= true;
        ReportName:= RN;
        Assign(ReportFile, ReportName);
        { Open the file - append existing log, or create a new file. }
        {$I-} append(ReportFile); {$I+}
        if IOResult <> 0 then {$I-} rewrite(ReportFile); {$I+}
        if IOResult <> 0 then halterr('Invalid reportfile specified!');
        StartReport;
        RSpecified:=true;
   end;

begin
     RSpecified:=false;
     ModeSet:=false;

     if ParamCount < 1 then PrintHelp;
     if paramstr(1)='/?' then PrintHelp;
     if ToUpper(paramstr(1))='/?D' then PrintHelp_DestroyLevels;
     if ToUpper(paramstr(1))='/?L' then PrintHelp_License;

     { Done by InitVars. }
     {with FileFilters do begin
          Size_Bigger:=0; Size_Less:=0;
          Time_Older:=0; Time_Newer:=0;
     end;}

     for i:= 2 to ParamCount do begin
         TempStr:=paramstr(i);
         if ToUpper(TempStr)='/B' then Brute:= true
         else if ToUpper(TempStr)='/H' then HideEnter:= true
         { /RD esetn DESTROY.LOG -ba, /RG esetn \DESTROY.LOG -ba logolunk. }
         else if ToUpper(TempStr)='/RD' then OpenReport('DESTROY.LOG')
         else if ToUpper(TempStr)='/RG' then OpenReport('\DESTROY.LOG')
         else if ToUpper(TempStr)='/K' then KeepFiles:= true
         else if ToUpper(TempStr)='/T' then TestOnly:=true
         else if ToUpper(TempStr)='/Y' then YesToAll:=true
         else if (TempStr[1]='+') or (TempStr[1]='-') then begin
            { All modes must be set in ONE parameter! }
            { (For instance, the following parameter set is INVALID:
              DESTROY *.com +ah-r /y -d+s ) }
            if not(ModeSet) then ProcessModes(TempStr) else halterr('Invalid mode set!');
            ModeSet:=true;
         end
         else begin
            { Some parameters require the next parameter. }
            if (i >= ParamCount) then begin
               { If this is the last parameter, exit agressively with our
                 beloved and hated HaltErr. }
               halterr('Parameter ''' + TempStr + ''' is invalid, or it requires a next parameter.');
            end
            else if ToUpper(TempStr)='/R' then begin
               { Open the logfile: }
               OpenReport(ParamStr(i+1));
            end
            else if ToUpper(TempStr)='/BS' then begin
               { Store the buffer size. It must bigger than 512,
                 but less than 8192. It also must be multiple of 512. }
               PutAsWord(ParamStr(i+1), BufferSize);
               if (BufferSize < 512) or (BufferSize > 8192) then
                  halterr('Invalid buffer size! It must between 512 and 8192.')
               else if (BufferSize mod 512) > 0 then
                  halterr('Invalid buffer size! It must be multiple of 512.');
            end
            else if ToUpper(TempStr)='/DL' then begin
               PutAsWord(ParamStr(i+1), DestroyLevel);
               if (DestroyLevel > 8) then halterr('The maximum destroy level is 8.');
            end
            else if ToUpper(TempStr)='/SB' then PutAsNumber(ParamStr(i+1), FileFilters.Size_Bigger)
            else if ToUpper(TempStr)='/SL' then PutAsNumber(ParamStr(i+1), FileFilters.Size_Less)
            else if ToUpper(TempStr)='/TO' then PutAsTime(ParamStr(i+1), FileFilters.Time_Older)
            else if ToUpper(TempStr)='/TN' then PutAsTime(ParamStr(i+1), FileFilters.Time_Newer)
            { Easter egg. :) }
            else if ToUpper(TempStr)='/CAT' then
               halterr('You should keep away your cat from your keyboard,'#13#10 +
                  'because he or she may type in random commands by walking on it.'#13#10 +
                  'Anyway, tell my greetings to ' + ParamStr(i+1) + '. :)')
            else halterr('Parameter ''' + TempStr + ''' is unknown.');
            Inc(i); { We used the next parameter, so don't check it in the next cycle. }
         end;
     end;
     { Keep files with destroy level 0? }
     if KeepFiles and (DestroyLevel = 0) then
        halterr('/K with /DL 0 has no point. Use /T instead.');
     { Set +a automatically, if ProcessModes has't run yet. }
     if not(ModeSet) then ProcessModes('+a');
end;

function CompareTimes(Time1, Time2: longint): boolean;
{ Returns TRUE, if Time1 is bigger (newer) than Time2, or equal. }
var
   TimeRec1, TimeRec2: DateTime;
begin
     UnpackTime(Time1, TimeRec1);
     UnpackTime(Time2, TimeRec2);
     { Compare the 2 time values. Oh, why aren't they in Linux timestamps?
       And no, it's not OK to compare the packed forms of times, I've already
       tried that. }
     if TimeRec1.Year > TimeRec2.Year then CompareTimes:= true
     else begin
        if TimeRec1.Year = TimeRec2.Year then begin
           if TimeRec1.Month > TimeRec2.Month then CompareTimes:= true
           else begin
              if TimeRec1.Month = TimeRec2.Month then begin
                 if TimeRec1.Day > TimeRec2.Day then CompareTimes:= true
                 else begin
                    if TimeRec1.Day = TimeRec2.Day then begin
                       if TimeRec1.Hour > TimeRec2.Hour then CompareTimes:= true
                       else begin
                          if TimeRec1.Hour = TimeRec2.Hour then begin
                             if TimeRec1.Min > TimeRec2.Min then CompareTimes:= true
                             else begin
                                if TimeRec1.Min = TimeRec2.Min then begin
                                   if TimeRec1.Sec > TimeRec2.Sec then CompareTimes:= true
                                   else begin
                                      CompareTimes:= TimeRec1.Sec = TimeRec2.Sec;
                                   end
                                end else CompareTimes:= false;
                             end
                          end else CompareTimes:= false;
                       end
                    end else CompareTimes:= false;
                 end
              end else CompareTimes:= false;
           end
        end else CompareTimes:= false;
     end;
end;

function CheckFileFilter(var FileData: SearchRec): boolean;
{ Can we destroy this file, or is it excluded by the specified filters? }
begin
     CheckFileFilter:=true;
     if FileFilters.Size_Bigger > 0 then
        if not(FileData.Size > FileFilters.Size_Bigger) then CheckFileFilter:=false;
     if FileFilters.Size_Less > 0 then
        if not(FileData.Size < FileFilters.Size_Less) then CheckFileFilter:=false;
     if FileFilters.Time_Newer > 0 then
        if not CompareTimes(FileData.Time, FileFilters.Time_Newer) then CheckFileFilter:=false;
     if FileFilters.Time_Older > 0 then
        if CompareTimes(FileData.Time, FileFilters.Time_Older) then CheckFileFilter:=false;
end;

procedure SafeRmDir(S: string);
{ This procedure calls System.RmDir in a safe manner, so it doesn't let
  the program halt with a runtime error, because of an I/O failure.
  It also reports, if the directory has been successfully removed or not. }
begin
   { Remove the last backslash from the string, if present. }
   if S[Length(S)] = '\' then S[0]:=Chr(Length(S)-1);
   {$I-}
   System.RmDir(S);
   {$I+}
   if IOResult = 0 then ReportLn(S+' directory removed!')
      else ReportLn('Failed to remove '+S+' !');
end;

procedure SplitPath(Full: string; var Files, Path: string);
{ Splits a full filename to it's path and name. }
var ChrN: byte;
begin
     Path:=Full;
     ChrN:=Length(Path);
     repeat
        ChrN:=ChrN-1;
     until (Path[ChrN]='\') or (ChrN = 0);
     Path[0]:=Chr(ChrN);
     Files:=Copy(Full, Length(Path)+1, Length(Full)-Length(Path)+1);
end;

procedure DestroyFirst;
{ Destroy the first file of FilesPath directory. }
begin
     FindFirst(FilesPath+Files, SearchAttr, FileData);
     if DosError = 0 then begin
        if KeyPressed then ProcessKey;
        if CheckFileFilter(FileData) then FileDestroy(FilesPath+FileData.Name, FileData.Size);
        DestroyNext;
     end;
end;

procedure DestroyNext;
{ Destroy the remaining files of FilesPath directory. }
begin
     FindNext(FileData);
     while DosError = 0 do begin
           if CheckFileFilter(FileData) then FileDestroy(FilesPath+FileData.Name, FileData.Size);
           FindNext(FileData);
           if KeyPressed then ProcessKey;
     end;
end;

procedure BindDir(var Path: string; DirName: string);
{ It appends Path with DirName. }
begin
     Path:=Path+DirName+'\';
end;

procedure UnBindDir(var Path: string);
{ It removes the last directory name from Path. }
var CN: byte;
begin
     CN:=Length(Path)-1;
     repeat
        Dec(CN);
     until (Path[CN]='\') or (CN = 0);
     Path[0]:=Chr(CN);
end;

procedure DestroyDir;
{ Destroy subdirs! Method: recursive calls. }
var
   DirData: SearchRec;
   SearchDir: byte;
begin
     SearchDir:=SearchAttr+Directory;
     { Destroy first subdir: }
     FindFirst(FilesPath+'*.*', SearchDir, DirData);
     if DirData.Name='.' then begin
        FindNext(DirData);
        FindNext(DirData);
     end;
     repeat
        if not(DirData.Attr and Directory <> 0) then FindNext(DirData);
     until (DirData.Attr and Directory <> 0) or (DosError <> 0);
     if DosError = 0 then begin
        BindDir(FilesPath, DirData.Name);
        if not HideEnter then ReportLn('*** Entering directory: ' + FilesPath);
        DestroyFirst;
        DestroyDir; { Recursive call - destroy the subdirs of the subdir. Muwhaha! }
        { If Files = '*.*' , probably the directory is already empty,
          we'll try to delete it. }
        if (Files='*.*') and (not(TestOnly)) then SafeRmDir(FilesPath);
        UnBindDir(FilesPath);
        { Destroy the other subdirectories: }
        FindNext(DirData);
        repeat
           repeat
              if not(DirData.Attr and Directory <> 0) then FindNext(DirData);
              if DosError <> 0 then exit;
           until DirData.Attr and Directory <> 0;
           BindDir(FilesPath, DirData.Name);
           if not HideEnter then ReportLn('*** Entering directory: ' + FilesPath);
           DestroyFirst;
           DestroyDir; { Recursion. }
           if (Files='*.*') and (not(TestOnly)) then SafeRmDir(FilesPath);
           UnBindDir(FilesPath);
           FindNext(DirData);
        until (DosError <> 0);
     end;
end;

procedure FileDestroy(DestroyFile: string; FSize: longint);
{ It does the bloody work - destroys the specified file. }
var
   AnswerChar: char;
   File_To_Destroy: file;
   i, c: longint;
   SCol, SLine, RandomChar: byte;
   Buffer: array[1..8192] of byte;
   HelloManStr: string;
   RandomOffset: word;
   LineExceeded: boolean;

   procedure CantAccess(TheFile: string);
   { Called, when a file is not accessible for some reason. }
   begin
        ReportLn('Access denied to file ' + TheFile);
        Inc(FilesFailed);
   end;

begin
     { If the file is our logfile, then it's wiser to skip it, because our
       dear user probably wouldn't like if we would destroy our own report,
       during our bloody, brutal work! :D }
     if ToUpper(DestroyFile) = ToUpper(ReportName) then begin
        ReportLn('*** ' + DestroyFile + ' skipped - this is the reportfile!');
        exit;
     end;

     { Are we in test mode now? Just because we don't need to destroy the file
       in that case, we only need to report that we'd gladly do that. }
     if TestOnly then begin
        { "OH NO!!! I'm so thirsty for blood, and it's ain't my time! :(" }
        ReportLn('Found ' + DestroyFile + ' !');
        Inc(FilesDestroyed);
     end
     else begin

        assign(File_To_Destroy, DestroyFile);

        { Don't ask this, if the user given /y parameter... }
        if not YesToAll then begin
           repeat
              Report('Are you sure you want to destroy this file? ('+DestroyFile+') [Y/N] ');
              AnswerChar:=ReadKey;
              ReportLn(AnswerChar);
           until AnswerChar in LogicalAnswers;
           if not(UpCase(AnswerChar) = 'Y') then exit;
        end;

        { We set the file's attribute to Archive, otherwise, possible that the OS
          would deny the access to the file. It's too late to weep, the user had
          many chances to change his mind. }
        SetFAttr(File_To_Destroy, Archive);

        { Prepare FSize, concerning the buffer size. }
        if (FSize mod BufferSize) > 0 then
           FSize:= FSize + BufferSize - (FSize mod BufferSize);

        c:= 0;
        while (c < DestroyLevel) do begin
           case c of
              0: FillChar(Buffer, BufferSize, #$00);
              1: FillChar(Buffer, BufferSize, #$55);
              2: FillChar(Buffer, BufferSize, #$AA);
              3: FillChar(Buffer, BufferSize, #$FF);
              else
                 begin
                    { Generate a random character, and fill our buffer. }
                    Randomize;
                    RandomChar:= Random(255);
                    FillChar(Buffer, BufferSize, RandomChar);
                    { Prepare our greetings. It's dedicated for government jerks,
                      I hope if the user see this accidentally, doesn't take it on. }
                    HelloManStr:= 'Hello dumbass! It''s all done by DESTROY V'
                                  + ToString(VerHigh) + '.' + ToString(VerLow)
                                  + ' written by MegaBrutal. It''s a free software,'
                                  + ' under GNU GPLv3. Greetings.';
                    { Generate a random offset for our welcome string. :) }
                    RandomOffset:= Random(BufferSize - Length(HelloManStr));
                    { Now copy it to out buffer. }
                    Move(HelloManStr[1], Buffer[RandomOffset], Length(HelloManStr));
                 end;
           end;
           {$I-}
           reset(File_To_Destroy, 1);
           {$I+}
           if ioresult <> 0 then begin CantAccess(DestroyFile); exit; end;
           Report('Writing ' + ToString(FSize) + ' bytes to ' + DestroyFile + ' ... ');
           SCol:=WhereX; SLine:=WhereY;
           for i:=1 to FSize div BufferSize do begin
              blockwrite(File_To_Destroy, Buffer, BufferSize);
              GotoXY(SCol, SLine);
              write((i*BufferSize), ' bytes - ', (i*BufferSize)/(FSize/100):6:2, '% done.');
              { If our string accidentally exceeded the last line, we need to decrement
                SLine, otherwise we would mess up the screen. }
              if (WhereX < SCol) and (WhereY = Hi(WindMax) + 1) then begin
                 Dec(SLine, 2);
                 writeln;
              end;
           end;
           close(File_To_Destroy);
           GotoXY(SCol, SLine); ClrEOL; ReportLn('destroyed!');
           if KeyPressed then ProcessKey;
           Inc(c);
        end;
        {$I-}
        if not KeepFiles then erase(File_To_Destroy);
        {$I+}
        if ioresult = 0 then begin
           Inc(FilesDestroyed);
           if DestroyLevel = 0 then ReportLn(DestroyFile + ' has been deleted.');
        end
        else CantAccess(DestroyFile);
     end;
end;

begin
     { Write a nice header. :) }
     writeln('DESTROY file destroyer program (V', VerHigh, '.', VerLow, ') by ', Author);
     { Initialize global variables. }
     InitVars;
     ParamCheck;
     if (not(Brute) and not(TestOnly)) then ShowWarning;

     ReportLn('');
     SplitPath(ParamStr(1), Files, FilesPath); { Fjlnv rszeire bontsa. }
     { If we only test, we let the user know that. We wouldn't like to
       scare him. :) }
     if TestOnly then ReportLn('*** Test-only mode, your files won''t be removed...');
     DestroyFirst;
     { Should we destroy subdirectories as well? If yes, C'MON START THE BANZAI!!!!! }
     if SubDirs then DestroyDir;

     { We wonder, if we didn't find files: }
     if (FilesDestroyed = 0) and (FilesFailed = 0) then
        ReportLn('*** No files found - please check the parameters!');

     if not(TestOnly) then begin
        ReportLn('       ' + ToString(FilesDestroyed) + ' file(s) destroyed!');
        if FilesFailed <> 0 then ReportLn('       ' + ToString(FilesFailed) + ' file(s) failed!');
     end else ReportLn('       ' + ToString(FilesDestroyed) + ' file(s) found!');
     StopReport;
     writeln;
end.