#ifndef _RAS_PROT_H_
#define _RAS_PROT_H_

//#define OPTIMISE_SPEED


/* Specialised Raster 1D modules */
/* 1 bit plane */
class Raster1D_1Bit: virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(1);};

	virtual DWORD GetValue1D(int x) const;
	virtual void SetValue1D(int x, DWORD NewValue);
#ifdef OPTIMISE_SPEED
	virtual void Get(Raster1DAbstract &R1) const;
	void Set(const Raster1DAbstract &R1);
#endif
	};

/* 2 bit planes */
class Raster1D_2Bit: virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(2);};

	virtual DWORD GetValue1D(int x) const;
	virtual void SetValue1D(int x, DWORD NewValue);
	};

/* 4 bit planes */
class Raster1D_4Bit: virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(4);};

	virtual DWORD GetValue1D(int x) const;
	virtual void SetValue1D(int x, DWORD NewValue);
	};

/* 8 bit planes */
class Raster1D_8Bit: virtual public Raster1DAbstract
	{
public:	Raster1D_8Bit(int InitSize1D) {if((Data1D=malloc(InitSize1D))!=NULL) Size1D=InitSize1D;}
	Raster1D_8Bit(void)	{};

	virtual int GetPlanes(void) const {return(8);};
#ifdef OPTIMISE_SPEED
	virtual void Set(const Raster1DAbstract &R1);
	virtual void Get(Raster1DAbstract &R1) const;
#endif	//OPTIMISE_SPEED

	virtual DWORD GetValue1D(int x) const {if(x<Size1D) return(((BYTE *)Data1D)[x]);return(0);};
	virtual void SetValue1D(int x, DWORD NewValue) {if(Size1D<x) return;((BYTE *)Data1D)[x]=NewValue;};
	};


/* 16 bit planes */
class Raster1D_16Bit: virtual public Raster1DAbstract
	{
public: Raster1D_16Bit(int InitSize1D) {if((Data1D=malloc(2*InitSize1D))!=NULL) Size1D=InitSize1D;}
	Raster1D_16Bit(void)	{};

	virtual int GetPlanes(void) const {return(16);};

	virtual DWORD GetValue1D(int x) const {if(Size1D<=x) return(0); return(((WORD *)Data1D)[x]);};
	virtual void SetValue1D(int x, DWORD NewValue) {if(Size1D<=x) return; ((WORD *)Data1D)[x]=NewValue;};
#ifdef OPTIMISE_SPEED
	virtual void Get(Raster1DAbstract &R1) const;
	void Set(const Raster1DAbstract &R1);
#endif
	};

/* 24 bit planes Gray */
class Raster1D_24Bit:virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(24);};

	virtual DWORD GetValue1D(int x) const;
	virtual void SetValue1D(int x, DWORD NewValue);

	virtual void Get24BitRGB(void *Buffer24Bit) const;

	virtual void Peel8Bit(BYTE *Buffer8Bit, char plane8);
	virtual void Join8Bit(BYTE *Buffer8Bit, char plane8);
	};

/* 32 bit planes */
class Raster1D_32Bit:virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(32);};

	virtual DWORD GetValue1D(int x) const {if(x<Size1D) return(((DWORD *)Data1D)[x]); return(0);};
	virtual void SetValue1D(int x, DWORD NewValue) {if(x<Size1D) ((DWORD *)Data1D)[x]=NewValue; return;};
	virtual void SetValue1Dd(int x, double NewValue);
	};

#ifdef QWORD
class Raster1D_64Bit:virtual public Raster1DAbstract
	{
public: virtual int GetPlanes(void) const {return(64);};

	virtual DWORD GetValue1D(int x) const {if(x<Size1D) return(((QWORD *)Data1D)[x]); return(0);};
	virtual double GetValue1Dd(int x) const {if(x<Size1D) return(((QWORD *)Data1D)[x]); return(0);};
	virtual void SetValue1D(int x, DWORD NewValue) {if(x<Size1D) ((QWORD *)Data1D)[x]=NewValue; return;};
	virtual void SetValue1Dd(int x, double NewValue);
	};
#endif


#endif _RAS_PROT_H_