#ifndef __Common_H_INCLUDED
#define __Common_H_INCLUDED

/******** Fixing some special features of compilers **********
(c) 1997-2014 Jaroslav Fojtik
  if you don't use below mentionted compiler, please correct this items
  for your compiler and send me your correction to:
		fojtik@penguin.cz or JaFojtik@seznam.cz

Outputs: 
  __Strict_Const_Procs		compiler is very touht on const arguments
  __string_already_used		the class string is used internally
  __Disable_NULL_printf		the printf("%s",NULL) crashes
  __Ellipsis_Expand_Short       ellipse ... convert all char and short arguments to int
  __Limited_Proc_Size		several old compilers have severe limitation of procedure code size <24kB
  __No_bool			Compiler do not support bool type
  NO_LVAL_CAST			Compiler cannot compile ((char *)ptr)++
  __FixNonTemplateFriend	Templates are supported on the obsolette basis, needed <> after operator
  __Mkdir_Has_1_arg		Mkdir is defined with 1 argument only
  explicit			for compilers that do not support this keyword redefine it to "private:"
*/


#ifdef __unix
  #ifndef __UNIX__
    #define __UNIX__
  #endif
#endif
#ifdef unix
  #ifndef __UNIX__
    #define __UNIX__
  #endif
#endif


#ifdef __BORLANDC__
  #define __Have_stricmp
  #define __Mkdir_Has_1_arg
  #define LO_ENDIAN
  #ifdef __OS2__
    #define __Strict_Const_Procs
    #define __string_already_used
  #endif
  #define __FixNonTemplateFriend	//Borland C++ has templates implemented wrongly
  #if __BORLANDC__ < 0x0500
    #define __Limited_Proc_Size
    #define __No_bool
//    #define __Safe_strchr
    #define __Safe_strstr
//    #define __Safe_strcmp
    #define __Safe_strlen
  #endif
  #define explicit private:
  #ifdef __WIN32__
    #define __Strict_Const_Procs
    #ifdef IN
      #undef IN
    #endif
    #define IN %
  #else
    typedef signed char  bool;
  #endif
#endif


#if defined(__EGC__) || defined(__GNUC__)

  #define __Have_strcasecmp
  #define PACKED  __attribute__((aligned(1))) __attribute__((packed))

  #if __GNUC__ >= 3
    #define __StrictSingUnsign  
    #define __Ellipsis_Expand_Short    
    #define _has_MemStreams
    #if (__GNUC__ == 3 && __GNUC_MINOR__ >= 4) || (__GNUC__ > 3)
      #define __FixNonTemplateFriend
    #endif
    #if (__GNUC__ == 4 && __GNUC_MINOR__ >= 4) || (__GNUC__ > 4)
      #define __Strict_Const_Procs
    #endif
    #if __GNUC__ >= 4
      #define NO_LVAL_CAST
    #endif
  #endif
  #ifndef __DJGPP__
    #ifndef __UNIX__
      #define __UNIX__
    #endif
  #else		//DJGPP
    #define __Have_stricmp
    #ifdef __UNIX__
      #undef __UNIX__
    #endif
  #endif
  #ifdef sun  
    #define __Disable_NULL_printf
  #endif
#endif


#ifndef __GNUC__
#ifdef __hpux
  #ifndef __HPUXC__
    #define __HPUXC__
  #endif
#endif


#ifdef hpux
  #ifndef __HPUXC__
    #define __HPUXC__
  #endif
#endif
#endif


#ifdef _MSC_VER
  #define __Have_stricmp
  #define __StrictSingUnsign
  #define __FixNonTemplateFriend
  #define __Mkdir_Has_1_arg
  #if _MSC_VER <= 800
    #define explicit private:
  #endif
  #if _MSC_VER >= 1400	
    #define __Strict_Const_Procs
  #endif
  #define NO_LVAL_CAST
#endif


#ifdef __WATCOMC__
 #define __Have_stricmp
 #ifdef __MSDOS__
   #define __Mkdir_Has_1_arg
 #endif
#endif


#if defined(__IAR_SYSTEMS_ICC__) || defined(__ARMCC_VERSION)
 #define PACKED __packed
#endif


#ifndef PACKED
 #define	PACKED		/**< Default definition of packed - nothing. */
#endif


#endif
