/*
 * COLOR.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_COLOR
#define __INC_COLOR
#include <console.h>

#ifdef __cplusplus
 extern "C" {
#endif

enum ColorBackground {
	B_Black,
	B_Desktop,
	B_Dialog,
	B_Menus,
	B_Error,
	B_Title,
	B_DarkGray,
	B_Gray
};

enum ColorForeground {
	F_Black,
	F_Panel,
	F_Frame,
	F_Subdir,
	F_Files,
	F_System,
	F_Hidden,
	F_Gray,

	F_DarkGray,
	F_Desktop,
	F_Dialog,
	F_Menus,
	F_TitleKey,
	F_DesktopKey,
	F_DialogKey,
	F_MenusKey,
};

typedef struct {
	unsigned char	backgr[8];
	unsigned char	foregr[16];
	unsigned char	palett[16];
      } COLOR;

extern unsigned char _CType at_background[8];
extern unsigned char _CType at_foreground[16];
extern unsigned char _CType at_palett[16];

#define bg_Black	at_background[B_Black]
#define bg_Desktop      at_background[B_Desktop]
#define bg_Dialog       at_background[B_Dialog]
#define bg_Menus        at_background[B_Menus]
#define bg_Error        at_background[B_Error]
#define bg_Title        at_background[B_Title]
#define bg_DarkGray	at_background[B_DarkGray]
#define bg_Gray         at_background[B_Gray]

#define fg_Black	at_foreground[F_Black]
#define fg_Panel	at_foreground[F_Panel]
#define fg_Frame	at_foreground[F_Frame]
#define fg_Subdir	at_foreground[F_Subdir]
#define fg_Files	at_foreground[F_Files]
#define fg_System	at_foreground[F_System]
#define fg_Hidden	at_foreground[F_Hidden]
#define fg_Gray         at_foreground[F_Gray]
#define fg_DarkGray	at_foreground[F_DarkGray]
#define fg_Desktop      at_foreground[F_Desktop]
#define fg_Dialog       at_foreground[F_Dialog]
#define fg_Menus        at_foreground[F_Menus]
#define fg_TitleKey	at_foreground[F_TitleKey]
#define fg_DesktopKey	at_foreground[F_Desktop + 4]
#define fg_DialogKey	at_foreground[F_Dialog + 4]
#define fg_MenusKey	at_foreground[F_Menus + 4]

#define bg_Reverse	bg_DarkGray

#define MKAT(b,f)	(at_background[b] | at_foreground[f])

#define at_Menus	MKAT(B_Menus, 	F_Menus)
#define at_Dialog	MKAT(B_Dialog, 	F_Dialog)
#define at_Desktop	MKAT(B_Desktop, F_Desktop)
#define at_MenusKey	MKAT(B_Menus, 	F_MenusKey)
#define at_DialogKey	MKAT(B_Dialog, 	F_DialogKey)
#define at_DesktopKey	MKAT(B_Desktop,	F_DesktopKey)

#define at_Panel	MKAT(B_Desktop,	F_Panel)
#define at_Frame	MKAT(B_Desktop,	F_Frame)
#define at_Subdir	MKAT(B_Desktop,	F_Subdir)
#define at_Files	MKAT(B_Desktop,	F_Files)
#define at_System	MKAT(B_Desktop,	F_System)
#define at_Hidden	MKAT(B_Desktop,	F_Hidden)
#define at_Selected	MKAT(B_Desktop,	F_DesktopKey)

#define at_Msdos	MKAT(B_Black,   F_Gray)
#define at_Reverse	MKAT(B_DarkGray,F_Black)
#define at_Error	MKAT(B_Error, 	F_Gray)
#define at_ErTitle	MKAT(B_Gray, 	F_Black)
#define at_Title	MKAT(B_Title, 	F_Black)
#define at_TitleKey	MKAT(B_Title, 	F_TitleKey)

#define LoadColor(c)	memcpy(at_background, c, 40)

int  _CType setpal(int __0_255, int __0_15);
void _CType resetpal(void);
void _CType loadpal(unsigned char *__16);
int  _CType editpal(void);
int  _CType editattrib(void);
int  _CType editcolor(void);

#ifdef __cplusplus
 }
#endif
#endif /* __INC_COLOR */