/*
 * CTYPE.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_CTYPE
#define __INC_CTYPE
#if !defined(__INC_DEFS)
 #include <defs.h>
#endif

#ifdef __cplusplus
 extern "C" {
#endif

extern unsigned char  _CType __ctype[];
extern unsigned char *_CType __pctype;

int _CType tolower(int __ch);
int _CType toupper(int __ch);

#define _UPPER          0x1
#define _LOWER          0x2
#define _DIGIT          0x4
#define _SPACE          0x8
#define _PUNCT          0x10
#define _CONTROL        0x20
#define _BLANK          0x40
#define _HEX            0x80

#define _LEADBYTE       0x8000
#define _ALPHA          (0x0100|_UPPER|_LOWER)

#define isalpha(c)	(__ctype[c] & (_UPPER|_LOWER))
#define isupper(c)	(__ctype[c] & _UPPER)
#define islower(c)	(__ctype[c] & _LOWER)
#define isdigit(c)	(__ctype[c] & _DIGIT)
#define isxdigit(c)	(__ctype[c] & _HEX)
#define ishex(c)	(__ctype[c] & _HEX)
#define isspace(c)	(__ctype[c] & _SPACE)
#define ispunct(c)	(__ctype[c] & _PUNCT)
#define isalnum(c)	(__ctype[c] & (_UPPER|_LOWER|_DIGIT))
#define isprint(c)	(__ctype[c] & (_BLANK|_PUNCT|_UPPER|_LOWER|_DIGIT))
#define isgraph(c)	(__ctype[c] & (_PUNCT|_UPPER|_LOWER|_DIGIT))
#define iscntrl(c)	(__ctype[c] & _CONTROL)

#define _isascii(_c)	((unsigned)(_c) < 0x80)
#define _toascii(_c)	((_c) & 0x7f)
#define _tolower(_c)	((_c)-'A'+'a')
#define _toupper(_c)	((_c)-'a'+'A')

#ifdef __cplusplus
 }
#endif
#endif /* __INC_CTYPE */