/*
 * STDSC.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_STDSC
#define __INC_STDSC
#if !defined(___INC_COLOR)
 #include <color.h>
#endif
#ifdef __cplusplus
 extern "C" {
#endif

#define _getxya(x,y)	((char)getxyw(x,y) >> 8)
#define _getxyc(x,y)	(char)getxyw(x,y)

char _CType getxya(int __x, int __y);
char _CType getxyc(int __x, int __y);
WORD _CType getxyw(int __x, int __y);

void * _CType getxyp(int __x, int __y);
int _CType getxys(int, int, char *, int __lsize, int __bsize);

void _CType scputa(int, int, int __count, int __at);
WORD _CType scputw(int, int, int __count, WORD __sw);
void _CType scputfg(int __x, int __y, int __count, int __attrib);
void _CType scputbg(int __x, int __y, int __count, int __attrib);

void _CType scputs(int, int, int __at, int __max, const char *);
void _cdecl scputf(int, int, int __at, int __max, const char *, ...);
void _CType scclr(int, int, int __col, int __row, int __at);
int _CType scpath(int, int, int __max, const char *);
int _CType scenter(int, int, int __max, const char *);
#define	scputc(x,y,a,c,ch) scputw(x,y,c,MKW(a,ch))

#define _FRAMESINGLE	0
#define _FRAMEDOUBLE	1
#define _INSFRAMEVER	2
#define _INSFRAMEHOR	3
#define _INSSLINEVER	4
#define _INSSLINEHOR	5

void _CType scbox(int, int, int __col, int __row, int __type, int __at);
void *_CType scpush(int __lcount);
void _CType scpop(void *__scbuf, int __lcount);
void _CType scpushst(const char *__statusline);
void _CType scpopst(void);

int _cdecl printfs(const char *, ...);

#ifdef __cplusplus
 }
#endif
#endif