/*
 * TESTENTR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <arch.h>
#include <string.h>

/*
 * Returns 0 if entry not part of basepath,
 * else _A_ARCH or _A_SUBDIR.
 */
int testentryname(WSUB *q)
{
	int ax,bx;
	char *zp;
	fblk **fp;

	zp = q->arch;
	ax = strlen(zp);
	if (ax >= strlen(entryname))
		return 0;
	if (ax > 0) {
		if (strnicmp(entryname, zp, ax) != 0)
			return 0;
		strcpy(entryname, &entryname[ax + 1]);
		if/*while*/ (entryname[0] == ',')
			strcpy(entryname, &entryname[1]);
	}
	ax = _A_ARCH;
	for (bx = 0; entryname[bx]; bx++) {
		if (entryname[bx] == '\\') {
			entryname[bx] = 0;
			ax = _A_SUBDIR;
			break;
		}
	}
	if (q->count > 1) {
		fp = q->fcb;
		for (bx = 1; bx < q->count; bx++) {
			if (stricmp(fp[bx]->name, entryname) == 0)
				return 0;
		}
	}
	return ax;
}