;
; RCMSMOVE.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		dialog.inc

		.386P

		LOCALS

_TEXT		SEGMENT

INITLOCAL:	xor	ax,ax
		mov	al,RECT.rc_col
		mov	XCOUNT,ax
		add	ax,ax
		mov	WCOUNT,ax
		xor	ax,ax
		mov	al,RECT.rc_row
		mov	YCOUNT,ax
		push	RECT
		call	rcsprc
		mov	WORD PTR [SCRPTR],ax
		mov	WORD PTR [SCRPTR+2],dx
		cld
		test	DFLAG,_D_SHADE
		jz	SHORT @@toend
		push	RECT
		push	WCHAR
		call	rcclrshade
@@toend:	ret

RECT_RESET:	mov	ax,RELY
		add	al,RECT.rc_y
		mov	CURY,ax
		mov	ax,RELX
		add	al,RECT.rc_x
		mov	CURX,ax
		call	mouseon
		ret

RECT_INITES:	call	mouseoff
		les	di,WCHAR
		lds	dx,SCRPTR
		mov	cx,YCOUNT
		ret

RECTMOVERIGHT:	xor	ax,ax
		mov	dx,ax
		mov	dl,RECT.rc_x
		add	dl,RECT.rc_col
		cmp	dx,80
		jb	SHORT @@Init
		ret
@@Init:		inc	RECT.rc_x
		add	SCRPTR,2
		call	RECT_INITES
@@NextLine:	mov	si,dx
		add	dx,160
		push	cx
		mov	cx,XCOUNT
		mov	bx,ES:[di]
@@NextWord:	mov	ax,[si-2]
		mov	[si-2],bx
		mov	bx,ax
		lodsw
		mov	ax,ES:[di+2]
		stosw
		loop	SHORT @@NextWord
		mov	ax,[si-2]
		mov	[si-2],bx
		mov	ES:[di-2],ax
		pop	cx
		loop	SHORT @@NextLine
		jmp	SHORT RECT_RESET

RECTMOVELEFT:	xor	ax,ax
		cmp	RECT.rc_x,al
		jnz	SHORT @@Init
		ret
@@Init:		dec	RECT.rc_x
		sub	SCRPTR,2
		call	RECT_INITES
@@NextLine:	mov	si,dx
		add	dx,160
		lodsw
		mov	bx,ES:[di]
		stosw
		push	cx
		mov	cx,XCOUNT
		dec	cx
		jnz	SHORT @@NextWord
		mov	ax,[si]
		mov	[si],bx
		mov	[si-2],ax
		jmp	SHORT @@LineLoop
@@NextWord:	lodsw
		mov	[si-4],ax
		mov	ax,bx
		mov	bx,ES:[di]
		stosw
		loop	SHORT @@NextWord
		lodsw
		mov	[si-4],ax
		mov	[si-2],bx
@@LineLoop:	pop	cx
		loop	SHORT @@NextLine
		jmp	RECT_RESET

RECTMOVEUP:	cmp	RECT.rc_y,2
		jb	SHORT Nul
		call	mouseoff
		dec	RECT.rc_y
		sub	SCRPTR,160
		lds	si,WCHAR
		mov	ax,XCOUNT
		mov	dx,YCOUNT
		mul	dl
		shl	ax,1
		add	ax,si
		sub	ax,WCOUNT
		mov	si,ax
		les	di,SCRPTR
		mov	ax,YCOUNT
		mov	dl,160
		mul	dl
		add	di,ax
		xor	bx,bx
		mov	cx,XCOUNT
@@Loop2:	push	cx
		push	si
		push	di
		mov	cx,YCOUNT
		mov	dx,[si+bx]
		cmp	cx,1
		je	SHORT @@OneLine
@@Loop1:	push	bx
		sub     bx,WCOUNT
		mov	ax,[si+bx]
		pop	bx
		mov	[si+bx],ax
@@OneLine:	mov	ax,ES:[di+bx]
		mov	ES:[di+bx],dx
		mov	dx,ax
		sub	di,160
		sub	si,WCOUNT
		loop	SHORT @@Loop1
		mov	ax,ES:[di+bx]
		mov	ES:[di+bx],dx
		add	si,WCOUNT
		mov	[si+bx],ax
		add	bx,2
		pop	di
		pop	si
		pop	cx
		loop	SHORT @@Loop2
		jmp	RECT_RESET

Nul:		xor	ax,ax
		ret

RECTMOVEDOWN:	mov	ax,0040H
		mov	bx,0084H
		mov	ES,ax
		mov	al,ES:[bx]
		cmp	al,RECT.rc_y
		je	SHORT Nul
		call	mouseoff
		inc	RECT.rc_y
		add	SCRPTR,160
		les	di,SCRPTR
		xor	bx,bx
		mov	cx,XCOUNT
@@Loop2:	push	cx
		lds	si,WCHAR
		mov	di,WORD PTR SCRPTR
		mov	cx,YCOUNT
		mov	dx,[si+bx]
@@Loop1:	mov	ax,ES:[di+bx-160]
		mov	ES:[di+bx-160],dx
		push	ax
		mov	dx,bx
		add     bx,WCOUNT
		mov	ax,[si+bx]
		mov	bx,dx
		mov	[si+bx],ax
		add	di,160
		add	si,WCOUNT
		pop	dx
		loop	SHORT @@Loop1
		mov	ax,ES:[di+bx-160]
		mov	ES:[di+bx-160],dx
		sub	si,WCOUNT
		mov	[si+bx],ax
		add	bx,2
		pop	cx
		loop	SHORT @@Loop2
		jmp	RECT_RESET

_TEXT		ENDS

PPROC		rcmsmove
LOCAL		SCRPTR	: DWORD,\
		CURSOR	: DWORD,\
		XCOUNT	: WORD,\
		YCOUNT	: WORD,\
		WCOUNT	: WORD,\
		CURX	: WORD,\
		CURY	: WORD,\
		RELX	: WORD,\
		RELY	: WORD
ARG		RECT	: DWORD,\
		WCHAR	: DWORD,\
		DFLAG	: WORD
USES		DS,si,di
		call	INITLOCAL
@@GetMouseInfo:	mov	ax,3
		int	MOUSEINT
		shr	cx,3
		shr	dx,3
		mov	CURX,cx
		mov	CURY,dx
		sub	cl,RECT.rc_x
		mov	RELX,cx
		sub	dl,RECT.rc_y
		mov	RELY,dx
		mov	ah,3
		mov	bh,0
		int	10h
		mov	WORD PTR [CURSOR+0],cx
		mov	WORD PTR [CURSOR+2],dx
		cmp     cx,CURSOR_HIDDEN
		jz	SHORT @@Mainloop
		mov	cx,CURSOR_HIDDEN
		mov     ah,1
		int	10h
		jmp	SHORT @@Mainloop
@@TestMousePos:	mov	ax,3
		int	MOUSEINT
		shr	cx,3
		shr	dx,3
		push	dx
		cmp	cx,CURX
		jl	SHORT @@Left
		jg	SHORT @@Right
		pop	dx
		jmp	SHORT @@Line
@@Right:	call	RECTMOVERIGHT
		pop	dx
		jmp     SHORT @@
@@Left:		call	RECTMOVELEFT
		pop	dx
@@:		or	ax,ax
		jz      SHORT @@Line
		jmp	SHORT @@Mainloop
@@Line:		cmp	dx,CURY
		jl	SHORT @@Up
		jg	SHORT @@Down
		jmp	SHORT @@Mainloop
@@Up:		call	RECTMOVEUP
		jmp	SHORT @@Mainloop
@@Down:		call	RECTMOVEDOWN
@@Mainloop:	call	mousep
		cmp	ax,1
		jz	SHORT @@TestMousePos
		push	CURSOR
		call	setcursor
		test	DFLAG,_D_SHADE
		jz	SHORT @@toend
		push	RECT
		push	WCHAR
		call	rcsetshade
@@toend:	mov	ax,WORD PTR [RECT]
		mov	dx,WORD PTR [RECT+2]
		ret
PEND		rcmsmove

		END