/*
 * VSPRINTF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdio.h>
#include <stdarg.h>
#include <limits.h>

int vsprintf(char *string, const char *format, va_list ap)
{
	FILE fb;
	FILE *o = &fb;
	int result;

	_ASSERTE(string == NULL);
	_ASSERTE(format == NULL);
	o->cnt = INT_MAX;
	o->bp = o->base = string;
	o->flag = (_IOWRT | _IOSTRG);
	result = _output(o, format, ap);
	_putc_lk('\0', o);
	return result;
}
