/*
 * CMEDIT.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <string.h>
#include <stdlib.h>
#include <dzmain.h>

const char cp_section_edit[] = "Edit";

int load_tedit(const char *file, int type)
{
	char fn[WMAXPATH];

	strcpy(fn, file);
	if (strchr(fn, '.') == 0)
		strcat(fn, ".");
	return load_iniproc(cp_section_edit, fn, type);
}

int cmedit(void)
{
	FBLK *b;
	int type = 4;

	if (shift->ShiftRight || shift->ShiftLeft)
		type = 1;
	else if (shift->Ctrl)
		type = 2;
	else if (shift->Alt)
		type = 3;
	if ((b = panel_curobj(cpanel)) == NULL)
		return 0;
	if (ISARCHIVE(b->flag) || ISSUBDIR(b->flag))
		return 0;
	return load_tedit(b->name, type);
}