/*
 * ARCH.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 *
 *  Modification: 17.03.07 - added _ER_USERABORT
 */
#ifndef __INC_ARCH
#define __INC_ARCH

#include <wsub.h>
#include <arch/arj.h>
#include <arch/zip.h>
#include <arch/gzip.h>

#define ARCMAXFNAME	512
#define ARCTEMP_EXT	".!Z!"

#define _ER_OK		0
#define _ER_WARN	1
#define _ER_ERRZIP	2
#define _ER_BADERR	3
#define _ER_MEM		4
#define _ER_CRCERR	5
#define _ER_NOZIP	9
#define _ER_FIND	11
#define _ER_DISKFULL	50
#define _ER_USERABORT	51

#define ARCHIVE_ERROR	(-2)

#define CFREADONY	0x0001
#define CFSYSTEM	0x0002
#define CFDIRECTORY	0x0004
#define CFSELECTED	0x0008
#define CFDELETEALL	0x0010

#define MSG_DELSINGEL	 1
#define MSG_DELRDONLY	-1
#define MSG_DELSYSTEM	-2

#ifdef __cplusplus
 extern "C" {
#endif

extern int _CType arc_srchnd;
extern int _CType arc_outhnd;
extern int _CType arc_enospc;
extern char _CType entryname[ARCMAXFNAME];
extern char _CType __outpath[WMAXPATH];
extern char _CType __srcpath[WMAXPATH];
extern char _CType __outfile[WMAXPATH];
extern char _CType __srcfile[WMAXPATH];

char * _CType arc_maketemp(char *); /* compile temp name */
int _CType arc_opentemp(void);      /* uses __outfile + ARCTEMP */
int _CType arc_renametemp(void);
int _CType arc_deltemp(void);

char * _CType unixtodos(char *);
char * _CType dostounix(char *);

int _CType testentryname(WSUB *);
int _CType copyhndl(int __ih, int __oh, DWORD __size);
int _CType arc_copyhndl(int __ih, int __oh, DWORD __size);
int _CType getouthandle(const char *);
int _CType openfile(const char *, int __mode, int __action);

extern int _CType confirmflag;
int _CType confirm_delete(const char *, int __selected);
int _CType confirm_delete_file(const char *, const char __attrib);
int _CType confirm_delete_sub(const char *);
int _CType confirm_continue(const char *);

#ifdef __cplusplus
 }
#endif
#endif /* __INC_ARCH */