/*
 * DIR.H
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#ifndef __INC_DIR
#define __INC_DIR

#include <ifsmgr.h>

#define MAXDRIVE  	3
#define MAXEXT    	5
#define MAXFILE   	9
#define MAXDIR    	66
#define MAXPATH		80
#define MAXDRIVES	32

#define WMAXPATH   	260
#define WMAXDRIVE	3
#define WMAXDIR    	256
#define WMAXFILE   	256
#define WMAXEXT    	256

#define _A_STDFILES	(_A_ARCH|_A_RDONLY|_A_SYSTEM|_A_SUBDIR)
#define _A_ALLFILES	(_A_STDFILES|_A_HIDDEN)

#ifdef __cplusplus
 extern "C" {
#endif

int _CType getdrv(void);
int _CType chdrv(int);
int _CType chdir(const char *);
int _CType mkdir(const char *);
int _CType rmdir(const char *);
char * _CType getcwd(char *, int);
char * _CType fullpath(char *, int);

extern int _CType (*fp_directory)(const char *);
extern int _CType (*fp_fileblock)(const char *, wfblk *);
extern const char * _CType fp_maskp;

extern char _CType scan_curpath[]; // & = [900] byte
extern char _CType scan_curfile[];
extern wfblk _CType scan_fblock;

int _CType scansub(const char *__path, const char *__mask, int __flag);
int _CType scan_files(const char *__path);
int _CType scan_directory(int __flag, const char *__path);

#ifdef __cplusplus
}
#endif
#endif