/*
 * PROGRESS.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <Progress.h>
#include <dialog.h>
#include <string.h>
#include <arch.h>

int 	progress_xpos;
long 	progress_size;
char *	progress_src;
DOBJ 	dl_progress = { _D_STDDLG, 0, 0, {4, 9, 71, 6}, NULL, NULL };

void progress_open(const char *title, const char *func)
{
	progress_size = 0L;
	progress_xpos = 4;
	progress_src  = (char *)title;
	if (twopen(&dl_progress, at_Dialog, title)) {
		if (func != NULL) {
			wcputf(dl_progress.wp + 146, MKW(at_DialogKey, 71),
				0, "%s\n  to", func);
			progress_xpos = 9;
		}
		wcputc(dl_progress.wp + 288, 64, '');
		twshow(&dl_progress);
	}
}

void progress_close(void)
{
	twclose(&dl_progress);
}

int progress_set(const char *src, const char *dest, long size)
{
	int x,y,m;

	tupdate();
	progress_src = (src) ? strfn(src) : strfn(dest);
	if (getesc() && confirm_continue(progress_src) == 0)
		return _ER_USERABORT;
	if ((dl_progress.flag & _D_ONSCR) == 0)
		return 0;

	m = 68 - progress_xpos;
	y = dl_progress.rc.y + 2;
	x = dl_progress.rc.x + progress_xpos;
	if (src == NULL) {
		if (size == 0) {
			scputc(x, y, 0, m, ' ');
			scpath(x, y, m, dest);
		} else {
			scputc(x, y + 1, 0, m, ' ');
			scpath(x, y + 1, m, dest);
		}
	} else {
		progress_size = size;
		scputc(x, y, 0, m, ' ');
		scpath(x, y, m, src);
		scputc(x, y + 1, 0, m, ' ');
		scpath(x, y + 1, m, dest);
		scputc(x - progress_xpos + 4, y + 2, 0, 64, '');
	}
	return 0;
}

int progress_update(long fpos)
{
	int step;
	long size;

	tupdate();
	if ((dl_progress.flag & _D_ONSCR) == 0)
		return 0;

	if (mousep() &&
	    mousey() == dl_progress.rc.y &&
	    mousex() >= dl_progress.rc.x &&
	    mousex() <= dl_progress.rc.x + dl_progress.rc.col)
		dl_progress.rc = rcmsmove(dl_progress.rc, dl_progress.wp, dl_progress.flag);

	size = progress_size / 64;
	for (step = 1; step < 64; step++) {
		if (fpos < (size * step))
			break;
	}
	scputc(dl_progress.rc.x + 4, dl_progress.rc.y + 4, 0, step, '');
	if (getesc() && confirm_continue(progress_src) == 0)
		return _ER_USERABORT;
	return 0;
}
