;
; QWTOSTR.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		clib.inc
INCLUDE		string.inc

_DATA		SEGMENT

string_01	DB	'1',0
string_02	DB	'52',0
string_03	DB	'904',0
string_04	DB	'3556',0
string_05	DB	'758401',0
string_06	DB	'1277761',0
string_07	DB	'54534862',0
string_08	DB	'927694924',0
string_09	DB	'3767491786',0
string_10	DB	'777261159901',0
string_11	DB	'1444068129571',0
string_12	DB	'56017679474182',0
string_13	DB	'940737269953054',0
string_14	DB	'3972973049575027',0
string_15	DB	'796486064051292511',0
string_16	DB	'1615590737044764481',0
result		DB	'00000000000000000000',0

str_off		DW	string_01
		DW	string_02
		DW	string_03
		DW	string_04
		DW	string_05
		DW	string_06
		DW	string_07
		DW	string_08
		DW	string_09
		DW	string_10
		DW	string_11
		DW	string_12
		DW	string_13
		DW	string_14
		DW	string_15
		DW	string_16

_DATA		ENDS

		.386p

PPROC		qwtostr
USES		si,di
ARG		odx:	DWORD,\
		oax:	DWORD
		mov	ax,DS
		mov	ES,ax
		mov	di,OFFSET result
		mov	cx,5
		mov	eax,'0000'
		cld
	rep	stosd
		mov	edx,oax
		mov	ax,dx
		and	ax,15
		add	al,'0'
		mov	di,OFFSET result
		cmp	al,'9'
		jle	SHORT firstbyte
		add	al,246
		inc	[result+1]
firstbyte:	stosb
		call	convert
		mov	dx,OFFSET result
		xor	ax,ax
		mov	ah,'0'
		mov	cx,19
		mov	di,dx
		add	di,19
		std
trunc:		cmp	[di],ah
		jnz	SHORT strev
		stosb
		loop	SHORT trunc
strev:		cld
		mov	si,di
		mov	di,dx
nextchar:	mov	al,[di]
		xchg	al,[si]
		stosb
		dec	si
charloop:	cmp	di,si
		jc	SHORT nextchar
		mov	ax,dx
		MMOV	dx,DS
toend:		ret
PEND		qwtostr

_TEXT		SEGMENT

test_byte:	mov	ax,[di]
		cmp	al,'9'
		jle	SHORT byte_ok
		add	al,246
		inc	ah
		mov	[di],ax
byte_ok:	ret
add_string:	push	si
		push	cx
		mov	di,OFFSET result
		mov	cx,17
		add	BYTE PTR [di],6
		call	test_byte
		inc	di
str_loop:	lodsb
		or	al,al
		jz	SHORT end_add
		add	al,-48
		add	[di],al
		call	test_byte
		inc	di
		loop	SHORT str_loop
end_add:        call	test_byte
		pop	cx
		pop	si
		ret
convert:        mov	cx,4
		mov	bx,OFFSET str_off
		call	do_dword
		mov	edx,odx
		xor	cx,cx
		call	do_dword
		ret
do_dword:	mov	eax,edx
		shr	eax,cl
		and	ax,15
		jz	SHORT dw_loop
		mov	si,[bx]
add_next:       push	ax
		call    add_string
		pop	ax
		dec	ax
		jnz	SHORT add_next
dw_loop:	add	cx,4
		add	bx,2
		cmp	cx,32
		jnz	SHORT do_dword
dw_end:		ret

_TEXT		ENDS

		END
