;
; TDEVENT.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

include		clib.inc
include		dialog.inc
include		dos.inc

		.386p
		locals

GLOBAL PASCAL pbuttset:		DIST
GLOBAL PASCAL pbuttclr:		DIST
GLOBAL PASCAL pbuttms:		DIST
GLOBAL PASCAL tdinitobj:	DIST
GLOBAL PASCAL key_scancode: 	BYTE
GLOBAL PASCAL thelp:		DWORD

_DATA		SEGMENT

td_proctab	DW	case_ESC
		DW      case_LEFT
		DW      case_UP
		DW      case_RIGHT
		DW      case_DOWN
		DW      case_TAB
		DW      case_ENTER
		DW      case_MOUSE

td_keytable	DW      KEY_ESC
		DW      KEY_LEFT
		DW      KEY_UP
		DW      KEY_RIGHT
		DW      KEY_DOWN
		DW      KEY_TAB
		DW      KEY_ENTER
		DW	MOUSECMD

key_count	=	(($ - td_keytable) / 2)

eventproc	DW	tdpbuttevent
		DW	tdradioevent
		DW	tdcheckevent
		DW	__xcellevent
		DW	tdteditevent
		DW	tdmenusevent
		DW	__xcellevent

_DATA		ENDS

_TEXT		SEGMENT

_lc_init_rxyc:	mov	bx,ax
		lea	ax,cr
		push	SS
		push	ax
		mov	ax,WORD PTR ES:[bx.to_rect]
		mov	dx,WORD PTR ES:[bx.to_rect+2]
		les	bx,dlg
		add	ax,WORD PTR ES:[bx.dl_rect]
		mov	WORD PTR rc,ax
		mov	WORD PTR rc+2,dx
		mov	dh,0
		mov	mx,dx
		mov	dl,al
		mov	rx,dx
		mov	dl,ah
		mov	ry,dx
		call	getcursor
		ret

_lc_mouse_rxy:	call	mousey
		cmp	ax,ry
		jne	SHORT @@0
		call	mousex
		mov	dx,rx
		dec	dx
		cmp	ax,dx
		jb	SHORT @@0
		add	dx,2
		cmp	ax,dx
		jbe	SHORT @@1
@@0:            xor	ax,ax
		mov	ax,MOUSECMD
		ret
@@1:		or	ax,1
		ret

_lc_mousep:	call	mousep
		or	ax,ax
		jnz	SHORT _lc_mousep
		ret

tdpbuttevent:   call	_lc_init_rxyc
		or	ax,ax
		jz	SHORT @@
		call	cursoroff
@@:		push	rx
		push	ry
		push	mx
		call	pbuttset
		call	tgetevent
		push	ax
		push	rx
		push	ry
		push	mx
		call	pbuttclr
		pop	ax
		jmp	SHORT _lc_ret_crax

_lc_rdsetflag:	call	lesbxcobj
		and	ax,_O_RADIO
		jnz	SHORT _lc_mousep
		les	bx,dlg
		movzx	cx,ES:[bx.dl_count]
		jcxz	SHORT @@toend
		les	bx,ES:[bx.dl_object]
@@:		test	ES:[bx.to_flag],_O_RBUTT
		jz	SHORT @@next
		and	ES:[bx.to_flag],(NOT _O_RADIO)
		push	ES
		push	bx
		push	cx
		push	dlg
		push	ES
		push	bx
		call	tdinitobj
		pop	cx
		pop	bx
		pop	ES
@@next:		add	bx,16
		loop	SHORT @@
		call	lesbxcobj
		or	ES:[bx.to_flag],_O_RADIO
		push	dlg
		push	dx
		push	bx
		call	tdinitobj
		call	_lc_mousep
		mov	ax,1
@@toend:	ret

_lc_swsetflag:  call	lesbxcobj
		push	rx
		push	ry
		push	1
		mov	ax,' '
		xor	ES:[bx.to_flag],_O_FLAGB
		test	ES:[bx.to_flag],_O_FLAGB
		jz	SHORT @@
		mov	ax,'x'
@@:		push	ax
		call	scputw
		call	_lc_mousep
		ret

_lc_ret_crax:	push	ax
		push	cr
		call	setcursor
		pop	ax
		ret

tdradioevent:	call	_lc_init_rxyc
		or	ax,ax
		jnz	SHORT @@
		call	cursoron
@@:             inc	rx
		push	rx
		push	ry
		call	gotoxy
@@event:	call	tgetevent
		cmp	ax,MOUSECMD
		je	SHORT @@mouse
		cmp	ax,KEY_SPACE
		je	SHORT @@set
		jmp	SHORT _lc_ret_crax
@@mouse:        call	_lc_mouse_rxy
		jz	SHORT _lc_ret_crax
@@set:		call	_lc_rdsetflag
		jmp	SHORT @@event

tdcheckevent:	call	_lc_init_rxyc
		or	ax,ax
		jnz	SHORT @@
		call	cursoron
@@:		inc	rx
		push	rx
		push	ry
		call	gotoxy
@@event:	call	tgetevent
		cmp	ax,MOUSECMD
		je	SHORT @@mouse
		cmp	ax,KEY_SPACE
		je	SHORT @@set
		jmp	SHORT _lc_ret_crax
@@mouse:        call	_lc_mouse_rxy
		jz	SHORT _lc_ret_crax
@@set:		call	_lc_swsetflag
		jmp	SHORT @@event

tdmenusevent:	call	_lc_init_rxyc
		or	ax,ax
		jz	SHORT @@
		call	cursoroff
@@:             call	lesbxcobj
		cmp	ES:[bx.to_data],0
		jz	SHORT @@0
		push	20
		xor	ax,ax
		mov	ES,ax
		mov	al,ES:[0484h]
		mov	ES,dx
		push	ax
		push	0
		push	58
		push	ES:[bx.to_data]
		push	20
		push	ax
		push	59
		mov	al,' '
		mov	ah,at_background[B_Menus]
		or	ah,at_foreground[F_Menus]
		push	ax
		call	scputw
		call	scputs
@@0:            call	_lc_select
		call	tgetevent
		jmp	SHORT _lc_deselect

_lc_rcxyrow:	push	rc
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcxyrow
		or	ax,ax
		mov	ax,MOUSECMD
		ret

_lc_select:	push	rc
		push	SS
		lea	ax,lbuf
		push	ax
		push	SS
		push	ax
		push	mx
		mov	dl,at_background[B_DarkGray]
		push	dx
		push	rc
		push	SS
		push	ax
		call	rcread
		call	wcputbg
		call	rcxchg
		ret

_lc_deselect:   push	ax
		push	rc
		push	SS
		lea	ax,lbuf
		push	ax
		call	rcwrite
		pop	ax
		ret

__xcellevent:	call	_lc_init_rxyc
		or	ax,ax
		jz	SHORT @@
		call	cursoroff
@@:             call	_lc_select
@@loop:		call	tgetevent
		cmp	ax,MOUSECMD
		jne	SHORT @@endl
		call	_lc_rcxyrow
		jz	SHORT @@endl
		push	rx
		push	ry
		push	mx
		call	mousewait
		call	lesbxcobj
		and	ax,000Fh
		cmp	ax,_O_XHTML
		mov	ax,KEY_ENTER
		je	SHORT @@endl
		push	si
		mov	si,10
@@wait:		push	16	; wait for dobbel-click
		call	delay
		call	mousep
		or	ax,ax
		jnz	SHORT @@mousep
		dec	si
		jnz	SHORT @@wait
@@mousep:	call	mousep
		or	ax,ax
		jz	SHORT @@null
		call	_lc_rcxyrow
		jz	SHORT @@null
		mov	ax,KEY_ENTER
		jmp	SHORT @@pop
@@null:         xor	ax,ax
@@pop:		pop	si
@@endl:		or	ax,ax
		jz	SHORT @@loop
		jmp	SHORT _lc_deselect

tdteditevent:	mov	bx,ax
		push	ES:[bx.to_data]
		push	WORD PTR ES:[bx.to_rect+2]
		mov	ax,WORD PTR ES:[bx.to_rect]
		movzx	cx,ES:[bx.to_count]
		les	bx,dlg
		add	ax,WORD PTR ES:[bx.dl_rect]
		push	ax
		shl	cx,4
		push	cx
		push	1
		call	tdedit
		ret

tdgetevent:     mov	ax,ES:[bx.to_flag]
		and	ax,000Fh
		cmp	ax,6
		ja	SHORT @@
		shl	ax,1
		xchg	ax,bx
		jmp	eventproc[bx]
@@:	DBUG	push	40
	DBUG	push	40
	DBUG	call	beep
		mov	ax,KEY_ESC
		;call	tgetevent
		ret

lesbxobjsi:	les	bx,dlg
		mov	ax,si
		jmp	SHORT lesbxcobj1
lesbxcobj:	les	bx,dlg
		movzx	ax,ES:[bx.dl_index]
lesbxcobj1:	shl	ax,4
		add	ax,WORD PTR ES:[bx.dl_object]
		mov	dx,WORD PTR ES:[bx.dl_object+2]
		mov	ES,dx
		mov	bx,ax
		mov	ax,ES:[bx.to_flag]
		ret

tdexechild:     les	bx,dlg
		call	lesbxcobj1
		call	ES:[bx.to_proc]
		mov	result,ax
		cmp	ax,_C_REOPEN
		jne	SHORT @@toend
		les	bx,dlg
		mov	al,ES:[bx.dl_index]
		push	ax
		push	dlg
		call	tdinit
		pop	ax
		les	bx,dlg
		mov	ES:[bx.dl_index],al
@@toend:	ret

previtem:	test	[si.to_flag],_O_DEACT
		jz	SHORT cxtoindex
		sub	si,16
		loop	SHORT previtem
previtem_0:	xor	ax,ax
		ret
cxtoindex_if:	test	[si.to_flag],_O_DEACT
		jnz	SHORT previtem_0
cxtoindex:	les	bx,dlg
		dec	cx
		mov	ES:[bx.dl_index],cl
		mov	ax,1
		or	ax,ax
		ret

tdprevitem:	push	DS
		push	si
		lds	si,dlg
		movzx	cx,[si.dl_index]
		jcxz    SHORT @@
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		call	previtem
		jnz	SHORT @@toend
@@:		lds	si,dlg
		movzx	cx,[si.dl_count]
		jcxz    SHORT @@null
		mov	bl,[si.dl_index]
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		xor	ax,ax
@@loop:		cmp	bl,cl
		ja	SHORT @@null
		test	[si.to_flag],_O_DEACT
		jz	SHORT @@ok
		sub	si,16
		loop	SHORT @@loop
@@null:		xor	ax,ax
@@toend:	pop	si
		pop	DS
		ret
@@ok:		call	cxtoindex
		jmp	SHORT @@toend

tditemleft:	push	DS
		push	si
		lds	si,dlg
		movzx	cx,[si.dl_index]
		jcxz    SHORT @@null
		lds	si,[si.dl_object]
		mov	ax,cx
		dec	ax
		shl	ax,4
		add	si,ax
		mov	bx,WORD PTR [si.to_rect.16]
@@loop:		cmp	bh,[si.to_rect.rc_y]
		jne	SHORT @@next
		cmp	bl,[si.to_rect.rc_x]
		jbe	SHORT @@next
		call	cxtoindex_if
		jnz	SHORT @@toend
@@next:		sub	si,16
		loop	SHORT @@loop
@@null:		xor	ax,ax
@@toend:	pop	si
		pop	DS
		ret

tdnextitem:	push	DS
		push	si
		push	di
		lds	si,dlg
		movzx	di,[si.dl_count]
		movzx	cx,[si.dl_index]
		inc	cx
		lds	si,[si.dl_object]
		mov	ax,cx
		shl	ax,4
		add	si,ax
		inc	cx
@@loop:         cmp	cx,di
		ja	SHORT @@2
		call	cxtoindex_if
		jnz	SHORT @@toend
		inc	cx
		add	si,16
		jmp	SHORT @@loop
@@2:		lds	si,dlg
		movzx	di,[si.dl_index]
		inc	di
		mov	cx,1
		lds	si,[si.dl_object]
@@loop2:	cmp	cx,di
		ja	SHORT @@null
		call	cxtoindex_if
		jnz	SHORT @@toend
		inc	cx
		add	si,16
		jmp	SHORT @@loop2
@@null:		xor	ax,ax
@@toend:        pop	di
		pop	si
		pop	DS
		ret

tditemright:	push	DS
		push	si
		push	di
		lds	si,dlg
		movzx	di,[si.dl_count]
		movzx	cx,[si.dl_index]
		inc	cx
		lds	si,[si.dl_object]
		mov	ax,cx
		shl	ax,4
		add	si,ax
		mov	bx,WORD PTR [si.to_rect-16]
		inc	cx
@@loop:         cmp	cx,di
		ja	SHORT @@null
		cmp	bh,[si.to_rect.rc_y]
		jne	SHORT @@next
		cmp	bl,[si.to_rect.rc_x]
		jae	SHORT @@next
		call	cxtoindex_if
		jnz	SHORT @@toend
@@next:         inc	cx
		add	si,16
		jmp	SHORT @@loop
@@null:		xor	ax,ax
@@toend:        pop	di
		pop	si
		pop	DS
		ret

case_MOUSE:     call	mousex
		mov	mx,ax
		call	mousey
		mov	my,ax
		les	bx,dlg
		push	ES:[bx.dl_rect]
		push	mx
		push	ax
		call	rcxyrow
		or	ax,ax
		jnz	SHORT @@
		mov	result,_C_ESCAPE
		ret
@@:		les	bx,dlg
		movzx	ax,ES:[bx.dl_rect.rc_x]
		mov	rx,ax
		sub	mx,ax
		movzx	ax,ES:[bx.dl_rect.rc_y]
		mov	ry,ax
		sub	my,ax
		push	si
		xor	si,si
@@objloop:	les	bx,dlg
		movzx	ax,ES:[bx.dl_count]
		cmp	ax,si
		ja	SHORT @@loop
		jmp	@@endl
@@loop:		push	ES:[bx.dl_rect]
		call	lesbxobjsi
		push	ES:[bx.to_rect]
		call	rcaddrc
		mov	WORD PTR rc,ax
		mov	WORD PTR rc+2,dx
		test	ES:[bx.to_flag],_O_DEACT
		jnz	SHORT @@deact
		push	ES:[bx.to_rect]
		push	mx
		push	my
		call	rcxyrow
		or	ax,ax
		jz	SHORT @@next
		les	bx,dlg
		mov	ax,si
		mov	ES:[bx.dl_index],al
		call	lesbxobjsi
		push	ax
		and	ax,000Fh
		cmp	ax,_O_PBUTT
		jnz	SHORT @@nopb
		mov	al,rc.rc_x
		push	ax
		mov	al,rc.rc_y
		push	ax
		mov	al,rc.rc_col
		push	ax
		call	pbuttms
@@nopb:		pop	ax
		test	ax,_O_DEXIT
		jz	SHORT @@0
		mov	result,_C_ESCAPE
		pop	si
		ret
@@0:		test	ax,_O_CHILD
		jz	SHORT @@1
		mov	ax,si
		pop	si
		call	tdexechild
		ret
@@1:            pop	si
		and	ax,000Fh
		cmp	ax,_O_PBUTT
		je	SHORT @@exit
		cmp	ax,_O_MENUS
		je	SHORT @@exit
		cmp	ax,_O_XHTML
		je	SHORT @@exit
		mov	result,_C_NORMAL
		ret
@@exit:		mov	result,_C_RETURN
		ret
@@next:		inc	si
		jmp	@@objloop
@@deact:	mov	ax,ES:[bx.to_flag]
		test	ax,_O_CHILD
		jz	SHORT @@next
		and	ax,000Fh
		cmp	ax,_O_MOUSE
		jne	SHORT @@next
		push	bx
		push	ES:[bx.to_rect]
		push	mx
		push	my
		call	rcxyrow
		pop	bx
		or	ax,ax
		jz	SHORT @@next
		mov	ax,si
		pop	si
		call	tdexechild
		ret
@@endl:		pop	si
		les	bx,dlg
		push	ES:[bx.dl_rect]
		call	mousex
		push	ax
		call	mousey
		push	ax
		call	rcxyrow
		cmp	ax,1
		jne	SHORT @@mouse
@@mov:		push	dlg
		call	twmove
@@mouse:	call	mousep
		or	ax,ax
		jnz	SHORT @@mouse
@@toend:	mov	result,_C_NORMAL
		ret

case_ESC:	mov	result,_C_ESCAPE
		ret
case_LEFT:	call	lesbxcobj
		and	ax,000Fh
		cmp	ax,_O_MENUS
		jne	SHORT @@0
		mov	di,1
		ret
@@0:		call	tditemleft
		jz	SHORT case_UP
		ret
case_UP:	call	tdprevitem
		ret
case_RIGHT:	call	lesbxcobj
		and	ax,000Fh
		cmp	ax,_O_MENUS
		jne	SHORT @@0
		mov	di,1
		ret
@@0:		call	tditemright
		jz	SHORT case_DOWN
		ret
case_DOWN:
case_TAB:	call	tdnextitem
		ret
case_ENTER:     call	lesbxcobj
		and	ax,_O_CHILD
		mov	ax,_C_RETURN
		jz	SHORT @@
		les	bx,dlg
		movzx	ax,ES:[bx.dl_index]
		call	tdexechild
		ret
@@:		mov	result,ax
		ret

tdshortkey:     push	ax
		test	ES:[bx.to_flag],_O_DEACT
		jnz	SHORT @@null
		cmp     ES:[bx.to_ascii],0
		je	SHORT @@null
		and	al,0DFh
		cmp     ES:[bx.to_ascii],al
		je	SHORT @@ok
		mov     al,ES:[bx.to_ascii]
		and	al,0DFh
		sub	al,'A'
		push	bx
		movzx	bx,al
		cmp	ah,key_scancode[bx]
		pop	bx
		jne	SHORT @@null
@@ok:		or	ax,1
		jmp	SHORT @@toend
@@null:         xor	ax,ax
@@toend:        pop	ax
		ret

tdhndevent:	or	ax,ax
		jnz	SHORT @@
		ret
@@:		push	si
		xor	edx,edx
		mov	si,dx
		les	bx,dlg
		movzx	cx,ES:[bx.dl_count]
		les	bx,ES:[bx.dl_object]
@@loop:         test	ES:[bx.to_flag],_O_GLCMD
		jnz	SHORT @@glcmd
@@thelp:	test	ES:[bx.to_flag],_O_DHELP
		jnz	SHORT @@help
@@tskey:	call	tdshortkey
		jnz	SHORT @@skey
		add	bx,16
		inc	si
		loop	SHORT @@loop
		or	dx,dx
		jz	SHORT @@null
		mov	bx,dx
		shr	edx,16
		mov	ES,dx
@@nkey:		cmp	ES:[bx.gl_key],0
		jz	SHORT @@null
		cmp	ES:[bx.gl_key],ax
		je	SHORT @@gl_proc
		add	bx,SIZE S_GLCMD
		jmp	SHORT @@nkey
@@glcmd:	mov	edx,ES:[bx.to_data]
		jmp	SHORT @@thelp
@@skey:		mov	ax,si
		les	bx,dlg
		mov	ES:[bx.dl_index],al
		mov	ax,1
		jmp	SHORT @@toend
@@gl_proc:	call    ES:[bx.gl_proc]
		jmp	SHORT @@toend
@@help:		cmp	ax,KEY_F1
		jne	SHORT @@tskey
		cmp	thelp,0
		jz	SHORT @@tskey
		call	thelp
		jmp	SHORT @@toend
@@null:		xor	ax,ax
@@toend:        pop	si
		ret

tdhandle_event:	mov	cx,key_count
		xor	bx,bx
@@keyloop:	cmp	ax,[bx.td_keytable]
		jz	SHORT @@exe
		add	bx,2
		loop	SHORT @@keyloop
		call	tdhndevent
		mov	result,ax
		ret
@@exe:		call	[bx.td_proctab]
		ret

_TEXT		ENDS

PPROC		tdevent
USES		si,di
ARG		dlg:	DPTR
LOCAL           lbuf:	WORD:[80],\
		cursor:	DWORD,\
		cr:	DWORD,\
		rx,ry:	WORD,\
		mx,my:	WORD,\
		rc:	DWORD,\
		cobj:	DWORD,\
		event:	WORD,\
		result:	WORD
		les	bx,dlg
		mov	si,ES:[bx.dl_flag]
		test	si,_D_DOPEN
		jnz	SHORT @@0	; if not open -- open it
		push	dlg
		call	twopen
		or	ax,ax
		jz	SHORT @@toend
@@0:            test	si,_D_ONSCR
		jnz	SHORT @@1	; if hidden -- make it visible
		push	dlg
		call	twshow
		or	ax,ax
		jz	SHORT @@toend
@@1:		lea	ax,cursor
		push	SS
		push	ax
		call	getcursor 	; save cursor
		call	cursoroff
		call	lesbxcobj
		and	ax,_O_DEACT
		jz	SHORT @@2
		call	tdnextitem
		jz	SHORT @@toend
@@2:		call	mousep 		; wait for mouse
		or	ax,ax
		jnz	SHORT @@2
		xor	di,di
		jmp	SHORT @@loop
@@toend:	ret
@@extrn:	call	ES:[bx.to_proc]
		jmp	SHORT @@set
@@loop:		mov	result,0
		call	lesbxcobj
		and	ax,_O_EVENT
		jnz	SHORT @@extrn
		call	tdgetevent
@@set:		mov	event,ax
		call	tdhandle_event
		cmp	result,_C_ESCAPE
		je	SHORT @@esc
		cmp	result,_C_RETURN
		je	SHORT @@return
		or	di,di
		jz	SHORT @@loop

@@break:	push	cursor
		call	setcursor
		mov	ax,event
		jmp	SHORT @@toend
@@esc:		mov	event,0
		jmp	SHORT @@break
@@return:	cmp	event,KEY_ENTER
		jne	SHORT @@index
		call	lesbxcobj
		and	ax,_O_DEXIT
		jnz	SHORT @@esc
@@index:	les	bx,dlg
		movzx	ax,ES:[bx.dl_index]
		inc	ax
		mov	event,ax
		jmp	SHORT @@break
PEND		tdevent

PPROC		tdxcellevent
USES		si,di
ARG		@@dlg:	DWORD,\
		@@obj:	DWORD
LOCAL           @@buf:	BYTE:[188]
		mov	eax,@@dlg
		les	bx,@@obj
		mov	@@obj,eax
		mov	ax,bx
		call	__xcellevent
		ret
PEND		tdxcellevent

		END
