/*
 * WCSTRCPY.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <wchar.h>
#include <string.h>

char *wcstrcpy(char *p, WCHR far *w, int count)
{
	int q,z;

	z = 0;
	p[z] = '\0';
	for (q = 0; q < count; q++) {
		if (w[q].ch != ' ') {
			z++;
			break;
		}
	}
	if (z == 0)
		return p;
	z = 0;
	for (; q < count; q++, z++) {
		if ((w[q].at & 0x0F) > 11) {
			p[z] = '&';
			z++;
			p[z] = w[q].ch;
		} else {
			p[z] = w[q].ch;
		}
	}
	p[z] = '\0';
	strtrim(p);
	return p;
}
