/*
 * WSRDARJ.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <string.h>
#include <arch.h>

static int warjreadentry(ARJ *, int __handle);
static int warjreadmainentry(ARJ *, int __handle);
static FBLK *warjalloc(ARJ *, WSUB *);

int warjreadmainentry(ARJ *p, int handle)
{
	WORD extsize;

	if (osread(handle, p, ARJHEADERVSIZE) != ARJHEADERVSIZE)
		return ARJERFAIL;
	if (p->id != ARJHEADERID)
		return ARJERFAIL;
	if (lseek(handle, 8L + p->size_head, SEEK_SET) == -1)
		return ARJERFAIL;
	if (osread(handle, &extsize, 2) != 2)
		return ARJERFAIL;
	if (extsize && lseek(handle, 4L + extsize, SEEK_CUR) == -1)
		return ARJERFAIL;
	return 0;
}

int warjreadentry(ARJ *p, int handle)
{
	WORD result;

	if (osread(handle, p, sizeof(ARJ)) != sizeof(ARJ))
		return 0;
	_ASSERT(p->type == 2);
	_ASSERT(p->type == 4);
	_ASSERT(p->flag & ARJBACKUP);
	if (p->id != ARJHEADERID)
		return 0;
	if (p->size_head - 34 > WMAXPATH)
		result = osread(handle, entryname, WMAXPATH);
	else
		result = osread(handle, entryname, p->size_head - 30);
	if (lseek(handle, 4L + p->size_head - result - 30, SEEK_CUR) == -1)
		return 0;
	if (osread(handle, &result, 2) != 2)
		return 0;
	if (result) { /* Seek to start of next entry */
		if (lseek(handle, p->compressed_size + result + 4L, SEEK_CUR) == -1)
			return 0;
	} else {
		if (lseek(handle, p->compressed_size, SEEK_CUR) == -1)
			return 0;
	}
	unixtodos(entryname);
	return 1;
}

FBLK *warjalloc(ARJ *p, WSUB *q)
{
	wfblk w;

	if (p->flag & ARJEXTFILE)
		return NULL;
	if (!(w.attrib = testentryname(q)))
		return NULL;
	if (ISSUBDIR(w.attrib) == 0 && cmpwarg(entryname, q->mask) == 0)
		return NULL;
	w.attrib |= _A_ARJ;
	w.time_modified = p->time;
	w.date_modified = p->date;
	w.size_low = p->original_size;
	strcpy(w.name, entryname);
	if (!ISSUBDIR(w.attrib) && !*q->flag & _W_LONGNAME)
		strlwr(w.name);
	return fballocwf(&w, w.attrib);
}

int warjread(WSUB *q)
{
	int h;
	wfblk w;
	fblk *b;
	ARJ entry;

	wsfree(q);
	if ((h = wsopenarch(q)) == -1)
		return ARCHIVE_ERROR;
	if (warjreadmainentry(&entry, h)) {
		close(h);
		return ARCHIVE_ERROR;
	}
	if (warjreadentry(&entry, h) == 0) {
		close(h);
		return ARCHIVE_ERROR;
	}
	q->fcb[0] = fbupdir(_A_ARJ);
	q->count = 1;
	do {
		if ((b = warjalloc(&entry, q)) == NULL)
			continue;
		q->fcb[q->count] = b;
		if (++q->count >= q->maxfb)
			break;
	} while (warjreadentry(&entry, h) != 0);
	close(h);
	return q->count;
}