/*
 * CMCOMPAR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#include <string.h>
#include <dzmain.h>

int cmcompare(void)
{
	panel *A;
	panel *B;
	fblk **fcb_A;
	fblk **fcb_B;
	int count_A; /* Number of files in Panel A */
	int count_B;
	int count_S; /* Number of identical files */
	int ax,bx;

	A = &panela;
	B = &panelb;
	if (cpanel != A) {
		B = A;
		A = &panelb;
	}
	if (!panel_state(A) || !panel_state(B))
		return 0;
	if ((*A->flag & _W_LONGNAME) != (*B->flag & _W_LONGNAME))
		return stdmsg(cp_compare, cp_different);

	fcb_A = A->ide->fcb;
	fcb_B = B->ide->fcb;
	count_A = A->fcb_count;
	count_B = B->fcb_count;

/* Selected all files in both panels */
	for (ax = 0; ax < A->fcb_count; ax++) {
		if (ISSUBDIR(fcb_A[ax]->flag)) {
			fcb_A[ax]->flag &= ~_A_SELECTED;
			count_A--;
		} else {
			fcb_A[ax]->flag |= _A_SELECTED;
		}
	}
	for (bx = 0; bx < B->fcb_count; bx++) {
		if (ISSUBDIR(fcb_B[bx]->flag)) {
			fcb_B[bx]->flag &= ~_A_SELECTED;
			count_B--;
		} else {
			fcb_B[bx]->flag |= _A_SELECTED;
		}
	}

/* If both panels have zero files they are identical */
	if (count_A + count_B == 0) {
		panel_putitem(B, 0);
		panel_putitem(A, 0);
		return stdmsg(cp_compare, cp_identical);

/* If one of the panels have zero files, then all is ok (selected) */
	} else if (count_A == 0 || count_B == 0) {
		panel_putitem(B, 0);
		panel_putitem(A, 0);
		return 0;
	}

/* Compare file blocks and de-select if equal */
	count_S = 0;
	for (ax = A->fcb_count - count_A; ax < A->fcb_count; ax++) {
		for (bx = B->fcb_count - count_B; bx < B->fcb_count; bx++) {
			if (fcb_A[ax]->time == fcb_B[bx]->time &&
			    fcb_A[ax]->date == fcb_B[bx]->date &&
			    fcb_A[ax]->size == fcb_B[bx]->size &&
			    0 == strcmp(fcb_A[ax]->name, fcb_B[bx]->name)) {
				fcb_A[ax]->flag &= ~_A_SELECTED;
				fcb_B[bx]->flag &= ~_A_SELECTED;
				count_S++;
				break;
			}
		}
	}
	panel_putitem(B, 0);
	panel_putitem(A, 0);
	if (count_A == count_B && count_B == count_S)
		stdmsg(cp_compare, cp_identical);
	return 1;
}
