;
; FBLK.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

;;; Output of files in panels

INCLUDE		clib.inc
INCLUDE		stdio.inc
INCLUDE		string.inc
INCLUDE		dialog.inc
INCLUDE		dzmain.inc

		.386p

		LOCALS

_DATA		SEGMENT

		PUBLIC	cp_subdir
		PUBLIC	cp_updir

cp_subdir	DB	" SUBDIR ",0
cp_updir	DB	" UP-DIR ",0
cp_timefrm	DB	"%2u:%02u",0
cp_datefrm	DB	"%2u.%02u.%02u",0
format_10lu	DB	"%10lu",0
format_7lu	DB	"%7lu%c",0
cp_strmega	DB	0,"KMGT"

_DATA		ENDS

_TEXT		SEGMENT

;;; Select and invert fileblock

FBLKIsSelect	PROC	NEAR
		mov	ax,ES:[bx.fb_flag]
		test	ax,_A_VOLID
		jnz	SHORT @@0
		and	ax,_A_SUBDIR
		jz	SHORT @@1
		test	config.c_lflag,_C_SELECTDIR
		jnz	SHORT @@1
@@0:		xor	ax,ax
		ret
@@1:		or	ax,1
		ret
FBLKIsSelect	ENDP

;;; Get color from flag

fbcolor		PROC	NEAR
		test	ax,_A_SELECTED
		jnz	SHORT @@sel
		test	ax,_A_HIDDEN
		jnz	SHORT @@hid
		test	ax,(_A_SYSTEM or _A_UPDIR)
		jnz	SHORT @@sys
		test	ax,_A_SUBDIR
		jnz	SHORT @@sub
		mov	al,at_foreground[F_Files]
@@toend:	or	al,at_background[B_Desktop]
		ret
@@sel:		mov	al,at_foreground[F_Panel]
		jmp	SHORT @@toend
@@hid:		mov	al,at_foreground[F_Hidden]
		jmp	SHORT @@toend
@@sys:		mov	al,at_foreground[F_System]
		jmp	SHORT @@toend
@@sub:		mov	al,at_foreground[F_Subdir]
		jmp	SHORT @@toend
fbcolor		ENDP

;;; ES:BX: fileblock, DX: xpos

fbputsize	PROC	NEAR
		push	ES:[bx.fb_size]
		push	DS
		push	OFFSET format_10lu
		push	0
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		push	ax
		push	fby
		push	dx
		call	scputf
		add	sp,16
		ret
fbputsize	ENDP

;;; AX: WCHAR, DX: xpos

fbputw		PROC	NEAR
		push	dx
		push	fby
		push	1
		push	ax
		call	scputw
		ret
fbputw		ENDP

;;; DX: xpos

fbsyshidden	PROC	NEAR
		les	bx,fblk
		mov	ax,ES:[bx.fb_flag]
		and	ax,(_A_HIDDEN or _A_SYSTEM)
		jnz	SHORT @@
@@:		ret
		call	fbcolor
		jmp	SHORT fbputw
fbsyshidden	ENDP

;;; AX: xpos

fbputmax	PROC	NEAR
		mov	dx,ax
		mov	al,175
		mov	ah,at_foreground[F_Panel]
		or	ah,at_background[B_Desktop]
		jmp	SHORT fbputw
fbputmax	ENDP

;;; AX: xpos

scputsi		PROC	NEAR
		xor	dx,dx
scputsi		ENDP

;;; AX: xpos, DX: count, SI: color

fbputs		PROC	NEAR
		push	ax
		push	fby
		push	si
		push	dx
		push	ES
		add	bx,fb_name
		push	bx
		call	scputs
		ret
fbputs		ENDP

;;; AX: xpos

fbdatetime	PROC	NEAR
		push	fblk
		push	ax
		push	fby
		push	fblk
		add	ax,9
		push	ax
		push	fby
		call	fbputtime
		call	fbputdate
		ret
fbdatetime	ENDP

_TEXT    	ENDS

;;; Out File Time

PPROC		fbputtime
ARG		fblk:	DWORD,\
		fbx:	WORD,\
		fby:	WORD
		les	bx,fblk
		mov	ax,ES:[bx.fb_time]
		shr	ax,5
		and	ax,003Fh
		push	ax
		mov	ax,ES:[bx.fb_time]
		shr	ax,11
		and	ax,001Fh
		push	ax
		push	DS
		push	OFFSET cp_timefrm
		push	0
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		push	ax
		push	fby
		push	fbx
		call	scputf
		add	sp,16
		ret
PEND		fbputtime

;;; Out File Date

PPROC		fbputdate
ARG		@@fb:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
		les	bx,@@fb
		mov	ax,ES:[bx.fb_date]
		shr	ax,9
		cmp	ax,20
		jb	SHORT @@
		sub	ax,20
		jmp	SHORT @@0
@@:             add	ax,80
@@0:		push	ax
		mov	ax,ES:[bx.fb_date]
		shr	ax,5
		and	ax,000Fh
		push	ax
		mov	ax,ES:[bx.fb_date]
		and	ax,001Fh
		push	ax
		push	DS
		push	OFFSET cp_datefrm
		push	0
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		push	ax
		push	@@y
		push	@@x
		call	scputf
		add	sp,18
		ret
PEND		fbputdate

;;; Out Short 8.3

PPROC		fbput83
ARG		@@x:	WORD,\
		@@y:	WORD,\
		@@at:	WORD,\
		@@fn:	DWORD
		push	@@fn
		push	'.'
		call	strrchr
		push	ax
		or	ax,ax
		jz	SHORT @@
		mov	ES,dx
		mov	bx,ax
		xor	ax,ax
		mov	ES:[bx],al
@@:             push	@@x
		push	@@y
		push	@@at
		push	8
		push	@@fn
		call	scputs
		pop	ax
		or	ax,ax
		jz	SHORT @@toend
		mov	ES,WORD PTR @@fn+2
		mov	bx,ax
		mov	BYTE PTR ES:[bx],'.'
		mov	ax,@@x
		add	ax,9
		push	ax
		push	@@y
		push	@@at
		push	3
		push	ES
		inc	bx
		push	bx
		call	scputs
@@toend:	ret
PEND		fbput83

;;; Out Short List

PPROC		fbputsl
ARG		@@fb:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
		les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		push	@@x
		push	@@y
		push	ax
		test	ES:[bx.fb_flag],_A_UPDIR
		jnz	SHORT @@upd
		push	ES
		add	bx,fb_name
		push	bx
		call	fbput83
		mov	dx,@@x
		add	dx,8
		call	fbsyshidden
		jmp	SHORT @@toend
@@upd:          push	0
		push	ES
		add	bx,fb_name
		push	bx
		call	scputs
@@toend:	ret
PEND		fbputsl

;;; Out Short Detail

PPROC		fbputsd
ARG		fblk:	DWORD,\
		fbx:	WORD,\
		fby:	WORD
		push	fblk
		push	fbx
		push	fby
		call	fbputsl
		les	bx,fblk
		mov	ax,ES:[bx.fb_flag]
		test	ax,_A_SUBDIR
		jnz	SHORT @@sub
		mov	dx,fbx
		add	dx,13
		call	fbputsize
		jmp	SHORT @@toend
@@sub:          mov	dx,ax
		mov	ax,fbx
		add	ax,13
		push	ax
		push	fby
		mov	ax,dx
		call	fbcolor
		push	ax
		push	0
		push	DS
		test	dx,_A_UPDIR
		jnz	SHORT @@upd
		push	OFFSET cp_subdir
		jmp	SHORT @@
@@upd:		push	OFFSET cp_updir
@@:		call	scputs
@@toend:        mov	ax,fbx
		add	ax,24
		call	fbdatetime
		ret
PEND		fbputsd

;;; Out Long List

PPROC		fbputll
USES		si,di
ARG		@@fb:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
		mov	di,16
		cmp	@@x,59
		jne	SHORT @@0
		mov	di,18
@@0:		cmp	@@x,20
		je	SHORT @@inc
		cmp	@@x,60
		jne	SHORT @@1
@@inc:		inc	di
@@1:		les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		mov	si,ax
		test	ES:[bx.fb_flag],_A_UPDIR
		jnz	SHORT @@upd
		push	ES
		add	bx,fb_name
		push	bx
		call	strlen
		cmp	ax,di
		jb	SHORT @@2
		mov	ax,@@x
		add	ax,di
		call	fbputmax
@@2:		push	@@x
		push	@@y
		push    si
		push	di
		push	WORD PTR @@fb+2
		mov	ax,WORD PTR @@fb
		add	ax,fb_name
		push	ax
		call	scputs
		mov	dx,di
		add	dx,@@x
		inc	dx
		call	fbsyshidden
		jmp	SHORT @@toend
@@upd:          mov	ax,@@x
		call	scputsi
@@toend:	ret
PEND		fbputll

;;; Out Long Detail

PPROC		fbputld
USES		si,di
ARG		@@fb:	DWORD,\
		@@x:	WORD,\
		@@y:	WORD
		les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		call	fbcolor
		mov	si,ax
		push	ES
		add	bx,fb_name
		push	bx
		call	strlen
		mov	di,ax
		test	config.c_lflag,_C_HORIZONTAL
		jnz	SHORT @@
		jmp	@@vertical
@@:		les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		test	ax,_A_UPDIR
		jz	SHORT @@0
		mov	ax,@@x
		call	scputsi
		push	54
		push	@@y
		push    si
		push	0
		push	DS
		push	OFFSET cp_updir
		call	scputs
		jmp	SHORT @@1
@@0:		cmp	di,52
		jna	SHORT @@01
		mov	ax,1
		mov	dx,51
		call	fbputs
		mov	ax,52
		call	fbputmax
		jmp	SHORT @@02
@@01:		mov	ax,1
		call	scputsi
@@02:		mov	dx,52
		call	fbsyshidden
		les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		test	ax,_A_SUBDIR
		jnz	SHORT @@04
		mov	dx,54
		call	fbputsize
		jmp	SHORT @@1
@@04:		push	54
		push	@@y
		push	si
		push	0
		push	DS
		push	OFFSET cp_subdir
		call	scputs
@@1:		mov	ax,@@x
		add	ax,64
		call	fbdatetime
		jmp	SHORT @@toend
@@upd:          mov	ax,@@x
		call	scputsi
		jmp	SHORT @@toend
@@vertical:	les	bx,@@fb
		mov	ax,ES:[bx.fb_flag]
		test	ax,_A_UPDIR
		jnz	SHORT @@upd
		test	ax,_A_SUBDIR
		jnz	SHORT @@sub
		mov	dx,@@x
		add	dx,28
		call	fbputsize
@@sub:		push	@@x
		push	@@y
		push	si
		les	bx,@@fb
		cmp	di,27
		jbe	SHORT @@2
		mov	ax,26
		push	ax
		push	ES
		add	bx,fb_name
		push	bx
		add	ax,@@x
		call	fbputmax
		jmp	SHORT @@3
@@2:		push	0
		push	ES
		add	bx,fb_name
		push	bx
@@3:		call	scputs
		mov	dx,@@x
		add	dx,26
		call	fbsyshidden
@@toend:	ret
PEND		fbputld

;;; Out Mini Status

PPROC		fbputfile
ARG		fblk:	DWORD,\
		fbx:	WORD,\
		fby:	WORD
LOCAL		result:	BYTE:[32]
		push	fblk
		push	fbx
		push	fby
		call	fbputll
		les	bx,fblk
		mov	ax,fbx
		add	ax,15
		test	ES:[bx.fb_flag],_A_SUBDIR
		jnz	SHORT @@isupd
		push	ax
		push	fby
		mov	al,at_foreground[F_Files]
		or	al,at_background[B_Desktop]
		push	ax
		push	0
		mov	eax,ES:[bx.fb_size]
		xor	bx,bx
@@cmp:		cmp	eax,1000000
		jb	SHORT @@str
		shr	eax,10
		inc	bx
		jmp	SHORT @@cmp
@@str:          mov	dl,cp_strmega[bx]
		push	dx
		push	eax
		push	DS
		push	OFFSET format_7lu
		push	SS
		lea	ax,result
		push	ax
		call	sprintf
		add	sp,14
		push	SS
		lea	ax,result
		push	ax
		jmp	SHORT @@toend
@@isupd:	test	ES:[bx.fb_flag],_A_UPDIR
		jz	SHORT @@issub
		inc	ax
		push	ax
		push	fby
		mov	al,at_foreground[F_System]
		or	al,at_background[B_Desktop]
		push	ax
		push	7
		push	DS
		push	(OFFSET cp_updir + 1)
		jmp	SHORT @@toend
@@issub:	inc	ax
		push	ax
		push	fby
		mov	al,at_foreground[F_Subdir]
		or	al,at_background[B_Desktop]
		push	ax
		push	7
		push	DS
		push	(OFFSET cp_subdir + 1)
@@toend:	call	scputs
		mov	ax,fbx
		add	ax,24
		call	fbdatetime
		ret
PEND		fbputfile

PPROC		select_fb
USES		si,di
ARG		@@fb:	DWORD
		les	bx,@@fb
		call	FBLKIsSelect
		jz	SHORT @@toend
		push	@@fb
		call	fbselect
@@toend:	ret
PEND		select_fb

PPROC		invert_fb
ARG		@@fb:	DWORD
		les	bx,@@fb
		call	FBLKIsSelect
		jz	SHORT @@toend
		push	@@fb
		call	fbinvert
@@toend:	ret
PEND		invert_fb

		END
