/*
 * RES_EN.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */
#if !defined(__INC__DTYPES)
 #include <_dtypes.h>
#endif

#define	_RCEDIT_

const char cp_copyright[] =
"The Doszip Commander, BETA Version v1.29\n"
"========================================\n"
"Copyright (c) 1996-98 by Hjort Nidudsson\n"
"\n"
"Last updated: 2008-05-05 01:29";

#define LF	"\r\n"

char _bufin[576] =
"Command line switches"							LF
" The following switches may be used in the command line:"		LF
									LF
"  -T (tiny)  - read maximum 500 files in each panel"              	LF
"  -L (large) - read maximum 5000 files in each panel"              	LF
"     default is 3000."                                         	LF
									LF
"  -XP (WinXP)     - trigger a mode change on startup"                 	LF
"  -V (verbose)    - print DOS return code (errorlevel)"		LF
"  -C<config_path> - Read/Write setup from/to <config_path>"		LF
									LF
"  DZ <filename> command starts DZ and forces it to show <filename>"    LF
"contents if it is an archive or show folder contents if <filename>"    LF
"is a folder."                                                          LF
;

char cp_termination[128] =
"**Error** running %s:"	LF
"Termination type: %s"  LF
"DOS return code:  %d"  LF;
char cp_system_error[64] =
"System error message: ";
char cp_termination_type[4][64] = {
	"Normal",
	"Control-C abort",
	"Critical error abort",
	"Terminate and stay resident"
};

char cp_ercomspec[64] =
"Error loading COMMAND.COM.."						LF
									LF
;

char default_ini[2048+960] =
"; DZ.INI - DOSZIP Configuration file"					LF
";"                                                                     LF
"; This file contains all the variables that \"customize\""		LF
"; DOSZIP to your particular needs."                                    LF
";"                                                                     LF
"; The entries have the following format:"                              LF
";"                                                                     LF
"; [<Section name>]"                                                    LF
"; <Entry name>=<properties>"                                           LF
";"                                                                     LF
"; Space and tabs may appear before or after the equal sign."           LF
";"                                                                     LF
"; Last Updated: 08.05.07"                                              LF
";"                                                                     LF
									LF
"[View]"                                                                LF
"F3      = ; You can override the internal viewer by redefine F3"       LF
"Alt     = ; Viewer for Alt+F3"                                         LF
"Ctrl    = ; Viewer for Ctrl+F3"                                        LF
"Shift   = ; Viewer for Shift+F3"                                       LF
									LF
"[Edit]"                                                                LF
"F4      = EDIT"                                                        LF
"Alt     = NOTEPAD ; Editor for Alt+F4"                                 LF
"Ctrl    = ; Editor for Ctrl+F4"                                        LF
"Shift   = ; Editor for Shift+F4"                                       LF
									LF
"[Filetype] ; This assumes the Borland tools is in the PATH"	    	LF
"asm=bc     ; Borland C++"                                              LF
"c=bc"                                                                  LF
"h=bc"                                                                  LF
"inc=bc"                                                                LF
"mak=make -f!"                                                          LF
"makefile=make"                                                         LF
"prj=bc"                                                                LF
"txt=bc"								LF
									LF
"[Directory] ; Directories for Ctrl-[0..9]"                             LF
"00=Doszip &Directory          Ctrl-0, %DOSZIP%"			LF
"01=Doszip &Source Directory   Ctrl-1, %DOSZIP%\\src"			LF
"02=System &Root               Ctrl-2, %SYSTEMROOT%"			LF
"03=&Program Files             Ctrl-3, %PROGRAMFILES%"			LF
"04=&Common Program Files      Ctrl-4, %COMMONPROGRAMFILES%"		LF
"05=&Application Data          Ctrl-5, %APPDATA%"			LF
"06=&Temp Directory            Ctrl-6, %TEMP%"				LF
"07=&Home Path                 Ctrl-7, %HOMEDRIVE%%HOMEPATH%"		LF
"08=&User Profile              Ctrl-8, %USERPROFILE%"			LF
"09=A&ll Users Profile         Ctrl-9, %ALLUSERSPROFILE%"		LF
"10=<>"				                 			LF
"11=L&ogon Server...,                  %LOGONSERVER%"			LF
									LF
"[Tools] ; Tools [0..9] use key Alt-[0..9]"                             LF
"00=&Add tool                   Alt-0, %EDIT% %DOSZIP%\\DZ.INI"		LF
"01=<>"				                 			LF
"02=&Doszip Commandline         Alt-2, %DOSZIP%\\dz -?"                 LF
"03=&View DZ.INI                Alt-3, %VIEW% %DOSZIP%\\DZ.INI"         LF
"04=View &README.TXT            Alt-4, %VIEW% %DOSZIP%\\README.TXT"     LF
									LF
"[Filter]"								LF
"00=&Executable, *.exe *.com *.bat"					LF
"01=&Compressed, *.lzh *.zoo *.zip *.arj *.pak *.arc *.7z *.bz2 *.tar"	LF
									LF
"[Packer]"								LF
"00=ZIP"								LF
"01=7Z"									LF
"02=TAR"								LF
"03=BZ2"								LF
"04=GZ"									LF
"05=ARJ"								LF
"06=ARC"								LF
"07=PAK"								LF
"08=LZH"								LF
"09=ZOO"								LF
									LF
"[ZIP]"									LF
"00=pkzip -u -wHS"							LF
"01=pkzip -u -P -wHS"							LF
"02=pkunzip -o"								LF
"03=pkunzip -o -d"							LF
"04=pkzip -d"								LF
"05=-ex"								LF
"06=-es"								LF
"07=-s"									LF
"09=@"									LF
"10=7za u -tzip -y"							LF
"11=7za u -tzip -y"							LF
"12=7za e -y"								LF
"13=7za x -y"								LF
"14=7za d -y"								LF
"15=-mx9"								LF
"16=-mx1"								LF
"17=-p"									LF
"18=-o"									LF
"19=@"									LF
									LF
"[7Z]"									LF
"10=7za u -y"								LF
"11=7za u -y"								LF
"12=7za e -y"								LF
"13=7za x -y"								LF
"17=-p"									LF
"18=-o"									LF
"19=@"									LF
									LF
"[TAR]"									LF
"10=7za u -ttar -y"							LF
"11=7za u -ttar -y"							LF
"12=7za e -y"								LF
"13=7za x -y"								LF
"17=-p"									LF
"18=-o"									LF
"19=@"									LF
									LF
"[BZ2]"									LF
"10=7za u -tbzip2 -y"							LF
"11=7za u -tbzip2 -y"							LF
"12=7za e -y"								LF
"13=7za x -y"								LF
"17=-p"									LF
"18=-o"									LF
"19=@"									LF
									LF
"[GZ]"									LF
"10=7za u -tgzip -y"							LF
"11=7za u -tgzip -y"							LF
"12=7za e -y"								LF
"13=7za x -y"								LF
"17=-p"									LF
"18=-o"									LF
"19=@"									LF
									LF
"[ARJ]"									LF
"00=arj u -y"								LF
"01=arj u -y"								LF
"02=arj e -y -e"							LF
"03=arj x -y"								LF
"05=-m4"								LF
"06=-m1"								LF
"07=-g"									LF
"09=!"									LF
									LF
"[ARC]"									LF
"00=arc a"								LF
"01=arc a"								LF
"02=arc eow"								LF
"03=arc xow"								LF
"09=@"									LF
									LF
"[PAK]"									LF
"00=pak u"								LF
"01=pak u"								LF
"02=pak e -wa"								LF
"03=pak e -i -wa" 							LF
"05=/C"									LF
"06=/CR"								LF
"09=@"									LF
									LF
"[LZH]"									LF
"00=lharc u -am"							LF
"01=lharc a -apm"							LF
"02=lharc e -m"								LF
"03=lharc e -m"								LF
									LF
"[ZOO]"									LF
"00=zoo -add"								LF
"01=zoo -add"								LF
"02=zoo -extract"							LF
"03=zoo -extract"							LF
"04=zoo -delete"							LF
"09=@"									LF
									LF
"%%EOF"                                                                 LF
;

/* @doszip/src/dzmain/menus.c */

const char
	cp_menusline[] =
"Panel-&A   &File   &Edit   &Setup   &Tools   &Help   Panel-&B",
	cp_statusline[] =
"&F&1 Help  &F&2 Ren  &F&3 View  &F&4 Edit  &F&5 Copy  &F&6 Move  "
"&F&7 Mkdir  &F&8 Del  &F&1&0 Exit",
	cp_stlctrl[] =
"&F&1 PanelA  &F&2 PanelB  &F&3 View  &F&4 Edit  &F&5 Name  &F&6 Type  "
"&F&7 Date  &F&8 Size",
	cp_stlctrlalt[] =
"&Quick Search: \x1A   ";

TOBJ tobj_menusline[] = { /* Active Menus Info */
	{ 0x0006, 0, 0x1E/*'A'*/, { 0, 0,11, 1}, "Panel-&A", },
	{ 0x0006, 0, 0x21/*'F'*/, {10, 0, 8, 1}, "&File",    },
	{ 0x0006, 0, 0x12/*'E'*/, {17, 0, 8, 1}, "&Edit",    },
	{ 0x0006, 0, 0x1F/*'S'*/, {24, 0, 9, 1}, "&Setup",   },
	{ 0x0006, 0, 0x14/*'T'*/, {32, 0, 9, 1}, "&Tools",   },
	{ 0x0006, 0, 0x23/*'H'*/, {40, 0, 8, 1}, "&Help",    },
	{ 0x0006, 0, 0x30/*'B'*/, {47, 0,11, 1}, "Panel-&B",  }
};

const char
	cp_long		[] = "Long/short filename",
	cp_detail	[] = "Show detail",
	cp_hidden	[] = "Show hidden files",
	cp_mini		[] = "Ministatus",
	cp_sort		[] = "Sort by Name|Type|Time|Size",
	cp_toggle	[] = "Toggle panel - on/off",
	cp_pfilter	[] = "Panel filter",
	cp_subinfo	[] = "Directory information",
	cp_update	[] = "Re-read",
	cp_chdrv	[] = "Select drive",

	cp_rename	[] = "Rename file or directory",
	cp_view		[] = "View",
	cp_edit		[] = "Edit",
	cp_copy		[] = "Copy",
	cp_move		[] = "Move",
	cp_mkdir	[] = "Make directory",
	cp_delete	[] = "Delete",
	cp_blkprop	[] = "Edit file property",
	cp_compress	[] = "Compress",
	cp_decompress	[] = "Decompress",
	cp_search	[] = "File Search",
	cp_history	[] = "List of the last 16 DOS commands",
	cp_exit		[] = "Exit program",

	cp_select	[] = "Select files",
	cp_deselect	[] = "Deselect files",
	cp_invert	[] = "Invert selection",
	cp_compare	[] = "Compare directories",

	cp_toggleon	[] = "Toggle panels - on/off",
	cp_togglehz 	[] = "Toggle panels - horizontal/vertical",
	cp_togglesz 	[] = "Toggle Panels - size",
	cp_egaline	[] = "Toggle 25-50 lines",
	cp_swappanels	[] = "Swap panels",

	cp_config	[] = "Configuration",
	cp_confirm	[] = "Confirmations options",
	cp_screen	[] = "Screen options",
	cp_panel	[] = "Panel options",

	cp_help		[] = "Help",
	cp_about	[] = "About Doszip";

/* @doszip/src/dzmain/initpath.c */

const char
	cp_copyselected	[] = "%d file(s) to",
	cp_ermkdir	[] = "Can't create the directory\n%s\n\n'%s'";

/* @doszip/src/dzmain/xcell.c */

const char
	cp_mcopyselected[] = "[%04d file(s)]";

/* @doszip/src/dzmain/cmcopy.c */

const char
	cp_ercopy	[] = "There was an error while copying",
//	cp_enospc	[] = "Out of space on target drive",
	cp_recursive	[] = "You tried to recursively copy or move a directory",
	cp_needpanel	[] = "You need two file panels to use this command.",
	cp_fnisequal	[] = "You can't copy a file to itself";

/* @doszip/src/dzmain/cmcompar.c */

const char
	cp_identical	[] = "The two folders seems\nto be identical",
	cp_different	[] = "Only one panel use Short File Names";

/* @doszip/src/dzmain/cmcompre.c */

const char
	cp_linkerror	[] = "You can't do this in a link or .ZIP panel.",
	cp_badentry	[] = "Bad or missing Entry in DZ.INI",
	cp_badentrymsg	[] = "Section: [%s]\nEntry: [%s]\n",
	cp_enterpassword[] = "Enter password",
	cp_skippassword	[] = "Skip Password?",
	cp_badpasswordsw[] = "07=(Password switch)",
	cp_compressto	[] = "%s to",
	cp_compressusing[] = "%s using %s to",
	cp_missingTEMP	[] = "Bad or missing TEMP directory",
	cp_nothingtodo	[] = "Nothing to do..";

/* @doszip/src/dzmain/cmdelete.c */

const char
	cp_userabort	[] = "User abort",
	cp_edel		[] = "Error delete",
	cp_emdel	[] = "Can't delete the file:\n%s\n'%s'";

/* @doszip/src/dzmain/cmdoskey.c */

const char
	cp_editcommand	[] = "Edit command";

/* @doszip/src/dzmain/cmfblock.c */

const char
	cp_property	[] = "&Property";

/* @doszip/src/dzmain/cmmove.c */

const char
	cp_emdelsub	[] = "Can't delete the directory\n%s\n'%s'";

/* @doszip/src/dzmain/cmpanels.c */

const char
	cp_selectdrv_A	[] = "Select disk Panel A",
	cp_selectdrv_B	[] = "Select disk Panel B";

/* @doszip/src/dzmain/cmscreen.c */

const char
	cp_loadcolor	[] = "Load color",
	cp_savecolor	[] = "Save color";

/* @doszip/src/dzmain/cmsubsiz.c */

const char
	cp_subsize	[] = "Directory Information",
	cp_selected	[] = "Selected Files",
	cp_bytesize	[] = "BKMGTPE",
	cp_location	[] = "Location:",
	cp_10lu_Files	[] = "%10lu Files\n%10lu Directories",
	cp_totalsbyte	[] = "total %s byte";

/* @doszip/src/dzmain/cmview.c */

const char
	cp_unziptotemp	[] = "Unzip file to TEMP";

/* @doszip/src/clib/color/editpal.c [Setup] */

const char
	cp_palinfo	[] = "Id   Init    Setup",
      *	cp_panelcolor	[] = {
		"Panel",
		"Frame",
		"Subdir",
		"Files",
		"System",
		"Hidden"
      },
      *	cp_editcolor	[] = {
		"Black",
		"Desktop",
		"Dialog",
		"Menus",
		"Error",
		"Title",
		"Reverse",
		"Gray",
		"DarkGray",
		"Desktop",
		"Dialog",
		"Menus",
		"Title",
		"Desktop",
		"Dialog",
		"Menus",
		"Background",
		"Foreground",
		"High-color"
      };

/* @doszip/src/clib/arch/confirmd.c */

const char
	cp_delselected	[] = "   You have selected %d file(s)\n"
			     "Do you want to delete all the files",
	cp_delrdonly	[] = "The following file is marked Read only.",
	cp_delsystem	[] = "The following file is marked System.",
	cp_delflag	[] = "Do you still wish to delete it?",
	cp_dodelete	[] = "Do you wish to delete";

/* @doszip/src/clib/const/*/

const char
	cp_error	[] = "Error",
	cp_emaxfb	[] = "This subdirectory contains more\n"
			     "than %d files/directories.\n"
			     "Only %d of the files is read.";
/* @doszip/src/clib/disk/*/

const char cp_selectdisk[] = "Select disk";

/* @doszip/src/clib/errno/*/

char
	cp_NOERROR	[] = "No error",
	cp_EPERM	[] = "Operation not permitted",
	cp_ENOENT	[] = "No such file or directory",
	cp_ESRCH	[] = "No such process",
	cp_EINTR	[] = "Interrupted function call",
	cp_EIO		[] = "Input/output error",
	cp_ENXIO	[] = "No such device or address",
	cp_E2BIG	[] = "Arg list too long",
	cp_ENOEXEC	[] = "Exec format error",
	cp_EBADF	[] = "Bad file descriptor",
	cp_ECHILD	[] = "No child processes",
	cp_EAGAIN	[] = "Resource temporarily unavailable",
	cp_ENOMEM	[] = "Not enough space",
	cp_EACCES	[] = "Permission denied",
	cp_EFAULT	[] = "Bad address",
	cp_EBUSY	[] = "Resource device",
	cp_EEXIST	[] = "File exists",
	cp_EXDEV	[] = "Improper link",
	cp_ENODEV	[] = "No such device",
	cp_ENOTDIR	[] = "Not a directory",
	cp_EISDIR	[] = "Is a directory",
	cp_EINVAL	[] = "Invalid argument",
	cp_ENFILE	[] = "Too many open files in system",
	cp_EMFILE	[] = "Too many open files",
	cp_ENOTTY	[] = "Inappropriate I/O control operation",
	cp_EFBIG	[] = "File too large",
	cp_ENOSPC	[] = "No space left on device",
	cp_ESPIPE	[] = "Invalid seek",
	cp_EROFS	[] = "Read-only file system",
	cp_EMLINK	[] = "Too many links",
	cp_EPIPE	[] = "Broken pipe",
	cp_EDOM		[] = "Domain error",
	cp_ERANGE	[] = "Result too large",
	cp_EDEADLK	[] = "Resource deadlock avoided",
	cp_UNKNOWN	[] = "Unknown error",
	cp_ENAMETOOLONG	[] = "Filename too long",
	cp_ENOLCK	[] = "No locks available",
	cp_ENOSYS	[] = "Function not implemented",
	cp_ENOTEMPTY	[] = "Directory not empty",
	cp_EILSEQ	[] = "Illegal byte sequence",

	cp_EMNOMEM	[] = "Insufficient memory",
	cp_EMDISKFULL	[] = "Insufficient disk space",
	cp_EMEROPEN	[] = "Error open file",
	cp_EMEROPENmsg	[] = "Can't open the file\n%s\n'%s'",
	cp_EMARCHIVE	[] = "Error in archive\n'%s'",
	cp_EMBADCRC	[] = "Data error (bad CRC)";

char *dos_errlist[] =
{
	"Write-protection violation attempted",
	"Unknown unit for driver",
	"Drive not ready",
	"Unknown command given to driver",
	cp_EMBADCRC,
	"Bad device driver request structure length",
	"Seek error",
	"Unknown media type",
	"Sector not found",
	"Printer out of paper..",
	"Write fault",
	"Read fault",
	"General failure",
	"Sharing violation",
	"Lock violation",
	"Invalid disk change",
	"FCB unavailable",
	"Sharing buffer overflow",
	"Code page mismatch",
	"Out of input",
	cp_EMDISKFULL
};

char *sys_errlist[] =
{
	cp_NOERROR,
	cp_EPERM,
	cp_ENOENT,
	cp_ESRCH,
	cp_EINTR,
	cp_EIO,
	cp_ENXIO,
	cp_E2BIG,
	cp_ENOEXEC,
	cp_EBADF,
	cp_ECHILD,
	cp_EAGAIN,
	cp_ENOMEM,
	cp_EACCES,
	cp_EFAULT,
	cp_UNKNOWN, /* cp_ENOTBLK, */
	cp_EBUSY,
	cp_EEXIST,
	cp_EXDEV,
	cp_ENODEV,
	cp_ENOTDIR,
	cp_EISDIR,
	cp_EINVAL,
	cp_ENFILE,
	cp_EMFILE,
	cp_ENOTTY,
	cp_UNKNOWN, /* cp_ETXTBSY, */
	cp_EFBIG,
	cp_ENOSPC,
	cp_ESPIPE,
	cp_EROFS,
	cp_EMLINK,
	cp_EPIPE,
	cp_EDOM,
	cp_ERANGE,
	cp_UNKNOWN, /* cp_EUCLEAN, */
	cp_EDEADLK,
	cp_UNKNOWN,
	cp_ENAMETOOLONG,
	cp_ENOLCK,
	cp_ENOSYS,
	cp_ENOTEMPTY,
	cp_EILSEQ,
	cp_UNKNOWN
};

int sys_nerr = sizeof( sys_errlist ) / sizeof( sys_errlist[ 0 ] ) - 1;

/* @doszip/src/clib/ios/notfound.c */

char cp_notfoundmsg[] = "Search string not found: '%s'";

/* @doszip/src/clib/ios/wsub/01_ZIP/*/

const char cp_WARNING[] = "WARNING";
const char cp_arctempfile[] = "[.ZIP tempfile]";

/******** Resource begin PANELA *
	{ 0x2418,  13,   0, { 0, 1,38,18} },
	{ 0x0005,   0, 'L', { 2, 1,34, 1} },
	{ 0x0005,   0, 'D', { 2, 2,34, 1} },
	{ 0x0005,   0, 'H', { 2, 3,34, 1} },
	{ 0x0005,   0, 'M', { 2, 4,34, 1} },
	{ 0x0005,   0, 'N', { 2, 6,34, 1} },
	{ 0x0005,   0, 'E', { 2, 7,34, 1} },
	{ 0x0005,   0, 'D', { 2, 8,34, 1} },
	{ 0x0005,   0, 'S', { 2, 9,34, 1} },
	{ 0x0005,   0, 'O', { 2,11,34, 1} },
	{ 0x0005,   0, 'P', { 2,12,34, 1} },
	{ 0x0005,   0, 'R', { 2,13,34, 1} },
	{ 0x0005,   0, 'U', { 2,15,34, 1} },
	{ 0x0005,   0, 'C', { 2,16,34, 1} },
********* Resource data  *******************/
static int PANELA_RC[] = {
#ifdef _RCEDIT_
	0x0680,0x2418,0x000D,0x0100,0x1226,0x0005,0x4C00,0x0102,
	0x0122,0x0005,0x4400,0x0202,0x0122,0x0005,0x4800,0x0302,
	0x0122,0x0005,0x4D00,0x0402,0x0122,0x0005,0x4E00,0x0602,
	0x0122,0x0005,0x4500,0x0702,0x0122,0x0005,0x4400,0x0802,
	0x0122,0x0005,0x5300,0x0902,0x0122,0x0005,0x4F00,0x0B02,
	0x0122,0x0005,0x5000,0x0C02,0x0122,0x0005,0x5200,0x0D02,
	0x0122,0x0005,0x5500,0x0F02,0x0122,0x0005,0x4300,0x1002,
	0x0122,
#endif
	0x29F0,0x3F3B,0x27F0,0x3F3B,0x23F0,0x3F3B,0x25F0,0x3F3B,
	0x53F0,0x3F3B,0x28F0,0x3F3B,0x22F0,0x3F3B,0x25F0,0x3F3B,
	0x44F0,0x3F3B,0x24F0,0x3F3B,0x2FF0,0x3F3B,0x41F0,0x3F3B,
	0x25F0,0x3F3B,0x48F0,0xDA3B,0x24F0,0xBFC4,0x20B3,0x4C20,
	0x6E6F,0x2067,0x6966,0x656C,0x616E,0x656D,0x0DF0,0x4320,
	0x7274,0x2D6C,0x204C,0xB320,0x20B3,0x4420,0x7465,0x6961,
	0xF06C,0x2014,0x7443,0x6C72,0x542D,0x2020,0xB3B3,0x2020,
	0x6948,0x6464,0x6E65,0x14F0,0x4320,0x7274,0x2D6C,0x2048,
	0xB320,0x20B3,0x4D20,0x6E69,0x2069,0x7473,0x7461,0x7375,
	0x0FF0,0x4320,0x7274,0x2D6C,0x204D,0xB320,0x20B3,0x22F0,
	0x20C4,0xB3B3,0x2020,0x6F53,0x7472,0x6220,0x2079,0x614E,
	0x656D,0x0EF0,0x4320,0x7274,0x2D6C,0x204E,0xB320,0xF0B3,
	0x200A,0x7954,0x6570,0x0EF0,0x4320,0x7274,0x2D6C,0x2045,
	0xB320,0xF0B3,0x200A,0x6144,0x6574,0x0EF0,0x4320,0x7274,
	0x2D6C,0x2044,0xB320,0xF0B3,0x200A,0x6953,0x657A,0x0EF0,
	0x4320,0x7274,0x2D6C,0x2053,0xB320,0x20B3,0x22F0,0x20C4,
	0xB3B3,0x2020,0x6F54,0x6767,0x656C,0x7020,0x6E61,0x6C65,
	0x0DF0,0x4320,0x7274,0x2D6C,0x3146,0x2020,0xB3B3,0x2020,
	0x6150,0x656E,0x206C,0x6966,0x746C,0x7265,0x16F0,0xB320,
	0x20B3,0x4420,0x7269,0x6365,0x6F74,0x7972,0x4920,0x666E,
	0x726F,0x616D,0x6974,0x6E6F,0x0DF0,0xB320,0x20B3,0x22F0,
	0x20C4,0xB3B3,0x2020,0x6552,0x722D,0x6165,0xF064,0x2013,
	0x7443,0x6C72,0x522D,0x2020,0xB3B3,0x2020,0x6843,0x6E61,
	0x6567,0x6420,0x6972,0x6576,0x0EF0,0x4120,0x746C,0x462D,
	0x2031,0xB320,0xF0C0,0xC424,0x3BD9,
}; //	508 byte
ROBJ *IDD_PANELA = (ROBJ *)&PANELA_RC;
/******** Resource end   PANELA */

/******** Resource begin FILE *
	{ 0x2418,  13,   0, {10, 1,31,18} },
	{ 0x0005,   0, 'R', { 2, 1,27, 1} },
	{ 0x0005,   0, 'V', { 2, 2,27, 1} },
	{ 0x0005,   0, 'E', { 2, 3,27, 1} },
	{ 0x0005,   0, 'Y', { 2, 4,27, 1} },
	{ 0x0005,   0, 'O', { 2, 5,27, 1} },
	{ 0x0005,   0, 'M', { 2, 6,27, 1} },
	{ 0x0005,   0, 'L', { 2, 7,27, 1} },
	{ 0x0005,   0, 'P', { 2, 8,27, 1} },
	{ 0x0005,   0, 'C', { 2,10,27, 1} },
	{ 0x0005,   0, 'D', { 2,11,27, 1} },
	{ 0x0005,   0, 'S', { 2,13,27, 1} },
	{ 0x0005,   0, 'H', { 2,14,27, 1} },
	{ 0x0005,   0, 'X', { 2,16,27, 1} },
********* Resource data  *******************/
static int FILE_RC[] = {
#ifdef _RCEDIT_
	0x057D,0x2418,0x000D,0x010A,0x121F,0x0005,0x5200,0x0102,
	0x011B,0x0005,0x5600,0x0202,0x011B,0x0005,0x4500,0x0302,
	0x011B,0x0005,0x5900,0x0402,0x011B,0x0005,0x4F00,0x0502,
	0x011B,0x0005,0x4D00,0x0602,0x011B,0x0005,0x4C00,0x0702,
	0x011B,0x0005,0x5000,0x0802,0x011B,0x0005,0x4300,0x0A02,
	0x011B,0x0005,0x4400,0x0B02,0x011B,0x0005,0x5300,0x0D02,
	0x011B,0x0005,0x4800,0x0E02,0x011B,0x0005,0x5800,0x1002,
	0x011B,
#endif
	0x22F0,0x3F3B,0x1EF0,0x3F3B,0x1EF0,0x3F3B,0x21F0,0x3F3B,
	0x1CF0,0x3F3B,0x1DF0,0x3F3B,0x20F0,0x3F3B,0x1CF0,0x3F3B,
	0x3DF0,0x3F3B,0x1EF0,0x3F3B,0x3DF0,0x3F3B,0x1EF0,0x3F3B,
	0x3EF0,0x3F3B,0x39F0,0xDA3B,0x1DF0,0xBFC4,0x20B3,0x5220,
	0x6E65,0x6D61,0xF065,0x2011,0x3246,0x2020,0xB3B3,0x2020,
	0x6956,0x7765,0x13F0,0x4620,0x2033,0xB320,0x20B3,0x4520,
	0x6964,0xF074,0x2013,0x3446,0x2020,0xB3B3,0x2020,0x6F43,
	0x7970,0x13F0,0x4620,0x2035,0xB320,0x20B3,0x4D20,0x766F,
	0xF065,0x2013,0x3646,0x2020,0xB3B3,0x2020,0x614D,0x656B,
	0x4420,0x7269,0x6365,0x6F74,0x7972,0x09F0,0x4620,0x2037,
	0xB320,0x20B3,0x4420,0x6C65,0x7465,0xF065,0x2011,0x3846,
	0x2020,0xB3B3,0x2020,0x7250,0x706F,0x7265,0x7974,0x0FF0,
	0x4620,0x2039,0xB320,0xF0B3,0xC41D,0xB3B3,0x2020,0x6F43,
	0x706D,0x6572,0x7373,0x0BF0,0x4120,0x746C,0x462D,0x2035,
	0xB320,0x20B3,0x4420,0x6365,0x6D6F,0x7270,0x7365,0xF073,
	0x2009,0x6C41,0x2D74,0x3646,0x2020,0xB3B3,0x1DF0,0xB3C4,
	0x20B3,0x5320,0x6165,0x6372,0xF068,0x200D,0x6C41,0x2D74,
	0x3746,0x2020,0xB3B3,0x2020,0x6948,0x7473,0x726F,0xF079,
	0x200C,0x6C41,0x2D74,0x3846,0x2020,0xB3B3,0x1DF0,0xB3C4,
	0x20B3,0x4520,0x6978,0xF074,0x2012,0x3146,0x2030,0xB320,
	0xF0C0,0xC41D,0x3BD9,
}; //	440 byte
ROBJ *IDD_FILE = (ROBJ *)&FILE_RC;
/******** Resource end   FILE */

/******** Resource begin EDIT *
	{ 0x2418,   4,   0, {17, 1,34, 7} },
	{ 0x0005,   0, 'S', { 2, 1,30, 1} },
	{ 0x0005,   0, 'D', { 2, 2,30, 1} },
	{ 0x0005,   0, 'I', { 2, 3,30, 1} },
	{ 0x0005,   0, 'C', { 2, 5,30, 1} },
********* Resource data  *******************/
static int EDIT_RC[] = {
#ifdef _RCEDIT_
	0x025A,0x2418,0x0004,0x0111,0x0722,0x0005,0x5300,0x0102,
	0x011E,0x0005,0x4400,0x0202,0x011E,0x0005,0x4900,0x0302,
	0x011E,0x0005,0x4300,0x0502,0x011E,
#endif
	0x25F0,0x3F3B,0x21F0,0x3F3B,0x21F0,0x3F3B,0x43F0,0x3F3B,
	0x40F0,0xDA3B,0x20F0,0xBFC4,0x20B3,0x5320,0x6C65,0x6365,
	0xF074,0x200E,0x654B,0x7079,0x6461,0x2B20,0x2020,0xB3B3,
	0x2020,0x6544,0x6573,0x656C,0x7463,0x0CF0,0x4B20,0x7965,
	0x6170,0x2064,0x202D,0xB320,0x20B3,0x4920,0x766E,0x7265,
	0xF074,0x200E,0x654B,0x7079,0x6461,0x2A20,0x2020,0xB3B3,
	0x20F0,0xB3C4,0x20B3,0x4320,0x6D6F,0x6170,0x6572,0x4420,
	0x7269,0x6365,0x6F74,0x6972,0x7365,0x03F0,0x4320,0x7274,
	0x2D6C,0x2043,0xB320,0xF0C0,0xC420,0x3BD9,
}; //	182 byte
ROBJ *IDD_EDIT = (ROBJ *)&EDIT_RC;
/******** Resource end   EDIT */

/******** Resource begin SETUP *
	{ 0x2418,   9,   0, {24, 1,36,14} },
	{ 0x0005,   0, 'O', { 2, 1,32, 1} },
	{ 0x0005,   0, 'H', { 2, 2,32, 1} },
	{ 0x0005,   0, 'Z', { 2, 3,32, 1} },
	{ 0x0005,   0, 'E', { 2, 4,32, 1} },
	{ 0x0005,   0, 'U', { 2, 6,32, 1} },
	{ 0x0005,   0, 'F', { 2, 8,32, 1} },
	{ 0x0005,   0, 'S', { 2, 9,32, 1} },
	{ 0x0005,   0, 'P', { 2,10,32, 1} },
	{ 0x0005,   0, 'T', { 2,12,32, 1} },
********* Resource data  *******************/
static int SETUP_RC[] = {
#ifdef _RCEDIT_
	0x04CE,0x2418,0x0009,0x0118,0x0E24,0x0005,0x4F00,0x0102,
	0x0120,0x0005,0x4800,0x0202,0x0120,0x0005,0x5A00,0x0302,
	0x0120,0x0005,0x4500,0x0402,0x0120,0x0005,0x5500,0x0602,
	0x0120,0x0005,0x4600,0x0802,0x0120,0x0005,0x5300,0x0902,
	0x0120,0x0005,0x5000,0x0A02,0x0120,0x0005,0x5400,0x0C02,
	0x0120,
#endif
	0x2EF0,0x3F3B,0x23F0,0x3F3B,0x25F0,0x3F3B,0x21F0,0x3F3B,
	0x8BF0,0x3F3B,0x20F0,0x3F3B,0x23F0,0x3F3B,0x47F0,0x3F3B,
	0x44F0,0xDA3B,0x22F0,0xBFC4,0x20B3,0x5420,0x676F,0x6C67,
	0x2065,0x6E4F,0x4F2F,0x6666,0x0BF0,0x4320,0x7274,0x2D6C,
	0x204F,0xB320,0xF0B3,0x2009,0x6F48,0x6972,0x6F7A,0x746E,
	0x6C61,0x0AF0,0x4620,0x3231,0x2020,0xB3B3,0x09F0,0x5320,
	0x7A69,0xF065,0x2010,0x3146,0x2031,0xB320,0xF0B3,0x2009,
	0x6745,0x6C61,0x6E69,0x7365,0x09F0,0x4120,0x746C,0x462D,
	0x2039,0xB320,0xF0B3,0xC422,0xB3B3,0x2020,0x7753,0x7061,
	0x5020,0x6E61,0x6C65,0xF073,0x200D,0x7443,0x6C72,0x552D,
	0x2020,0xB3B3,0x22F0,0xB3C4,0x20B3,0x4320,0x6E6F,0x6966,
	0x6D72,0x7461,0x6F69,0xF06E,0x200C,0x7443,0x6C72,0x462D,
	0x2020,0xB3B3,0x2020,0x6353,0x6572,0x6E65,0x6F20,0x7470,
	0x6F69,0x736E,0x0AF0,0x4320,0x7274,0x2D6C,0x2041,0xB320,
	0x20B3,0x5020,0x6E61,0x6C65,0x6F20,0x7470,0x6F69,0x736E,
	0x0BF0,0x4320,0x7274,0x2D6C,0x2050,0xB320,0xF0B3,0xC422,
	0xB3B3,0x2020,0x6F43,0x666E,0x6769,0x7275,0x7461,0x6F69,
	0x2E6E,0xF02E,0x2008,0x7443,0x6C72,0x462D,0x2039,0xB320,
	0xF0C0,0xC422,0x3BD9,
}; //	376 byte
ROBJ *IDD_SETUP = (ROBJ *)&SETUP_RC;
/******** Resource end   SETUP */

/******** Resource begin HELP *
	{ 0x2418,   2,   0, {40, 1,30, 5} },
	{ 0x0005,   0, 'H', { 2, 1,26, 1} },
	{ 0x0005,   0, 'A', { 2, 3,26, 1} },
********* Resource data  *******************/
static int HELP_RC[] = {
#ifdef _RCEDIT_
	0x0182,0x2418,0x0002,0x0128,0x051E,0x0005,0x4800,0x0102,
	0x011A,0x0005,0x4100,0x0302,0x011A,
#endif
	0x21F0,0x3F3B,0x3BF0,0x3F3B,0x38F0,0xDA3B,0x1CF0,0xBFC4,
	0x20B3,0x4820,0x6C65,0xF070,0x2012,0x3146,0x2020,0xB3B3,
	0xF020,0xC41A,0xB320,0x20B3,0x4120,0x6F62,0x7475,0x15F0,
	0xB320,0xF0C0,0xC41C,0x3BD9,
}; //	82 byte
ROBJ *IDD_HELP = (ROBJ *)&HELP_RC;
/******** Resource end   HELP */

/******** Resource begin PANELB *
	{ 0x2418,  13,   0, {42, 1,38,18} },
	{ 0x0045,   0, 'L', { 2, 1,34, 1} },
	{ 0x0045,   0, 'T', { 2, 2,34, 1} },
	{ 0x0045,   0, 'H', { 2, 3,34, 1} },
	{ 0x0045,   0, 'M', { 2, 4,34, 1} },
	{ 0x0045,   0, 'N', { 2, 6,34, 1} },
	{ 0x0045,   0, 'E', { 2, 7,34, 1} },
	{ 0x0045,   0, 'D', { 2, 8,34, 1} },
	{ 0x0045,   0, 'S', { 2, 9,34, 1} },
	{ 0x0045,   0, 'P', { 2,11,34, 1} },
	{ 0x0045,   0, 'A', { 2,12,34, 1} },
	{ 0x0045,   0, 'R', { 2,13,34, 1} },
	{ 0x0045,   0, 'R', { 2,15,34, 1} },
	{ 0x0045,   0, 'C', { 2,16,34, 1} },
********* Resource data  *******************/
static int PANELB_RC[] = {
#ifdef _RCEDIT_
	0x0680,0x2418,0x000D,0x012A,0x1226,0x0045,0x4C00,0x0102,
	0x0122,0x0045,0x5400,0x0202,0x0122,0x0045,0x4800,0x0302,
	0x0122,0x0045,0x4D00,0x0402,0x0122,0x0045,0x4E00,0x0602,
	0x0122,0x0045,0x4500,0x0702,0x0122,0x0045,0x4400,0x0802,
	0x0122,0x0045,0x5300,0x0902,0x0122,0x0045,0x5000,0x0B02,
	0x0122,0x0045,0x4100,0x0C02,0x0122,0x0045,0x5200,0x0D02,
	0x0122,0x0045,0x5200,0x0F02,0x0122,0x0045,0x4300,0x1002,
	0x0122,
#endif
	0x29F0,0x3F3B,0x27F0,0x3F3B,0x23F0,0x3F3B,0x25F0,0x3F3B,
	0x53F0,0x3F3B,0x28F0,0x3F3B,0x22F0,0x3F3B,0x25F0,0x3F3B,
	0x44F0,0x3F3B,0x24F0,0x3F3B,0x2FF0,0x3F3B,0x41F0,0x3F3B,
	0x25F0,0x3F3B,0x48F0,0xDA3B,0x24F0,0xBFC4,0x20B3,0x4C20,
	0x6E6F,0x2067,0x6966,0x656C,0x616E,0x656D,0x0DF0,0x4320,
	0x7274,0x2D6C,0x204C,0xB320,0x20B3,0x4420,0x7465,0x6961,
	0xF06C,0x2014,0x7443,0x6C72,0x542D,0x2020,0xB3B3,0x2020,
	0x6948,0x6464,0x6E65,0x14F0,0x4320,0x7274,0x2D6C,0x2048,
	0xB320,0x20B3,0x4D20,0x6E69,0x2069,0x7473,0x7461,0x7375,
	0x0FF0,0x4320,0x7274,0x2D6C,0x204D,0xB320,0x20B3,0x22F0,
	0x20C4,0xB3B3,0x2020,0x6F53,0x7472,0x6220,0x2079,0x614E,
	0x656D,0x0EF0,0x4320,0x7274,0x2D6C,0x204E,0xB320,0xF0B3,
	0x200A,0x7954,0x6570,0x0EF0,0x4320,0x7274,0x2D6C,0x2045,
	0xB320,0xF0B3,0x200A,0x6144,0x6574,0x0EF0,0x4320,0x7274,
	0x2D6C,0x2044,0xB320,0xF0B3,0x200A,0x6953,0x657A,0x0EF0,
	0x4320,0x7274,0x2D6C,0x2053,0xB320,0x20B3,0x22F0,0x20C4,
	0xB3B3,0x2020,0x6F54,0x6767,0x656C,0x7020,0x6E61,0x6C65,
	0x0DF0,0x4320,0x7274,0x2D6C,0x3246,0x2020,0xB3B3,0x2020,
	0x6150,0x656E,0x206C,0x6966,0x746C,0x7265,0x16F0,0xB320,
	0x20B3,0x4420,0x7269,0x6365,0x6F74,0x7972,0x4920,0x666E,
	0x726F,0x616D,0x6974,0x6E6F,0x0DF0,0xB320,0x20B3,0xF020,
	0xC421,0xB320,0x20B3,0x5220,0x2D65,0x6572,0x6461,0x13F0,
	0x4320,0x7274,0x2D6C,0x2052,0xB320,0x20B3,0x4320,0x6168,
	0x676E,0x2065,0x7264,0x7669,0xF065,0x200E,0x6C41,0x2D74,
	0x3246,0x2020,0xC0B3,0x24F0,0xD9C4,0x3B3B,
}; //	510 byte
ROBJ *IDD_PANELB = (ROBJ *)&PANELB_RC;
/******** Resource end   PANELB */

ROBJ *ResourceMenus[] = {
	(ROBJ *)&PANELA_RC,
	(ROBJ *)&FILE_RC,
	(ROBJ *)&EDIT_RC,
	(ROBJ *)&SETUP_RC,
	NULL,
	(ROBJ *)&HELP_RC,
	(ROBJ *)&PANELB_RC
};

/* @doszip/src/dzmain/initpath.c */

/******** Resource begin COPY *
	{ 0x0C1C,   4,   0, { 8, 5,59, 7} },
	{ 0x0004,   0, 'N', { 4, 3,51, 1} },
	{ 0x0000,   0, 'O', { 4, 5, 8, 1} },
	{ 0x4000,   0, 'F', {15, 5,10, 1} },
	{ 0x0200,   0, 'C', {44, 5,10, 1} },
********* Resource data  *******************/
static int COPY_RC[] = {
	0x03D1,0x0C1C,0x0004,0x0508,0x073B,0x0004,0x4E00,0x0304,
	0x0133,0x0000,0x4F00,0x0504,0x0108,0x4000,0x4600,0x050F,
	0x010A,0x0200,0x4300,0x052C,0x010A,0x21F0,0x5A50,0x19F0,
	0xF050,0x2A7A,0x33F0,0xF007,0x2A43,0x03F0,0x5C50,0x04F0,
	0x2050,0x2A2A,0x5050,0xF05C,0x5007,0xF020,0x2A12,0x5050,
	0xF05C,0x5007,0xF020,0x2A09,0x08F0,0xF020,0x2A03,0x0AF0,
	0xF020,0x2A13,0x0AF0,0xF020,0x2A04,0x1BF0,0x4320,0x706F,
	0xF079,0x205B,0x6F43,0x7970,0x37F0,0xF020,0xFA33,0x45F0,
	0x4320,0x706F,0x2079,0xDC20,0x04F0,0x4620,0x6C69,0x6574,
	0x2072,0xDC20,0x14F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,
	0x09F0,0xF020,0xDF08,0x03F0,0xF020,0xDF0A,0x13F0,0xF020,
	0xDF0A,0x04F0,0x2A20,
}; //	182 byte
ROBJ *IDD_COPY = (ROBJ *)&COPY_RC;
/******** Resource end   COPY */

/******** Resource begin MOVE *
	{ 0x4C1C,   3,   0, { 8, 5,59, 7} },
	{ 0x0004,   0, 'N', { 4, 3,51, 1} },
	{ 0x0000,   0, 'M', { 4, 5, 8, 1} },
	{ 0x0200,   0, 'C', {15, 5,10, 1} },
********* Resource data  *******************/
static int MOVE_RC[] = {
	0x03C1,0x4C1C,0x0003,0x0508,0x073B,0x0004,0x4E00,0x0304,
	0x0133,0x0000,0x4D00,0x0504,0x0108,0x0200,0x4300,0x050F,
	0x010A,0x21F0,0x5A50,0x19F0,0xF050,0x2A7A,0x33F0,0xF007,
	0x2A43,0x5050,0xF05C,0x5005,0x2A20,0x502A,0x5C50,0x07F0,
	0x2050,0x26F0,0xF02A,0x2008,0x03F0,0xF02A,0x200A,0x21F0,
	0xF02A,0x201B,0x6F4D,0x6576,0x5BF0,0x4D20,0x766F,0xF065,
	0x2037,0x33F0,0xF0FA,0x2045,0x6F4D,0x6576,0x2020,0xF0DC,
	0x2004,0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2026,0x08F0,
	0xF0DF,0x2003,0x0AF0,0xF0DF,0x2021,0x2A2A,
}; //	140 byte
ROBJ *IDD_MOVE = (ROBJ *)&MOVE_RC;
/******** Resource end   MOVE */

/* @doszip/src/dzmain/config.c */

/******** Resource begin SaveSetup *
	{ 0x041C,   2,   0, {27, 7,27, 7} },
	{ 0x0000,   0, 'S', { 3, 5, 8, 1} },
	{ 0x0200,   0, 'C', {14, 5,10, 1} },
********* Resource data  *******************/
static int SaveSetup_RC[] = {
	0x01D1,0x041C,0x0002,0x071B,0x071B,0x0000,0x5300,0x0503,
	0x0108,0x0200,0x4300,0x050E,0x010A,0x1BF0,0xF050,0x2A6F,
	0x5050,0xF05C,0x5005,0x2A20,0x502A,0x5C50,0x07F0,0x2050,
	0x06F0,0xF02A,0x2008,0x03F0,0xF02A,0x200A,0x2A2A,0x0BF0,
	0x5320,0x7465,0x7075,0x2AF0,0x4420,0x206F,0x6F79,0x2075,
	0x6977,0x6873,0x7420,0x206F,0x6173,0x6576,0x08F0,0x7420,
	0x6568,0x6320,0x7275,0x6572,0x746E,0x7320,0x7465,0x7075,
	0xF03F,0x2025,0x6153,0x6576,0x2020,0xF0DC,0x2004,0x6143,
	0x636E,0x6C65,0x2020,0xF0DC,0x2006,0x08F0,0xF0DF,0x2003,
	0x0AF0,0x20DF,0x2A20,
}; //	150 byte
ROBJ *IDD_SaveSetup = (ROBJ *)&SaveSetup_RC;
/******** Resource end   SaveSetup */

/* @doszip/src/dzmain/filter.c */

/******** Resource begin OperationFilters *
	{ 0x041C,  16,  15, {10, 4,61,16} },
	{ 0x0004,   0, 'I', {12, 3,45, 1} },
	{ 0x0004,   0, 'E', {12, 4,45, 1} },
	{ 0x0004,   2, 'F', {12, 7,16, 1} },
	{ 0x0004,   2, 'B', {12, 8,16, 1} },
	{ 0x0004,   2, 'V', {41, 7,16, 1} },
	{ 0x0004,   2, 'W', {41, 8,16, 1} },
	{ 0x0022,   0, 'R', { 4,11,13, 1} },
	{ 0x0022,   0, 'H', { 4,12,10, 1} },
	{ 0x0022,   0, 'Y', {22,11,10, 1} },
	{ 0x8002,   0,   0, {22,12,10, 1} },
	{ 0x8022,   0,   0, {40,11,16, 1} },
	{ 0x0022,   0, 'A', {40,12,11, 1} },
	{ 0x0000,   0, 'O', { 3,14, 6, 1} },
	{ 0x4000,   0, 'L', {13,14, 9, 1} },
	{ 0x5000,   0, 'D', {26,14, 8, 1} },
	{ 0x0200,   0, 'C', {47,14,10, 1} },
********* Resource data  *******************/
static int OperationFilters_RC[] = {
	0x098B,0x041C,0x0F10,0x040A,0x103D,0x0004,0x4900,0x030C,
	0x012D,0x0004,0x4500,0x040C,0x012D,0x0004,0x4602,0x070C,
	0x0110,0x0004,0x4202,0x080C,0x0110,0x0004,0x5602,0x0729,
	0x0110,0x0004,0x5702,0x0829,0x0110,0x0022,0x5200,0x0B04,
	0x010D,0x0022,0x4800,0x0C04,0x010A,0x0022,0x5900,0x0B16,
	0x010A,0x8002,0x0000,0x0C16,0x010A,0x8022,0x0000,0x0B28,
	0x0110,0x0022,0x4100,0x0C28,0x010B,0x0000,0x4F00,0x0E03,
	0x0106,0x4000,0x4C00,0x0E0D,0x0109,0x5000,0x4400,0x0E1A,
	0x0108,0x0200,0x4300,0x0E2F,0x010A,0x3DF0,0xF050,0x2A7E,
	0xF03F,0x2A07,0x2DF0,0xF007,0x2A08,0xF03F,0x2A07,0x2DF0,
	0xF007,0x2A83,0xF02E,0x2A06,0x10F0,0xF007,0x2A05,0xF02E,
	0x2A07,0x10F0,0xF007,0x2A08,0xF02E,0x2A07,0x10F0,0xF007,
	0x2A09,0xF02E,0x2A03,0x10F0,0xF007,0x2A86,0xF02E,0x2A12,
	0xF02E,0x2A0C,0x0DF0,0xF028,0x2A10,0xF02E,0x2A0D,0x09F0,
	0xF028,0x2A0D,0xF02E,0x2A50,0x5050,0xF05C,0x5003,0xF020,
	0x2A03,0x03F0,0x5C50,0x05F0,0x2050,0x03F0,0xF02A,0x5005,
	0x505C,0x2050,0x0CF0,0x502A,0x5C50,0x07F0,0x2050,0x07F0,
	0xF02A,0x2006,0x04F0,0xF02A,0x2009,0x04F0,0xF02A,0x2008,
	0x0DF0,0xF02A,0x200A,0x03F0,0xF02A,0x2016,0x704F,0x7265,
	0x7461,0x6F69,0x206E,0x6946,0x746C,0x7265,0x56F0,0xDA20,
	0x37F0,0xBFC4,0x04F0,0xB320,0x4920,0x636E,0x756C,0x6564,
	0x2FF0,0xB320,0x04F0,0xB320,0x4520,0x6378,0x756C,0x6564,
	0x2FF0,0xB320,0x04F0,0xC020,0x37F0,0xD9C4,0x04F0,0xDA20,
	0x4620,0x6C69,0x2065,0x6164,0x6574,0xF020,0xC40F,0x20BF,
	0x20DA,0x6946,0x656C,0x7320,0x7A69,0x2065,0x0FF0,0xBFC4,
	0x04F0,0xB320,0x4120,0x7466,0x7265,0x14F0,0xB320,0xB320,
	0x4120,0x6F62,0x6576,0x14F0,0xB320,0x04F0,0xB320,0x4220,
	0x6665,0x726F,0xF065,0x2013,0x20B3,0x20B3,0x6542,0x6F6C,
	0xF077,0x2014,0xF0B3,0x2004,0xF0C0,0xC41A,0x20D9,0xF0C0,
	0xC41A,0xF0D9,0x2004,0x20DA,0x7441,0x7274,0x6269,0x7475,
	0x2065,0x6966,0x746C,0x7265,0x2073,0x24F0,0xBFC4,0x04F0,
	0xB320,0x5B20,0x5D78,0x5220,0x6165,0x2064,0x6E4F,0x796C,
	0x05F0,0x5B20,0x5D78,0x5320,0x7379,0x6574,0xF06D,0x2008,
	0x785B,0x205D,0x6944,0x6572,0x7463,0x726F,0xF079,0x2005,
	0xF0B3,0x2004,0x20B3,0x785B,0x205D,0x6948,0x6464,0x6E65,
	0x08F0,0x5B20,0x5D20,0x5620,0x6C6F,0x6469,0x09F0,0x5B20,
	0x5D78,0x4120,0x6372,0x6968,0x6576,0x07F0,0xB320,0x04F0,
	0xC020,0x37F0,0xD9C4,0x07F0,0x4F20,0x206B,0xDC20,0x05F0,
	0x4320,0x656C,0x7261,0x2020,0xF0DC,0x2005,0x6F4C,0x6461,
	0x2020,0xF0DC,0x200E,0x6143,0x636E,0x6C65,0x2020,0xF0DC,
	0x2007,0x06F0,0xF0DF,0x2004,0x09F0,0xF0DF,0x2004,0x08F0,
	0x20DF,0x4620,0x3D33,0x6F4C,0x6461,0x04F0,0xF020,0xDF0A,
	0x03F0,0x0720,
}; //	676 byte
ROBJ *IDD_OperationFilters = (ROBJ *)&OperationFilters_RC;
/******** Resource end   OperationFilters */

/******** Resource begin PanelFilter *
	{ 0x041C,   6,   5, { 3, 3,38,13} },
	{ 0x0004,   2, 'B', {18, 3,14, 1} },
	{ 0x0004,   2, 'F', {18, 6,14, 1} },
	{ 0x0004,  17, 'D', { 6, 9,26, 1} },
	{ 0x0000,   0, 'O', { 3,11, 6, 1} },
	{ 0x4000,   0, 'L', {12,11, 8, 1} },
	{ 0x0200,   0, 'C', {23,11,10, 1} },
********* Resource data  *******************/
static int PanelFilter_RC[] = {
	0x05DA,0x041C,0x0506,0x0303,0x0D26,0x0004,0x4202,0x0312,
	0x010E,0x0004,0x4602,0x0612,0x010E,0x0004,0x4411,0x0906,
	0x011A,0x0000,0x4F00,0x0B03,0x0106,0x4000,0x4C00,0x0B0C,
	0x0108,0x0200,0x4300,0x0B17,0x010A,0x26F0,0xF050,0x2A2B,
	0x0BF0,0xF02E,0x2A28,0x0EF0,0xF007,0x2A31,0x05F0,0xF02E,
	0x2A2E,0x0EF0,0xF007,0x2A31,0x09F0,0xF02E,0x2A1E,0x1AF0,
	0xF007,0x2A2F,0x5050,0xF05C,0x5003,0x2A20,0x502A,0x5C50,
	0x05F0,0x2050,0x2A2A,0x5050,0xF05C,0x5007,0xF020,0x2A08,
	0x06F0,0xF020,0x2A03,0x08F0,0xF020,0x2A03,0x0AF0,0xF020,
	0x2A04,0x0DF0,0x5020,0x6E61,0x6C65,0x4620,0x6C69,0x6574,
	0xF072,0x2036,0x20DA,0x7542,0x6666,0x7265,0x7320,0x7A69,
	0x2065,0x11F0,0xBFC4,0x06F0,0xB320,0x5220,0x6165,0x2064,
	0x6F63,0x6E75,0x3A74,0x5B20,0x0EF0,0x5DFA,0xB320,0x06F0,
	0xC020,0x1EF0,0xD9C4,0x06F0,0xDA20,0x4620,0x6C69,0x7365,
	0xF020,0xC417,0xF0BF,0x2006,0x20B3,0x6552,0x6461,0x6D20,
	0x7361,0x3A6B,0x2020,0xF05B,0xFA0E,0x205D,0xF0B3,0x2006,
	0xF0C0,0xC41E,0xF0D9,0x2006,0x20DA,0x6944,0x6572,0x7463,
	0x726F,0x2079,0x13F0,0xBFC4,0x06F0,0xB320,0x5B20,0x1AF0,
	0x5DFA,0xB320,0x06F0,0xC020,0x1EF0,0xD9C4,0x08F0,0x4F20,
	0x206B,0xDC20,0x04F0,0x4C20,0x616F,0x2064,0xDC20,0x04F0,
	0x4320,0x6E61,0x6563,0x206C,0xDC20,0x08F0,0xF020,0xDF06,
	0x03F0,0xF020,0xDF08,0x03F0,0xF020,0xDF0A,0x04F0,0x2A20,
}; //	352 byte
ROBJ *IDD_PanelFilter = (ROBJ *)&PanelFilter_RC;
/******** Resource end   PanelFilter */

/* @doszip/src/dzmain/cmcompre.c */

/******** Resource begin Compression *
	{ 0x041C,   6,   4, {17, 6,46,13} },
	{ 0x0001,   0, 'A', { 5, 3,36, 1} },
	{ 0x0001,   0, 'S', { 5, 4,24, 1} },
	{ 0x0001,   0, 'U', { 5, 5,22, 1} },
	{ 0x0002,   0, 'P', { 5, 8,25, 1} },
	{ 0x0000,   0, 'O', { 4,11, 6, 1} },
	{ 0x0200,   0, 'C', {14,11,10, 1} },
********* Resource data  *******************/
static int Compression_RC[] = {
	0x0562,0x041C,0x0406,0x0611,0x0D2E,0x0001,0x4100,0x0305,
	0x0124,0x0001,0x5300,0x0405,0x0118,0x0001,0x5500,0x0505,
	0x0116,0x0002,0x5000,0x0805,0x0119,0x0000,0x4F00,0x0B04,
	0x0106,0x0200,0x4300,0x0B0E,0x010A,0x2EF0,0xF050,0x2A34,
	0x0EF0,0xF02E,0x2A23,0xF02E,0x2A34,0xF02E,0x2A26,0xF02E,
	0x2A58,0x07F0,0xF02E,0x2A37,0xF02E,0x2A77,0x5050,0xF05C,
	0x5003,0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,0x2A1A,
	0x06F0,0xF020,0x2A04,0x0AF0,0xF020,0x2A15,0x11F0,0x4320,
	0x6D6F,0x7270,0x7365,0x6973,0x6E6F,0x43F0,0xDA20,0x2020,
	0x7453,0x726F,0x6761,0x2065,0x656D,0x6874,0x646F,0xF020,
	0xC415,0xF0BF,0x2006,0x20B3,0x2028,0x2029,0x7541,0x6F74,
	0x616D,0x6974,0x6163,0x6C6C,0x2079,0x6573,0x656C,0x7463,
	0x6220,0x7365,0x2074,0x656D,0x6874,0x646F,0xB320,0x06F0,
	0xB320,0x2820,0x2920,0x4320,0x6572,0x7461,0x2065,0x6D73,
	0x6C61,0x656C,0x7473,0x6620,0x6C69,0xF065,0x200D,0xF0B3,
	0x2006,0x20B3,0x2028,0x2029,0x7355,0x2065,0x6166,0x7473,
	0x7365,0x2074,0x656D,0x6874,0x646F,0x0FF0,0xB320,0x06F0,
	0xC020,0x26F0,0xD9C4,0x06F0,0xDA20,0x20C4,0x6547,0x656E,
	0x6172,0x206C,0x1CF0,0xBFC4,0x06F0,0xB320,0x5B20,0x5D20,
	0x4320,0x6E6F,0x6966,0x6D72,0x7720,0x7469,0x2068,0x6170,
	0x7373,0x6F77,0x6472,0x0CF0,0xB320,0x06F0,0xC020,0x26F0,
	0xD9C4,0x37F0,0x4F20,0x206B,0xDC20,0x05F0,0x4320,0x6E61,
	0x6563,0x206C,0xDC20,0x1AF0,0xF020,0xDF06,0x04F0,0xF020,
	0xDF0A,0x15F0,0x2A20,
}; //	374 byte
ROBJ *IDD_Compression = (ROBJ *)&Compression_RC;
/******** Resource end   Compression */

/******** Resource begin Decompress *
	{ 0x0C1C,   7,   3, { 5, 7,70, 9} },
	{ 0x0004,  16, 'P', { 3, 3,64, 1} },
	{ 0x0002,   0, 'E', { 5, 5,33, 1} },
	{ 0x0002,   0, 'L', {41, 5,21, 1} },
	{ 0x0000,   0, 'D', { 3, 7,14, 1} },
	{ 0x4000,   0, 'O', {20, 7,11, 1} },
	{ 0x4000,   0, 'S', {34, 7,17, 1} },
	{ 0x0A00,   0, 'C', {56, 7,10, 1} },
********* Resource data  *******************/
static int Decompress_RC[] = {
	0x06C2,0x0C1C,0x0307,0x0705,0x0946,0x0004,0x5010,0x0303,
	0x0140,0x0002,0x4500,0x0505,0x0121,0x0002,0x4C00,0x0529,
	0x0115,0x0000,0x4400,0x0703,0x010E,0x4000,0x4F00,0x0714,
	0x010B,0x4000,0x5300,0x0722,0x0111,0x0A00,0x4300,0x0738,
	0x010A,0x46F0,0xF050,0x2A4E,0xF02E,0x2A40,0x40F0,0xF007,
	0x2A52,0xF03F,0x2A30,0xF03F,0x2A54,0x5050,0xF05C,0x500B,
	0x2A20,0x502A,0x5C50,0x08F0,0x2050,0x2A2A,0x5050,0xF05C,
	0x500E,0xF020,0x2A04,0x5050,0xF05C,0x5007,0xF020,0x2A07,
	0x0EF0,0xF020,0x2A03,0x0BF0,0xF020,0x2A03,0x11F0,0xF020,
	0x2A05,0x0AF0,0xF020,0x2A03,0x1EF0,0x4420,0x6365,0x6D6F,
	0x7270,0x7365,0xF073,0x2067,0x6544,0x6F63,0x706D,0x6572,
	0x7373,0x3CF0,0xF020,0xFA40,0x06F0,0xDA20,0x3EF0,0xBFC4,
	0x06F0,0xB320,0x5B20,0x5D20,0x4520,0x7478,0x6172,0x7463,
	0x6620,0x6C69,0x7365,0x7720,0x7469,0x2068,0x7566,0x6C6C,
	0x7020,0x7461,0x7368,0x03F0,0x5B20,0x5D20,0x4520,0x6964,
	0x2074,0x6F43,0x6D6D,0x6E61,0x2064,0x694C,0x656E,0x04F0,
	0xB320,0x06F0,0xC020,0x3EF0,0xD9C4,0x08F0,0x4420,0x6365,
	0x6D6F,0x7270,0x7365,0x2073,0xDC20,0x04F0,0x4F20,0x7470,
	0x6F69,0x736E,0x2020,0xF0DC,0x2004,0x6553,0x656C,0x7463,
	0x6D20,0x7465,0x6F68,0x2064,0xDC20,0x06F0,0x4320,0x6E61,
	0x6563,0x206C,0xDC20,0x07F0,0xF020,0xDF0E,0x03F0,0xF020,
	0xDF0B,0x03F0,0xF020,0xDF11,0x05F0,0xF020,0xDF0A,0x03F0,
	0x2A20,
}; //	354 byte
ROBJ *IDD_Decompress = (ROBJ *)&Decompress_RC;
/******** Resource end   Decompress */

/******** Resource begin Archive *
	{ 0x041C,  16,   0, {40, 3,17,18} },
	{ 0x8006,   2,   0, { 2, 1,13, 1} },
	{ 0x8006,   2,   0, { 2, 2,13, 1} },
	{ 0x8006,   2,   0, { 2, 3,13, 1} },
	{ 0x8006,   2,   0, { 2, 4,13, 1} },
	{ 0x8006,   2,   0, { 2, 5,13, 1} },
	{ 0x8006,   2,   0, { 2, 6,13, 1} },
	{ 0x8006,   2,   0, { 2, 7,13, 1} },
	{ 0x8006,   2,   0, { 2, 8,13, 1} },
	{ 0x8006,   2,   0, { 2, 9,13, 1} },
	{ 0x8006,   2,   0, { 2,10,13, 1} },
	{ 0x8006,   2,   0, { 2,11,13, 1} },
	{ 0x8006,   2,   0, { 2,12,13, 1} },
	{ 0x8006,   2,   0, { 2,13,13, 1} },
	{ 0x8006,   2,   0, { 2,14,13, 1} },
	{ 0x8006,   2,   0, { 2,15,13, 1} },
	{ 0x8006,   2,   0, { 2,16,13, 1} },
********* Resource data  *******************/
static int Archive_RC[] = {
	0x05A7,0x041C,0x0010,0x0328,0x1211,0x8006,0x0002,0x0102,
	0x010D,0x8006,0x0002,0x0202,0x010D,0x8006,0x0002,0x0302,
	0x010D,0x8006,0x0002,0x0402,0x010D,0x8006,0x0002,0x0502,
	0x010D,0x8006,0x0002,0x0602,0x010D,0x8006,0x0002,0x0702,
	0x010D,0x8006,0x0002,0x0802,0x010D,0x8006,0x0002,0x0902,
	0x010D,0x8006,0x0002,0x0A02,0x010D,0x8006,0x0002,0x0B02,
	0x010D,0x8006,0x0002,0x0C02,0x010D,0x8006,0x0002,0x0D02,
	0x010D,0x8006,0x0002,0x0E02,0x010D,0x8006,0x0002,0x0F02,
	0x010D,0x8006,0x0002,0x1002,0x010D,0x32F1,0xF12A,0x2032,
	0x2A2A,
}; //	146 byte
ROBJ *IDD_Archive = (ROBJ *)&Archive_RC;
/******** Resource end   Archive */

/******** Resource begin Compress *
	{ 0x0C1C,   8,   3, { 5, 7,70, 9} },
	{ 0x0004,  16, 'U', { 3, 3,64, 1} },
	{ 0x0002,   0, 'R', { 5, 5,25, 1} },
	{ 0x0002,   0, 'E', {36, 5,21, 1} },
	{ 0x0000,   0, 'P', { 3, 7,12, 1} },
	{ 0x4000,   0, 'O', {18, 7,11, 1} },
	{ 0x4000,   0, 'M', {32, 7, 8, 1} },
	{ 0x4000,   0, 'F', {43, 7,10, 1} },
	{ 0x0A00,   0, 'C', {56, 7,10, 1} },
********* Resource data  *******************/
static int Compress_RC[] = {
	0x06D2,0x0C1C,0x0308,0x0705,0x0946,0x0004,0x5510,0x0303,
	0x0140,0x0002,0x5200,0x0505,0x0119,0x0002,0x4500,0x0524,
	0x0115,0x0000,0x5000,0x0703,0x010C,0x4000,0x4F00,0x0712,
	0x010B,0x4000,0x4D00,0x0720,0x0108,0x4000,0x4600,0x072B,
	0x010A,0x0A00,0x4300,0x0738,0x010A,0x46F0,0xF050,0x2A52,
	0xF02E,0x2A3C,0x40F0,0xF007,0x2A52,0xF03F,0x2A1E,0xF03F,
	0x2A66,0x05F0,0x5C50,0x06F0,0x2050,0x2A2A,0x5050,0xF05C,
	0x5008,0x2A20,0x502A,0x5C50,0x05F0,0x2050,0x2A2A,0x5050,
	0xF05C,0x5007,0x2A20,0x502A,0x5C50,0x07F0,0x2050,0x07F0,
	0xF02A,0x200C,0x03F0,0xF02A,0x200B,0x03F0,0xF02A,0x2008,
	0x03F0,0xF02A,0x200A,0x03F0,0xF02A,0x200A,0x03F0,0xF02A,
	0x201F,0x6F43,0x706D,0x6572,0x7373,0x68F0,0x4320,0x6D6F,
	0x7270,0x7365,0x2073,0x7375,0x6E69,0xF067,0x2038,0x40F0,
	0xF0FA,0x2006,0xF0DA,0xC43E,0xF0BF,0x2006,0x20B3,0x205B,
	0x205D,0x6552,0x7563,0x7372,0x2065,0x7573,0x6462,0x7269,
	0x6365,0x6F74,0x6972,0x7365,0x05F0,0x5B20,0x5D20,0x4520,
	0x6964,0x2074,0x6F43,0x6D6D,0x6E61,0x2064,0x694C,0x656E,
	0x09F0,0xB320,0x06F0,0xC020,0x3EF0,0xD9C4,0x08F0,0x4320,
	0x6D6F,0x7270,0x7365,0x2073,0xDC20,0x04F0,0x4F20,0x7470,
	0x6F69,0x736E,0x2020,0xF0DC,0x2004,0x7954,0x6570,0x2020,
	0xF0DC,0x2004,0x6946,0x746C,0x7265,0x2020,0xF0DC,0x2004,
	0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2007,0x0CF0,0xF0DF,
	0x2003,0x0BF0,0xF0DF,0x2003,0x08F0,0xF0DF,0x2003,0x0AF0,
	0xF0DF,0x2003,0x0AF0,0xF0DF,0x2003,0x2A2A,
}; //	380 byte
ROBJ *IDD_Compress = (ROBJ *)&Compress_RC;
/******** Resource end   Compress */

/* @doszip/src/dzmain/cmdoskey.c */

/******** Resource begin History *
	{ 0x041C,  17,   0, {22, 3,36,19} },
	{ 0x8003,   0,   0, { 2, 2,32, 1} },
	{ 0x8003,   0,   0, { 2, 3,32, 1} },
	{ 0x8003,   0,   0, { 2, 4,32, 1} },
	{ 0x8003,   0,   0, { 2, 5,32, 1} },
	{ 0x8003,   0,   0, { 2, 6,32, 1} },
	{ 0x8003,   0,   0, { 2, 7,32, 1} },
	{ 0x8003,   0,   0, { 2, 8,32, 1} },
	{ 0x8003,   0,   0, { 2, 9,32, 1} },
	{ 0x8003,   0,   0, { 2,10,32, 1} },
	{ 0x8003,   0,   0, { 2,11,32, 1} },
	{ 0x8003,   0,   0, { 2,12,32, 1} },
	{ 0x8003,   0,   0, { 2,13,32, 1} },
	{ 0x8003,   0,   0, { 2,14,32, 1} },
	{ 0x8003,   0,   0, { 2,15,32, 1} },
	{ 0x8003,   0,   0, { 2,16,32, 1} },
	{ 0x8003,   0,   0, { 2,17,32, 1} },
	{ 0x8007,   0,   0, { 2,18,32, 1} },
********* Resource data  *******************/
static int History_RC[] = {
	0x06C0,0x041C,0x0011,0x0316,0x1324,0x8003,0x0000,0x0202,
	0x0120,0x8003,0x0000,0x0302,0x0120,0x8003,0x0000,0x0402,
	0x0120,0x8003,0x0000,0x0502,0x0120,0x8003,0x0000,0x0602,
	0x0120,0x8003,0x0000,0x0702,0x0120,0x8003,0x0000,0x0802,
	0x0120,0x8003,0x0000,0x0902,0x0120,0x8003,0x0000,0x0A02,
	0x0120,0x8003,0x0000,0x0B02,0x0120,0x8003,0x0000,0x0C02,
	0x0120,0x8003,0x0000,0x0D02,0x0120,0x8003,0x0000,0x0E02,
	0x0120,0x8003,0x0000,0x0F02,0x0120,0x8003,0x0000,0x1002,
	0x0120,0x8003,0x0000,0x1102,0x0120,0x8007,0x0000,0x1202,
	0x0120,0x24F0,0xF250,0x2A88,0x0EF0,0x4820,0x7369,0x6F74,
	0x7972,0x97F2,0x5020,
}; //	166 byte
ROBJ *IDD_History = (ROBJ *)&History_RC;
/******** Resource end   History */

/* @doszip/src/dzmain/cmexit.c */

/******** Resource begin EXIT *
	{ 0x041C,   2,   0, {26, 7,28, 6} },
	{ 0x0000,   0, 'O', { 4, 4, 6, 1} },
	{ 0x0200,   0, 'C', {14, 4,10, 1} },
********* Resource data  *******************/
static int EXIT_RC[] = {
	0x01A6,0x041C,0x0002,0x071A,0x061C,0x0000,0x4F00,0x0404,
	0x0106,0x0200,0x4300,0x040E,0x010A,0x1CF0,0xF050,0x2A58,
	0x5050,0xF05C,0x5003,0xF020,0x2A03,0x5050,0xF05C,0x5007,
	0xF020,0x2A08,0x06F0,0xF020,0x2A04,0x0AF0,0xF020,0x2A03,
	0x0CF0,0x4520,0x6978,0xF074,0x202F,0x7845,0x7469,0x7020,
	0x6F72,0x7267,0x6D61,0x3F20,0x29F0,0x4F20,0x206B,0xDC20,
	0x05F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,0x08F0,0xF020,
	0xDF06,0x04F0,0xF020,0xDF0A,0x03F0,0x2A20,
}; //	124 byte
ROBJ *IDD_EXIT = (ROBJ *)&EXIT_RC;
/******** Resource end   EXIT */

/* @doszip/src/dzmain/cmfblock.c */

/******** Resource begin PROPERTY *
	{ 0x4C1C,  18,  17, {18, 2,44,21} },
	{ 0x0002,   0,   0, { 5, 5, 3, 1} },
	{ 0x0002,   0, 'R', {10, 5, 3, 1} },
	{ 0x0002,   0,   0, { 5, 6, 3, 1} },
	{ 0x0002,   0, 'A', {10, 6, 3, 1} },
	{ 0x0002,   0,   0, { 5, 7, 3, 1} },
	{ 0x0002,   0, 'H', {10, 7, 3, 1} },
	{ 0x0002,   0,   0, { 5, 8, 3, 1} },
	{ 0x0002,   0, 'T', {10, 8, 3, 1} },
	{ 0x0002,   0, 'P', { 5,10, 3, 1} },
	{ 0x0004,  16, 'N', {10,12,30, 1} },
	{ 0x0004,   1, 'E', {19,15,10, 1} },
	{ 0x0004,   1,   0, {32,15, 8, 1} },
	{ 0x0004,   1, 'M', {19,16,10, 1} },
	{ 0x0004,   1,   0, {32,16, 8, 1} },
	{ 0x0004,   1, 'L', {19,17,10, 1} },
	{ 0x0004,   1,   0, {32,17, 8, 1} },
	{ 0x0000,   0, 'S', { 3,19, 7, 1} },
	{ 0x0A00,   0, 'C', {14,19,10, 1} },
********* Resource data  *******************/
static int PROPERTY_RC[] = {
	0x0A1C,0x4C1C,0x1112,0x0212,0x152C,0x0002,0x0000,0x0505,
	0x0103,0x0002,0x5200,0x050A,0x0103,0x0002,0x0000,0x0605,
	0x0103,0x0002,0x4100,0x060A,0x0103,0x0002,0x0000,0x0705,
	0x0103,0x0002,0x4800,0x070A,0x0103,0x0002,0x0000,0x0805,
	0x0103,0x0002,0x5400,0x080A,0x0103,0x0002,0x5000,0x0A05,
	0x0103,0x0004,0x4E10,0x0C0A,0x011E,0x0004,0x4501,0x0F13,
	0x010A,0x0004,0x0001,0x0F20,0x0108,0x0004,0x4D01,0x1013,
	0x010A,0x0004,0x0001,0x1020,0x0108,0x0004,0x4C01,0x1113,
	0x010A,0x0004,0x0001,0x1120,0x0108,0x0000,0x5300,0x1303,
	0x0107,0x0A00,0x4300,0x130E,0x010A,0x2CF0,0xF050,0x2ABE,
	0xF02E,0x2A2B,0xF02E,0x2A2B,0xF02E,0x2A2E,0xF02E,0x2A4F,
	0xF02E,0x2A53,0xF02E,0x2A04,0x1EF0,0xF007,0x2A63,0xF02E,
	0x2A0B,0x0AF0,0xF007,0x2A03,0x08F0,0xF007,0x2A09,0xF02E,
	0x2A0D,0x0AF0,0xF007,0x2A03,0x08F0,0xF007,0x2A09,0xF02E,
	0x2A0D,0x0AF0,0xF007,0x2A03,0x08F0,0xF008,0x2A33,0x5050,
	0xF05C,0x5004,0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,
	0x2A17,0x07F0,0xF020,0x2A04,0x0AF0,0xF020,0x2A13,0x12F0,
	0x5020,0x6F72,0x6570,0x7472,0xF079,0x2014,0xF0DA,0xC426,
	0xF0BF,0x2004,0xF0B3,0x2006,0x6843,0x6E61,0x6567,0x6620,
	0x6C69,0x2065,0x7461,0x7274,0x6269,0x7475,0x7365,0x0AF0,
	0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,0xB320,0x2020,
	0x6553,0x2074,0x4320,0x656C,0x7261,0x1AF0,0xB320,0x04F0,
	0xB320,0x2020,0x205B,0x205D,0x5B20,0x5D20,0x5220,0x6165,
	0x2064,0x6E6F,0x796C,0x12F0,0xB320,0x04F0,0xB320,0x2020,
	0x205B,0x205D,0x5B20,0x5D20,0x4120,0x6372,0x6968,0x6576,
	0x14F0,0xB320,0x04F0,0xB320,0x2020,0x205B,0x205D,0x5B20,
	0x5D20,0x4820,0x6469,0x6564,0xF06E,0x2015,0xF0B3,0x2004,
	0x20B3,0x5B20,0x5D20,0x2020,0x205B,0x205D,0x7953,0x7473,
	0x6D65,0x15F0,0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,
	0xB320,0x2020,0x205B,0x205D,0x7250,0x636F,0x7365,0x2073,
	0x7573,0x6662,0x6C6F,0x6564,0x7372,0x0EF0,0xB320,0x04F0,
	0xC320,0x26F0,0xB4C4,0x04F0,0xB320,0x2020,0x614E,0x656D,
	0x20F0,0xB320,0x04F0,0xC320,0x26F0,0xB4C4,0x04F0,0xB320,
	0x10F0,0x6420,0x2E64,0x6D6D,0xF02E,0x7904,0x03F0,0x6820,
	0x3A68,0x6D6D,0x733A,0x2073,0xF0B3,0x2004,0x20B3,0x4320,
	0x6572,0x7461,0x6F69,0xF06E,0x201C,0xF0B3,0x2004,0x20B3,
	0x4D20,0x646F,0x6669,0x6369,0x7461,0x6F69,0xF06E,0x2018,
	0xF0B3,0x2004,0x20B3,0x4C20,0x7361,0x2074,0x6361,0x6563,
	0x7373,0x19F0,0xB320,0x04F0,0xC020,0x26F0,0xD9C4,0x07F0,
	0x5320,0x7465,0x2020,0xF0DC,0x2005,0x6143,0x636E,0x6C65,
	0x2020,0xF0DC,0x2017,0x07F0,0xF0DF,0x2004,0x0AF0,0xF0DF,
	0x2013,0x2A2A,
}; //	660 byte
ROBJ *IDD_PROPERTY = (ROBJ *)&PROPERTY_RC;
/******** Resource end   PROPERTY */

/* @doszip/src/dzmain/cmhelp.c */

/******** Resource begin DoszipHelp *
	{ 0x0C1C,  11,   9, {15, 5,51,14} },
	{ 0x0406,   0, 'M', { 4, 2,24, 1} },
	{ 0x0006,   0, 'C', { 4, 3,28, 1} },
	{ 0x0006,   0, 'V', { 4, 4,26, 1} },
	{ 0x0006,   0, 'E', { 4, 5,26, 1} },
	{ 0x0006,   0, 'W', { 4, 6,35, 1} },
	{ 0x0006,   0, 'I', { 4, 7,39, 1} },
	{ 0x0006,   0, 'T', { 4, 8,39, 1} },
	{ 0x0006,   0, 'S', { 4, 9,19, 1} },
	{ 0x0006,   0, 'R', { 4,10,15, 1} },
	{ 0x4000,   0, 'A', { 5,12, 9, 1} },
	{ 0x0200,   0, 'O', {19,12, 6, 1} },
********* Resource data  *******************/
static int DoszipHelp_RC[] = {
	0x06A1,0x0C1C,0x090B,0x050F,0x0E33,0x0406,0x4D00,0x0204,
	0x0118,0x0006,0x4300,0x0304,0x011C,0x0006,0x5600,0x0404,
	0x011A,0x0006,0x4500,0x0504,0x011A,0x0006,0x5700,0x0604,
	0x0123,0x0006,0x4900,0x0704,0x0127,0x0006,0x5400,0x0804,
	0x0127,0x0006,0x5300,0x0904,0x0113,0x0006,0x5200,0x0A04,
	0x010F,0x4000,0x4100,0x0C05,0x0109,0x0200,0x4F00,0x0C13,
	0x0106,0x33F0,0xF250,0x2A36,0x5050,0xF05C,0x5006,0xF020,
	0x2A04,0x5050,0xF05C,0x5003,0xF020,0x2A1F,0x09F0,0xF020,
	0x2A05,0x06F0,0xF020,0x2A19,0x17F0,0x4820,0x6C65,0xF070,
	0x2050,0x3E3C,0x4D20,0x6D65,0x726F,0x2079,0x6572,0x7571,
	0x7269,0x6D65,0x6E65,0x7374,0x1DF0,0x3C20,0x203E,0x6F43,
	0x706D,0x6572,0x7373,0x6465,0x6620,0x6C69,0x2065,0x7573,
	0x7070,0x726F,0xF074,0x2019,0x3E3C,0x5620,0x6569,0x6577,
	0x2F72,0x6445,0x7469,0x726F,0x7320,0x7075,0x6F70,0x7472,
	0x1BF0,0x3C20,0x203E,0x6E45,0x6976,0x6F72,0x6D6E,0x6E65,
	0x2074,0x6176,0x6972,0x6261,0x656C,0xF073,0x201B,0x3E3C,
	0x5720,0x6E69,0x6F64,0x7377,0x3920,0x2F35,0x3839,0x582F,
	0x2050,0x6F43,0x706D,0x7461,0x6269,0x6C69,0x7469,0xF079,
	0x2012,0x3E3C,0x4920,0x736E,0x6174,0x6C6C,0x6E69,0x2067,
	0x6F43,0x6D6D,0x6E61,0x6564,0x2072,0x6E75,0x6564,0x2072,
	0x6957,0x646E,0x776F,0xF073,0x200E,0x3E3C,0x4320,0x6572,
	0x7461,0x6E69,0x2067,0x2061,0x7375,0x7265,0x6420,0x6665,
	0x6E69,0x6465,0x7420,0x6F6F,0x736C,0x6D20,0x6E65,0xF075,
	0x200E,0x3E3C,0x5320,0x6F68,0x7472,0x656B,0x2079,0x6174,
	0x6C62,0xF065,0x2022,0x3E2D,0x5220,0x4145,0x4D44,0x2E45,
	0x5854,0xF054,0x205B,0x6241,0x756F,0x2074,0xDC20,0x06F0,
	0x4F20,0x206B,0xDC20,0x1FF0,0xF020,0xDF09,0x05F0,0xF020,
	0xDF06,0x19F0,0x2A20,
}; //	438 byte
ROBJ *IDD_DoszipHelp = (ROBJ *)&DoszipHelp_RC;
/******** Resource end   DoszipHelp */

/* @doszip/src/dzmain/cmoption.c */

/******** Resource begin Configuration *
	{ 0x041C,   7,   5, {11, 3,58,19} },
	{ 0x4000,   0, 'S', { 4, 2,17, 1} },
	{ 0x4000,   0, 'P', { 4, 4,17, 1} },
	{ 0x4000,   0, 'F', { 4, 6,17, 1} },
	{ 0x4000,   0, 'M', { 4, 8,17, 1} },
	{ 0x0002,   0, 'A', { 6,11,19, 1} },
	{ 0x0000,   0, 'O', { 4,17, 6, 1} },
	{ 0x0200,   0, 'C', {14,17,10, 1} },
********* Resource data  *******************/
static int Configuration_RC[] = {
	0x097A,0x041C,0x0507,0x030B,0x133A,0x4000,0x5300,0x0204,
	0x0111,0x4000,0x5000,0x0404,0x0111,0x4000,0x4600,0x0604,
	0x0111,0x4000,0x4D00,0x0804,0x0111,0x0002,0x4100,0x0B06,
	0x0113,0x0000,0x4F00,0x1104,0x0106,0x0200,0x4300,0x110E,
	0x010A,0x3AF0,0xF050,0x2A3E,0x5050,0xF05C,0x500E,0xF020,
	0x2A29,0x11F0,0xF020,0x2A28,0x5050,0xF05C,0x500E,0xF020,
	0x2A29,0x11F0,0xF020,0x2A28,0x05F0,0x5C50,0x0BF0,0x2050,
	0x29F0,0xF02A,0x2011,0x28F0,0xF02A,0x5004,0xF05C,0x500C,
	0xF020,0x2A29,0x11F0,0xF020,0x2A68,0xF12E,0x2A55,0x5050,
	0xF05C,0x5003,0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,
	0x2A26,0x06F0,0xF020,0x2A04,0x0AF0,0xF020,0x2A21,0x16F0,
	0x4320,0x6E6F,0x6966,0x7567,0x6172,0x6974,0x6E6F,0x57F0,
	0x5320,0x7263,0x6565,0xF06E,0x2009,0x20DC,0x6553,0x656C,
	0x7463,0x7320,0x7263,0x6565,0x206E,0x706F,0x6974,0x6E6F,
	0xF073,0x2013,0x11F0,0xF0DF,0x202A,0x6150,0x656E,0x206C,
	0x704F,0x6974,0x6E6F,0x2073,0xDC20,0x4320,0x6E6F,0x6966,
	0x7567,0x6572,0x4320,0x6D6F,0x616D,0x646E,0x7265,0x5020,
	0x6E61,0x6C65,0xF073,0x200E,0x11F0,0xF0DF,0x202A,0x6F43,
	0x666E,0x7269,0x616D,0x6974,0x6E6F,0x2073,0xDC20,0x5320,
	0x7465,0x522F,0x7365,0x7465,0x5020,0x6F72,0x7267,0x6D61,
	0x5020,0x6F72,0x706D,0x7374,0x0FF0,0xF020,0xDF11,0x2AF0,
	0x4320,0x6D6F,0x7270,0x7365,0x6973,0x6E6F,0x04F0,0xDC20,
	0x4320,0x6E6F,0x6966,0x7567,0x6572,0x4320,0x6D6F,0x616D,
	0x646E,0x7265,0x4320,0x6D6F,0x7270,0x7365,0x6973,0x6E6F,
	0x09F0,0xF020,0xDF11,0x28F0,0xDA20,0x30F0,0xBFC4,0x08F0,
	0xB320,0x5B20,0x5D20,0x4120,0x7475,0x206F,0x6173,0x6576,
	0x7320,0x7465,0x7075,0x1CF0,0xB320,0x08F0,0xC020,0x30F0,
	0xD9C4,0x09F0,0x4E20,0x746F,0x3A65,0x4320,0x6568,0x6B63,
	0x7420,0x6568,0x4120,0x7475,0x206F,0x6173,0x6576,0x6320,
	0x6568,0x6B63,0x6220,0x786F,0x7420,0x206F,0x7561,0x6F74,
	0x7320,0x7661,0xF065,0x2010,0x6874,0x2065,0x6F63,0x666E,
	0x6769,0x7275,0x7461,0x6F69,0x2E6E,0x5920,0x756F,0x6320,
	0x6E61,0x6D20,0x6E61,0x6175,0x6C6C,0x2079,0x6173,0x6576,
	0x12F0,0x7920,0x756F,0x2072,0x6F63,0x666E,0x6769,0x7275,
	0x7461,0x6F69,0x206E,0x7962,0x7020,0x6572,0x7373,0x6E69,
	0x2067,0x6853,0x6669,0x2B74,0x3946,0xF02E,0x2047,0x6B4F,
	0x2020,0xF0DC,0x2005,0x6143,0x636E,0x6C65,0x2020,0xF0DC,
	0x2026,0x06F0,0xF0DF,0x2004,0x0AF0,0xF0DF,0x2021,0x2020,
}; //	608 byte
ROBJ *IDD_Configuration = (ROBJ *)&Configuration_RC;
/******** Resource end   Configuration */
/******** Resource begin Confirm *
	{ 0x041C,   9,   7, {36, 5,30,14} },
	{ 0x0002,   0, 'P', { 5, 3, 8, 1} },
	{ 0x0002,   0, 'M', { 5, 4, 8, 1} },
	{ 0x0002,   0, 'D', { 5, 5,10, 1} },
	{ 0x0002,   0, 'R', { 5, 6,20, 1} },
	{ 0x0002,   0, 'S', { 5, 7,17, 1} },
	{ 0x0002,   0, 'H', { 5, 8,17, 1} },
	{ 0x0002,   0, 'E', { 5, 9,16, 1} },
	{ 0x0000,   0, 'O', { 4,12, 6, 1} },
	{ 0x0200,   0, 'C', {13,12,10, 1} },
********* Resource data  *******************/
static int Confirm_RC[] = {
	0x0420,0x041C,0x0709,0x0524,0x0E1E,0x0002,0x5000,0x0305,
	0x0108,0x0002,0x4D00,0x0405,0x0108,0x0002,0x4400,0x0505,
	0x010A,0x0002,0x5200,0x0605,0x0114,0x0002,0x5300,0x0705,
	0x0111,0x0002,0x4800,0x0805,0x0111,0x0002,0x4500,0x0905,
	0x0110,0x0000,0x4F00,0x0C04,0x0106,0x0200,0x4300,0x0C0D,
	0x010A,0x1EF0,0xF050,0x2A47,0xF02E,0x2A1B,0xF02E,0x2A1D,
	0xF02E,0x2A26,0xF02E,0x2A1B,0xF02E,0x2A1D,0xF02E,0x2A16,
	0xF02E,0x2A54,0x5B5B,0xF05C,0x5B03,0x2A20,0x502A,0x5C50,
	0x07F0,0x2050,0x0BF0,0xF02A,0x2006,0x03F0,0xF02A,0x200A,
	0x06F0,0xF02A,0x200B,0x6F43,0x666E,0x7269,0xF06D,0x202D,
	0xC4DA,0x4320,0x6E6F,0x6966,0x6D72,0x7461,0x6F69,0x736E,
	0xF020,0xC406,0xF0BF,0x2006,0x20B3,0x205B,0x205D,0x6F43,
	0x7970,0x0DF0,0xB320,0x06F0,0xB320,0x5B20,0x5D20,0x4D20,
	0x766F,0xF065,0x200D,0xF0B3,0x2006,0x20B3,0x205B,0x205D,
	0x6544,0x656C,0x6574,0x0BF0,0xB320,0x06F0,0xB320,0x5B20,
	0x5D20,0x4420,0x6C65,0x7465,0x2065,0x6944,0x6572,0x7463,
	0x726F,0x2079,0xF0B3,0x2006,0x20B3,0x205B,0x205D,0x6544,
	0x656C,0x6574,0x5320,0x7379,0x6574,0xF06D,0x2004,0xF0B3,
	0x2006,0x20B3,0x205B,0x205D,0x6544,0x656C,0x6574,0x4820,
	0x6469,0x6564,0xF06E,0x2004,0xF0B3,0x2006,0x20B3,0x205B,
	0x205D,0x7845,0x7469,0x5020,0x6F72,0x7267,0x6D61,0x05F0,
	0xB320,0x06F0,0xC020,0x16F0,0xD9C4,0x27F0,0x4F20,0x206B,
	0xDC20,0x04F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,0x0BF0,
	0xF020,0xDF06,0x03F0,0xF020,0xDF0A,0x06F0,0x2A20,
}; //	382 byte
ROBJ *IDD_Confirm = (ROBJ *)&Confirm_RC;
/******** Resource end   Confirm */
/******** Resource begin Panel *
	{ 0x041C,   5,   3, {29, 6,37, 9} },
	{ 0x0002,   0, 'I', { 5, 3,21, 1} },
	{ 0x0002,   0, 'S', { 5, 4,22, 1} },
	{ 0x0002,   0, 'L', { 5, 5,27, 1} },
	{ 0x0000,   0, 'O', { 4, 7, 6, 1} },
	{ 0x0200,   0, 'C', {13, 7,10, 1} },
********* Resource data  *******************/
static int Panel_RC[] = {
	0x032F,0x041C,0x0305,0x061D,0x0925,0x0002,0x4900,0x0305,
	0x0115,0x0002,0x5300,0x0405,0x0116,0x0002,0x4C00,0x0505,
	0x011B,0x0000,0x4F00,0x0704,0x0106,0x0200,0x4300,0x070D,
	0x010A,0x25F0,0xF050,0x2A53,0xF02E,0x2A24,0xF02E,0x2A25,
	0xF02E,0x2A43,0x5B5B,0xF05C,0x5B03,0x2A20,0x502A,0x5C50,
	0x07F0,0x2050,0x12F0,0xF02A,0x2006,0x03F0,0xF02A,0x200A,
	0x0DF0,0xF02A,0x2010,0x6150,0x656E,0xF06C,0x2038,0xC4DA,
	0x5020,0x6E61,0x6C65,0x4F20,0x7470,0x6F69,0x736E,0xF020,
	0xC40D,0xF0BF,0x2006,0x20B3,0x205B,0x205D,0x6E49,0x6573,
	0x7472,0x6D20,0x766F,0x7365,0x6420,0x776F,0xF06E,0x2007,
	0xF0B3,0x2006,0x20B3,0x205B,0x205D,0x6553,0x656C,0x7463,
	0x4420,0x7269,0x6365,0x6F74,0x6972,0x7365,0x06F0,0xB320,
	0x06F0,0xB320,0x5B20,0x5D20,0x4320,0x656C,0x7261,0x7220,
	0x6165,0x2064,0x6E6F,0x796C,0x6620,0x6F72,0x206D,0x4443,
	0xB320,0x06F0,0xC020,0x1DF0,0xD9C4,0x09F0,0x4F20,0x206B,
	0xDC20,0x04F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,0x12F0,
	0xF020,0xDF06,0x03F0,0xF020,0xDF0A,0x0DF0,0x2A20,
}; //	270 byte
ROBJ *IDD_Panel = (ROBJ *)&Panel_RC;
/******** Resource end   Panel */

/* @doszip/src/dzmain/cmscreen.c */

/******** Resource begin Screen *
	{ 0x041C,  16,  14, {13, 4,55,16} },
	{ 0x0002,   0, 'E', { 5, 3, 8, 1} },
	{ 0x0002,   0, 'I', {19, 3, 8, 1} },
	{ 0x0001,   0, 'N', { 5, 6, 8, 1} },
	{ 0x0001,   0, 'G', { 5, 7, 9, 1} },
	{ 0x0001,   0, 'Y', { 5, 8,10, 1} },
	{ 0x0001,   0, 'R', {19, 6, 7, 1} },
	{ 0x0001,   0, 'K', {19, 7,10, 1} },
	{ 0x0101,   0, 'D', {19, 8,11, 1} },
	{ 0x2002,   0, 'U', { 5,11,24, 1} },
	{ 0x4000,   0, 'A', {35, 3,16, 1} },
	{ 0x4000,   0, 'P', {35, 5,16, 1} },
	{ 0x4000,   0, 'S', {35, 7,16, 1} },
	{ 0x4000,   0, 'L', {35, 9,16, 1} },
	{ 0x4000,   0, 'v', {35,11,16, 1} },
	{ 0x0000,   0, 'O', { 4,14, 6, 1} },
	{ 0x0A00,   0, 'C', {14,14,10, 1} },
********* Resource data  *******************/
static int Screen_RC[] = {
	0x0845,0x041C,0x0E10,0x040D,0x1037,0x0002,0x4500,0x0305,
	0x0108,0x0002,0x4900,0x0313,0x0108,0x0001,0x4E00,0x0605,
	0x0108,0x0001,0x4700,0x0705,0x0109,0x0001,0x5900,0x0805,
	0x010A,0x0001,0x5200,0x0613,0x0107,0x0001,0x4B00,0x0713,
	0x010A,0x0101,0x4400,0x0813,0x010B,0x2002,0x5500,0x0B05,
	0x0118,0x4000,0x4100,0x0323,0x0110,0x4000,0x5000,0x0523,
	0x0110,0x4000,0x5300,0x0723,0x0110,0x4000,0x4C00,0x0923,
	0x0110,0x4000,0x7600,0x0B23,0x0110,0x0000,0x4F00,0x0E04,
	0x0106,0x0A00,0x4300,0x0E0E,0x010A,0x37F0,0xF050,0x2A7A,
	0xF02E,0x2A0B,0xF02E,0x2A0A,0x07F0,0x5C50,0x08F0,0x2050,
	0x27F0,0xF02A,0x2010,0x26F0,0xF02A,0x5007,0xF05C,0x5008,
	0xF020,0x2A0C,0xF02E,0x2A0D,0xF02E,0x2A0C,0x10F0,0xF020,
	0x2A0C,0xF02E,0x2A11,0xF02E,0x2A07,0x5050,0xF05C,0x500D,
	0xF020,0x2A0C,0xF02E,0x2A0D,0xF02E,0x2A0C,0x10F0,0xF020,
	0x2A26,0x5050,0xF05C,0x500D,0xF020,0x2A27,0x10F0,0xF020,
	0x2A0C,0xF02E,0x2A19,0x04F0,0x5C50,0x0BF0,0x2050,0x27F0,
	0xF02A,0x2010,0x3EF0,0x502A,0x5C50,0x03F0,0x2050,0x03F0,
	0x502A,0x5C50,0x07F0,0x2050,0x23F0,0xF02A,0x2006,0x04F0,
	0xF02A,0x200A,0x1EF0,0xF02A,0x2018,0x6353,0x6572,0x6E65,
	0x53F0,0xDA20,0x20C4,0x654D,0x756E,0x6220,0x7261,0xF020,
	0xC410,0xF0BF,0x201A,0x20B3,0x205B,0x205D,0x6144,0x6574,
	0x06F0,0x5B20,0x5D20,0x5420,0x6D69,0xF065,0x2004,0xF0B3,
	0x2005,0x6445,0x7469,0x6120,0x7474,0x6972,0xF062,0x2003,
	0xF0DC,0x2006,0xF0C0,0xC41B,0xF0D9,0x2004,0x10F0,0xF0DF,
	0x2006,0xC4DA,0x5320,0x6174,0x646E,0x7261,0x2064,0x6F63,
	0x6F6C,0x2072,0x0AF0,0xBFC4,0x05F0,0x4520,0x6964,0x2074,
	0x6170,0x656C,0x7474,0x2065,0xDC20,0x06F0,0xB320,0x2820,
	0x2920,0x4E20,0x7661,0xF079,0x2006,0x2028,0x2029,0x6552,
	0xF064,0x2005,0xF0B3,0x2004,0x10F0,0xF0DF,0x2006,0x20B3,
	0x2028,0x2029,0x7247,0x6565,0xF06E,0x2005,0x2028,0x2029,
	0x6C42,0x6361,0xF06B,0x2003,0xF0B3,0x2005,0x6553,0x2074,
	0x7473,0x6E61,0x6164,0x6472,0x2020,0xF0DC,0x2006,0x20B3,
	0x2028,0x2029,0x6559,0x6C6C,0x776F,0x04F0,0x2820,0x2907,
	0x4420,0x6665,0x7561,0x746C,0xB320,0x04F0,0xF020,0xDF10,
	0x06F0,0xC020,0xC4C4,0xF0C2,0xC418,0xF0D9,0x2005,0x6F4C,
	0x6461,0x6320,0x6C6F,0x726F,0x04F0,0xDC20,0x06F0,0xDA20,
	0xC4C4,0xF0C1,0xC418,0xF0BF,0x2004,0x10F0,0xF0DF,0x2006,
	0x20B3,0x205B,0x205D,0x7355,0x2065,0x7267,0x7061,0x6968,
	0x6163,0x206C,0x6F63,0x6F6C,0x7372,0x2020,0xF0B3,0x2005,
	0x6153,0x6576,0x6320,0x6C6F,0x726F,0x04F0,0xDC20,0x06F0,
	0xC020,0x1BF0,0xD9C4,0x04F0,0xF020,0xDF10,0x40F0,0x4F20,
	0x206B,0xDC20,0x05F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,
	0x23F0,0xF020,0xDF06,0x04F0,0xF020,0xDF0A,0x1EF0,0x2020,
}; //	688 byte
ROBJ *IDD_Screen = (ROBJ *)&Screen_RC;
/******** Resource end   Screen */

/* @doszip/src/dzmain/cmsearch.c */

/******** Resource begin FILE_SEARCH *
	{ 0x0C1C,  25,  13, { 2, 2,76,22} },
	{ 0xA003,   0,   0, { 3, 2,70, 1} },
	{ 0xA003,   0,   0, { 3, 3,70, 1} },
	{ 0xA003,   0,   0, { 3, 4,70, 1} },
	{ 0xA003,   0,   0, { 3, 5,70, 1} },
	{ 0xA003,   0,   0, { 3, 6,70, 1} },
	{ 0xA003,   0,   0, { 3, 7,70, 1} },
	{ 0xA003,   0,   0, { 3, 8,70, 1} },
	{ 0xA003,   0,   0, { 3, 9,70, 1} },
	{ 0xA003,   0,   0, { 3,10,70, 1} },
	{ 0xA003,   0,   0, { 3,11,70, 1} },
	{ 0xA003,   0,   0, { 3,12,70, 1} },
	{ 0x0004,   8, 'F', {16,14,32, 1} },
	{ 0x0004,   8, 'L', {16,15,55, 1} },
	{ 0x0004,   8, 'C', {16,17,32, 1} },
	{ 0x8004,   8, 'R', {16,18,55, 1} },
	{ 0x0002,   0, 'P', {50,14,21, 1} },
	{ 0x0002,   0, 'E', {50,17, 3, 1} },
	{ 0x4000,   0, 'S', { 2,20, 9, 1} },
	{ 0x4000,   0, 'F', {15,20,10, 1} },
	{ 0x4000,   0, 'V', {29,20, 8, 1} },
	{ 0x0000,   0, 'G', {41,20, 8, 1} },
	{ 0x4000,   0, 'V', {53,20, 8, 1} },
	{ 0x0A00,   0, 'Q', {65,20, 8, 1} },
	{ 0xD007,   0,   0, { 3, 1,70, 1} },
	{ 0xC007,   0,   0, { 3,13,70, 1} },
********* Resource data  *******************/
static int FILE_SEARCH_RC[] = {
	0x1126,0x0C1C,0x0D19,0x0202,0x164C,0xA003,0x0000,0x0203,
	0x0146,0xA003,0x0000,0x0303,0x0146,0xA003,0x0000,0x0403,
	0x0146,0xA003,0x0000,0x0503,0x0146,0xA003,0x0000,0x0603,
	0x0146,0xA003,0x0000,0x0703,0x0146,0xA003,0x0000,0x0803,
	0x0146,0xA003,0x0000,0x0903,0x0146,0xA003,0x0000,0x0A03,
	0x0146,0xA003,0x0000,0x0B03,0x0146,0xA003,0x0000,0x0C03,
	0x0146,0x0004,0x4608,0x0E10,0x0120,0x0004,0x4C08,0x0F10,
	0x0137,0x0004,0x4308,0x1110,0x0120,0x8004,0x5208,0x1210,
	0x0137,0x0002,0x5000,0x0E32,0x0115,0x0002,0x4500,0x1132,
	0x0103,0x4000,0x5300,0x1402,0x0109,0x4000,0x4600,0x140F,
	0x010A,0x4000,0x5600,0x141D,0x0108,0x0000,0x4700,0x1429,
	0x0108,0x4000,0x5600,0x1435,0x0108,0x0A00,0x5100,0x1441,
	0x0108,0xD007,0x0000,0x0103,0x0146,0xC007,0x0000,0x0D03,
	0x0146,0x4CF0,0xF350,0x2AE0,0xF02E,0x2A31,0xF02E,0x2A19,
	0xF02E,0x2A97,0xF02E,0x2A34,0xF02E,0x2A16,0xF02E,0x2806,
	0x05F0,0xF02A,0x2837,0x53F0,0x502A,0x5C50,0x06F0,0x2050,
	0x03F0,0x502A,0x5C50,0x07F0,0x2050,0x03F0,0xF02A,0x5004,
	0xF05C,0x5003,0xF020,0x2A03,0x5050,0xF05C,0x5005,0xF020,
	0x2A03,0x5050,0xF05C,0x5005,0xF020,0x2A03,0x5050,0xF05C,
	0x5005,0xF020,0x2A05,0x09F0,0xF020,0x2A04,0x0AF0,0xF020,
	0x2A04,0x08F0,0xF020,0x2A04,0x08F0,0xF020,0x2A04,0x08F0,
	0xF020,0x2A04,0x08F0,0x2A20,0xF02A,0x2020,0x6946,0x656C,
	0x5320,0x6165,0x6372,0xF068,0x2023,0xF0DA,0xC446,0xF0BF,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0B3,0x2046,0xF0B3,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0B3,0x2046,0xF0B3,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0B3,0x2046,0xF0B3,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0B3,0x2046,0xF0B3,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0B3,0x2046,0xF0B3,
	0x2004,0xF0B3,0x2046,0xF0B3,0x2004,0xF0C3,0xC446,0xF0B4,
	0x2004,0x20B3,0x6946,0x646E,0x4620,0x6C69,0x7365,0x5B20,
	0x20F0,0x5DFA,0x5B20,0x5D20,0x5020,0x6F72,0x6563,0x7373,
	0x7320,0x6275,0x6F66,0x646C,0x7265,0x2073,0xF0B3,0x2004,
	0x20B3,0x6F4C,0x6163,0x6974,0x6E6F,0x03F0,0x5B20,0x37F0,
	0x5DFA,0xB320,0x04F0,0xC320,0x46F0,0xB4C4,0x04F0,0xB320,
	0x4320,0x6E6F,0x6174,0x6E69,0x6E69,0x2067,0xF05B,0xFA20,
	0x205D,0x205B,0x205D,0x6143,0x6573,0x7320,0x6E65,0x6973,
	0x6974,0x6576,0x05F0,0xB320,0x04F0,0xB320,0x5220,0x7065,
	0x616C,0x6563,0x04F0,0x5B20,0x37F0,0x5DFA,0xB320,0x04F0,
	0xC020,0x46F0,0xD9C4,0x06F0,0x5320,0x6174,0x7472,0x2020,
	0xF0DC,0x2005,0x6946,0x746C,0x7265,0x2020,0xF0DC,0x2005,
	0x6153,0x6576,0x2020,0xF0DC,0x2005,0x6F47,0x6F74,0x2020,
	0xF0DC,0x2005,0x6956,0x7765,0x2020,0xF0DC,0x2005,0x7551,
	0x7469,0x2020,0xF0DC,0x2005,0x09F0,0xF0DF,0x2004,0x0AF0,
	0xF0DF,0x2004,0x08F0,0xF0DF,0x2004,0x08F0,0xF0DF,0x2004,
	0x08F0,0xF0DF,0x2004,0x08F0,0x20DF,0x2A20,
}; //	716 byte
ROBJ *IDD_FILE_SEARCH = (ROBJ *)&FILE_SEARCH_RC;
/******** Resource end   FILE_SEARCH */
/******** Resource begin FSMakelist *
	{ 0x041C,   5,   4, {10, 8,61, 9} },
	{ 0x0004,  16, 'F', {13, 2,45, 1} },
	{ 0x0004,  16, 'B', {35, 4,23, 1} },
	{ 0x0004,  16, 'A', {35, 5,23, 1} },
	{ 0x0000,   0, 'O', { 3, 7, 6, 1} },
	{ 0x0A00,   0, 'C', {13, 7,10, 1} },
********* Resource data  *******************/
static int FSMakelist_RC[] = {
	0x07F7,0x041C,0x0405,0x080A,0x093D,0x0004,0x4610,0x020D,
	0x012D,0x0004,0x4210,0x0423,0x0117,0x0004,0x4110,0x0523,
	0x0117,0x0000,0x4F00,0x0703,0x0106,0x0A00,0x4300,0x070D,
	0x010A,0x3DF0,0xF050,0x2A40,0xF02E,0x2A09,0x2DF0,0xF007,
	0x2A50,0xF02E,0x2A12,0x17F0,0xF007,0x2A13,0xF02E,0x2A12,
	0x17F0,0xF007,0x2A43,0x5050,0xF05C,0x5003,0xF020,0x2A03,
	0x5050,0xF05C,0x5007,0xF020,0x2A29,0x06F0,0xF020,0x2A04,
	0x0AF0,0xF020,0x2A25,0x1AF0,0x4C20,0x7369,0x6674,0x6C69,
	0xF065,0x205B,0x6946,0x656C,0x616E,0x656D,0xF03A,0x2072,
	0x6554,0x7478,0x7420,0x206F,0x7570,0x2074,0x6562,0x6F66,
	0x6572,0x6620,0x6C69,0x2065,0x616E,0x656D,0x3A73,0x1FF0,
	0x5420,0x7865,0x2074,0x6F74,0x7020,0x7475,0x6120,0x7466,
	0x7265,0x6620,0x6C69,0x2065,0x616E,0x656D,0x3A73,0x5EF0,
	0x4F20,0x206B,0xDC20,0x05F0,0x4320,0x6E61,0x6563,0x206C,
	0xDC20,0x29F0,0xF020,0xDF06,0x04F0,0xF020,0xDF0A,0x25F0,
	0x2A20,
}; //	242 byte
ROBJ *IDD_FSMakelist = (ROBJ *)&FSMakelist_RC;
/******** Resource end   FSMakelist */

/* @doszip/src/dzmain/cmsubsiz.c */

/******** Resource begin SUBINFO *
	{ 0x0C1C,   1,   0, {22, 7,37,11} },
	{ 0x0000,   0, 'O', {15, 9, 6, 1} },
********* Resource data  *******************/
static int SUBINFO_RC[] = {
	0x0387,0x0C1C,0x0001,0x0716,0x0B25,0x0000,0x4F00,0x090F,
	0x0106,0x25F0,0xF150,0x2A37,0x5B5B,0xF05C,0x5B03,0xF020,
	0x2A1F,0x06F0,0xF020,0x2A0F,0x5EF1,0x4F20,0x206B,0xDC20,
	0x1FF0,0xF020,0xDF06,0x0FF0,0x5020,
}; //	58 byte
ROBJ *IDD_SUBINFO = (ROBJ *)&SUBINFO_RC;
/******** Resource end   SUBINFO */

/******** Resource begin EditColor *
	{ 0x4C1C,  26,  25, {10, 1,61,23} },
	{ 0x2003,   0, '0', { 4, 4, 7, 1} },
	{ 0x2003,   0, '0', { 4, 5, 7, 1} },
	{ 0x2003,   0, '0', { 4, 6, 7, 1} },
	{ 0x2003,   0, '0', { 4, 7, 7, 1} },
	{ 0x2003,   0, '0', { 4, 8, 7, 1} },
	{ 0x2003,   0, '0', { 4, 9, 7, 1} },
	{ 0x2003,   0, '0', { 4,10, 7, 1} },
	{ 0x2003,   0, '0', { 4,11, 7, 1} },
	{ 0x2003,   0, '0', {16, 4, 7, 1} },
	{ 0x2003,   0, '0', {16, 5, 7, 1} },
	{ 0x2003,   0, '0', {16, 6, 7, 1} },
	{ 0x2003,   0, '0', {16, 7, 7, 1} },
	{ 0x2003,   0, '0', {16, 8, 7, 1} },
	{ 0x2003,   0, '0', {16, 9, 7, 1} },
	{ 0x2003,   0, '0', {16,10, 7, 1} },
	{ 0x2003,   0, '0', {16,11, 7, 1} },
	{ 0x2003,   0, '0', {16,12, 7, 1} },
	{ 0x2003,   0, '0', {16,13, 7, 1} },
	{ 0x2003,   0, '0', {16,14, 7, 1} },
	{ 0x2003,   0, '0', {16,15, 7, 1} },
	{ 0x2003,   0, '0', {16,16, 7, 1} },
	{ 0x2003,   0, '0', {16,17, 7, 1} },
	{ 0x2003,   0, '0', {16,18, 7, 1} },
	{ 0x2003,   0, '0', {16,19, 7, 1} },
	{ 0x0000,   0, 'o', { 4,21, 6, 1} },
	{ 0x0200,   0, 'C', {14,21,10, 1} },
********* Resource data  *******************/
static int EditColor_RC[] = {
	0x0D0F,0x4C1C,0x191A,0x010A,0x173D,0x2003,0x3000,0x0404,
	0x0107,0x2003,0x3000,0x0504,0x0107,0x2003,0x3000,0x0604,
	0x0107,0x2003,0x3000,0x0704,0x0107,0x2003,0x3000,0x0804,
	0x0107,0x2003,0x3000,0x0904,0x0107,0x2003,0x3000,0x0A04,
	0x0107,0x2003,0x3000,0x0B04,0x0107,0x2003,0x3000,0x0410,
	0x0107,0x2003,0x3000,0x0510,0x0107,0x2003,0x3000,0x0610,
	0x0107,0x2003,0x3000,0x0710,0x0107,0x2003,0x3000,0x0810,
	0x0107,0x2003,0x3000,0x0910,0x0107,0x2003,0x3000,0x0A10,
	0x0107,0x2003,0x3000,0x0B10,0x0107,0x2003,0x3000,0x0C10,
	0x0107,0x2003,0x3000,0x0D10,0x0107,0x2003,0x3000,0x0E10,
	0x0107,0x2003,0x3000,0x0F10,0x0107,0x2003,0x3000,0x1010,
	0x0107,0x2003,0x3000,0x1110,0x0107,0x2003,0x3000,0x1210,
	0x0107,0x2003,0x3000,0x1310,0x0107,0x0000,0x6F00,0x1504,
	0x0106,0x0200,0x4300,0x150E,0x010A,0x3DF0,0xF050,0x2A60,
	0x10F0,0xF220,0x2AE8,0xF12C,0x2A6F,0x5050,0xF05C,0x5003,
	0xF020,0x2A03,0x5050,0xF05C,0x5007,0xF020,0x2A03,0xF020,
	0x2A0B,0xF020,0x2A19,0x06F0,0xF020,0x2A04,0x0EF0,0xF020,
	0x2A03,0x09F0,0xF020,0x2A14,0x1CF0,0x4320,0x6C6F,0x726F,
	0x7CF0,0x5020,0x5567,0x2F70,0x6750,0x6E44,0x203A,0x6156,
	0x756C,0xF065,0x200D,0x37F0,0xF4C4,0x2016,0x6B4F,0x2020,
	0xF0DC,0x2005,0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2029,
	0x06F0,0xF0DF,0x2004,0x0AF0,0xF0DF,0x2024,0x2A2A,
}; //	350 byte
ROBJ *IDD_EditColor = (ROBJ *)&EditColor_RC;
/******** Resource end   EditColor */


/* @doszip/src/clib/arch/confirmd.c */

/******** Resource begin ConfirmDelete *
	{ 0x081C,   4,   0, {11, 6,59, 7} },
	{ 0x0000,   0, 'D', { 4, 5,10, 1} },
	{ 0x0000,   0, 'A', {17, 5,14, 1} },
	{ 0x0000,   0, 'J', {34, 5, 8, 1} },
	{ 0x0200,   0, 'C', {45, 5,10, 1} },
********* Resource data  *******************/
static int ConfirmDelete_RC[] = {
	0x03D1,0x081C,0x0004,0x060B,0x073B,0x0000,0x4400,0x0504,
	0x010A,0x0000,0x4100,0x0511,0x010E,0x0000,0x4A00,0x0522,
	0x0108,0x0200,0x4300,0x052D,0x010A,0x3BF0,0xF070,0x47F0,
	0x7070,0xF074,0x7007,0x4740,0xF047,0x7009,0xF074,0x7004,
	0x4740,0x7047,0x7470,0x05F0,0x4070,0x4747,0x7070,0xF074,
	0x7007,0xF040,0x4708,0x0AF0,0xF040,0x4703,0x0EF0,0xF040,
	0x4703,0x08F0,0xF040,0x4703,0x0AF0,0xF040,0x4703,0x1AF0,
	0x4420,0x6C65,0x7465,0xF165,0x200D,0x6544,0x656C,0x6574,
	0x2020,0xF0DC,0x2004,0x6544,0x656C,0x6574,0x6120,0x6C6C,
	0x2020,0xF0DC,0x2004,0x754A,0x706D,0x2020,0xF0DC,0x2004,
	0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2008,0x0AF0,0xF0DF,
	0x2003,0x0EF0,0xF0DF,0x2003,0x08F0,0xF0DF,0x2003,0x0AF0,
	0xF0DF,0x2003,0x4747,
}; //	198 byte
ROBJ *IDD_ConfirmDelete = (ROBJ *)&ConfirmDelete_RC;
/******** Resource end   ConfirmDelete */

/* @doszip/src/clib/arch/continue.c */

/******** Resource begin ConfirmContinue *
	{ 0x041C,   2,   0, {19, 7,42,10} },
	{ 0x0000,   0, 'O', { 3, 8,12, 1} },
	{ 0x0200,   0, 'C', {19, 8,10, 1} },
********* Resource data  *******************/
static int ConfirmContinue_RC[] = {
	0x03B4,0x041C,0x0002,0x0713,0x0A2A,0x0000,0x4F00,0x0803,
	0x010C,0x0200,0x4300,0x0813,0x010A,0x2AF0,0xF050,0x2A88,
	0x08F0,0xF02E,0x2A2B,0x06F0,0xF02E,0x2A08,0x03F0,0xF02E,
	0x2A5D,0x03F0,0x5C50,0x08F0,0x2050,0x03F0,0x502A,0x5C50,
	0x07F0,0x2050,0x10F0,0xF02A,0x200C,0x04F0,0xF02A,0x200A,
	0x0CF0,0xF02A,0x200D,0x6F43,0x666E,0x7269,0x206D,0x6F43,
	0x746E,0x6E69,0x6575,0x3AF0,0x5B20,0x22F0,0x5DFA,0x30F0,
	0x4320,0x6F68,0x736F,0x2065,0x6F43,0x746E,0x6E69,0x6575,
	0x6920,0x2066,0x6F79,0x2075,0x6F77,0x6C75,0x2064,0x696C,
	0x656B,0x7420,0xF06F,0x2006,0x6F63,0x746E,0x6E69,0x6575,
	0x202E,0x7250,0x7365,0x2073,0x6143,0x636E,0x6C65,0x6F20,
	0x2072,0x6968,0x2074,0x5345,0x2043,0x6F74,0x06F0,0x7420,
	0x7265,0x696D,0x616E,0x6574,0x6F20,0x6570,0x6172,0x6974,
	0x6E6F,0xF02E,0x2042,0x6F43,0x746E,0x6E69,0x6575,0x2020,
	0xF0DC,0x2005,0x6143,0x636E,0x6C65,0x2020,0xF0DC,0x2010,
	0x0CF0,0xF0DF,0x2004,0x0AF0,0xF0DF,0x200C,0x2A2A,
}; //	254 byte
ROBJ *IDD_ConfirmContinue = (ROBJ *)&ConfirmContinue_RC;
/******** Resource end   ConfirmContinue */

/* @doszip/src/clib/disk/drvretry.c */

/******** Resource begin DriveNotReady *
	{ 0x081C,   2,   1, { 6, 4,35, 8} },
	{ 0x0000,   0, 'T', { 4, 6,13, 1} },
	{ 0x0000,   0, 'C', {20, 6,10, 1} },
********* Resource data  *******************/
static int DriveNotReady_RC[] = {
	0x0291,0x081C,0x0102,0x0406,0x0823,0x0000,0x5400,0x0604,
	0x010D,0x0000,0x4300,0x0614,0x010A,0x23F0,0xF070,0x47B3,
	0x7070,0xF074,0x700A,0x4740,0x7047,0x7470,0x07F0,0x4070,
	0x09F0,0xF047,0x400D,0x03F0,0xF047,0x400A,0x04F0,0xF047,
	0x200A,0x7244,0x7669,0x2065,0x6F6E,0x2074,0x6572,0x6461,
	0xF079,0x2030,0x6E55,0x6261,0x656C,0x7420,0x206F,0x6572,
	0x6461,0x6420,0x6972,0x6576,0x03F0,0x3A20,0x77F0,0x5420,
	0x7972,0x6120,0x6167,0x6E69,0x2020,0xF0DC,0x2004,0x6143,
	0x636E,0x6C65,0x2020,0xF0DC,0x2009,0x0DF0,0xF0DF,0x2003,
	0x0AF0,0xF0DF,0x2004,0x4747,
}; //	152 byte
ROBJ *IDD_DriveNotReady = (ROBJ *)&DriveNotReady_RC;
/******** Resource end   DriveNotReady */
