/* DZMENU.H--
 * Copyright (c) 2001 Hjort Nidudsson
 *
 * Change history:
 * 19 Oct 2001	- Created.
 */
#ifndef __INC_DZMENU
#define __INC_DZMENU
#include <dialog.h>

#define MAXUSERITEM	20

enum {
	ID_MPANELA,
	ID_MFILE,
	ID_MEDIT,
	ID_MSETUP,
	ID_MTOOLS,
	ID_MHELP,
	ID_MPANELB
};

enum {
	ID_ALONGNAME,
	ID_ADETAIL,
	ID_AHIDDEN,
	ID_AMINISTATUS,
	ID_AVOLINFO,
	ID_ANAME,
	ID_ATYPE,
	ID_ADATE,
	ID_ASIZE,
	ID_ANOSORT,
	ID_ATOGGLE,
	ID_AFILTER,
	ID_ASUBINFO,
	ID_AUPDATE,
	ID_ACHDRV,

	ID_RENAME,
	ID_VIEW,
	ID_EDIT,
	ID_COPY,
	ID_MOVE,
	ID_MKDIR,
	ID_DELETE,
	ID_BLKPROPERTY,
	ID_COMPRESS,
	ID_DECOMPRESS,
	ID_SEARCH,
	ID_HISTORY,
	ID_EXIT,

	ID_SELECT,
	ID_DESELECT,
	ID_INVERT,
	ID_COMPARE,

	ID_TOGGLEON,
	ID_TOGGLEHZ,
	ID_TOGGLESZ,
	ID_EGALINE,
	ID_SWAPPANELS,
	ID_CONFIRMATION,
	ID_SCREENOPTIONS,
	ID_PANELOPTIONS,
	ID_CONFIGURATION,

	ID_HELP,
	ID_ABOUT,

	ID_BLONGNAME,
	ID_BDETAIL,
	ID_BHIDDEN,
	ID_BMINISTATUS,
	ID_BVOLINFO,
	ID_BNAME,
	ID_BTYPE,
	ID_BDATE,
	ID_BSIZE,
	ID_BNOSORT,
	ID_BTOGGLE,
	ID_BFILTER,
	ID_BSUBINFO,
	ID_BUPDATE,
	ID_BCHDRV,

	ID_COUNT
};

enum {
	ID_SHELP,
	ID_SRENAME,
	ID_SVIEW,
	ID_SEDIT,
	ID_SCOPY,
	ID_SMOVE,
	ID_SMKDIR,
	ID_SDELETE,
	ID_SEXIT
};

enum {
	IDSTL_ATOGGLE,
	IDSTL_BTOGGLE,
	IDSTL_NAME,
	IDSTL_TYPE,
	IDSTL_DATE,
	IDSTL_SIZE
};

extern ROBJ *IDD_PANELA;
extern ROBJ *IDD_FILE;
extern ROBJ *IDD_EDIT;
extern ROBJ *IDD_SETUP;
extern ROBJ *IDD_HELP;
extern ROBJ *IDD_PANELB;
extern ROBJ *IDD_Archive;
extern ROBJ *IDD_Compress;
extern ROBJ *IDD_Decompress;
extern ROBJ *IDD_Compression;
extern ROBJ *IDD_History;
extern ROBJ *IDD_EXIT;
extern ROBJ *IDD_PROPERTY;
extern ROBJ *IDD_DoszipHelp;
extern ROBJ *IDD_Panel;
extern ROBJ *IDD_Confirm;
extern ROBJ *IDD_Configuration;
extern ROBJ *IDD_Screen;
extern ROBJ *IDD_FSMakelist;
extern ROBJ *IDD_FILE_SEARCH;
extern ROBJ *IDD_SUBINFO;
extern ROBJ *IDD_SaveSetup;
extern ROBJ *IDD_PanelFilter;
extern ROBJ *IDD_OperationFilters;
extern ROBJ *ResourceMenus[];

extern TOBJ tobj_menusline[];

extern const char
	cp_copyright	[],
	cp_menusline	[],
	cp_statusline	[],
	cp_stlctrl	[],
	cp_stlctrlalt	[], /* Quick Search: */
	cp_long		[], /* Long/short filename */
	cp_detail	[], /* Show detail */
	cp_hidden	[], /* Show hidden files */
	cp_mini		[], /* Ministatus */
	cp_volinfo	[], /* Volume Information */
	cp_sort		[], /* Sort by Name|Type|Time|Size */
	cp_toggle	[], /* Toggle panel - on/off */
	cp_pfilter	[], /* Panel filter */
	cp_subinfo	[], /* Directory information */
	cp_update	[], /* Re-read */
	cp_chdrv	[], /* Select drive */
	cp_rename	[], /* Rename file or directory */
	cp_view		[], /* View file */
	cp_edit		[], /* Edit file */
	cp_copy		[], /* Copy */
	cp_move		[], /* Move */
	cp_mkdir	[], /* Make directory */
	cp_delete	[], /* Delete */
	cp_blkprop	[], /* Edit file property */
	cp_compress	[], /* Compress */
	cp_decompress	[], /* Decompress */
	cp_search	[], /* File Search */
	cp_history	[], /* List of the last 10 DOS commands */
	cp_exit		[], /* Exit program */
	cp_select	[], /* Select files */
	cp_deselect	[], /* Deselect files */
	cp_invert	[], /* Invert selection */
	cp_compare	[], /* Compare directories */
	cp_toggleon	[], /* Toggle panels - on/off */
	cp_togglehz 	[], /* Toggle panels - horizontal/vertical */
	cp_togglesz 	[], /* Toggle Panels - size */
	cp_egaline	[], /* Toggle 25-50 lines */
	cp_swappanels	[], /* Swap panels */
	cp_config	[], /* Configuration */
	cp_confirm	[], /* Confirmations options */
	cp_screen	[], /* Screen options */
	cp_panel	[], /* Panel options */
	cp_help		[], /* Help */
	cp_about	[]; /* About */
extern const char
	cp_mcopyselected[]; /* "[%04d file(s)]" */
extern const char
	cp_ercopy   [], /* There was an error while copying */
	cp_enospc   [], /* Out of space on target drive */
	cp_recursive[], /* You tried to recursively copy or move a directory */
	cp_needpanel[], /* You need two file panels to use this command. */
	cp_fnisequal[]; /* You can't copy a file to itself */
extern const char
	cp_identical	[], /* The two folders seems\nto be identical */
	cp_different	[]; /* Only one panel use Short File Names */
extern const char
	cp_linkerror	[], /* You can't do this in a link or .ZIP panel. */
	cp_badentry	[], /* Bad or missing Entry in DZ.INI */
	cp_badentrymsg	[], /* Section: [%s]\nEntry: [%s]\n */
	cp_enterpassword[], /* Enter password */
	cp_skippassword	[], /* Skip Password? */
	cp_badpasswordsw[], /* 07=(Password switch) */
	cp_compressto	[], /* %s to */
	cp_compressusing[], /* %s using %s to */
	cp_missingTEMP	[], /* Bad or missing TEMP directory */
	cp_nothingtodo	[]; /* Nothing to do.. */
extern const char
	cp_userabort	[], /* User abort */
	cp_edel		[], /* Error delete */
	cp_emdel	[]; /* Can't delete the file:\n%s\n'%s' */
extern const char
	cp_editcommand	[]; /* Edit command */
extern const char
	cp_property	[]; /* &Property */
extern const char
	cp_selectdrv_A	[], /* Select disk Panel A */
	cp_selectdrv_B	[]; /* Select disk Panel B */
extern const char
	cp_loadcolor	[], /* Load color */
	cp_savecolor	[]; /* Save color */
extern const char
	cp_subsize	[], /* Directory Information */
	cp_selected	[], /* Selected Files */
	cp_bytesize	[], /* BKMGTPE */
	cp_location	[], /* Location: */
	cp_10lu_Files	[], /* %10lu Files\n%10lu Directories */
	cp_totalsbyte	[]; /* total %s byte */
extern const char
	cp_unziptotemp	[]; /* Unzip file to TEMP */

int cmalong(void);
int cmadetail(void);
int cmahidden(void);
int cmamini(void);
int cmavolinfo(void);
int cmanosort(void);
int cmaname(void);
int cmatype(void);
int cmadate(void);
int cmasize(void);
int cmatoggle(void);
int cmafilter(void);
int cmasubinfo(void);
int cmaupdate(void);
int cmachdrv(void);

int cmhistory(void);
int cmrename(void);
int cmview(void);
int cmedit(void);
int cmcopy(void);
int cmmove(void);
int cmmkdir(void);
int cmdelete(void);
int cmblkprop(void);
int cmcompress(void);
int cmdecompress(void);
int cmhistory(void);
int cmsearch(void);
int cmexit(void);

int cminvert(void);
int cmselect(void);
int cmdeselect(void);
int cmcompare(void);

int cmtoggleon(void);
int cmtogglehz(void);
int cmtogglesz(void);
int cmegaline(void);
int cmswap(void);
int cmconfirm(void);
int cmscreen(void);
int cmpanel(void);
int cmoptions(void);

int cmtool0(void);
int cmtool1(void);
int cmtool2(void);
int cmtool3(void);
int cmtool4(void);
int cmtool5(void);
int cmtool6(void);
int cmtool7(void);
int cmtool8(void);
int cmtool9(void);

int cmhelp(void);
int cmabout(void);

int cmblong(void);
int cmbdetail(void);
int cmbhidden(void);
int cmbmini(void);
int cmbvolinfo(void);
int cmbnosort(void);
int cmbname(void);
int cmbtype(void);
int cmbdate(void);
int cmbsize(void);
int cmbtoggle(void);
int cmbfilter(void);
int cmbsubinfo(void);
int cmsubsize(void);
int cmbupdate(void);
int cmbchdrv(void);

int cmclong(void);
int cmcdetail(void);
int cmchidden(void);
int cmcmini(void);
int cmcname(void);
int cmctype(void);
int cmcdate(void);
int cmcsize(void);
int cmcnosort(void);
int cmcupdate(void);

int cmcopycell(void);
int cmdoskey_up(void);
int cmdoskey_dn(void);
int notsup(void);
int cmquit(void);

int cmcompression(void);
int cmsavesetup(void);

int cmclrcmdl(void);
int cmupdir(void);
int cmsubdir(void);
int cmctrlenter(void);
#ifdef _DOSBMP_
int dosbmp(void);
#endif
int cmvolinfo(void);

int cmpath0(void);
int cmpath1(void);
int cmpath2(void);
int cmpath3(void);
int cmpath4(void);
int cmpath5(void);
int cmpath6(void);
int cmpath7(void);
int cmpath8(void);
int cmpath9(void);

#endif