/*
 * STDERROR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <errno.h>
#include <tdialog.h>

extern const char
	cp_EMNOMEM	[], /* Insufficient memory */
	cp_ENOMEM	[], /* Not enough space */
	cp_EMDISKFULL   [], /* Insufficient disk space */
	cp_EMEROPEN	[], /* Error open file */
	cp_EMEROPENmsg	[], /* Can't open the file\n%s\n'%s' */
	cp_EMARCHIVE	[], /* Error in archive\n'%s' */
	cp_EMBADCRC	[]; /* Data error (bad CRC) */

int stderror(const char *msg, int type, int returncode)
{
	switch (type) {
	case EMNOMEM:
		ermsg(NULL, cp_EMNOMEM);
		break;
	case EMDISKFULL:
		ermsg(cp_ENOMEM, cp_EMDISKFULL);
		break;
	case EMEROPEN:
		ermsg(cp_EMEROPEN, cp_EMEROPENmsg, msg, sys_errlist[errno]);
		break;
	case EMERRNO:
		ermsg(NULL, "%s\n'%s'", sys_errlist[errno], msg);
		break;
	case EMNOENT:
		ermsg(NULL, "%s\n'%s'", sys_errlist[ENOENT], msg);
		break;
	case EMARCHIVE:
		ermsg(NULL, cp_EMARCHIVE, cp_EMBADCRC, msg);
		break;
	default:
		ermsg(NULL, msg);
		break;
	}
	return returncode;
}
