/* DLSEARCH.C--
 * Copyright (c) 2008 Hjort Nidudsson
 *
 * Change history:
 */

#include <iost.h>
#include <stdsc.h>
#include <tdialog.h>

/******** Resource begin Search *
	{ 0x041C,   7,   0, {20, 6,51,10} },
	{ 0x2004,   0, 'T', { 3, 3,45, 1} },
	{ 0x0002,   0, 'A', { 3, 5,18, 1} },
	{ 0x0002,   0, 'H', { 3, 6,22, 1} },
	{ 0x0000,   0, 'S', { 3, 8,10, 1} },
	{ 0x0200,   0, 'C', {16, 8,10, 1} },
	{ 0x0001,   0, 'F', {30, 5,16, 1} },
	{ 0x0001,   0, 'E', {30, 6,16, 1} },
********* Resource data  *******************/
static int Search_RC[] = {
	0x04C1,0x041C,0x0007,0x0614,0x0A33,0x2004,0x5400,0x0303,
	0x012D,0x0002,0x4100,0x0503,0x0112,0x0002,0x4800,0x0603,
	0x0116,0x0000,0x5300,0x0803,0x010A,0x0200,0x4300,0x0810,
	0x010A,0x0001,0x4600,0x051E,0x0110,0x0001,0x4500,0x061E,
	0x0110,0x33F0,0xF050,0x2A46,0xF02F,0x2A22,0x2DF0,0xF007,
	0x2A3E,0xF03F,0x2A19,0xF02E,0x2A17,0xF03F,0x2A1A,0xF03F,
	0x2A46,0x5A5A,0xF05C,0x5A07,0x03F0,0x5A2A,0x5C5A,0x07F0,
	0xF05A,0x2A4C,0x16F0,0x5320,0x6165,0x6372,0xF068,0x204D,
	0x6553,0x7261,0x6863,0x6620,0x726F,0x7420,0x6568,0x7320,
	0x7274,0x6E69,0xF067,0x2084,0x205B,0x205D,0x6143,0x6573,
	0x7320,0x6E65,0x6973,0x6974,0x6576,0x09F0,0x2820,0x2920,
	0x4620,0x6F72,0x206D,0x7563,0x7372,0x726F,0x09F0,0x5B20,
	0x5D20,0x4820,0x7865,0x6461,0x7365,0x6D69,0x6C61,0x7320,
	0x7274,0x6E69,0xF067,0x2005,0x2028,0x2029,0x6E45,0x6974,
	0x6572,0x7320,0x6F63,0x6570,0x3DF0,0x5320,0x6165,0x6372,
	0x2068,0xDC20,0x04F0,0x4320,0x6E61,0x6563,0x206C,0xDC20,
	0x1CF0,0xF020,0xDF0A,0x03F0,0xF020,0xDF0A,0x18F0,0x2A20,
}; //	272 byte
ROBJ *IDD_Search = (ROBJ *)&Search_RC;
/******** Resource end   Search */

/******** Resource begin Searchmsg  *
	{ 0x041C,   0,   0, {20, 9,39, 4} },
********* Resource data  *******************/
static int Searchmsg_RC[] = {
	0x0175,0x041C,0x0000,0x0914,0x0427,0x27F0,0xF050,0x2A75,
	0x09F0,0x5320,0x6165,0x6372,0x2068,0x6F66,0x2072,0x6874,
	0x2065,0x7473,0x6972,0x676E,0x7EF0,0x5020,
}; //	44 byte
static
ROBJ *IDD_Searchmsg  = (ROBJ *)&Searchmsg_RC;
/******** Resource end   Searchmsg  */

enum	SearchIDD {
	ID_TEXT,
	ID_CASE,
	ID_HEX,
	ID_SEARCH,
	ID_CANCEL,
	ID_CURSOR,
	ID_SCOPE,
	ID_COUNT
};

int continue_search(void)
{
	DOBJ *d;
	long eax;

	if (searchstring[0] == 0)
		return 0;
	if ((d = rsopen(IDD_Searchmsg)) == NULL)
		return 0;
	twshow(d);
	scenter(20, 11, 39, searchstring);
	if (oseekl(STDI.bb, SEEK_SET) == 0) {
		twclose(d);
		return 0;
	}
	if (STDI.flag & IO_SEARCHHEX)
		eax = osearchhex();
	else
		eax = osearchtxt();
	twclose(d);
	if (eax == -1) {
		onotfoundmsg();
		return 0;
	}
	STDI.bb = eax;
	return 1;
}

static int event_text(void)
{
	int result;

	tminascii = 1;
	result = tdteditevent();
	tminascii = ' ';
	return result;
}

int cmdsearch(DWORD fsize)
{
	DOBJ *d;
	TOBJ *o;
	int ax,result;

	if (fsize < 16)
		return 0;
	if ((d = rsopen(IDD_Search)) == NULL)
		return 0;
	o = d->object;
	o[ID_TEXT].count = (128 >> 4);
	o[ID_TEXT].data = searchstring;
	o[ID_TEXT].proc = event_text;
	if (STDI.flag & IO_SEARCHCASE)
		o[ID_CASE].flag |= _O_FLAGB;
	if (STDI.flag & IO_SEARCHHEX)
		o[ID_HEX].flag |= _O_FLAGB;
	if (STDI.flag & IO_SEARCHCUR)
		o[ID_CURSOR].flag |= _O_RADIO;
	else
		o[ID_SCOPE].flag |= _O_RADIO;
	tdinit(d);
	if (rsevent(IDD_Search, d) == 0 || searchstring[0] == 0) {
		twclose(d);
		return 0;
	}
	STDI.flag &= ~IO_SEARCHMASK;
	if (o[ID_CASE].flag & _O_FLAGB)
		STDI.flag |= IO_SEARCHCASE;
	if (o[ID_HEX].flag & _O_FLAGB)
		STDI.flag |= IO_SEARCHHEX;
	if (o[ID_SCOPE].flag & _O_RADIO)
		STDI.flag |= IO_SEARCHSET;
	else
		STDI.flag |= IO_SEARCHCUR;
	ax = (STDI.flag & (IO_SEARCHCUR | IO_SEARCHSET));
	twclose(d);
	result = continue_search();
	STDI.flag |= ax;
	return result;
}
