; OSEARCHT.ASM--
; Copyright (c) 1999 Hjort Nidudsson
;
; Change history:
; 21 Aug 2008	- added IOST.H
; 25 Des 1999	- created

include		clib.inc
include		iost.inc

EXTRN		searchstring: BYTE:[128]

_TEXT		SEGMENT

SEEKSTART:      mov	eax,[si.ios_bb]
		mov	dx,[si.ios_flag]
		and	[si.ios_flag],(not (IO_SEARCHSET or IO_SEARCHCUR))
		test	dx,IO_SEARCHSET
		jz	SHORT @@seekcur
		xor	eax,eax
@@seek:         mov     coff,eax
		push	eax
		push	SEEK_SET
		call	oseek
		ret
@@seekcur:	test	dx,IO_SEARCHCUR
		jnz	SHORT @@seek
		inc	eax
		jmp	SHORT @@seek

iosback:	cmp	bx,[si.ios_i]
		jbe	SHORT @@sub
		push	di
		mov	di,bx
@@ungetc:	call	oungetc
		dec	coff
		dec	di
		jnz	SHORT @@ungetc
		pop	di
		ret
@@sub:          movzx	eax,bx
		sub	coff,eax
		sub	[si.ios_i],ax
		ret

iosscan:	push	di
		mov	di,ax
@@loop:		call	ogetc
		jz	SHORT @@toend
		inc	coff
		mov	dx,di
		cmp	al,dl
		jz	SHORT @@found
		cmp	al,dh
		jnz	SHORT @@loop
@@found:	or	ah,1
@@toend:	pop	di
		ret

setcase:	mov	ah,al
		test	[si.ios_flag],IO_SEARCHCASE
		jnz	SHORT @@toend
		cmp	al,'Z'
		ja	SHORT @@toupper
		cmp	al,'A'
		jb	SHORT @@toupper
		add	al,('a' - 'A')
@@toupper:	cmp	ah,'z'
		ja	SHORT @@toend
		cmp	ah,'a'
		jb	SHORT @@toend
		sub	ah,('a' - 'A')
@@toend:	ret

gethexb:	mov	al,[si]
		or	al,al
		jz	SHORT @@toend
		inc	si
		cmp	al,'0'
		jb	SHORT gethexb
		cmp	al,'9'
		jbe	SHORT @@set
		or	al,20h
		cmp	al,'f'
		ja	SHORT gethexb
		sub	al,27h
@@set:		sub	al,'0'
		or	si,si
@@toend:	ret

gethexw:	call	gethexb
		jz	SHORT @@toend
		mov	ah,al
		call	gethexb
		jnz	SHORT @@set
		xchg	al,ah
@@set:		shl	ah,4
		or	al,ah
		inc	di
@@toend:	ret

_TEXT		ENDS

PPROC		osearchhex
LOCAL		coff:	DWORD
		USES	si,di
		mov	si,OSTDI
		call	SEEKSTART
		jz	SHORT @@notfound
@@loop:		xor	di,di
		mov	si,OFFSET searchstring
@@strloop:      call	gethexw
		jz	SHORT @@found
		push	ax
		call	ogetc
		pop	dx
		mov	ah,dl
		jz	SHORT @@notfound
		inc	coff
		cmp	al,ah
		je      SHORT @@strloop
		jmp	SHORT @@loop
@@found:        or	di,di
		jz	SHORT @@notfound
		movzx	eax,di
		sub	coff,eax
		mov	eax,coff
		mov	dx,WORD PTR [coff+2]
		or	di,1
@@toend:	ret
@@notfound:	xor	ax,ax
		mov	ax,-1
		cwd
		jmp	SHORT @@toend
PEND		osearchhex

PPROC		osearchtxt
LOCAL		coff:	DWORD
		USES	si,di
		mov	si,OSTDI
		call	SEEKSTART
		jz	SHORT @@notfound
@@loop:		mov	al,searchstring
		call	setcase
@@scan:		call	iosscan
		jz	SHORT @@notfound
		mov	di,OFFSET searchstring
@@getc:		call	ogetc
		jz	SHORT @@notfound
		inc	coff
		inc	di
		mov	dl,al
		mov	al,[di]
		or	al,al
		jz	SHORT @@found
		call	setcase
		cmp	ah,dl		; cmp upcase
		je	SHORT @@getc
		cmp	al,dl           ; cmp lowcase
		je	SHORT @@getc
		mov	bx,di
		sub	bx,OFFSET searchstring
		call	iosback
		jmp	SHORT @@loop
@@notfound:	xor	ax,ax
		mov	ax,-1
		cwd
		jmp	SHORT @@toend
@@found:	movzx	eax,di
		sub	ax,OFFSET searchstring
		inc	ax
		sub	coff,eax
		mov	eax,coff
		mov	dx,WORD PTR [coff+2]
		or	di,1
@@toend:	ret
PEND		osearchtxt

		END
