/*
 * FPRINTF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <stdio.h>
#include <stdarg.h>

int fprintf(FILE *o, const char *format, ...)
{
	int b, val;
	va_list(arglist);

	_ASSERTE(o == NULL);
	_ASSERTE(format == NULL);
	va_start(arglist, format);
	b = _stbuf(o);
	val = _output(o, format, arglist);
	_ftbuf(b, o);
	return val;
}
