/*
 * FSEEK.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>
#include <errno.h>

int fseek(FILE *o, long offset, int whence)
{
	if (!inuse(o) || whence < SEEK_SET || whence > SEEK_END) {
		errno = EINVAL;
		return (-1);
	}
	o->flag &= ~_IOEOF;
	if (whence == SEEK_CUR) {
		offset += ftell(o);
		whence = SEEK_SET;
	}
	_flush(o);
	if (o->flag & _IORW)
		o->flag &= ~(_IOWRT | _IOREAD);
	else if ((o->flag & _IOREAD) && (o->flag & _IOMYBUF) &&
		!(o->flag & _IOSETVBUF))
		o->bufsize = _MINIOBUF;
	return (lseek(_fileno(o), offset, whence) == -1L ? -1 : 0);
}