/* MODAL.C--
 * Copyright (c) 2000 Hjort Nidudsson
 *
 * Change history:
 * 10 Jan 2009	- added Ctrl-I: Directory Information
 * 11 Des 2008	- added Ctrl-S: File Search
 * 29 Nov 2008	- Quick Search --> start from current position
 * 11 Nov 2008	- added Shift-F10: Last menu item used
 * 19 Oct 2001	- added Shift-F2:  Dublicate file
 * 16 Des 2000	- Created
 */

#include <string.h>
#include <dzmain.h>

int menus_getevent(void);
static int cmuserscreen(void);
static int event_mouse(void);
static int global_event(int);
static int event_ctrlevent(void);
static int panel_scrollup(panel *);
static int panel_scrolldn(panel *);
#ifdef DEBUG
static int debug_info(void);
#endif
int cmlastmenu(void);
int cmcalendar(void);
int cmsubinfo(void);

GCMD 	global_key[] = {
	{ F1, 	 cmhelp		},
	{ F2, 	 cmrename	},
	{ F3, 	 cmview		},
	{ F4, 	 cmedit		},
	{ F5, 	 cmcopy		},
	{ F6, 	 cmmove		},
	{ F7, 	 cmmkdir	},
	{ F8, 	 cmdelete	},
	{ F9, 	 cmblkprop	},
	{ F10, 	 cmexit  	},
	{ F11, 	 cmtogglesz 	},
	{ F12, 	 cmtogglehz 	},
	{ SHIFTF2, cmcopycell	},
	{ SHIFTF3, cmview	},
	{ SHIFTF4, cmedit	},
	{ SHIFTF9, cmsavesetup	},
	{ SHIFTF10, cmlastmenu	},

	{ ALT0,  cmtool0	},
	{ ALT1,  cmtool1	},
	{ ALT2,  cmtool2	},
	{ ALT3,  cmtool3	},
	{ ALT4,  cmtool4	},
	{ ALT5,  cmtool5	},
	{ ALT6,  cmtool6	},
	{ ALT7,  cmtool7	},
	{ ALT8,  cmtool8	},
	{ ALT9,  cmtool9	},

	{ ALTF1, cmachdrv	},
	{ ALTF2, cmbchdrv	},
	{ ALTF3, cmview		},
	{ ALTF4, cmedit		},
	{ ALTF5, cmcompress	},
	{ ALTF6, cmdecompress	},
	{ ALTF7, cmsearch	},
	{ ALTF8, cmhistory	},
	{ ALTF9, cmegaline	},

	{ ALTX,	 cmquit		},
#ifdef DEBUG
	{ ALTF10, debug_info	},
#endif
	{ CTRL0,  cmpath0	},
	{ CTRL1,  cmpath1	},
	{ CTRL2,  cmpath2	},
	{ CTRL3,  cmpath3	},
	{ CTRL4,  cmpath4	},
	{ CTRL5,  cmpath5	},
	{ CTRL6,  cmpath6	},
	{ CTRL7,  cmpath7	},
	{ CTRL8,  cmpath8	},
	{ CTRL9,  cmpath9	},

	{ CTRLF1, cmatoggle	},
	{ CTRLF2, cmbtoggle	},
	{ CTRLF3, cmview	},
	{ CTRLF4, cmedit	},

	{ CTRLF5, cmcname	},
	{ CTRLF6, cmctype	},
	{ CTRLF7, cmcdate	},
	{ CTRLF8, cmcsize	},
	{ CTRLF9, cmoptions	},

	{ CTRLN, cmcname	},
	{ CTRLE, cmctype	},
	{ CTRLD, cmcdate	},
	{ CTRLZ, cmcsize	},
	{ CTRLU, cmcnosort	},

	{ CTRLO, cmtoggleon	},
	{ CTRLL, cmclong	},
	{ CTRLT, cmcdetail	},
	{ CTRLH, cmchidden	},
	{ CTRLM, cmcmini	},
	{ CTRLR, cmcupdate	},
	{ CTRLC, cmcompare	},
	{ CTRLW, cmswap		},
	{ CTRLF, cmconfirm	},
	{ CTRLA, cmscreen	},
	{ CTRLP, cmpanel	},
#ifdef _DOSBMP_
	{ CTRLX, dosbmp	},
#endif
	{ CTRLUP, cmdoskey_up	},
	{ CTRLDN, cmdoskey_dn	},
	{ CTRLPGUP, cmupdir	},
	{ CTRLPGDN, cmsubdir	},
	{ CTRLENTER, cmctrlenter },

	{ CTRLB, cmuserscreen	},
	{ CTRLV, cmvolinfo	},
	{ CTRLG, cmcalendar	},

	{ KPPLUS, cmselect	},
	{ KPMIN,  cmdeselect	},
	{ KPSTAR, cminvert	},

	{ ESC,   cmclrcmdl	},
	{ CTRLS, cmsearch  	},
	{ CTRLI, cmsubinfo	},
	{ 0,     NULL		}
};

#define COUNT_STLCMD	9
#define COUNT_CTRLSTL	8

MOBJ mobj_statusline[] = {
	{ 0x0008, F1, { 1,24, 7, 1}, 0, cmhelp	},
	{ 0x0008, F2, {10,24, 6, 1}, 0, cmrename},
	{ 0x0008, F3, {18,24, 7, 1}, 0, cmview	},
	{ 0x0008, F4, {27,24, 7, 1}, 0, cmedit	},
	{ 0x0008, F5, {36,24, 7, 1}, 0, cmcopy	},
	{ 0x0008, F6, {45,24, 8, 1}, 0, cmmove	},
	{ 0x0008, F7, {54,24, 6, 1}, 0, cmmkdir	},
	{ 0x0008, F8, {64,24, 6, 1}, 0, cmdelete},
	{ 0x0008, ESC, {72,24, 8, 1}, 0, cmexit	},
};

MOBJ mobj_stlctrl[] = {
	{ 0, CTRLF1, { 1,24, 7, 1}, 0, cmatoggle },
	{ 0, CTRLF2, {12,24, 6, 1}, 0, cmbtoggle },
	{ 0, CTRLF3, {23,24, 7, 1}, 0, cmview	},
	{ 0, CTRLF4, {32,24, 7, 1}, 0, cmedit	},
	{ 0, CTRLF5, {41,24, 7, 1}, 0, cmcname	},
	{ 0, CTRLF6, {50,24, 7, 1}, 0, cmctype	},
	{ 0, CTRLF7, {58,24, 7, 1}, 0, cmcdate	},
	{ 0, CTRLF8, {68,24, 7, 1}, 0, cmcsize	},
};

#ifdef DEBUG
#include <alloc.h>
int debug_info(void)
{
	stdmsg("configfile", "configfile = %s", configfile);
	return 0;
}
#endif

int global_event(int event)
{
	int q = 0;

	do {
		if (event == global_key[q].key) {
			global_key[q].proc();
			return 1;
		}
	} while (global_key[++q].key);

	return 0;
}

int cmuserscreen(void) /* User screen Ctrl-B */
{
	DOBJ 	d;
	COBJ	c;
	extern 	void *api_oldscreen;

	getcursor(&c);
	cursoroff();
	d.flag = 0;
	d.rc.x = 0;
	d.rc.y = 0;
	d.rc.col = 80;
	d.rc.row = 25;
	d.wp = api_oldscreen;
	twshow(&d);
	while (getkey() == 0);
	twhide(&d);
	setcursor(c);
	return 0;
}

/* Quick Search */

#define CTRLALTBKSP	0x0E00
extern BYTE key_scancode[];

static int psearch(const char *string, int len)
{
	int q;
	FBLK **fcb;

	fcb = cpanel->ide->fcb;
	for (q = cpanel->fcb_index + cpanel->cel_index;
		q < cpanel->fcb_count; q++) {
		if (strnicmp(string, fcb[q]->name, len) == 0) {
			pcell_hide(cpanel);
			panel_setid(cpanel, q);
			panel_putitem(cpanel, 0);
			pcell_show(cpanel);
			return 1;
		}
	}
	for (q = 0; q < cpanel->fcb_index; q++) {
		if (strnicmp(string, fcb[q]->name, len) == 0) {
			pcell_hide(cpanel);
			panel_setid(cpanel, q);
			panel_putitem(cpanel, 0);
			pcell_show(cpanel);
			return 1;
		}
	}
	return 0;
}

static int scantoascii(WORD key)
{
	int x;

	key >>= 8;
	for (x = 0; key_scancode[x]; x++) {
		if ((BYTE)key == key_scancode[x])
			return 'a' + x;
	}
	if ((BYTE)key >= 0x78 && (BYTE)key <= 0x80)
		return '9' - (0x80 - (BYTE)key);
	if ((BYTE)key == 0x81)
		return '0';
	if ((BYTE)key == 0x34)
		return '.';
	if ((BYTE)key == 0x35)
		return '_'; /* || '-' */
	return 0;
}

static int event_quicksearch(void)
{
	int  ch,x,y;
	WCHR stl[80];
	COBJ cursor;
	char string[80];

	if (panel_state(cpanel) == 0)
		return 0;
	getcursor(&cursor);
	wcpushst(stl, cp_stlctrlalt);
	x = 15;
	y = *__egaline;
	while (shift->Ctrl && shift->Alt) {
		tupdate();
		gotoxy(x, y);
		if ((ch = getkey()) == 0)
			continue;
		if (ch == CTRLALTBKSP && x > 15) {
			x--;
			scputc(x, y, 0, 2, ' ');
			continue;
		}
		if ((ch = scantoascii(ch)) == 0)
			continue;
		string[x - 15] = ch;
		if (psearch(string, x - 14)) {
			scputc(x, y, 0, 1, ch);
			if (x < 78)
				x++;
		}
	}
	wcpopst(stl);
	setcursor(cursor);
	while (shift->Ctrl || shift->Alt);
	return 0;
}

int event_ctrlevent(void)
{
	int q,x,y,event;
	WCHR stl[80];

	if (shift->Alt)
		return event_quicksearch();
	wcpushst(stl, cp_stlctrl);
	while (shift->Ctrl && !shift->Alt) {
		tupdate();
		if ((event = getkey()) != 0)
			break;
		if (mousep()) {
			x = mousex();
			y = mousey();
			event = MOUSECMD;
			for (q = 0; q < COUNT_CTRLSTL; q++) {
				if (rcxyrow(mobj_stlctrl[q].rc, x, y)) {
					mobj_stlctrl[q].proc();
				}
			}
			while (mousep());
			break;
		}
	}
	wcpopst(stl);
	return event;
}

int panel_scrollup(panel *p)
{
	if (cpanel == p) {
		do {
			if (p->cel_index) {
				p->cel_index = 0;
				pcell_update(p);
				scroll_delay();
			} else {
				panel_hndevent(p, UP);
			}
			scroll_delay();
		} while (mousep() == 1);
		return 1;
	}
	panel_setactive(p);
	return 0;
}

int panel_scrolldn(panel *p)
{
	if (cpanel == p) {
		do {
			if (p->cel_index < p->cel_count - 1) {
				p->cel_index = p->cel_count - 1;
				pcell_update(p);
				scroll_delay();
			} else {
				panel_hndevent(p, DOWN);
			}
			scroll_delay();
		} while (mousep() == 1);
		return 1;
	}
	panel_setactive(p);
	return 0;
}

int panel_toggleinfo(panel *p)
{
	*p->flag ^= _W_DRVINFO;
	if (*p->flag & _W_DRVINFO)
		*p->flag |= _W_MINISTATUS;
	return panel_update_rect(p);
}

int event_mouse(void)
{
	int q,x,y;

	if (mousep() == 0)
		return 0;
	x = mousex();
	y = mousey();
	if (y == 0 && x > 70)
		return cmcalendar();
	if (y == *__egaline) {
		while (mousep());
		for (q = 0; q < COUNT_STLCMD; q++) {
			if (rcxyrow(mobj_statusline[q].rc, x, mobj_statusline[q].rc.y))
				return mobj_statusline[q].proc();
		}
		return 0;
	}
	switch (panel_xycmd(&panela, x, y)) {
		case PN_XYCONFIG:     cmafilter(); 		break;
		case PN_XYNEWDISK:    cmachdrv(); 		break;
		case PN_XYMOVEUP:     panel_scrollup(&panela);	break;
		case PN_XYMOVEDOWN:   panel_scrolldn(&panela);	break;
		case PN_XYMINISTATUS: panel_togglemini(&panela); break;
		case PN_XYDRVINFO:    panel_toggleinfo(&panela); break;
		case PN_XYFILE:
		case PN_XYINSIDE:
			panel_setactive(&panela);
			pcell_setxy(&panela, x, y);
		default: break;
	}
	switch (panel_xycmd(&panelb, x, y)) {
		case PN_XYCONFIG:     cmbfilter(); 		break;
		case PN_XYNEWDISK:    cmbchdrv();		break;
		case PN_XYMOVEUP:     panel_scrollup(&panelb);	break;
		case PN_XYMOVEDOWN:   panel_scrolldn(&panelb);	break;
		case PN_XYMINISTATUS: panel_togglemini(&panelb); break;
		case PN_XYDRVINFO:    panel_toggleinfo(&panelb); break;
		case PN_XYFILE:
		case PN_XYINSIDE:
			panel_setactive(&panelb);
			pcell_setxy(&panelb, x, y);
		default: break;
	}
	while (mousep() == 1);
	return 0;
}

void dzmain(void)
{
	int event;
#ifdef _DOSBMP_
	thelp = dosbmp;
	scputs(63, 0, 0, 0, "12.05.07 01:28:00");
#endif
	while (shift->Alt)
		;
	while (_end == 0) {
		tupdate();
		if (shift->Ctrl)
			event = event_ctrlevent();
		else
			event = menus_getevent();
		if ((event == ENTER || (WORD)event == KPENTER) && *com.base) {
			if (doskey_save()) {
				if (ex_command(com.base) == 0)
					com_hndevent(END);
			} else {
				com_hndevent(END);
			}
			continue;
		}
		if (*com.base && com_hndevent(event)) {
			continue;
		} else if (panel_state(cpanel) == 0) {
			if (event == KPPLUS || event == KPMIN || event == KPSTAR) {
				if (com_hndevent(event))
					continue;
			}
		}
		if (panel_state(cpanel) && panel_hndevent(cpanel, event))
			continue;
		if (_end)
			break;
		if (event == MOUSECMD) {
			event_mouse();
		} else if (event == TAB) {
			if (panel_state(&panela) && panel_state(&panelb)) {
				if (cpanel == &panela)
					panel_setactive(&panelb);
				else
					panel_setactive(&panela);
			}
		} else if (global_event(event) == 0) {
			com_hndevent(event);
		}
		while (mousep());
	}
}