include	clib.inc
include	dos.inc
include	malloc.inc

; Single linked list
MEM_SIZE EQU	0	; WORD paragraphs allocated
MEM_USED EQU	2	; BYTE block is used (1|0)
MEM_SIGN EQU	3	; BYTE block signature (debug)

_TEXT	SEGMENT

	public	memseg

memseg	DW	0	; segment of memory == base || 0000h
mavail	DW	0	; first available block

CREATEHEAP PROC
	MOV	BX,seg_heaptop
	MOV	DX,seg_heapbase
	SUB	BX,DX
	DEC	BX		; Size of heap
	SUB	DX,_psp		; Size of program
	CMP	BX,MINHEAPSIZE+HEAPMARGIN
	JB	CREATEH_01
	SUB	BX,HEAPMARGIN	; leave a margin at top
	CMP	BX,MAXHEAPSIZE
	JB	CREATEH_00
	MOV	BX,MAXHEAPSIZE
CREATEH_00:
	PUSH	BX
	ADD	BX,DX
	MOV	ES,_psp		; segment of block to resize
	MOV	AH,4AH		; RESIZE MEMORY BLOCK
	INT	21H
	POP	DX
	JC	CREATEH_01	; CF clear if successful
	MOV	AX,seg_heapbase
	MOV	CS:[memseg],AX	; Init first block to [memseg]
	MOV	CS:[mavail],AX
	MOV	BX,AX
	ADD	AX,DX
	MOV	seg_brklvl,AX
	XOR	AX,AX
	MOV	ES,BX
	MOV	CX,DX
	DEC	CX
	MOV	ES:[0],CX	; max size
	MOV	ES:[2],AX	; unused
	ADD	CX,BX
	MOV     ES,CX		; last 16 byte block
	MOV	ES:[0],AX	; 0
	INC	AX
	MOV	ES:[2],AX	; used
	RET
CREATEH_01:
	XOR	AX,AX
	RET
CREATEHEAP ENDP

IF USE_EXTENDHEAP

EXTENDHEAP PROC
	PUSH	DS
	PUSH	CS:DGROUP@
	POP	DS
	XOR	AX,AX
	MOV	BX,seg_heaptop
	CMP	BX,seg_brklvl
	JE	EXTENDHEAP_01
	MOV	AX,_psp
	SUB	BX,AX
	MOV	ES,AX
	MOV	AH,4AH		; RESIZE MEMORY BLOCK
	INT	21H
	JNC	EXTENDHEAP_00	; CF clear if successful
	XOR	AX,AX
	JMP	EXTENDHEAP_01
EXTENDHEAP_00:
	XOR	AX,AX
	MOV	BX,seg_heaptop
	MOV	DX,seg_brklvl
	MOV	seg_brklvl,BX
	DEC	BX
	DEC	DX
	MOV	ES,BX
	MOV	ES:[0],AX	; last block to zero
	INC	AX
	MOV	ES:[2],AX	; and not free..
	DEC	AX
	MOV	ES,DX
	SUB	BX,DX
	MOV	CX,seg_brklvl
	MOV	AX,ES:[0]
	MOV	CX,ES:[2]
	MOV	ES:[0],BX	; size of first free
	MOV	ES:[2],AX	; prev last to free
	MOV	CS:[mavail],DX	; first free block
	INC	AX
EXTENDHEAP_01:
	POP	DS
	RET
EXTENDHEAP ENDP

ENDIF

FINDFIRSTFREE PROC
	PUSH	SI
	PUSH	DI		; first free block
	XOR	AX,AX
	MOV	DI,AX
	MOV	DX,CS:[memseg]
	OR	DX,DX
	JZ	DEFRAG_06	; no heap
DEFRAG_00:
	MOV	ES,DX
	MOV	CX,ES:[0]
	OR	CX,CX
	JZ	DEFRAG_06	; end of heap
	CMP	ES:[2],AL
	JE	DEFRAG_01	; found one..
	ADD	DX,CX
	JMP	DEFRAG_00	; next block
DEFRAG_01:
	OR	DI,DI
	JNZ	DEFRAG_02
	MOV	DI,DX		; save first free block
DEFRAG_02:
	MOV	SI,CX
	MOV	CX,AX
	PUSH	DX
DEFRAG_03:
	OR	SI,SI
	JZ	DEFRAG_05
	ADD	CX,SI		; add size of this block
	ADD	DX,SI		; move to next block
	MOV	ES,DX
	CMP	AL,ES:[2]	; free ?
	JNE	DEFRAG_04
	MOV	SI,ES:[0]	; yes, add size
	MOV	ES:[0],AX	; clear adress
	JMP	DEFRAG_03	; next block
DEFRAG_04:
	POP	DX		; restore segment
	MOV	ES,DX
	MOV	ES:[0],CX	; update size
	ADD	DX,CX		; next block
	JMP	DEFRAG_00
DEFRAG_05:
	POP	DX
DEFRAG_06:
	MOV	AX,DI
	POP	DI
	POP	SI
	OR	AX,AX
	MOV	CS:[mavail],AX
	RET
FINDFIRSTFREE ENDP

FINDFREEBLOCK PROC
	CALL	FINDFIRSTFREE
	JZ	FINDF_03
	MOV	DX,AX
	XOR	AX,AX
FINDF_00:
	MOV	ES,DX
	MOV	CX,ES:[0]	; get size in para
	OR	CX,CX		; last block ?
	JZ	FINDF_03
	CMP	ES:[2],AL
	JE	FINDF_01
	ADD	DX,CX
	JMP	FINDF_00
FINDF_01:
	CMP	BX,CX
	JBE	FINDF_02
	ADD	DX,CX
	JMP	FINDF_00
FINDF_02:
	MOV	AX,DX
FINDF_03:
	OR	AX,AX
	RET
FINDFREEBLOCK ENDP

_TEXT	ENDS

PPROC	malloc, MSIZE:WORD
	MOV	BX,MSIZE
	MOV	CX,4
	ADD	BX,CX
	JC	ALLOC_07
	MOV	DL,BL
	SHR	BX,CL
	AND	DL,15
	JZ	ALLOC_00
	INC	BX
ALLOC_00:
	OR	BX,BX
	JZ	ALLOC_07
	XOR	DX,DX
	CMP	CS:[memseg],DX
	JE	ALLOC_06
	MOV	AX,CS:[mavail]
	CMP	AX,DX
	JE	ALLOC_07
	MOV	ES,AX
	MOV	CX,ES:[0]
	CMP	BX,CX
	JA	ALLOC_01
	CMP	ES:[2],DL
	JE	ALLOC_02
ALLOC_01:
	CALL	FINDFREEBLOCK
IF USE_EXTENDHEAP
	JZ	ALLOC_08
ELSE
	JZ	ALLOC_07
ENDIF
ALLOC_02:
	PUSH	AX
	MOV	DX,AX
	MOV	AX,4
	PUSH	AX
	MOV	ES:[0],BX	; set new size
	MOV	BYTE PTR ES:[2],1
	CMP	BX,CX
	JE	ALLOC_03	; same size ?
	SUB	CX,BX
	ADD	BX,DX		; link to list
	MOV	ES,BX		; *this->next
	MOV	ES:[0],CX
	MOV	BYTE PTR ES:[2],0
	MOV	CS:[mavail],BX	; first free block
	JMP	ALLOC_04
ALLOC_03:
	CMP	CS:[mavail],DX
	JNE	ALLOC_04
	MOV	AX,CS:[memseg]
	MOV	CS:[mavail],AX
ALLOC_04:
	POP	AX
	POP	DX
	OR	AX,AX
ALLOC_05:
	RET
ALLOC_07:
	XOR	AX,AX
	MOV	DX,AX
	JMP	ALLOC_05
ALLOC_06:
	PUSH	BX
	CALL	CREATEHEAP	; Need DS!!
	POP	BX
	JZ	ALLOC_07
	JMP	ALLOC_01
IF USE_EXTENDHEAP
ALLOC_08:
	PUSH	BX
	CALL	EXTENDHEAP
	MOV	CX,BX
	POP	BX
	JZ	ALLOC_07
	CMP	BX,CX
	JA	ALLOC_07
	MOV	AX,DX
	JMP	ALLOC_02
ENDIF
PEND	malloc

PPROC	free,	S:WORD, O:WORD
	XOR	AX,AX
	MOV	DX,[S]
	OR	DX,DX
	JZ	FREE_02
	CMP	DX,CS:[memseg]
	JB	FREE_02
	MOV	CS:[mavail],DX
	MOV	ES,DX
	MOV	BX,ES:[0]
	MOV	ES:[2],AX
	MOV	CX,AX
FREE_00:
	OR	BX,BX
	JZ	FREE_01
	ADD	CX,BX		; Add up unused block's
	ADD	DX,BX
	MOV	ES,DX
	CMP	AL,ES:[2]
	JNE	FREE_01
	MOV	BX,ES:[0]
	MOV	ES:[0],AX	; Size to zero..
	JMP	FREE_00
FREE_01:
	MOV	DX,[S]
	MOV	ES,DX
	MOV	ES:[0],CX
	INC	AX
FREE_02:
	OR	AX,AX
	RET
PEND	free

	END
