include	clib.inc
include	time.inc
include	dialog.inc

STARTDAY  	= 5
STARTYEAR       = 0
MAXYEAR 	= 3000

_TEXT	SEGMENT

CAL_DAYSFEB PROC
	PUSH	DX
	PUSH	BX
	OR	CX,CX
	JZ	DAYSFEB_02
	MOV	AX,CX
	AND	AL,3
	JNZ	DAYSFEB_00
	MOV	AX,CX
	MOV	BX,100
	XOR	DX,DX
	DIV	BX
	OR	DX,DX
	JNZ	DAYSFEB_02
DAYSFEB_00:
	MOV	BX,400
	MOV	AX,CX
	XOR	DX,DX
	DIV	BX
	OR	DX,DX
	JZ	DAYSFEB_02
	MOV	AX,28
DAYSFEB_01:
	POP	BX
	POP	DX
	RET
DAYSFEB_02:
	MOV	AX,29
	JMP	DAYSFEB_01
CAL_DAYSFEB ENDP

CAL_DAYSMND PROC
	CMP	BX,2
	JE	CAL_DAYSFEB
	MOV	AH,0
	MOV	AL,mnd_table[BX-1]
	RET
CAL_DAYSMND ENDP

CAL_WEEKDAYJAN1	PROC
	PUSH	BP
	PUSH	SI
	PUSH	DI
	XOR	BP,BP
	MOV	SI,STARTDAY
	MOV	DI,CX
	MOV	CX,STARTYEAR
WEEKDJAN_00:
	CMP	CX,DI
	JNB	WEEKDJAN_02
	CALL	CAL_DAYSFEB
	CMP	AX,29
	JNE	WEEKDJAN_01
	ADD	SI,1
	ADC	BP,0
WEEKDJAN_01:
	INC	CX
	ADD	SI,1
	ADC	BP,0
	JMP	WEEKDJAN_00
WEEKDJAN_02:
	PUSH	DX
	MOV	DX,BP
	MOV	AX,SI
	MOV	SI,7
	DIV	SI
	MOV	AX,DX
	POP	DX
	MOV	CX,DI
	POP	DI
	POP	SI
	POP	BP
	RET
CAL_WEEKDAYJAN1	ENDP

CAL_WEEKDAY PROC
	CALL	CAL_WEEKDAYJAN1
	PUSH	SI
	PUSH	DI
	MOV	SI,AX
	MOV	DI,BX
	MOV	BX,1
WEEKD_00:
	CMP	BX,DI
	JNB	WEEKD_01
	CALL	CAL_DAYSMND
	ADD	SI,AX
	INC	BX
	JMP	WEEKD_00
WEEKD_01:
	PUSH	DX
	MOV	DI,7
	XOR	DX,DX
	MOV	AX,SI
	DIV	DI
	MOV	AX,DX
	POP	DX
	POP	DI
	POP	SI
	RET
CAL_WEEKDAY ENDP

CAL_CURDATE PROC	; GET SYSTEM DATE
	MOV	AH,2Ah	; CX = year (1980-2099)
	INT	21h	; DH = month
	XOR	AH,AH	; DL = day
	MOV	AL,DL
	MOV	[BP-22],AX
	MOV	AL,DH
	MOV	[BP-20],AX
	MOV	[BP-18],CX
	MOV	DX,[BP-22]
	MOV	BX,AX
	CALL	CAL_WEEKDAY
	MOV	[BP-16],AX
	CALL	CAL_DAYSMND
	MOV	[BP-14],AX
	RET
CAL_CURDATE ENDP

CAL_INCYEAR PROC
	MOV	CX,[BP-18]
	CMP	CX,MAXYEAR
	JE	INCYEAR_00
	INC	CX
	JMP	INCYEAR_01
INCYEAR_00:
	MOV	CX,STARTYEAR
INCYEAR_01:
	RET
CAL_INCYEAR ENDP

CAL_DECYEAR PROC
	MOV	CX,[BP-18]
	OR	CX,CX
	JZ	DECYEAR_00
	DEC	CX
	RET
DECYEAR_00:
	MOV	CX,MAXYEAR
	RET
CAL_DECYEAR ENDP

CAL_PUTMND PROC
	MOV	BX,[BP-24]
	ADD	BX,0A03h
	MOV	CX,14
	MOV	AX,0720h
	CALL	@scputw
	PUSH	WORD PTR [BP-18]
	PUSH	DS
	MOV	AX,BX
	MOV	BX,[BP-20]
	DEC	BX
	ADD	BX,BX
	PUSH    [BX+cp_month]
	MOV	BX,AX
	MOV	AX,OFFSET format_s_d
	CALL	@scputf
	ADD	SP,6
	RET
CAL_PUTMND ENDP

CAL_PUT2D PROC
	INC	SI
	PUSH	CX
	PUSH	DI
	PUSH	SI
	MOV	BX,CX
	MOV	CL,02h
	MOV	CH,at_background[7]
	CMP	SI,[BP-22]
	JNE	PUT2D_00
	OR	CH,at_foreground[0Fh]
	JMP	PUT2D_01
PUT2D_00:
	OR	CH,at_foreground[0]
PUT2D_01:
	MOV	AL,[BX+cal_keypos]
	MOV	BX,DI
	MOV	BL,AL
	ADD	BX,[BP-24]
	MOV	AX,OFFSET format_2d
	CALL	@scputf
	ADD	SP,2
	MOV	DI,BX
	CALL	getday
	XOR	AH,AH
	CMP	AX,SI
	JNE	PUT2D_02
	CALL	getmnd
	XOR	AH,AH
	CMP	AX,[BP-20]
	JNE	PUT2D_02
	CALL	getyear
	CMP	AX,[BP-18]
	JNE	PUT2D_02
	MOV	BX,DI
	MOV	CX,2
	MOV	AL,04h
	OR	AL,at_background[7]
	CALL	@scputa
PUT2D_02:
	POP	DI
	POP	CX
	RET
CAL_PUT2D ENDP

CAL_PUTDATA PROC
	PUSH	SI
	PUSH	DI
	MOV	AX,[BP-18]	; year
	MOV	DX,[BP-20]	; month
	CMP	AX,[BP-12]	; current_year
	JNE	CPUTD_00
	CMP	DX,[BP-10]	; current_month
	JE	CPUTD_02
CPUTD_00:
	MOV	[BP-10],DX
	MOV	[BP-12],AX
	CALL	CAL_PUTMND
	MOV	BX,[BP-24]
	ADD	BH,3
	MOV	CX,29
CPUTD_01:
	MOV	AL,20h
	MOV	AH,at_background[7]
	OR	AH,at_foreground[0]
	CALL	@scputw
	INC	BH
	MOV	AL,[BP-23]
	ADD	AL,3+6
	CMP	BH,AL
	JB	CPUTD_01
CPUTD_02:
	XOR	SI,SI
	MOV	DI,0300h
CPUTD_03:
	CMP	SI,[BP-14]
	JNB	CPUTD_08
	XOR	CX,CX
CPUTD_04:
	CMP	CX,7
	JNB	CPUTD_07
	CMP	[BP-16],CX
	JA      CPUTD_06
	CMP	DI,0300h
	JNE	CPUTD_06
	CALL	CAL_PUT2D
CPUTD_05:
	INC	CX
	JMP	CPUTD_04
CPUTD_06:
	CMP	DI,0300h
	JNA	CPUTD_05
	CMP	SI,[BP-14]
	jae	CPUTD_05
	CALL	CAL_PUT2D
	JMP	CPUTD_05
CPUTD_07:
	ADD	DI,0100h
	CMP	DI,0A00h
	JB	CPUTD_03
CPUTD_08:
	POP	DI
	POP	SI
	RET
CAL_PUTDATA ENDP

CAL_SETDATE PROC
	MOV	[BP-22],DX
	MOV	[BP-20],BX
	MOV	[BP-18],CX
	CALL	CAL_WEEKDAY
	MOV	[BP-16],AX
	CALL	CAL_DAYSMND
	MOV	[BP-14],AX
	CALL	CAL_PUTDATA
	RET
CAL_SETDATE ENDP

CAL_ENTER PROC
	MOV	AX,1
	MOV	[BP-8],AX
CAL_ENTER ENDP

CAL_ESC	PROC
	INC	BYTE PTR [BP-1]
	RET
CAL_ESC	ENDP

CAL_HOME PROC
	CALL	CAL_CURDATE
	CALL	CAL_PUTDATA
	RET
CAL_HOME ENDP

CAL_NEXTDAY PROC
	MOV	DX,[BP-22]
	INC	DX
	CMP	DX,[BP-14]
	JA	CAL_NEXTMONTH
	MOV	[BP-22],DX
	CALL    CAL_PUTDATA
	RET
CAL_NEXTDAY ENDP

CAL_PREVDAY PROC
	MOV	DX,[BP-22]
	CMP	DX,1
	JE	PREVDAY_00
	MOV	CX,[BP-18]
	MOV	BX,[BP-20]
	DEC	DX
	JMP	CAL_SETDATE
PREVDAY_00:
	CALL	CAL_PREVMONTH
	MOV	AX,[BP-14]
	MOV	[BP-22],AX
	CALL	CAL_PUTDATA
	RET
CAL_PREVDAY ENDP

CAL_UP	PROC
	CMP	WORD PTR [BP-22],7
	JBE	CAL_PREVDAY
	SUB	WORD PTR [BP-22],7
	CALL	CAL_PUTDATA
	RET
CAL_UP	ENDP

CAL_DOWN PROC
	MOV	AX,[BP-22]
	ADD	AX,7
	CMP	AX,[BP-14]
	JA	CAL_NEXTDAY
	MOV	[BP-22],AX
	CALL    CAL_PUTDATA
	RET
CAL_DOWN ENDP

CAL_PREVMONTH PROC
	MOV	DX,1
	MOV	BX,[BP-20]
	MOV	CX,[BP-18]
	CMP	BX,1
	JE	PREVMND_00
	DEC	BX
	JMP	CAL_SETDATE
PREVMND_00:
	MOV	BX,12
	CALL	CAL_DECYEAR
	JMP	CAL_SETDATE
CAL_PREVMONTH ENDP

CAL_NEXTMONTH PROC
	MOV	BX,[BP-20]
	CMP	BX,12
	JE	CAL_NEXTYEAR
	MOV	DX,1
	MOV	CX,[BP-18]
	INC	BX
	JMP	CAL_SETDATE
CAL_NEXTMONTH ENDP

CAL_PREVYEAR PROC
	MOV	DX,1
	MOV	BX,DX
	CALL	CAL_DECYEAR
	JMP	CAL_SETDATE
CAL_PREVYEAR ENDP

CAL_NEXTYEAR PROC
	MOV	DX,1
	MOV	BX,DX
	CALL	CAL_INCYEAR
	JMP	CAL_SETDATE
CAL_NEXTYEAR ENDP

CAL_MOUSE PROC
if USE_MOUSE
	LES	BX,[BP-28]
	PUSH32	ES:[BX.dl_rect]
	CALL	mousex
	PUSH	AX
	CALL	mousey
	PUSH	AX
	CALL	rcxyrow
	OR	AX,AX
	JNZ	MOUSE_00
	JMP	CAL_ESC
MOUSE_00:
	PUSH32	[BP-6]
	CALL	twhide
	PUSH32	[BP-28]
	CALL	twmove
	LES	BX,[BP-28]
	MOV	AX,ES:[BX+4]
	MOV	[BP-24],AX
	ADD	AX,0A03h
	LES	BX,[BP-6]
	MOV	ES:[BX+4],AX
	PUSH32	[BP-6]
	CALL	twshow
else
	XOR	AX,AX
endif
	RET
CAL_MOUSE ENDP

CAL_MODAL PROC
	CMP	BYTE PTR [BP-1],0
	JNE	CMODAL_02
	CALL	tgetevent
	MOV	CX,cal_keycount
	XOR	BX,BX
CMODAL_00:
	CMP	AX,[BX+cal_keylocal]
	JE	CMODAL_01
	ADD	BX,2
	LOOP	CMODAL_00
	JMP	CAL_MODAL
CMODAL_01:
	CALL	WORD PTR [BX+cal_keyproc]
	JMP	CAL_MODAL
CMODAL_02:
	RET
CAL_MODAL ENDP

_TEXT	ENDS

PPROC	cmcalendar
LOCAL	ld[28]:BYTE
	XOR	AX,AX
	MOV     [BP-1],AL
	MOV     [BP-12],AX
	MOV     [BP-10],AX
	MOV	[BP-8],AX
	PUSH	DS
	PUSH	WORD PTR IDD_CALENDAR
	CALL	rsopen
	JZ	CAL_00
	MOV     [BP-28],AX
	MOV     [BP-26],DX
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	MOV	BX,AX
	MOV	AX,ES:[BX+4]
	MOV     [BP-24],AX
	CALL	twshow
	PUSH	DS
	PUSH	WORD PTR IDD_CALENDAR2
	CALL	rsopen
	MOV     [BP-6],AX
	MOV     [BP-4],DX
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	CALL	twshow
	CALL	CAL_CURDATE
	MOV	DX,[BP-22]
	MOV	BX,[BP-20]
	MOV	CX,[BP-18]
	CALL	CAL_SETDATE
if USE_MOUSE
	CALL	msloop
endif
	CALL	CAL_MODAL
	CALL	twclose
	CALL	twclose
	MOV	DX,[BP-22]
	MOV	BX,[BP-20]
	MOV	CX,[BP-18]
CAL_00:
	MOV	AX,[BP-8]
	RET
PEND	cmcalendar

_DATA	SEGMENT

;******** Resource begin CALENDAR *
;	{ 0x005C,   0,   0, {42, 2,29,10} },
;******** Resource data  *******************
CALENDAR_RC LABEL WORD
	DW	00283h	; Alloc size
	DW	0005Ch,00000h,0022Ah,00A1Dh,03AF0h,0F02Eh,02A3Ah,01DF0h
	DW	0F02Eh,02A74h,01DF0h,0F02Eh,0DF1Dh,04D20h,06E6Fh,05420h
	DW	06575h,05720h,06465h,05420h,07568h,04620h,06972h,05320h
	DW	07461h,05320h,06E75h,02020h,01BF0h,0F0C4h,020AFh,01DF0h
	DW	02EDCh
;	68 byte
IDD_CALENDAR DD DGROUP:CALENDAR_RC

;	public	IDD_CALENDAR

;******** Resource end   CALENDAR *

;******** Resource begin CALENDAR2 *
;	{ 0x0010,   0,   0, {45,12,14, 1} },
;******** Resource data  *******************
CALENDAR2_RC LABEL WORD
	DW	0002Ch	; Alloc size
	DW	00010h,00000h,00C2Dh,0010Eh,00EF0h,0F007h,0200Eh,00707h
;	18 byte
IDD_CALENDAR2 DD DGROUP:CALENDAR2_RC

;	public	IDD_CALENDAR2

;******** Resource end   CALENDAR2 *

cp_jan		DB	"January",0
cp_feb		DB	"February",0
cp_mar		DB	"March",0
cp_apr		DB	"April",0
cp_may		DB	"May",0
cp_jun		DB	"June",0
cp_jul		DB	"July",0
cp_aug		DB	"August",0
cp_sep		DB	"September",0
cp_oct		DB	"October",0
cp_nov		DB	"November",0
cp_dec		DB	"December",0

cp_month	DW	OFFSET cp_jan
		DW      OFFSET cp_feb
		DW      OFFSET cp_mar
		DW      OFFSET cp_apr
		DW      OFFSET cp_may
		DW      OFFSET cp_jun
		DW      OFFSET cp_jul
		DW      OFFSET cp_aug
		DW      OFFSET cp_sep
		DW      OFFSET cp_oct
		DW      OFFSET cp_nov
		DW      OFFSET cp_dec

mnd_table	DB	31,28,31,30,31,30,31,31,30,31,30,31
format_s_d	DB	'%s %d',0
format_2d	DB	'%2d',0

cal_keypos	DB	1,5,9,13,17,21,25

cal_keylocal LABEL WORD
	DW	MOUSECMD
	DW	KEY_ESC
	DW	KEY_HOME
	DW	KEY_RIGHT
	DW	KEY_LEFT
	DW	KEY_UP
	DW	KEY_DOWN
	DW	KEY_PGUP
	DW	KEY_PGDN
	DW	KEY_CTRLPGUP
	DW	KEY_CTRLPGDN
	DW	KEY_ENTER

cal_keyproc LABEL WORD
	DW	CAL_MOUSE
	DW	CAL_ESC
	DW	CAL_HOME
	DW	CAL_NEXTDAY
	DW	CAL_PREVDAY
	DW	CAL_UP
	DW	CAL_DOWN
	DW	CAL_PREVMONTH
	DW	CAL_NEXTMONTH
	DW	CAL_PREVYEAR
	DW	CAL_NEXTYEAR
	DW	CAL_ENTER

cal_keycount =	12

_DATA	ENDS

	END
