include doszip.inc
include string.inc
include stdio.inc
include dialog.inc
include dir.inc
include io.inc
include ios.inc
include errno.inc

	.186

	public	opencfg
	public	getinifile
	public	configread
	public	configwrite
	public	doskey_save
	public	dzcmd_delete
	public	history_init
	public	history_save
	public	history_write

	public	cmhistory	; Alt-F8    - Select command
	public	cmpathleft      ; Alt-Left  - Previous Directory
	public	cmpathright	; Alt-Right - Next Directory
	public	cmdoskey_up	; Alt-Up    - Previous Command
	public	cmdoskey_dn	; Alt-Down  - Next Command
	public	cmsavesetup	; Shift-F10

	public	findfilemask

if USE_MEMCONFIG
	extrn	memcfg:DWORD
endif

_DZIP	SEGMENT

DPROC	MKARGV0_CFG
	MOV	AX,WORD PTR extcfg
	MOV	DX,WORD PTR extcfg+2
	JMP	MKARGV0_EXT
DEND	MKARGV0_CFG

DPROC	MKARGV0_CMD
	MOV	AX,WORD PTR extcmd
	MOV	DX,WORD PTR extcmd+2
DEND	MKARGV0_CMD

DPROC	MKARGV0_EXT
	MOV	BX,configextp
	MOV	[BX],AX
	MOV	[BX+2],DX
	MOV	DX,DS
	MOV	AX,OFFSET configfile
	RET
DEND	MKARGV0_EXT

DPROC	DOSKEYTOCOM
	PUSH	DS
	PUSH	OFFSET com_base
	PUSH	DS
	MOV	AH,doskey_bindex
	MOV	AL,00h
	SHR	AX,1
	ADD	AX,OFFSET _bufin
	PUSH	AX
	CALL	strcpy
	RET
DEND	DOSKEYTOCOM

DPROC	SETDZPATH
	PUSH	SI
	PUSH	DI
	MOV	SI,OFFSET history
	XOR	AX,AX
	CMP	AL,[SI]
	JZ	SETP_00
	MOV	DI,cpanel
	MOV	DI,[DI]
	MOV	DX,[DI]
	TEST	DX,_W_ARCHIVE
	JNZ	SETP_00
	MOV	AX,DX
	AND	AX,_W_PANELID OR _W_VISIBLE
	OR	AX,[SI.dzp_flag]
	MOV	[DI],AX
	MOV	AX,[SI.dzp_bufid]
	MOV	DX,[SI.dzp_celid]
	MOV	BX,cpanel
	MOV	[BX.pn_fcb_index],AX
	MOV	[BX.pn_cel_index],DX
	MOV	DX,DS
	MOV	AX,SI
	CALL	cpanel_setpath

	MOV	AX,cpanel
	CALL	panel_redraw

	MOV	AX,1
SETP_00:
	OR	AX,AX
	POP	DI
	POP	SI
	RET
DEND	SETDZPATH

DPROC	DZCMD_WRITE
	MOV	AX,OPENCMD_WRITE
	MOV	DX,1
	JMP	DZCMD_IO
DEND	DZCMD_WRITE

DPROC	DZCMD_READ
	MOV	AX,OPENCMD_READ
	XOR	DX,DX
DEND	DZCMD_READ

DPROC	DZCMD_IO	; int dzcmd_io(int fmode, int (*proc));
	PUSH	DX      ; DX = OSREAD/OSWRITE
	PUSH	AX	; AX = fmode (Read/Write)
	CALL	opencfg
	POP	DX
	CMP	AX,-1
	JE	DZCMDIO_01
	PUSH	AX
	PUSH	AX
	PUSH	DS
	PUSH	OFFSET _bufin
	PUSH	DZCMD_SIZE+256
	OR	DX,DX
	JNZ	DZCMDIO_02
	CALL	osread
	JMP     DZCMDIO_03
DZCMDIO_02:
	CALL	oswrite
DZCMDIO_03:
	POP	DX
	PUSH	AX
	PUSH	DX
	CALL	close
	POP	DX
	XOR	AX,AX
	CMP	DX,DZCMD_SIZE+256
	JNE	DZCMDIO_01
	INC	AX
DZCMDIO_00:
	RET
DZCMDIO_01:
	XOR	AX,AX
	JMP	DZCMDIO_00
DEND	DZCMD_IO

DPROC	getinifile
	MOV	AX,extini
	MOV	DX,extini+2
	CALL	MKARGV0_EXT
	RET
DEND	getinifile

DPROC	opencfg	; flag:WORD
	PUSH	BP
	MOV	BP,SP
	MOV	BX,OFFSET extini
	MOV	AX,[BP+4]
	SHR	AX,10
	ADD	BX,AX
	MOV	AX,[BX]
	MOV	DX,[BX+2]
	CALL	MKARGV0_EXT
	PUSH	DX
	PUSH	AX
	MOV	AX,[BP+4]
	MOV	AL,AH
	AND	AX,000Fh
	PUSH	AX
	MOV	AX,[BP+4]
	XOR	AH,AH
	XOR	DX,DX
	CMP	AX,1
	JZ	OA0_00
	INC	DX
OA0_00:	PUSH	DX
	PUSH	AX
	CALL	osopen
	MOV	CX,AX
	MOV	AX,extini
	MOV	DX,extini+2
	MOV	BX,configextp
	MOV	[BX],AX
	MOV	[BX+2],DX
	MOV	AX,CX
	CMP	AX,-1
	POP	BP
	RET	2
DEND	opencfg

DPROC	configread
	PUSH	SI
if USE_MEMCONFIG
	LES	BX,memcfg
	OR	BX,BX
	JZ	CONFIGREAD_06
	MOV	AX,ES:[BX.mc_memconfig]
	OR	AX,AX
	JZ	CONFIGREAD_06
	MOV	AX,ES:[BX.mc_flagb]
	MOV	path_b,AX
	MOV	DX,BX
	ADD	DX,mc_path
	ADD	BX,mc_lflag
	PUSH	DS
	PUSH	OFFSET cflag
	PUSH	ES
	PUSH	BX
	PUSH	20
	PUSH	DS
	MOV	AX,OFFSET path_a+2
	MOV	BX,ES:[BX]
	AND	BX,_W_PANELID
	JNZ	CONFIGREAD_05
	ADD	AX,SIZE S_PATH
CONFIGREAD_05:
	PUSH	AX
	PUSH	ES
	PUSH	DX
	PUSH	SIZE S_PATH-2
	CALL	memcpy
	CALL	memcpy
	JMP	CFGREAD_00
CONFIGREAD_06:
endif
	PUSH	OPENCFG_READ
	CALL	opencfg
	MOV	SI,AX
	CMP	AX,-1
	JNE	CFGREAD_02
CFGREAD_00:
	XOR	AX,AX
CFGREAD_01:
	POP	SI
	RET
CFGREAD_02:
	PUSH	SI
	PUSH	DS
	PUSH	OFFSET config
	PUSH	2
	CALL	osread
	CMP	AX,2
	JNE	CFGREAD_03
	MOV	AX,config
	MOV	config,DZVERSION
	CMP	AX,DZVERSION
	JA	CFGREAD_03
	CMP	AX,MINVERSION
	JAE	CFGREAD_04
CFGREAD_03:
	PUSH	SI
	CALL	close
	JMP	CFGREAD_00
CFGREAD_04:
	PUSH	SI
	PUSH	DS
	PUSH	OFFSET config+2
	PUSH	SIZE S_CONFIG-2
	CALL	osread
	PUSH	AX
	PUSH	SI
	CALL	close
	POP	AX
	CMP	AX,SIZE S_CONFIG-2
	MOV	AX,1
	JE	CFGREAD_01
	JMP	CFGREAD_00
DEND	configread

DPROC	configwrite
if USE_MEMCONFIG
	LES	BX,memcfg
	OR	BX,BX
	JZ	CONFIGWRITE_04
	MOV	AX,path_b
	MOV	ES:[BX.mc_flagb],AX
	MOV	AX,BX
	ADD	AX,mc_path
	ADD	BX,mc_lflag
	PUSH	ES
	PUSH	BX
	PUSH	DS
	PUSH	OFFSET cflag
	PUSH	20
	PUSH	ES
	PUSH	AX
	PUSH	DS
	MOV	AX,OFFSET path_a+2
	MOV	BX,cpanel
	CMP	BX,panela
	JNE	CONFIGWRITE_03
	ADD	AX,SIZE S_PATH
CONFIGWRITE_03:
	PUSH	AX
	PUSH	SIZE S_PATH-2
	CALL	memcpy
	CALL	memcpy
CONFIGWRITE_04:
endif
	PUSH	OPENCFG_WRITE
	CALL	opencfg
	CMP	AX,-1
	JE	CONFIGWRITE_00
	PUSH	AX
	PUSH	AX
	PUSH	DS
	PUSH	OFFSET config
	PUSH	SIZE S_CONFIG
	CALL	oswrite
	POP	DX
	PUSH	AX
	PUSH	DX
	CALL	close
	POP	AX
	CMP	AX,SIZE S_CONFIG
	JNE	CONFIGWRITE_00
	OR	AX,AX
	JMP	CONFIGWRITE_01
CONFIGWRITE_00:
	XOR	AX,AX

if USE_MEMCONFIG
	LES	BX,memcfg
	OR	BX,BX
	JZ	CONFIGWRITE_02
	INC	AX
	MOV	ES:[BX.mc_memconfig],AX
	DEC	AX
CONFIGWRITE_02:
endif

CONFIGWRITE_01:
	RET
DEND	configwrite

DPROC	dzcmd_delete
	CALL	MKARGV0_CMD
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	PUSH	0
	CALL	setfattr
	CALL	remove
	RET
DEND	dzcmd_delete

DPROC	history_init
	CALL	DZCMD_READ
	JZ	HISTORY_INIT_00
	PUSH	DS
	PUSH	OFFSET history
	PUSH	DS
	PUSH	OFFSET _bufin+DOSKEY_SIZE
	PUSH	HISTORY_SIZE+256
	CALL	memcpy
HISTORY_INIT_00:
	RET
DEND	history_init

DPROC	history_save
	MOV	BX,cpanel
	MOV	BX,[BX]
	MOV	AX,[BX]
	AND	AX,_W_ARCHIVE
	JZ      HISTORY_SAVE_00
	XOR	AX,AX
	JMP	HISTORY_SAVE_02
HISTORY_SAVE_00:
	PUSH	SI
	MOV	SI,OFFSET _bufin
	XOR	AX,AX
	PUSH	DS
	PUSH	SI
	PUSH	AX
	CALL	fullpath
	OR	AX,AX
	JZ	HISTORY_SAVE_01
	PUSH	DS
	PUSH	SI
	PUSH	DS
	MOV	SI,OFFSET history
	PUSH	SI
	CALL	strcmp
	OR	AX,AX
	JZ	HISTORY_SAVE_01
	XOR	AX,AX
	CALL	history_move
	PUSH	DS
	PUSH	SI
	PUSH	DS
	PUSH	OFFSET _bufin
	CALL	strcpy
	MOV	BX,cpanel
	MOV	AX,[BX.pn_fcb_index]
	MOV	[SI.dzp_bufid],AX
	MOV	AX,[BX.pn_cel_index]
	MOV	[SI.dzp_celid],AX
	MOV	BX,[BX]
	MOV	AX,[BX]
	AND	AX,NOT (_W_PANELID OR _W_VISIBLE)
	MOV	[SI.dzp_flag],AX
	INC	AX
HISTORY_SAVE_01:
	POP	SI
HISTORY_SAVE_02:
	RET
DEND	history_save

DPROC	history_write
	CALL	DZCMD_READ
	JNZ	HISTORY_WRITE_00
	PUSH	DS
	PUSH	OFFSET _bufin
	PUSH	DZCMD_SIZE+256
	CALL	memzero
HISTORY_WRITE_00:
	PUSH	DS
	PUSH	OFFSET _bufin + DOSKEY_SIZE
	PUSH	DS
	PUSH	OFFSET history
	PUSH	HISTORY_SIZE+256
	CALL	memcpy
	CALL	DZCMD_WRITE
	RET
DEND	history_write

DPROC	doskey_save
	PUSH	DS
	PUSH	OFFSET com_base
	CALL	strtrim
	OR	AX,AX
	JZ	DOSKEY_SAVE_03
DOSKEY_SAVE_00:
	PUSH	SI
	MOV	SI,OFFSET _bufin
	CALL	DZCMD_READ
	JNZ	DOSKEY_SAVE_01
	PUSH	DS
	PUSH	SI
	PUSH	DZCMD_SIZE+256
	CALL	memzero
DOSKEY_SAVE_01:
	PUSH	DS
	PUSH	OFFSET com_base
	PUSH	DS
	PUSH	SI
	CALL	strcmp
	OR	AX,AX
	JZ	DOSKEY_SAVE_02
	PUSH	DS
	MOV	AX,SI
	ADD	AX,128
	PUSH	AX
	PUSH	DS
	PUSH	SI
	PUSH	15*128
	CALL	memmove
	PUSH	DS
	PUSH	SI
	PUSH	DS
	PUSH	OFFSET com_base
	CALL	strcpy
	CALL	DZCMD_WRITE
DOSKEY_SAVE_02:
	MOV	AX,1
	POP	SI
DOSKEY_SAVE_03:
	RET
DEND	doskey_save

history_move	PROC	; void history_move(int direction);
		PUSH	SI
		PUSH	DI
		MOV	DI,DS
		MOV	ES,DI
		MOV	DI,OFFSET convbuf
		MOV	SI,OFFSET history
		MOV	CX,SIZE S_DZPATH
		MOV	BX,SIZE S_DZPATH * (HISTORY_MAX - 1)
		CLD
		OR	AL,AL
		JNZ	HSMOV_00
		ADD	SI,BX
HSMOV_00:	REP	MOVSB
		MOV	CX,BX
		MOV	DI,OFFSET history
		MOV	SI,DI
		ADD	SI,SIZE S_DZPATH
		OR	AL,AL
		JNZ	HSMOV_01
		XCHG	SI,DI
		DEC	BX
		ADD	SI,BX
		ADD	DI,BX
		INC	BX
		STD
HSMOV_01:	REP	MOVSB
		MOV	SI,OFFSET convbuf
		MOV	DI,OFFSET history
		MOV	CX,SIZE S_DZPATH
		CLD
		OR	AL,AL
		JZ	HSMOV_02
		ADD	DI,BX
HSMOV_02:	REP	MOVSB
		POP	DI
		POP	SI
		RET
history_move	ENDP

;--------------------------------------------------------------------------

DAPI	cmhistory
	PUSH	SI
	PUSH	DI
	CALL	DZCMD_READ
	JZ	HISTORY_06
	CMP	AH,_bufin
	JE	HISTORY_06
	PUSH	DS
	PUSH	WORD PTR IDD_HISTORY
	CALL	rsopen
	JZ	HISTORY_06
	PUSH	DX
	PUSH	AX
	PUSH	DS
	PUSH	WORD PTR IDD_HISTORY
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	PUSH	DX
	PUSH	AX
	MOV	AX,OFFSET _bufin
	ADD	BX,16
	PUSH	DS
	MOV	SI,DS
	MOV	DS,DX
	MOV	DX,NOT _O_STATE
	XOR	CX,CX
HISTORY_00:
	MOV	WORD PTR [BX.to_data],AX
	MOV	WORD PTR [BX.to_data+2],SI
	LES	DI,[BX.to_data]
	CMP	BYTE PTR ES:[DI],0
	JZ	HISTORY_01
	AND	[BX],DX
	ADD	BX,SIZE S_TOBJ
	ADD	AX,128
	INC	CX
	CMP	CX,16
	JB	HISTORY_00
	JMP	HISTORY_01
HISTORY_05:
	XOR	AX,AX
HISTORY_06:
	POP	DI
	POP	SI
	RET
HISTORY_01:
	POP	DS
	POP	BX
	POP	ES
	MOV	AX,CX
	MOV	ES:[BX.dl_count],AL
	MOV	AL,doskey_bindex
	MOV	ES:[BX.dl_index],AL
	CMP	AL,CL
	JB	HISTORY_02
	MOV	ES:[BX.dl_index],CH
HISTORY_02:
	MOV	AL,CL
	ADD	AL,2
	MOV	ES:[BX+7],AL
	PUSH	WORD PTR ES:[BX.dl_rect+2]
	INC	BYTE PTR ES:[BX+7]
	PUSH	0100h
	PUSH32	ES:[BX.dl_wp]
	MOV	AL,ES:[BX+6]
	MOV	AH,00h
	PUSH	AX
	PUSH	0
	CALL	rcframe
	CALL	twshow
	CALL	tdinit
	CALL	rsevent
	CALL	twclose
	XOR	AX,AX
	OR	DX,DX
	JZ	HISTORY_06
	MOV	AL,ES:[BX.dl_index]
	MOV	doskey_bindex,AL
	MOV	AX,DX
	SHL	AX,4
	ADD	BX,AX
	PUSH	DS
	PUSH	OFFSET com_base
	PUSH32	ES:[BX.to_data]
	CALL	strcpy
	PUSH	KEY_END
	CALL	comevent
	MOV	AX,1
	JMP	HISTORY_06
DEND	cmhistory

DAPI	cmpathleft	; Alt-Left - Previous Directory
	CALL	history_save
	MOV	AX,1
	CALL	history_move
	CALL	SETDZPATH
	JZ	CMPATHLEFT_00
	RET
CMPATHLEFT_00:
	CALL	history_move
	RET
DEND	cmpathleft

DAPI	cmpathright	; Alt-Right - Next Directory
	CALL	history_save
	XOR	AX,AX
	CALL	history_move
	CALL	SETDZPATH
	JZ	CMPATHRIGHT_00
	RET
CMPATHRIGHT_00:
	INC	AX
	CALL	history_move
	RET
DEND	cmpathright

DAPI	cmdoskey_up
	CALL	DZCMD_READ
	JZ	DKEYUP_02
	CMP	doskey_isnext,AL
	JNE	DKEYUP_00
	MOV	com_base,AH
	JMP	DKEYUP_01
DKEYUP_00:
	CALL	DOSKEYTOCOM
	INC	doskey_bindex
	CMP	doskey_bindex,16
	JB	DKEYUP_01
	MOV	doskey_bindex,0
DKEYUP_01:
	PUSH	KEY_END
	CALL	comevent
	MOV	AX,1
	MOV	doskey_isnext,AH
DKEYUP_02:
	RET
DEND	cmdoskey_up

DAPI	cmdoskey_dn
	CALL	DZCMD_READ
	JZ	DKEYDN_04
	CMP	doskey_isnext,AH
	JNE	DKEYDN_00
	MOV	com_base,AH
	JMP	DKEYDN_03
DKEYDN_00:
	CMP	doskey_bindex,0
	JNE	DKEYDN_01
	MOV	doskey_bindex,15
	JMP	DKEYDN_02
DKEYDN_01:
	DEC	doskey_bindex
DKEYDN_02:
	CALL	DOSKEYTOCOM
DKEYDN_03:
	PUSH	KEY_END
	CALL	comevent
	MOV	AX,1
	MOV	doskey_isnext,AL
DKEYDN_04:
	RET
DEND	cmdoskey_dn

DAPI	cmsavesetup
	PUSH	DS
	PUSH	WORD PTR IDD_SAVESETUP
	CALL	rsmodal
	OR	AX,AX
	JZ	savesetup_00
	CALL	configwrite
	JZ	savesetup_01
	MOV	AX,1
savesetup_00:
	RET
savesetup_01:
	CALL	MKARGV0_CFG
	PUSH	DX
	PUSH	AX
	CALL	eropen
	INC	AX
	JMP	savesetup_00
DEND	cmsavesetup

_DZIP	ENDS

_DATA	SEGMENT

; Configuration file: DZ.CFG

config		DW	DZVERSION
cflag		DW	_C_AUTOSAVE+_C_INSMOVDN+_C_MENUSLINE+_C_STATUSLINE+_C_COMMANDLINE
		DB	0FFh
console		DW	307Fh
fsflag		DB	IO_SEARCHSUB
tvflag		DB	_C_HEXOFFSET
compressflag	DW	0
		DB 	0
		DW	0,0,0,0
path_a		DW	_W_SORTTYPE+_W_HIDDEN+_W_MINISTATUS+_W_VISIBLE
		DB	'*.*',0
		DB	28 dup(0)
;		DB	'C:\DOSZIP',0
;		DB	WMAXPATH-10 dup(0)
		DB	WMAXPATH dup(0)
		DB	WMAXPATH dup(0)
		DB	WMAXPATH dup(0)
path_b		DW	_W_SORTTYPE+_W_HIDDEN+_W_PANELID+_W_MINISTATUS+_W_VISIBLE
		DB	'*.*',0
		DB	28 dup(0)
;		DB      'C:\DOSZIP',0
;		DB	WMAXPATH-10 dup(0)
		DB	WMAXPATH dup(0)
		DB	WMAXPATH dup(0)
		DB	WMAXPATH dup(0)

		DW	-1,0,0,0,0,0,0
		DB	'*.*',0
		DB	252 dup(0)

at_background	DB	00h,10h,70h,70h,40h,30h,30h,70h
at_foreground	DB	00h,0Ah,0Fh,0Bh,0Fh,07h,07h,07h
		DB	08h,0Bh,00h,00h,0Fh,0Ah,0Fh,0Fh
at_palett	DB	0,1,2,3,4,5,20,7
		DB	56,57,58,59,60,61,62,63

		DB 	WMAXPATH dup(0)

; -- End DZ.CFG --

extini		LABEL	WORD
		DB	'ini',0
extcfg		LABEL	WORD
		DB	'cfg',0
extcmd		LABEL	WORD
		DB	'cmd',0

doskey_bindex	DB	0
doskey_isnext	DB	0

S_DZPATH	STRUC
dzp_directory	DB MAXPATH dup(?)
dzp_flag	DW ?
dzp_bufid	DW ?
dzp_celid	DW ?
S_DZPATH	ENDS

HISTORY_MAX	=	16
DOSKEY_SIZE	=	HISTORY_MAX * 128
HISTORY_SIZE	=	HISTORY_MAX * SIZE S_DZPATH
DZCMD_SIZE	=	DOSKEY_SIZE + HISTORY_SIZE

; History file: DZ.CMD

history		DB	HISTORY_SIZE dup(?)
searchstring	DB	0
		DB	127 dup(0)
findfilemask    DB	'*.*',0
		DB	124 dup(0)

;******** Resource begin HISTORY *
;	{ 0x005C,  16,   0, {22, 3,36,19} },
;	{ 0x8003,   0,   0, { 2, 2,32, 1} },
;	{ 0x8003,   0,   0, { 2, 3,32, 1} },
;	{ 0x8003,   0,   0, { 2, 4,32, 1} },
;	{ 0x8003,   0,   0, { 2, 5,32, 1} },
;	{ 0x8003,   0,   0, { 2, 6,32, 1} },
;	{ 0x8003,   0,   0, { 2, 7,32, 1} },
;	{ 0x8003,   0,   0, { 2, 8,32, 1} },
;	{ 0x8003,   0,   0, { 2, 9,32, 1} },
;	{ 0x8003,   0,   0, { 2,10,32, 1} },
;	{ 0x8003,   0,   0, { 2,11,32, 1} },
;	{ 0x8003,   0,   0, { 2,12,32, 1} },
;	{ 0x8003,   0,   0, { 2,13,32, 1} },
;	{ 0x8003,   0,   0, { 2,14,32, 1} },
;	{ 0x8003,   0,   0, { 2,15,32, 1} },
;	{ 0x8003,   0,   0, { 2,16,32, 1} },
;	{ 0x8003,   0,   0, { 2,17,32, 1} },
;******** Resource data  *******************
HISTORY_RC LABEL WORD
	DW	006B0h	; Alloc size
	DW	0005Ch,00010h,00316h,01324h,08003h,00000h,00202h,00120h
	DW	08003h,00000h,00302h,00120h,08003h,00000h,00402h,00120h
	DW	08003h,00000h,00502h,00120h,08003h,00000h,00602h,00120h
	DW	08003h,00000h,00702h,00120h,08003h,00000h,00802h,00120h
	DW	08003h,00000h,00902h,00120h,08003h,00000h,00A02h,00120h
	DW	08003h,00000h,00B02h,00120h,08003h,00000h,00C02h,00120h
	DW	08003h,00000h,00D02h,00120h,08003h,00000h,00E02h,00120h
	DW	08003h,00000h,00F02h,00120h,08003h,00000h,01002h,00120h
	DW	08003h,00000h,01102h,00120h,024F0h,0F250h,02A88h,00EF0h
	DW	04820h,07369h,06F74h,07972h,097F2h,05020h
;	158 byte
IDD_HISTORY DD DGROUP:HISTORY_RC

	public	IDD_HISTORY

;******** Resource end   HISTORY *

;******** Resource begin SAVESETUP *
;	{ 0x005C,   2,   0, {27, 7,27, 7} },
;	{ 0x0000,   0, 'S', { 3, 5, 8, 1} },
;	{ 0x0200,   0, 'C', {14, 5,10, 1} },
;******** Resource data  *******************
SAVESETUP_RC LABEL WORD
	DW	001D1h	; Alloc size
	DW	0005Ch,00002h,0071Bh,0071Bh,00000h,05300h,00503h,00108h
	DW	00200h,04300h,0050Eh,0010Ah,01BF0h,0F050h,02A6Fh,05050h
	DW	0F05Ch,05005h,02A20h,0502Ah,05C50h,007F0h,02050h,006F0h
	DW	0F02Ah,02008h,003F0h,0F02Ah,0200Ah,02A2Ah,00BF0h,05320h
	DW	07465h,07075h,02AF0h,04420h,0206Fh,06F79h,02075h,06977h
	DW	06873h,07420h,0206Fh,06173h,06576h,008F0h,07420h,06568h
	DW	06320h,07275h,06572h,0746Eh,07320h,07465h,07075h,0F03Fh
	DW	02025h,06153h,06576h,02020h,0F0DCh,02004h,06143h,0636Eh
	DW	06C65h,02020h,0F0DCh,02006h,008F0h,0F0DFh,02003h,00AF0h
	DW	020DFh,02A20h
;	150 byte
IDD_SAVESETUP DD DGROUP:SAVESETUP_RC

	public	IDD_SAVESETUP

;******** Resource end   SAVESETUP *

_DATA	ENDS

	END
