; Change history:
; 09/24/2010 fixed bug in tiputc (Paste)
; 10/21/2009 added pre-selected default text
; 10/20/2009 fixed bug in selected text
; 10/11/2009 fixed bug in tiputs
; 09/21/2009 fixed bug in ClipboardCut

include	clib.inc
include	clip.inc
include	dos.inc
include	string.inc
include	conio.inc
include	keyb.inc
include	mouse.inc
include	malloc.inc

	.186

CONTINUE equ	0	; continue edit
RETEVENT equ	1	; return current event (keystroke)
CMFAILED equ	2	; operation fail (end of line/buffer)

_DATA	SEGMENT

base	dd ?	; base pointer
xpos	dw ?	; text window x,y
ypos	dw ?
cols	dw ?	; size of screen-line
bcol	dw ?	; size of buffer-line
xoff	dw ?	; offset on screen
boff	dw ?	; offset in buffer (start of screen-line)
bcnt	dw ?	; byte count in line
ifdef __CLIP__
 clst	dd ?	; Clipboard start
 clen	dd ?	; Clipboard end
endif
 clat	dw ?	; Normal string attrib

ti_proctab label word
	dw	ticontinue
	dw      tinextword
	dw      tiprevword
	dw      tidelete
	dw      tiesc
	dw      timouse
	dw      tileft
	dw      tiright
	dw      tihome
	dw      titoend
	dw      tibacksp
	dw      tiesc
	dw      tiesc
	dw      tiesc

ti_keytable label word
	dw	CONTINUE
	dw      KEY_CTRLRIGHT
	dw      KEY_CTRLLEFT
	dw      KEY_DEL

ti_skipkeys label word
	dw      KEY_ESC		; 011B
	dw      MOUSECMD	; FFFE
	dw      KEY_LEFT	; 4B00
	dw      KEY_RIGHT	; 4D00
	dw      KEY_HOME	; 4700
	dw      KEY_END 	; 4F00
	dw      KEY_BKSP	; 0E08
	dw      KEY_TAB		; 0F09
	dw      KEY_ENTER	; 1C0D
	dw      KEY_KPENTER	; E00D
	dw	KEY_UP		; 4800
	dw	KEY_DOWN	; 5000

ti_key_count =	14

_DATA	ENDS

_TEXT	SEGMENT

ticurlp	PROC
	les	bx,base ; current line offset (in buffer)
	mov	dx,es
	mov	ax,bx	; return DX:AX and ES:BX
	ret
ticurlp	ENDP

ticursp	PROC
	call	ticurlp		; current line offset (on screen)
	add	ax,boff
	mov	bx,ax
	ret
ticursp	ENDP

ticurp	PROC
	call	ticurlp		; current char offset (on screen)
	add	ax,boff
	add	ax,xoff
	mov	bx,ax
	ret
ticurp	ENDP

nocando	PROC
	push	9
	push	1
	call	beep	; end of line/buffer
	mov	ax,CMFAILED
	ret
nocando	ENDP

tihome	PROC
	xor	ax,ax
	mov	xoff,ax
	mov	boff,ax
	ret
tihome	ENDP

titoend	PROC
	mov	dx,cols
	dec	dx
	mov	ax,bcnt
	cmp	ax,dx
	jle	titoend_00
	mov	ax,dx
    titoend_00:
	mov	xoff,ax	; MIN(bcnt, cols - 1);
	mov	dx,bcnt
	sub	dx,cols
	inc	dx
	xor	ax,ax
	cmp	ax,dx
	jg	titoend_01
	mov	ax,dx
    titoend_01:
	mov	boff,ax	; MAX(bcnt - cols + 1, 0);
	mov	ax,boff
	dec	ax
	cmp	ax,bcnt
	jne	titoend_02
	dec	boff	; if (bcnt == bcol - 1) boff--;
    titoend_02:
	mov	ax,CONTINUE
	ret
titoend	ENDP

tiseto	PROC
	call	ticurlp
	push	dx
	push	ax
	xor	ax,ax
	add	bx,bcol
	dec	bx
	mov	es:[bx],al	; line[bcol - 1] = 0;
	call	strlen
	mov	bcnt,ax		; byte count in line
	mov	dx,boff		; test if char is visible
	add	dx,xoff
	cmp	dx,ax
	jb	tiseto_00
	call	titoend         ; if not --> to end of line
	mov	ax,1
	ret
    tiseto_00:
	xor	ax,ax
	ret
tiseto	ENDP

tiputl	PROC
	push	ds	; print out ES:BX to screen
	push	si
  ifdef __CLIP__
	push	di
	mov	di,bx
  endif
	push	es
	push	bx
	mov	bh,byte ptr ypos
	mov	bl,byte ptr xpos
	call	@getxyp	; ES:BX to screen
  ifdef __CLIP__
	push	bx
	inc	bx
	mov	ah,at_background[B_DarkGray]
	mov	cx,cols
    tiputl_00:
	cmp	di,word ptr clen
	jge	tiputl_02
	cmp	di,word ptr clst
	jl	tiputl_01
	mov	es:[bx],ah
    tiputl_01:
	inc	di
	add	bx,2
	dec	cx
	jnz	tiputl_00
    tiputl_02:
	pop	bx
  endif
	mov	cx,cols
	pop	si	; DS:SI to string
	pop	ds
    tiputl_03:
	mov	al,[si]
	inc	si
	or	al,al
	jz	tiputl_04
	mov	es:[bx],al
	add	bx,2
	dec	cx
	jnz	tiputl_03
    tiputl_04:
  ifdef __MOUSE__
	call	mouseshow
  endif
  ifdef __CLIP__
	pop	di
  endif
	pop	si
	pop	ds
	ret
tiputl	ENDP

tiputs	PROC
	mov	bh,byte ptr ypos
	mov	bl,byte ptr xpos
	mov	cx,cols
	mov	al,tclrascii
  ifdef __CLIP__
	mov	ah,byte ptr clat
	call	@scputw
  else
	call	@scputc
  endif
	push	word ptr base+2
	push	word ptr base
	call	strlen
	cmp	ax,boff
	jbe	tiputs_00
	les	bx,base
	add	bx,boff
	call	tiputl
    tiputs_00:
	mov	ax,xpos
	add	ax,xoff
	push	ax
	push	ypos
	call	gotoxy
	xor	ax,ax
	ret
tiputs	ENDP

tiputc	PROC
	cmp	al,tminascii
	jb	tiputc_ret
	cmp	al,tmaxascii
	ja	tiputc_ret
	inc	bcnt
	mov	bx,bcnt
	mov	dx,bcol
	cmp	dx,bx
	jbe	tiputc_eof
	push	ax
	call	ticurp
	push	dx
	inc	ax
	push	ax
	push	dx
	push	bx
	mov	ax,bcol
	sub	ax,xoff
	sub	ax,boff
	dec	ax
	push	ax
	call	memmove
	mov	es,dx
	dec	ax
	mov	bx,ax
	pop	ax
	mov	es:[bx],al
	inc	xoff
	mov	ax,cols
	cmp	xoff,ax
	jl	tiputc_end
	dec	ax
	mov	xoff,ax
	add	ax,boff
	cmp	bcnt,ax
	jbe	tiputc_end
	inc	boff
	jmp	tiputc_end
    tiputc_ret:
	mov	ax,RETEVENT
	ret
    tiputc_end:
	mov	ax,CONTINUE
	ret
    tiputc_eof:
	dec	dx
	mov	bcnt,dx
	call	nocando
	ret
tiputc	ENDP

tinextword PROC
	call	ticurp
	xor	ax,ax
	cmp	al,es:[bx]
	jz	tinextword_06
	mov	ax,boff
	add	ax,xoff
	cmp	ax,bcnt
	mov	ax,' '
	jnb	tinextword_06
	cmp	es:[bx+1],ah
	jz	tinextword_06
	push	bx
	inc	bx
	push	es
	push	bx
	push	ax
	call	strchr
	pop	bx
	jz	tinextword_05
	mov	es,dx
	xchg	ax,bx
    tinextword_00:
	cmp	byte ptr es:[bx],' '
	jne	tinextword_01
	inc	bx
	jmp	tinextword_00
    tinextword_01:
	sub	bx,ax
	jmp	tinextword_04
    tinextword_02:
	dec	bx
	mov	ax,cols
	dec	ax
	cmp	ax,xoff
	jbe	tinextword_03
	inc	xoff
	jmp	tinextword_04
    tinextword_03:
	inc	boff
    tinextword_04:
	or	bx,bx
	jnz	tinextword_02
	jmp	tinextword_06
    tinextword_05:
	call	titoend
	ret
    tinextword_06:
	mov	ax,CONTINUE
	ret
tinextword ENDP

tiback	PROC
	mov	ax,CMFAILED
	cmp	cx,xoff
	je	tiback_00
	dec	xoff
	xor	ax,ax
	ret
    tiback_00:
	cmp	cx,boff
	je	tiback_end
	dec	boff
	xor	ax,ax
    tiback_end:
	ret
tiback	ENDP

tiprevword PROC
	mov	ax,boff
	add	ax,xoff
	or	ax,ax
	jz	tiprevword_03
	call	ticurp
	dec	bx
	mov	dl,' '
	xor	cx,cx
    tiprevword_00:
	cmp	es:[bx],dl
	ja	tiprevword_01
	call	tiback
	dec	bx
	jmp	tiprevword_00
    tiprevword_01:
	cmp	bx,ax
	jbe	tiprevword_02
	call	tiback
	dec	bx
	cmp	es:[bx],dl
	ja	tiprevword_01
    tiprevword_02:
	cmp	ax,bx
	jnz	tiprevword_03
	xor	ax,ax
	mov	boff,ax
	mov	xoff,ax
    tiprevword_03:
	mov	ax,CONTINUE
	ret
tiprevword ENDP

tidelete PROC
	call	ticurp
	cmp	byte ptr es:[bx],0
	je	tidelete_end
	dec	bcnt
	push	dx
	push	bx
	inc	bx
	push	dx
	push	bx
	call	strcpy
    tidelete_end:
	mov	ax,CONTINUE
	ret
tidelete ENDP

tibacksp PROC
	xor	cx,cx
	mov	ax,boff
	add	ax,xoff
	or	ax,ax
	jz	tibacksp_end
	call	tiback
	dec	bcnt
	call	ticurp
	push	dx
	push	bx
	inc	bx
	push	dx
	push	bx
	call	strcpy
	mov	ax,CONTINUE
	ret
    tibacksp_end:
	call	nocando
	ret
tibacksp ENDP

timouse	PROC
  ifdef __MOUSE__
	call	mousey
	cmp	ax,ypos
	jne	timouse_end
	call	mousex
	mov	dx,xpos
	cmp	al,dl
	jb	timouse_end
	add	dx,cols
	cmp	ax,dx
	jnb	timouse_end
	sub	ax,xpos
	mov	xoff,ax
	mov	ax,word ptr base
	add	ax,boff
	push	word ptr base+2
	push	ax
	call	strlen
	cmp	ax,xoff
	jnb	timouse_00
	mov	xoff,ax
    timouse_00:
	mov	ax,xpos
	add	ax,xoff
	push	ax
	push	ypos
	call	gotoxy
	call	msloop
	jmp	ticontinue
    timouse_end:
	mov	ax,RETEVENT
	ret
  else
	mov	ax,CONTINUE
	ret
  endif
timouse	ENDP

tiesc	PROC
	mov	ax,RETEVENT
	ret
tiesc	ENDP

tileft	PROC
	xor	cx,cx
	call	tiback
	ret
tileft	ENDP

ticontinue PROC
	xor	ax,ax
	ret
ticontinue ENDP

tiright	PROC
	call	ticurp
	mov	al,es:[bx]
	sub	bx,xoff
	or	al,al
	jz	tiright_00
	mov	ax,cols
	dec	ax
	cmp	ax,xoff
	jbe	tiright_00
	inc	xoff
	jmp	ticontinue
    tiright_00:
	push	dx
	push	bx
	call	strlen
	cmp	ax,cols
	jb	tiright_eof
	inc	boff
	jmp	ticontinue
    tiright_eof:
	call	nocando
	ret
tiright	ENDP

ifdef __CLIP__

set_clipboard:
	call	ticurp	; set clipboard to current position
	mov	word ptr clst,ax
	mov	word ptr clst+2,dx
	mov	word ptr clen,ax
	mov	word ptr clen+2,dx
	ret

clipboard_delete:
	mov	ax,word ptr clen
	sub	ax,word ptr clst
	jz	clipboard_delete_end
	push	word ptr clst+2
	push	word ptr clst
	push	word ptr clen+2
	push	word ptr clen
	call	strcpy
	mov	dx,word ptr clen
	sub	dx,ax
	mov	bx,word ptr base
	add	bx,boff
	add	bx,xoff
	cmp	ax,bx
	je	clipboard_delete_set
	sub	xoff,dx
    clipboard_delete_set:
	call	tiseto
	call	set_clipboard
	xor	ax,ax
	inc	ax
    clipboard_delete_end:
	ret

clipboard_cut:
	mov	dx,ax
	mov	ax,word ptr clen
	sub	ax,word ptr clst
	jle	clipboard_cut_end
	push	dx
	push	word ptr clst+2
	push	word ptr clst
	push	ax
	call	ClipboardOpen
	call	ClipboardEmpty
	call	ClipboardCopy
	call	ClipboardClose
	pop	ax
	or	ax,ax
	jz	clipboard_cut_end
	call	clipboard_delete
    clipboard_cut_end:
	call	set_clipboard
	xor	ax,ax
	ret

clipboard_get:
	push	si
	push	di
	push	xoff
	push	boff
	call	clipboard_delete
	call	ClipboardOpen
	call	ClipboardSize
	or	ax,ax
	jz	clipboard_get_01
	cmp	ax,1FFFh
	ja	clipboard_get_01
	mov	si,ax
	call	ClipboardPaste
	jz	clipboard_get_01
	push	dx
	push	ax
	call	ClipboardClose
	pop	di
	pop	es
    clipboard_get_00:
	mov	al,es:[di]
	or	al,al
	jz	clipboard_get_01
	inc	di
	push	es
	call	tiputc
	pop	es
	or	ax,ax
	jnz	clipboard_get_01
	dec	si
	jnz	clipboard_get_00
    clipboard_get_01:
	pop	dx
	pop	ax
	mov	xoff,ax
	mov	boff,dx
	xor	ax,ax
	pop	di
	pop	si
	ret

clipboard_event:
	push	si
	mov	si,ax
	mov	ax,word ptr clst
	cmp	ax,word ptr clen
	jne	clipboard_event_00
	call	set_clipboard
    clipboard_event_00:
	cmp	si,KEY_CTRLINS
	je	clipboard_event_05
	cmp	si,KEY_CTRLDEL
	je	clipboard_event_06
	mov	ax,0040h
	mov	bx,0017h
	mov	es,ax
	mov	al,es:[bx]
	and	al,3
	jnz	clipboard_event_01
	cmp	si,KEY_DEL
	jne	clipboard_event_12
	call	clipboard_delete
	jz	clipboard_event_set
	xor	ax,ax
	jmp	clipboard_event_end
    clipboard_event_01:
	cmp	si,KEY_INS
	je	clipboard_event_get
	cmp	si,KEY_DEL
	je	clipboard_event_06
	cmp	si,KEY_HOME
	je	clipboard_event_08
	cmp	si,KEY_LEFT
	je	clipboard_event_08
	cmp	si,KEY_RIGHT
	je	clipboard_event_08
	cmp	si,KEY_END
	je	clipboard_event_08
    clipboard_event_12:
	cmp	si,KEY_ESC
	je	clipboard_event_set
  ifdef __MOUSE__
	cmp	si,MOUSECMD
	je	clipboard_event_set
  endif
	cmp	si,KEY_BKSP
	je	clipboard_event_set
	cmp	si,KEY_TAB
	je	clipboard_event_set
	cmp	si,KEY_ENTER
	je	clipboard_event_set
	cmp	si,KEY_KPENTER
	je	clipboard_event_set
	mov	ax,si
	or	al,al
	jz	clipboard_event_set
	call	clipboard_delete
    clipboard_event_set:
	call	set_clipboard
	mov	ax,si
    clipboard_event_end:
	pop	si
	ret
    clipboard_event_get:
	call	clipboard_get
	jmp	clipboard_event_end
    clipboard_event_05:
	xor	ax,ax
	jmp	clipboard_event_cut
    clipboard_event_06:
	mov	ax,1
    clipboard_event_cut:
	call	clipboard_cut
	jmp	clipboard_event_end
    clipboard_event_08:
	mov	ax,si
	call	tievent
	or	ax,ax
	jnz	clipboard_event_nul
	call	ticurp
	cmp	ax,word ptr clst
	jb	clipboard_event_10
	cmp	si,KEY_RIGHT
	jne	clipboard_event_09
	mov	dx,ax
	dec	dx
	cmp	dx,word ptr clst
	jne	clipboard_event_09
	cmp	dx,word ptr clen
	jnz	clipboard_event_10
    clipboard_event_09:
	mov	word ptr clen,ax
	jmp	clipboard_event_nul
    clipboard_event_10:
	mov	word ptr clst,ax
    clipboard_event_nul:
	xor	ax,ax
	jmp	clipboard_event_end

endif	; Clipboard

tievent	PROC
	mov	cx,ti_key_count
	xor	bx,bx
    tievent_cmp:
	cmp	ax,[bx+ti_keytable]
	je	tievent_found
	add	bx,2
	dec	cx
	jnz	tievent_cmp
	call	tiputc
	ret
    tievent_found:
	jmp	[bx+ti_proctab]
tievent	ENDP

timodal	PROC
	push	si
	push	di
	mov	si,CONTINUE
    timodal_idle:
	call	tiseto
	call	tiputs
	cmp	si,RETEVENT
	je	timodal_break
	call	tgetevent
  ifdef __CLIP__
	call	clipboard_event
  endif
	mov	di,ax
	call	tievent
	mov	si,ax
	jmp	timodal_idle
    timodal_break:
	call	ticurlp
	push	dx
	push	ax
	call	strlen
	mov	bcnt,ax
	mov	ax,di
	pop	di
	pop	si
	ret
timodal	ENDP

ifdef __CLIP__
 init_clipboard PROC
	mov	ax,word ptr base
	mov	word ptr clst,ax; start = end = base
	mov	word ptr clen,ax
	mov	ax,word ptr base+2
	mov	word ptr clst+2,ax
	mov	word ptr clen+2,ax
	call	ClipboardInit	; init WINOLDAP functions
	ret
 init_clipboard ENDP
endif

_TEXT	ENDS

;************** int tdedit(char *base, RECT, int bsize[, int lcount]);

PPROC	tdedit, b:dword, rc:dword, bz:word
local	cursor:	dword
	lea	ax,cursor
	push	ss
	push	ax
	call	getcursor
	call	cursoron
	mov	ax,word ptr b
	mov	word ptr base,ax
	mov	ax,word ptr b+2
	mov	word ptr base+2,ax
	mov	ax,bz
	and	ax,7FFFh
	mov	bcol,ax
	call	tihome
	mov	xoff,ax
	mov	al,byte ptr rc
	mov	xpos,ax
	push	ax
	mov	al,byte ptr rc+1
	mov	ypos,ax
	push	ax
	mov	al,byte ptr rc+2
	mov	cols,ax
	call	gotoxy
	mov	bl,byte ptr xpos ; get attrib of text to select
	mov	bh,byte ptr ypos
	call	@getxya
	mov	clat,ax         ; save text color
  ifdef __CLIP__
	call	init_clipboard
	test	bz,8000h
	jz	tdedit_00
	call	tiseto
	call	titoend
	call	ticurp
	mov	word ptr clen,ax
	mov	word ptr clen+2,dx
    tdedit_00:
  endif
	call	tiseto
	call	timodal
	push	ax
	call	tiputs
	push	word ptr cursor+2
	push	word ptr cursor
	call	setcursor
	pop	ax
	ret
PEND	tdedit

PPROC	tihndlevent, tinfo:dword, event:word
	push	ds
	push	offset base
	push	word ptr tinfo+2
	push	word ptr tinfo
	push	size S_TINFO
	call	memcpy
  ifdef __CLIP__
	cmp	clat,0
	jne	tihndlevent_00
	call	init_clipboard
  endif
    tihndlevent_00:
	call	tiseto
	call	tiputs
	mov	ax,event
	or	ax,ax
	jnz	tihndlevent_01
	call	tgetevent
	mov	event,ax
    tihndlevent_01:
  ifdef __CLIP__
	call	clipboard_event
  endif
	call	tievent
	push	ax
	call	tiseto
	call	tiputs
	push	word ptr tinfo+2
	push	word ptr tinfo
	push	ds
	push	offset base
	push	size S_TINFO
	call	memcpy
	pop	dx
	xor	ax,ax
	cmp	dx,RETEVENT
	jne	tihndlevent_02
	mov	ax,event
    tihndlevent_02:
	ret
PEND	tihndlevent

	END
