	.186

include	clib.inc

	public	membase
	public	palloc
	public	malloc
	public	free

_TEXT	SEGMENT

ENOMEM	= 12

membase	dw ?
memfree	dw ?
memlast	dw ?

resize_block:
	mov	bx,ax
	mov	ax,ss:_psp
	sub	bx,ax
	mov	es,ax
	mov	ah,4Ah
	int	21h
	ret

create_heap:
	mov	ax,heapbase
	inc	ax
	cmp	ax,heaptop
	ja	create_heap_failed
	call	resize_block
	jc	create_heap_failed
	mov	ax,heapbase
	mov	cs:membase,ax
	mov	cs:memlast,ax
	mov	es,ax
	xor	ax,ax
	mov	bx,ax
	mov	cs:memfree,ax
	mov	es:[bx],ax
	inc	ax
	mov	es:[bx+2],ax
	ret
    create_heap_failed:
	xor	ax,ax
	ret

extend_heap:
	mov	ax,cs:memlast
	inc	ax
	add	ax,cx
	cmp	ax,heaptop
	ja	extend_heap_failed
	call	resize_block
	jc	extend_heap_failed
	mov	ax,cs:memlast
	mov	es,ax
	xor	bx,bx
	mov	es:[bx],cx
	mov	dx,ax
	add	ax,cx
	mov	cs:memlast,ax
	mov	es,ax
	xor	ax,ax
	mov	es:[bx],ax
	inc	ax
	mov	es:[bx+2],ax
	ret
    extend_heap_failed:
	xor	ax,ax
	ret

getmaxblock:
	push	si
	push	di
	xor	cx,cx		; max size of block
	mov	dx,cs:membase	; segment of block
	mov	ax,dx
	mov	bx,cx
	mov	si,ax		; segment of last block
    getmaxblock_loop:
	mov	es,ax
	mov	di,es:[bx]
	or	di,di
	jz	getmaxblock_exit
	mov	si,ax
	cmp	es:[bx+2],bl
	jne	getmaxblock_next
	add	ax,di
	mov	es,ax
	cmp	es:[bx+2],bl
	jne	getmaxblock_set
	mov	ax,es:[bx]
	or	ax,ax
	jz	getmaxblock_set
	add	di,ax
	mov	ax,si
	mov	es,ax
	mov	es:[bx],di
	jmp	getmaxblock_loop
    getmaxblock_set:
	mov	ax,si
	cmp	di,cx
	jb	getmaxblock_next
	mov	cx,di
	mov	dx,ax
    getmaxblock_next:
	add	ax,di
	jmp	getmaxblock_loop
    getmaxblock_exit:
	mov	ax,si		; last block
	or	cx,cx
	jz	getmaxblock_end
	mov	cs:memfree,dx
    getmaxblock_end:
	pop	di
	pop	si
	ret

free	PROC	DIST
	push	bp
	mov	bp,sp
	mov	ax,[bp+ARG1+2]
	cmp	ax,cs:membase
	jb	free_failed
	cmp	ax,cs:memlast
	jae	free_failed
	mov	es,ax
	xor	bx,bx
	add	ax,es:[bx]
	cmp	ax,cs:memlast
	mov	es:[bx+2],bx
	je	free_resize
	mov	ax,es
	mov	cs:memfree,ax
    free_end:
	mov	sp,bp
	pop	bp
	ret	4
    free_failed:
	xor	ax,ax
	jmp	free_end
    free_resize:
	call	getmaxblock
	mov	es,ax
	mov	es:[bx],bx
	inc	bx
	mov	es:[bx+1],bx
	mov	cs:memlast,ax
	inc	ax
	call	resize_block
	jmp	free_end
free	ENDP

palloc	PROC DIST
	or	ax,ax
	jz	palloc_failed
	mov	cx,ax
	mov	ax,cs:memfree
	or	ax,ax
	jz	palloc_create
	mov	es,ax
	mov	dx,ax
	xor	bx,bx
	cmp	es:[bx+2],bl
	mov	ax,es:[bx]
	je	palloc_found
    palloc_find:
	push	cx
	call	getmaxblock
	pop	ax
	xchg	ax,cx
	jz	palloc_extend
	cmp	ax,cx
	jb	palloc_extend
	mov	es,dx
    palloc_found:
	cmp	ax,cx
	jb	palloc_find
	mov	word ptr es:[bx+2],1
	je	palloc_set
	mov	es:[bx],cx
	sub	ax,cx
	add	cx,dx
	mov	es,cx
	mov	es:[bx],ax
	mov	es:[bx+2],bx
	mov	es,dx
    palloc_set:
	mov	ax,es:[bx]
	add	ax,dx
	mov	cs:memfree,ax
    palloc_seto:
	mov	ax,4
    palloc_end:
	or	ax,ax
	ret
    palloc_failed:
	mov	ss:errno,ENOMEM
	xor	ax,ax
	mov	dx,ax
	jmp	palloc_end
    palloc_create:
	cmp	ax,cs:membase
	jne	palloc_find
	call	create_heap
	jz	palloc_failed
    palloc_extend:
	call	extend_heap
	jnz	palloc_seto
	jmp	palloc_failed
palloc	ENDP

malloc	PROC DIST
	push	bp
	mov	bp,sp
	mov	ax,[bp+ARG1]
	add	ax,4
	jnc	malloc_para
	mov	ax,1001h
	jmp	malloc_end
    malloc_para:
	mov	dl,al
	shr	ax,4
	and	dl,15
	jz	malloc_end
	inc	ax
    malloc_end:
	call	palloc
	or	ax,ax
	mov	sp,bp
	pop	bp
	ret	2
malloc	ENDP

_TEXT	ENDS

	END
