	.186

include	clib.inc
include	ctype.inc
include	tinfo.inc
include	conio.inc
include	string.inc
include	dos.inc
include	keyb.inc
include	mouse.inc

  ifdef __CLIP__
	extrn	tiselected:	NEAR
	extrn	ticlipevent:	NEAR
  endif
	public	tievent
	public	timodal
	public	tiputs
	public	tiputc
	public	tiseto
	public	tiretevent
	public	ticontinue
	public	titoend
	public	tidelete
	public	tisetcursor
	public	tiinitcursor

  ifdef __EDIT__
	public	tiremline
	public	tialignx
	public	tialigny

	extrn	tistyle:	NEAR
  endif

_DATA	SEGMENT

ti_proctab label word
	dw	ticontinue
	dw      tinextword
	dw      tiprevword
	dw      tidelete
	dw      tiesc
	dw      timouse
	dw      tileft
	dw      tiright
	dw      tihome
	dw      titoend
	dw      tibacksp
  ifdef __EDIT__
	dw	tienter
	dw	tienter
	dw	tiup
	dw	tidown
	dw	tipgup
	dw	tipgdn
	dw      tictrlhome
	dw      tictrlend
  else
	dw      tiesc
	dw      tiesc
	dw      tiesc
  endif

ti_key_count =	(($ - offset ti_proctab) / 2)

ti_keytable label word
	dw	_TI_CONTINUE
	dw      KEY_CTRLRIGHT
	dw      KEY_CTRLLEFT
	dw      KEY_DEL
	dw      KEY_ESC
	dw      MOUSECMD
	dw      KEY_LEFT
	dw      KEY_RIGHT
	dw      KEY_HOME
	dw      KEY_END
	dw      KEY_BKSP
	dw      KEY_ENTER
	dw      KEY_KPENTER
ifndef __EDIT__
	dw	KEY_TAB
else
	dw	KEY_UP
	dw	KEY_DOWN
	dw	KEY_PGUP
	dw	KEY_PGDN
	dw	KEY_CTRLHOME
	dw	KEY_CTRLEND

cp_linetolong	db 'Line too long, was truncated',0

	public	cp_linetolong

endif

_DATA	ENDS

_TEXT	SEGMENT

ticurlp	PROC
	mov	bx,tinfo
  ifdef __EDIT__
	mov	ax,[bx.ti_loff]
	add	ax,[bx.ti_yoff]
	call	tigetline
	jz	ticurlp_eof
	call	tistrlen
	or	dx,dx
    ticurlp_eof:
  else
	mov	ax,[bx.ti_bpax]
	mov	dx,[bx.ti_bpdx]
  endif
	ret
ticurlp	ENDP

ticurcp	PROC
	call	ticurlp
	add	ax,[bx.ti_boff]
	add	ax,[bx.ti_xoff]
	ret
ticurcp	ENDP

nocando	PROC
	push	9
	push	1
	call	beep	; end of line/buffer
	mov	ax,_TI_CMFAILED
	ret
nocando	ENDP

ifdef __EDIT__

tiincx	PROC		; Increase xoff or boff
	push	bp	; ZF set if end of line
	push	ax	; CF set if boff increased
	mov	bp,ss:tinfo
	mov	ax,[bp.ti_xoff]
	add	ax,[bp.ti_boff]
	inc	ax
	cmp	ax,[bp.ti_bcol]
	jae	tiincx_eof
	mov	ax,[bp.ti_cols]
	inc	[bp.ti_xoff]
	cmp	[bp.ti_xoff],ax
	jb	tiincx_x
	dec	ax
	mov	[bp.ti_xoff],ax
	inc	[bp.ti_boff]
	or	ax,ax
	stc
	jmp	tiincx_end
    tiincx_x:
	or	ax,ax
	clc
    tiincx_end:
	pop	ax
	pop	bp
	ret
    tiincx_eof:
	xor	ax,ax
	jmp	tiincx_end
tiincx	ENDP

tiincy	PROC		; Increase yoff or loff
	push	bp	; ZF set if eof
	push	ax	; CF set if boff increased
	mov	bp,tinfo
	mov	ax,[bp.ti_yoff]
	add	ax,[bp.ti_loff]
	inc	ax
	cmp	ax,[bp.ti_brow]
	jae	tiincy_eof
	mov	ax,[bp.ti_rows]
	inc	[bp.ti_yoff]
	cmp	[bp.ti_yoff],ax
	jb	tiincy_y
	dec	ax
	mov	[bp.ti_yoff],ax
	inc	[bp.ti_loff]
	or	ax,ax
	stc
	jmp	tiincy_end
    tiincy_y:
	or	ax,ax
	clc
    tiincy_end:
	pop	ax
	pop	bp
	ret
    tiincy_eof:
	xor	ax,ax
	jmp	tiincy_end
tiincy	ENDP

tidecx	PROC		; Decrease xoff or boff
	push	bp	; ZF set if start of line
	push	ax	; CF set if boff decreased
	mov	bp,ss:tinfo
	mov	ax,[bp.ti_xoff]
	add	ax,[bp.ti_boff]
	jz	tidecx_end
	xor	ax,ax
	cmp	ax,[bp.ti_xoff]
	jne	tidecx_x
	dec	[bp.ti_boff]
	inc	ax
	stc
	jmp	tidecx_end
    tidecx_x:
	dec	[bp.ti_xoff]
	inc	ax
	clc
    tidecx_end:
	pop	ax
	pop	bp
	ret
tidecx	ENDP

tidecy	PROC		; Decrease yoff or loff
	push	bx	; ZF set if first line
	push	ax	; CF set if --loff
	mov	bx,tinfo
	mov	ax,[bx.ti_yoff]
	add	ax,[bx.ti_loff]
	jz	tidecy_end
	xor	ax,ax
	cmp	ax,[bx.ti_yoff]
	jne	tidecy_y
	dec	[bx.ti_loff]
	inc	ax
	stc
	jmp	tidecy_end
    tidecy_y:
	dec	[bx.ti_yoff]
	inc	ax
	clc
    tidecy_end:
	pop	ax
	pop	bx
	ret
tidecy	ENDP

tialignx PROC		; Align xoff and boff to AX
	push	bp
	push	cx
	mov	bp,ss:tinfo
	mov	cx,[bp.ti_xoff]
	add	cx,[bp.ti_boff]
	cmp	cx,ax
	jb	tialignx_inc
	je	tialignx_end
    tialignx_dec:
	call	tidecx
	jz	tialignx_end
	dec	cx
	cmp	ax,cx
	jne	tialignx_dec
	jmp	tialignx_ok
    tialignx_inc:
	call	tiincx
	jz	tialignx_end
	inc	cx
	cmp	ax,cx
	jne	tialignx_inc
    tialignx_ok:
	inc	cx
    tialignx_end:
	pop	cx
	pop	bp
	ret
tialignx ENDP

tialigny PROC
	push	cx
	mov	bx,tinfo	; Align yoff and loff to AX
	mov	cx,[bx.ti_yoff]
	add	cx,[bx.ti_loff]
	cmp	cx,ax
	jb	tialigny_inc
	je	tialigny_end
    tialigny_dec:
	call	tidecy
	jz	tialigny_end
	dec	cx
	cmp	ax,cx
	jne	tialigny_dec
	jmp	tialigny_ok
    tialigny_inc:
	call	tiincy
	jz	tialigny_end
	inc	cx
	cmp	ax,cx
	jne	tialigny_inc
    tialigny_ok:
	inc	cx
    tialigny_end:
	pop	cx
	ret
tialigny ENDP

tiincc	PROC		; Increase bcnt and xoff or boff
	push	bp
	push	ax
	mov	bp,ss:tinfo
	mov	ax,[bp.ti_bcnt]
	inc	ax
	cmp	ax,[bp.ti_bcol]
	jae	tiincc_eof
	call	tiincx
	jz	tiincc_end
	inc	[bp.ti_bcnt]
    tiincc_end:
	pop	ax
	pop	bp
	ret
    tiincc_eof:
	xor	ax,ax
	jmp	tiincc_end
tiincc	ENDP

tidecc	PROC		; Decrease bcnt and xoff or boff
	push	bp
	push	ax
	mov	bp,ss:tinfo
	mov	ax,[bp.ti_bcnt]
	or	ax,ax
	jz	tidecc_end
	dec	[bp.ti_bcnt]
	inc	ax
    tidecc_end:
	pop	ax
	pop	bp
	ret
tidecc	ENDP

tialigntab PROC		; Align xoff and boff to next TAB
	push	bp
	mov	bp,ss:tinfo
	mov	ax,[bp.ti_xoff]
	add	ax,[bp.ti_boff]
	pop	bp
	test	al,7
	jz	tialigntab_end
	and	al,0F8h
	add	al,8
	jmp	tialignx
    tialigntab_end:
	ret
tialigntab ENDP

fixtabs	PROC
	test	[bp.ti_flag],_T_LINEBUF
	jnz	fixtabs_do
	ret
    fixtabs_do:		; DS:SI string
	push	cx	; ES:DI string
	push	dx	; BX insert offset
	mov	dx,si
    fixtabs_lod:
	lodsb
	or	al,al
	jz	fixtabs_eof
	cmp	al,9
	je      fixtabs_09h
    fixtabs_sto:
	stosb
	assert	di,128,jb,"fixtabs:1"
	jmp	fixtabs_lod
    fixtabs_09h:
	stosb
	assert	di,128,jb,"fixtabs:2"
	test	si,7
	jz	fixtabs_lod
	mov	cx,di
    fixtabs_20h:
	lodsb
	or	al,al
	jz	fixtabs_eof
	cmp	al,9
	je	fixtabs_09h
	cmp	al,' '
	jne	fixtabs_sto
	cmp	bx,cx		; reduse insertion point if above
	jbe	fixtabs_ins	; '\t    x[]' --> '\tx[]'
	cmp	bx,dx
	je	fixtabs_ins
	dec	bx
    fixtabs_ins:
	jmp	fixtabs_20h
    fixtabs_eof:
	stosb
	pop	dx
	pop	cx
	ret
fixtabs	ENDP

simove	PROC		; move string to &string[1]
	lodsb
	cmp	si,cx		; CX max offset
	jae	simove_eof
	mov     [si-1],ah
	mov	ah,al
	or	al,al
	jnz	simove
	or	cx,cx
    simove_end:
	mov     [si],al		; terminate string
	ret
    simove_eof:
	xor	ax,ax
	jmp	simove_end
simove	ENDP

exptabs	PROC		; DS:SI string
	test	[bp.ti_flag],_T_LINEBUF
	jz	exptabs_nol
    exptabs_next:
	lodsb		; ES:DI string
	or	al,al	; BP offset tinfo
	jz	exptabs_eos
	cmp	al,9
	je	exptabs_09h
	stosb
	cmp	di,cx
	jb	exptabs_next
    exptabs_end:
	mov	al,0
	stosb
    exptabs_ret:
	ret
    exptabs_nol:
	or	cx,cx
	jmp	exptabs_ret
    exptabs_eos:
	or	cx,cx
	jmp	exptabs_end
    exptabs_09h:	; insert TAB char
	stosb
	cmp	di,cx
	jae	exptabs_end
	mov	dx,si
    exptabs_lup:		; insert spaces to next Tab offset
	mov	ah,' '
	mov	si,dx
	mov	di,dx
	test	si,7
	jz	exptabs_next
	call	simove
	jz	exptabs_ret
	inc	dx
	jmp	exptabs_lup
exptabs	ENDP

tixxxch PROC
	pop	bx
	push	ds	; DX:AX string
	push	si	; CL char to insert if put
	push	di
	push	bp
	push	cx
	push	ax
	push	bx
	mov	bp,tinfo
	mov	bx,[bp.ti_xoff]
	add	bx,[bp.ti_boff]
	add	bx,ax		; BX to insert offset
	mov	es,dx		; DS:SI and ES:DI to string
	mov	ds,dx
	mov	dx,ax		; save offset in DX
	mov	di,ax
	xor	ax,ax
	mov	si,bx		; set space count to AL
	std
	or	bx,bx
	jz	tixxxch_lup
	cmp	[si],al
	jnz	tixxxch_lup
	cmp	byte ptr [si-1],' '
	jne	tixxxch_lup
	lodsb
	inc	ah
    tixxxch_lup:
	lodsb
	cmp	al,' '
	jne	tixxxch_end
	inc	ah
	cmp	si,dx
	jae	tixxxch_lup
    tixxxch_end:
	cld
	mov	si,dx
	mov	al,ah
	mov	ah,cl		; char to insert to AH
	mov	cx,[bp.ti_bcol]
	dec	cx		; CX to max offset
	add	cx,dx
	push	ax              ; save AX
	push	bx		; save insert offset
	call	fixtabs		; remove spaces before insert/delete
	pop	di		; original offset in DI
	pop	ax
	ret
tixxxch	ENDP

tiputch PROC
	dec	[bx.ti_xoff]
	call	tixxxch
	inc	[bp.ti_xoff]
	mov	si,bx		; insert point to SI
	push	ax		; AH is the char to insert
	call	simove		; insert the char
	pop	ax
	test	[bp.ti_flag],_T_LINEBUF
	jz	tiendch
	mov	si,bx
	cmp	ah,9
	je	tiendch
	test	di,7
	jz	tiendch
	cmp	si,dx
	je	tiendch
	cmp	byte ptr [si-1],9
	jne	tiendch
	mov	ah,0
	mov	di,ax
	mov	ah,' '
	mov	[si-1],ah
	or	di,di
	jz	tiputch_tab
	dec	di
    tiputch_pad:
	jz	tiputch_tab
	call	simove
	mov	ah,' '
	inc	bx
	mov	si,bx
	dec	di
	jnz	tiputch_pad
    tiputch_tab:
	inc	si
	mov	ah,9
	call	simove
	assert	si,128,jb,"simove: line overflow"
tiputch ENDP

tiendch PROC
	mov	si,dx		; restore SI and DI
	mov	di,dx
	call	exptabs		; add spaces
	mov	dx,es
	mov	bx,bp
	pop	ax
	pop	cx
	pop	bp
	pop	di
	pop	si
	pop	ds
	ret
tiendch	ENDP

tixxxup PROC
	call	tixxxch
	jmp	tiendch
tixxxup ENDP

tiremch PROC
	call	tixxxch
	mov	si,bx
	test	[bp.ti_flag],_T_LINEBUF
	jz	tiremch_del
	test	di,7
	jz	tiremch_del
	cmp	si,dx
	je	tiremch_del
	cmp	byte ptr [si-1],9
	jne	tiremch_del
	mov	ah,0		; space count in revers direction in AL
	mov	di,ax
	mov	ah,' '		; remove tab in front of char
	mov	[si-1],ah
    tiremch_pad:
	call	simove		; padd to offset
	mov	ah,' '
	inc	bx
	mov	si,bx
	dec	di
	jnz	tiremch_pad
	dec	si
    tiremch_del:
	mov	di,si
	lodsb			; delete the char
	or	al,al
	jnz	tiremch_lup
	dec	si
    tiremch_lup:
	lodsb
	assert	di,[bp.ti_bcol],jb,"tiremch"
	stosb
	or	al,al
	jnz	tiremch_lup
	jmp	tiendch
tiremch ENDP

tiremline PROC
	push	si      ; AX index of line to remove
	push	di      ; DX nuber of lines to remove
	push	bp
	mov	bx,ax
	mov	bp,tinfo
	mov	ax,[bp.ti_bcol]
	sub	sp,ax
	mov	bp,sp
	push	ax
	mov	ax,dx
	mov	cx,[bp.ti_lcnt]
	sub	cx,bx
	push	cx
	add	dx,bx
	push	dx
	push	ax
    tiremlines_do:
	mov	ax,[bp-6]
	call	tigetline
	jc	tiremlines_eof
	mov	ds,dx
	mov	si,ax
	mov	cx,[bp-2]
	shr	cx,1
	push	ss
	pop	es
	mov	di,bp
	rep	movsw
	push	ss
	pop	ds
	mov	ax,bx
	call	tigetline
	jc	tiremlines_err
	mov	es,dx
	mov	di,ax
	mov	cx,[bp-2]
	shr	cx,1
	mov	si,bp
	rep	movsw
	inc	bx
	inc	word ptr [bp-6]
	dec	word ptr [bp-4]
	jnz	tiremlines_do
    tiremlines_eof:
	mov	bx,[bp-8]
	mov	si,tinfo
    tiremlines_clr:
	mov	ax,[si.ti_lcnt]
	dec	ax
	call	tigetline
	jz	tiremlines_end
	mov	es,dx
	mov	di,ax
	xor	ax,ax
	mov	cx,[bp-2]
	shr	cx,1
	rep	stosw
	dec	[si.ti_lcnt]
	dec	bx
	jnz	tiremlines_clr
	inc	ax
    tiremlines_end:
	add	sp,[bp-2]
	add	sp,8
	or	ax,ax
	pop	bp
	pop	di
	pop	si
	ret
    tiremlines_err:
	xor	ax,ax
	jmp	tiremlines_end
tiremline ENDP

endif ; __EDIT__

tiputc	PROC
	mov	bx,tinfo
	mov	cx,ax
	call	getctype
	test	ah,_CONTROL
	jnz	tiputc_CONTROL
    tiputc_add:
	mov	ax,[bx.ti_bcnt]
	inc	ax
	cmp	ax,[bx.ti_bcol]
	jae	tiputc_eof
    tiputc_ins:
  ifdef __EDIT__
	push	cx
	call	ticurlp
	pop	cx
	jz	tiputc_eof
	call	tiincc
	jz	tiputc_eof
	or	[bx.ti_flag],_T_MODIFIED
	call	tiputch
	jz	tiputc_eof
	test	[bx.ti_flag],_T_LINEBUF
	jz	tiputc_CONTINUE
	cmp	cl,9
	jne	tiputc_CONTINUE
	call	tialigntab
  else
	push	cx
	call	ticurcp
	push	si
	push	di
	mov	cx,[bx.ti_bcol]
	sub	cx,[bx.ti_xoff]
	sub	cx,[bx.ti_boff]
	dec	cx
	mov	ds,dx
	mov	es,dx
	mov	di,ax
	mov	si,ax
	inc	di
	dec	cx
	mov	ax,si
	add	si,cx
	add	di,cx
	inc	cx
	std
	rep	movsb
	cld
	mov	bx,ax
	pop	di
	pop	si
	pop	ax
	mov	[bx],al
	mov	ax,ss
	mov	ds,ax
	mov	bx,tinfo
	inc	[bx.ti_bcnt]
	inc	[bx.ti_xoff]
	mov	ax,[bx.ti_cols]
	cmp	[bx.ti_xoff],ax
	jl	tiputc_CONTINUE
	dec	ax
	mov	[bx.ti_xoff],ax
	add	ax,[bx.ti_boff]
	cmp	[bx.ti_bcnt],ax
	jbe	tiputc_CONTINUE
	inc	[bx.ti_boff]
  endif
    tiputc_CONTINUE:
	mov	ax,_TI_CONTINUE
	ret
  ifdef __EDIT__
    tiputc_strbuf:
  else
    tiputc_CONTROL:
  endif
	or	al,al
	jz	tiputc_ret
	test	[bx.ti_flag],_T_USECONTROL
	jnz	tiputc_add
    tiputc_ret:
	mov	ax,_TI_RETEVENT
	ret
    tiputc_eof:
  ifdef __EDIT__
	mov	ax,[bx.ti_bcol]
	dec	ax
	mov	[bx.ti_bcnt],ax
	mov	ax,offset cp_linetolong
	call	@ermsg
	mov	bx,tinfo
    tiputc_nocando:
  endif
	jmp	nocando
  ifdef __EDIT__
    tiputc_ENTER:
	jmp	tienterni
    tiputc_CONTROL:
	test	[bx.ti_flag],_T_LINEBUF
	jz	tiputc_strbuf
	cmp	al,9
	je	tiputc_TAB
	cmp	al,0Ah
	je	tiputc_ENTER
	cmp	al,0Dh
	je	tiputc_CONTINUE
	jmp	tiputc_ret
    tiputc_TAB:
	call	tiputc_add
	cmp	ax,_TI_CONTINUE
	jne	tiputc_nocando
	jmp	tiputc_CONTINUE
  endif
tiputc	ENDP

tidelete PROC
	call	ticurcp
	mov	es,dx
	xchg	ax,bx
	cmp	byte ptr es:[bx],0
	xchg	ax,bx
  ifdef __EDIT__
	je	tidelete_line
	test	[bx.ti_flag],_T_LINEBUF
	jz	tidelete_nol
	call	ticurlp
	call	tidecc
	jz	tidelete_eof
	call	tiremch
	or	[bx.ti_flag],_T_MODIFIED
	jmp	ticontinue
    tidelete_nol:
  else
	je	tidelete_end
  endif
	dec	[bx.ti_bcnt]
	push	dx
	push	ax
	inc	ax
	push	dx
	push	ax
	call	strcpy
    tidelete_end:
	jmp	ticontinue
  ifdef __EDIT__
    tidelete_eof:
	jmp	nocando
    tidelete_line:
	test	[bx.ti_flag],_T_LINEBUF
	jz	tidelete_end
	mov	ax,[bx.ti_loff]
	add	ax,[bx.ti_yoff]
	inc	ax
	cmp	ax,[bx.ti_brow]
	jae	tidelete_end
	cmp	ax,[bx.ti_lcnt]
	jae	tidelete_end
	call	tigetline
	jc	tidelete_end
	mov	cx,dx
	push	ax
	push	dx
	push	ax
	call	strlen
	add	ax,[bx.ti_bcnt]
	cmp	ax,[bx.ti_bcol]
	pop	ax
	jae	tidelete_end
	push	si
	push	di
	push	bp
	sub	sp,[bx.ti_bcol]		; add next line to this line
	mov	bp,sp
	push	ss
	push	bp
	push	cx
	push	ax
	call	strcpy
	mov	ax,[bx.ti_loff]
	add	ax,[bx.ti_yoff]
	mov	si,ax
	call	tigetline
	jc	tidelete_pop
	push	dx
	push	ax
	push	ss
	push	bp
	call	strcat
	add	sp,[bx.ti_bcol]
	inc	si
	mov	ax,si
	mov	dx,1
	call	tiremline
    tidelete_pop:
	pop	bp
	pop	di
	pop	si
	jmp	ticontinue
  endif
tidelete ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ticontinue PROC
	xor	ax,ax
	ret
ticontinue ENDP

tiretevent PROC
	mov	ax,_TI_RETEVENT
	ret
tiretevent ENDP

tiesc	PROC
	jmp	tiretevent
tiesc	ENDP

tihome	PROC
	mov	bx,tinfo
	xor	ax,ax
	mov	[bx.ti_xoff],ax
	mov	[bx.ti_boff],ax
	ret
tihome	ENDP

titoend	PROC
	mov	bx,tinfo
	mov	dx,[bx.ti_cols]
	dec	dx
	mov	ax,[bx.ti_bcnt]
	cmp	ax,dx
	jle	titoend_00
	mov	ax,dx
    titoend_00:
	mov	[bx.ti_xoff],ax
	mov	dx,[bx.ti_bcnt]
	sub	dx,[bx.ti_cols]
	inc	dx
	xor	ax,ax
	cmp	ax,dx
	jg	titoend_01
	mov	ax,dx
    titoend_01:
	mov	[bx.ti_boff],ax
	add	ax,[bx.ti_xoff]
	cmp	ax,[bx.ti_bcnt]
	jbe	titoend_02
	dec	[bx.ti_boff]
    titoend_02:
	jmp	ticontinue
titoend	ENDP

tiright	PROC
  ifdef __EDIT__
	mov	bx,tinfo
	test	[bx.ti_flag],_T_LINEBUF
	jz	tiright_do
	call	tiincx
	jmp	ticontinue
    tiright_do:
  endif
	push	di
	call	ticurcp
	mov	es,dx
	mov	di,ax
	mov	al,es:[di]
	sub	di,[bx.ti_xoff]
	or	al,al
	jz	tiright_00
	mov	ax,[bx.ti_cols]
	dec	ax
	cmp	ax,[bx.ti_xoff]
	jbe	tiright_00
	inc	[bx.ti_xoff]
    tiright_ok:
	pop	di
	jmp	ticontinue
    tiright_00:
	push	dx
	push	di
	call	strlen
	cmp	ax,[bx.ti_cols]
	jb	tiright_eof
	inc	[bx.ti_boff]
	jmp	tiright_ok
    tiright_eof:
	pop	di
	jmp	nocando
tiright	ENDP

tileft	PROC
	xor	cx,cx
tileft	ENDP

tiback	PROC
	mov	bx,tinfo
	mov	ax,_TI_CMFAILED
	cmp	cx,[bx.ti_xoff]
	je	tiback_00
	dec	[bx.ti_xoff]
    tiback_xor:
	xor	ax,ax
    tiback_end:
	ret
    tiback_00:
	cmp	cx,[bx.ti_boff]
	je	tiback_end
	dec	[bx.ti_boff]
	jmp	tiback_xor
tiback	ENDP

tibacksp PROC
	mov	bx,tinfo
	xor	cx,cx
	mov	ax,[bx.ti_boff]
	add	ax,[bx.ti_xoff]
	or	ax,ax
  ifdef __EDIT__
	jz	tibacksp_line
  else
	jz	tibacksp_nocando
  endif
	call	tiback
	call	ticurcp
  ifdef __EDIT__
	assert	dx,0,jnz,"tibacksp"
	or	[bx.ti_flag],_T_MODIFIED
  endif
	dec	[bx.ti_bcnt]
	push	dx
	push	ax
	inc	ax
	push	dx
	push	ax
	call	strcpy
	mov	ax,_TI_CONTINUE
	ret
    tibacksp_nocando:
	jmp	nocando
  ifdef __EDIT__
    tibacksp_line:
	test	[bx.ti_flag],_T_LINEBUF
	jz	tibacksp_nocando
	mov	ax,[bx.ti_loff]
	add	ax,[bx.ti_yoff]
	jz	tibacksp_nocando
	cmp	[bx.ti_yoff],cx
	je	tibacksp_bline
	dec	[bx.ti_yoff]
	jmp	tibacksp_end
    tibacksp_bline:
	dec	[bx.ti_loff]
    tibacksp_end:
	call	tiseto
	call	titoend
	jmp	tidelete
  endif
tibacksp ENDP

isword	PROC
	call	getctype
	and	ah,_UPPER or _LOWER or _DIGIT
	jnz	isword_end
	cmp	al,'_'
	jne	isword_nul
	or	al,al
	ret
    isword_nul:
	cmp	al,al
    isword_end:
	ret
isword	ENDP

tinextword PROC
	push	ds
	push	si
	call	ticurcp
	mov	ds,dx
	mov	si,ax
	mov	dx,ax
	xchg	bp,bx
	cld
    tinextword_l1:
	lodsb
	call	isword
	jnz	tinextword_l1
	or	al,al
	jz      tinextword_eof
    tinextword_l2:
	lodsb
	or	al,al
	jz      tinextword_eof
	call	isword
	jz	tinextword_l2
	dec	si
	sub	si,dx
	mov	ax,[bp.ti_boff]
	add	ax,[bp.ti_xoff]
	add	ax,si
	cmp	ax,[bp.ti_bcnt]
	ja	tinextword_eof
	mov	ax,si
	add	ax,[bp.ti_xoff]
	mov	dx,[bp.ti_cols]
	pop	si
	pop	ds
	cmp	ax,dx
	jb	tinextword_xoff
	dec	dx
	sub	ax,dx
	add	[bp.ti_boff],ax
	mov	ax,dx
    tinextword_xoff:
	mov	[bp.ti_xoff],ax
	xchg	bp,bx
	jmp	ticontinue
    tinextword_eof:
	; next line..
	xchg	bp,bx
	pop	si
	pop	ds
	jmp	titoend
tinextword ENDP

tiprevword PROC
	push	ds
	push	si
	mov	bx,tinfo
	mov	ax,[bx.ti_boff]
	add	ax,[bx.ti_xoff]
	or	ax,ax
	jz	tiprevword_eof
	mov	si,ax
	mov	cx,ax
	call	ticurlp
	mov	ds,dx
	mov	dx,ax
	add	si,ax
	std
	lodsb
	inc	si
	call	isword
	jnz	tiprevword_start
	or	al,al
	jnz	tiprevword_l1
	dec	si
    tiprevword_l1:
	call	tiprevword_lodsb
	jz	tiprevword_l1
    tiprevword_l2:
	call	tiprevword_lodsb
	jnz	tiprevword_l2
	mov	ax,si
	cld
	pop	si
	pop	ds
	sub	ax,dx
	add	ax,2
	cmp	ax,[bx.ti_xoff]
	ja	tiprevword_boff
	mov	[bx.ti_xoff],ax
	jmp	ticontinue
    tiprevword_start:
	mov	al,[si-1]
	call	isword
	jnz	tiprevword_l2
	dec	si
	jmp	tiprevword_l1
    tiprevword_boff:
	sub	ax,[bx.ti_xoff]
	mov	[bx.ti_xoff],0
	sub	[bx.ti_boff],ax
	jmp	ticontinue
    tiprevword_eof:
	cld
	pop	si
	pop	ds
	jmp	tihome
    tiprevword_lodsb:
	lodsb
	cmp	si,dx
	jbe	tiprevword_leof
	or	al,al
	jz	tiprevword_leof
	call	isword
	ret
    tiprevword_leof:
	pop	ax
	jmp	tiprevword_eof
tiprevword ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

timouse	PROC
  ifdef __MOUSE__
	mov	bx,tinfo
	call	mousey
   ifdef __EDIT__
	mov	bx,tinfo
	call	mousey
	mov	dx,ax
	call	mousex
	mov	cx,ax
	mov	ax,[bx.ti_xpos]
	cmp	cx,ax
	jb	timouse_end
	add	ax,[bx.ti_cols]
	cmp	cx,ax
	jae	timouse_end
	mov	ax,[bx.ti_ypos]
	cmp	dx,ax
	jb	timouse_end
	add	ax,[bx.ti_rows]
	cmp	dx,ax
	jae	timouse_end
	sub	dx,[bx.ti_ypos]
	mov	[bx.ti_yoff],dx
	push	cx
	call	ticurlp
	jz	timouse_nol
	push	dx
	push	ax
	call	strlen
   timouse_nol:
	pop	cx
	sub	cx,[bx.ti_xpos]
	cmp	cx,ax
	jg      timouse_00
	mov	ax,cx
   timouse_00:
	mov	[bx.ti_xoff],ax
	call	tisetcursor
	call	msloop
   else
	cmp	ax,[bx.ti_ypos]
	jne	timouse_end
	call	mousex
	mov	dx,[bx.ti_xpos]
	cmp	al,dl
	jb	timouse_end
	add	dx,[bx.ti_cols]
	cmp	ax,dx
	jnb	timouse_end
	sub	ax,[bx.ti_xpos]
	mov	[bx.ti_xoff],ax
	mov	ax,[bx.ti_bpax]
	add	ax,[bx.ti_boff]
	push	[bx.ti_bpdx]
	push	ax
	call	strlen
	cmp	ax,[bx.ti_xoff]
	jnb	timouse_00
	mov	[bx.ti_xoff],ax
    timouse_00:
	mov	ax,[bx.ti_xpos]
	add	ax,[bx.ti_xoff]
	push	ax
	push	[bx.ti_ypos]
	call	gotoxy
	call	msloop
   endif ; __EDIT__
	jmp	ticontinue
    timouse_end:
	jmp	tiesc
  else
	jmp	ticontinue
  endif ; __MOUSE__
timouse	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tiseto	PROC
	call	ticurlp
  ifdef __EDIT__
	call	tistripl
	mov	ax,[bx.ti_boff]		; test if char is visible
	add	ax,[bx.ti_xoff]
	cmp	ax,cx
	jbe	tiseto_00
	test	[bx.ti_flag],_T_LINEBUF
	jz	tiseto_toend
	call	tipadtooff		; if not --> pad to this pos
	jmp	tiseto_end
    tiseto_toend:
  else
	push	dx
	push	ax
	add	ax,[bx.ti_bcol]
	dec	ax
	mov	es,dx
	mov	bx,ax
	xor	ax,ax
	mov	es:[bx],al
	call	strlen
	mov	dx,ax
	mov	bx,tinfo
	mov	[bx.ti_bcnt],ax
	mov	ax,[bx.ti_boff]		; test if char is visible
	add	ax,[bx.ti_xoff]
	cmp	ax,dx
	jb	tiseto_00
  endif
	call	titoend			; if not --> to end of line
    tiseto_end:
	mov	ax,1
	ret
    tiseto_00:
	xor	ax,ax
	ret
tiseto	ENDP

tievent	PROC
	mov	cx,ti_key_count
	xor	bx,bx
    tievent_cmp:
	cmp	ax,[bx+ti_keytable]
	je	tievent_found
	add	bx,2
	dec	cx
	jnz	tievent_cmp
	call	tiputc
	ret
    tievent_found:
	jmp	[bx+ti_proctab]
tievent	ENDP

tiinitcursor PROC
	mov	bx,tinfo
	mov     [bx.ti_cuse],CURSOR_NORMAL
	lea	ax,[bx.ti_curs]
	push	ss
	push	ax
	call	getcursor
tiinitcursor ENDP

tisetcursor PROC
	mov	bx,tinfo
	mov	ax,[bx.ti_xpos]
	add	ax,[bx.ti_xoff]
	mov	[bx.ti_cuxy.cr_x],al
	mov	ax,[bx.ti_ypos]
  ifdef __EDIT__
	test	[bx.ti_flag],_T_LINEBUF
	jz	tisetcursor_str
	add	ax,[bx.ti_yoff]
    tisetcursor_str:
  endif
	mov	[bx.ti_cuxy.cr_y],al
	push	[bx.ti_cuse]
	push	[bx.ti_cuxy]
	call	setcursor
	ret
tisetcursor ENDP

tiputl	PROC PASCAL
local	lb[2+MAXSCRLINE]:BYTE
local	wc[2*MAXSCRLINE]:BYTE
local	line:WORD	; current line 0..max
local	loff:WORD	; adress of line
local	lseg:WORD
local	llen:WORD	; length of line
local	clst:WORD	; clip start
local	clen:WORD	; clip end
	push	si
	push	di
	mov	si,tinfo
  ifdef __EDIT__
	mov	line,ax
	mov	ah,[si.ti_clat]
	mov	al,[si.ti_clch]
	test	[si.ti_flag],_T_USESTYLE
	jz	tiputl_nostyle
	;test	[si.ti_flag],_T_LINEBUF
	;jz	tiputl_nostyle
	mov	ah,[si.ti_stat]
	mov	al,[si.ti_stch]
    tiputl_nostyle:
  else
	mov	ah,[si.ti_clat]
	mov	al,[si.ti_clch]
  endif
	push	ss
	pop	es
	lea	dx,wc
	mov	di,dx
	mov	cx,MAXSCRLINE
	cld
	rep	stosw
	mov	di,dx
  ifdef __EDIT__
	mov	ax,line
	call	tigetline
	mov	loff,ax
	mov	lseg,dx
	jz	tiputl_screen
  else
	mov	ax,[si.ti_bpax]
	mov	dx,[si.ti_bpdx]
	mov	loff,ax
	mov	lseg,dx
  endif
	push	dx
	push	ax
	push	ss
	lea	bx,lb
	push	bx
	push	dx
	add	ax,[si.ti_boff]
	push	ax
	push    MAXSCRLINE
	call	memcpy
	mov	[bx+MAXSCRLINE],cl
	call	strlen
	mov	es,dx
	mov	llen,ax
	cmp	ax,[si.ti_boff]
	jbe	tiputl_color
	xchg	si,bx
	mov	cx,MAXSCRLINE
    tiputl_cl:
	lodsb
	or	al,al
	jz	tiputl_break
	cmp	al,9
	jne	tiputl_sto
	test	[bx.ti_flag],_T_SHOWTABS
	jnz	tiputl_sto
	mov	al,' '
    tiputl_sto:
	stosb
	inc	di
	dec	cx
	jnz	tiputl_cl
    tiputl_break:
	mov	si,bx
  ifdef __EDIT__
	test	[si.ti_flag],_T_USESTYLE
	jz	tiputl_color
	push	es
	mov	ax,loff
	mov	di,lseg
	lea	dx,wc
	mov	cx,llen
	mov	bx,line
	call	tistyle
	pop     es
  endif
    tiputl_color:
  ifdef __CLIP__
	xor	ax,ax
	mov	clen,ax		; clip end to   0000
	dec	ax		; clip start to FFFF
	mov	clst,ax
	call	tiselected
	jz	tiputl_screen
  ifdef __EDIT__
	xor	dx,dx
	cmp	[si.ti_bpax],dx
	jne	tiputl_local
	mov	ax,line
	cmp	ax,[si.ti_clsl]
	jb	tiputl_screen
	je	tiputl_clst
	cmp	ax,[si.ti_clel]
	ja	tiputl_screen
	mov	clst,dx
	je      tiputl_clen
	dec	dx
	mov	clen,dx
	jmp	tiputl_clput
    tiputl_clen:
	mov	ax,[si.ti_cleo]
	mov	clen,ax
	jmp	tiputl_clput
    tiputl_clst:
	dec	dx
	mov	clen,dx
	cmp	ax,[si.ti_clel]
	mov	ax,[si.ti_clso]
	mov	clst,ax
	je	tiputl_clen
	jmp	tiputl_clput
    tiputl_local:
  endif
	mov	ax,[si.ti_clso]
	add	ax,[si.ti_bpax]
	mov	clst,ax
	mov	ax,[si.ti_cleo]
	add	ax,[si.ti_bpax]
	mov	clen,ax
    tiputl_clput:
	mov	cx,MAXSCRLINE
	lea	di,wc+1
	mov	al,at_background[B_DarkGray]
	mov	bx,loff
	add	bx,[si.ti_boff]
	mov	dx,clst
    tiputl_cloop:
	cmp	bx,dx
	jb	tiputl_noat
	cmp	bx,clen
	jae	tiputl_screen
	stosb
	jmp	tiputl_inc
    tiputl_noat:
	inc	di
    tiputl_inc:
	inc	bx
	inc	di
	dec	cx
	jnz	tiputl_cloop
  endif
    tiputl_screen:
	mov	bx,[si.ti_xpos]
	mov	ax,[si.ti_ypos]
	mov	bh,al
  ifdef __EDIT__
	mov	ax,line
	sub	ax,[si.ti_loff]
	add	bh,al
  endif
	call	@getxyp
	mov	di,bx
	mov	cx,[si.ti_cols]
	lea	si,wc
	assert	cx,MAXSCRLINE,jna,"tiputl"
	rep	movsw
  ifdef __MOUSE__
	call	mouseshow
  endif
	xor	ax,ax
	pop	di
	pop	si
	ret
tiputl	ENDP

tiputs	PROC
	call	tisetcursor
  ifdef __EDIT__
	push	si
	push	di
	mov	di,tinfo
	mov	si,[di.ti_rows]
	mov	di,[di.ti_loff]
	or	si,si
	jnz	tiputs_next
	inc	si
    tiputs_next:
	mov	ax,di
	call	tiputl
	inc	di
	dec	si
	jnz	tiputs_next
	pop	di
	pop	si
  else
	xor	ax,ax
	call	tiputl
  endif
	ret
tiputs	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ifdef __EDIT__

tipadtooff PROC
	push	di
	call	ticurlp
	mov	di,ax
	add	di,cx
	mov	cx,[bx.ti_boff]
	add	cx,[bx.ti_xoff]
	sub	cx,[bx.ti_bcnt]
	DADD	ax,[bx.ti_bcol]
	DSUB	ax,di
	assert	cx,[bx.ti_bcol],jb,"tipad"
	push	di
	push	cx
	mov	es,dx
	mov	ax,' '
	cld
	rep	stosb
	mov	al,ah
	stosb
	pop	cx
	pop	di
	test	[bx.ti_flag],_T_OPTIMALFILL
	jz	tipadtooff_end
	mov	al,9
    tipadtooff_09h:
	cmp	cx,8
	jb	tipadtooff_end
	stosb
	add	di,7
	sub	cx,8
	jmp	tipadtooff_09h
    tipadtooff_end:
	pop	di
	ret
tipadtooff ENDP

tistrlen PROC
	push	es
	push	si
	push	di
	mov	es,dx
	mov	si,ax
	mov	di,ax
	xor	ax,ax
	add	di,[bx.ti_bcol]
	dec	di
	mov	es:[di],al	; line[bcol - 1] = 0;
	mov	di,si
	mov	cx,ax
	dec	cx
	cld
	repnz	scasb
	not	cx
	dec	cx
	mov	[bx.ti_bcnt],cx
	mov	ax,si
	pop	di
	pop	si
	pop	es
	ret
tistrlen ENDP

tistripl PROC
	push	es
	push	si
	push	di
	mov	si,ax
	push	dx
	push	ax
	call	strlen
	mov	di,si
	add	di,ax
	mov	cx,ax
	mov	ax,[bx.ti_flag]
	test	ax,_T_LINEBUF
	jz	tistripl_end
	test	ax,_T_USECONTROL
	jnz	tistripl_end
    tistripl_len:
	dec	di
	cmp	di,si
	jb      tistripl_end
	mov	al,es:[di]
	cmp	al,9
	je	tistripl_do
	cmp	al,' '
	jne	tistripl_end
    tistripl_do:
	mov	byte ptr es:[di],0
	dec	cx
	jnz	tistripl_len
    tistripl_end:
	or	cx,cx
	mov	[bx.ti_bcnt],cx
	mov	ax,si
	pop	di
	pop	si
	pop	es
	ret
tistripl ENDP

tixchgl	PROC
	push	si
    tixchgl_get:
	push	ax
	call	tigetline
	mov	cx,[bp-2]
	mov	es,dx
	mov	di,ax
	mov	si,bp
	jc	tixchgl_eof
	shr	cx,1
    tixchgl_xchg:
	mov	ax,es:[di]
	movsw
	mov	[si-2],ax
	dec	cx
	jnz	tixchgl_xchg
	pop	ax
	inc	ax
	jmp	tixchgl_get
    tixchgl_eof:
	jz	tixchgl_end
	shr	cx,1
    tixchgl_lup:
	mov	ax,es:[di]
	movsw
	mov	[si-2],ax
	dec	cx
	jnz	tixchgl_lup
	inc	cx
    tixchgl_end:
	pop	ax	; return last line + 1 or -1
	pop	si
	ret
tixchgl ENDP

tinsline PROC		; AX current line - insert line + 1
	push	si
	push	di
	push	bp
	mov	bx,ax
	mov	si,tinfo
	mov	ax,[si.ti_bcol]
	sub	sp,ax
	mov	bp,sp
	push	ax
	push	ss
	push	bp
	push	ax
	call	memzero
	mov	ax,[si.ti_lcnt]
	cmp	ax,[si.ti_brow]
	jae	tinsline_eof
	mov	ax,bx
	inc	ax
	call	tixchgl
	cmp	ax,[si.ti_lcnt]
	jne	tinsline_eof
	inc	[si.ti_lcnt]	; ZF clear
    tinsline_end:
	add	sp,[bp-2]
	pop	cx
	or	ax,ax
	pop	bp
	pop	di
	pop	si
	ret
    tinsline_eof:
	xor	ax,ax
	jmp     tinsline_end
tinsline ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

iflines PROC	; do if lines
	mov	bx,tinfo
	test	[bx.ti_flag],_T_LINEBUF
	jnz	iflines_end
	pop	ax
	jmp	tiretevent
    iflines_end:
	ret
iflines	ENDP

tiup	PROC
	call	iflines
	xor	ax,ax
	cmp	ax,[bx.ti_yoff]
	je	tiup_line
	dec	[bx.ti_yoff]
	ret
    tiup_line:
	cmp	ax,[bx.ti_loff]
	je	tiup_end
	dec	[bx.ti_loff]
    tiup_end:
	ret
tiup	ENDP

tidown	PROC
	call	iflines
	mov	dx,[bx.ti_loff]
	mov	cx,[bx.ti_yoff]
	mov	ax,dx
	add	ax,cx
	inc	ax
	cmp	ax,[bx.ti_brow]
	jae	tidown_end
	cmp	ax,[bx.ti_lcnt]
	jb	tidown_inc
	jmp	ticontinue
    tidown_inc:
	mov	ax,[bx.ti_rows]
	dec	ax
	cmp	cx,ax
	jae	tidown_line
	inc	[bx.ti_yoff]
	jmp	ticontinue
    tidown_line:
	mov	ax,[bx.ti_brow]
	sub	ax,dx
	sub	ax,cx
	jz	tidown_end
	dec	ax
	jz	tidown_end
	inc	[bx.ti_loff]
	jmp	ticontinue
    tidown_end:
	jmp	tiretevent
tidown	ENDP

tictrlend PROC
	call	iflines
	mov	ax,[bx.ti_lcnt]
	xor	dx,dx
    tictrlend_loop:
	dec	ax
	jz	tictrlend_end
	cmp	dx,[bx.ti_rows]
	jnb	tictrlend_end
	inc	dx
	jmp	tictrlend_loop
    tictrlend_end:
	dec	dx
	mov	[bx.ti_loff],ax
	mov	[bx.ti_yoff],dx
	jmp	ticontinue
tictrlend ENDP

tictrlhome PROC
;	call	iflines
	mov	bx,tinfo
	xor	ax,ax
	mov	[bx.ti_loff],ax
	mov	[bx.ti_yoff],ax
	jmp	tihome
tictrlhome ENDP

tipgup	PROC
	call	iflines
	mov	ax,[bx.ti_loff]
	or	ax,ax
	jz	tipgup_home
	cmp	ax,[bx.ti_rows]
	jb	tipgup_home
	sub	ax,[bx.ti_rows]
	mov	[bx.ti_loff],ax
	jmp	ticontinue
    tipgup_home:
	jmp	tictrlhome
tipgup	ENDP

tipgdn	PROC
	call	iflines
	mov	ax,[bx.ti_rows]
	add	ax,ax
	add	ax,[bx.ti_loff]
	cmp	ax,[bx.ti_lcnt]
	jnb	tipgdn_end
	mov	ax,[bx.ti_loff]
	add	ax,[bx.ti_rows]
	mov	[bx.ti_loff],ax
	jmp	ticontinue
    tipgdn_end:
	jmp	tictrlend
tipgdn	ENDP

tienterni PROC
	push	si
	push	di
	push	bp
	mov	si,tinfo
	mov	bx,[si.ti_brow]
	mov	ax,[si.ti_loff]
	add	ax,[si.ti_yoff]
	mov	di,ax
	inc	ax
	cmp	ax,bx
	mov	ax,_TI_RETEVENT
	jb	tienterni_do
	dec	bx
	jz	tienterni_end
    tienterni_nocando:
	call	nocando
	jmp	tienterni_end
    tienterni_CONTINUE:
	mov	ax,_TI_CONTINUE
    tienterni_end:
	pop	bp
	pop	di
	pop	si
	ret
    tienterni_do:
	mov	ax,di
	call	tinsline
	jz	tienterni_nocando
	mov	cx,[si.ti_bcol]
	or	[si.ti_flag],_T_MODIFIED
	sub	sp,cx
	mov	bp,sp
	call	ticurcp
	push	dx
	push	ax
	push	ss
	push	bp
	push	dx
	push	ax
	call	strcpy
	pop	bx
	pop	es
	xor	ax,ax
	mov	es:[bx],al
	mov	ax,di
	inc	ax
	call	tigetline
	jz	tienterni_home
	push	dx
	push	ax
	push	ss
	push	bp
	call	strcpy
	call	tixxxup
    tienterni_home:
	add	sp,[si.ti_bcol]
	call	tihome
	call	tidown
	jmp	tienterni_end
tienterni ENDP

tienter	PROC
	call	iflines
	push	si
	push	di
	call	tienterni
	cmp	ax,_TI_CONTINUE
	je	tienter_indent
	cmp	ax,_TI_RETEVENT
	je	tienter_ret
	jmp	tienter_end
    tienter_indent:
	mov	si,tinfo
	mov	ax,[si.ti_flag]
	and	ax,_T_USEINDENT
	jz	tienter_end
	mov	ax,[si.ti_loff]
	add	ax,[si.ti_yoff]
	dec	ax
	call	tigetline
	jz	tienter_end
	mov	es,dx
	mov	di,ax
	add	ax,[si.ti_bcol]
	mov	dx,ax
	xor	cx,cx
    tienter_lup:
	mov	al,es:[di]
	call	isspace
	jz	tienter_break
	inc	cx
	inc	di
	cmp	di,dx
	jb	tienter_lup
    tienter_break:
	or	cx,cx
	jz	tienter_end
	mov	di,cx
    tienter_lop:
	mov	ax,[si.ti_xoff]
	add	ax,[si.ti_boff]
	push	ax
	mov	al,' '
	call	tiputc
	cmp	ax,_TI_CONTINUE
	pop	dx
	jne	tienter_end
	mov	ax,[si.ti_xoff]
	add	ax,[si.ti_boff]
	cmp	ax,dx
	je	tienter_end
	dec	di
	jnz	tienter_lop
    tienter_end:
	pop	di
	pop	si
	jmp	ticontinue
    tienter_ret:
	pop	di
	pop	si
	jmp	tiretevent
tienter	ENDP

endif

timodal	PROC
	push	si
	push	di
	mov	si,_TI_CONTINUE
    timodal_idle:
	call	tiseto
	call	tiputs
	cmp	si,_TI_RETEVENT
	je	timodal_break
	call	tgetevent
  ifdef __CLIP__
	call	ticlipevent
  endif
	mov	di,ax
	call	tievent
	mov	si,ax
	jmp	timodal_idle
    timodal_break:
	call	ticurlp
	push	dx
	push	ax
	call	strlen
	mov	[bx.ti_bcnt],ax
	mov	ax,di
	pop	di
	pop	si
	ret
timodal	ENDP

_TEXT	ENDS

	END
