include	doszip.inc
include stdio.inc
include	string.inc
include	ini.inc
include	io.inc
include	iost.inc
include	dos.inc
include	disk.inc
include	errno.inc
include	conio.inc
include tinfo.inc
include	mouse.inc
include	progress.inc

ifndef DEBUG
__INI_LOAD__	= 1	; DZ.INI: [Load]
endif

ifdef DEBUG
 DEBUG_PROCESS	= 1	; load a fake DZ.EXE for debug
endif
	public	dzmain
	public	_stklen
	public	_bufin
	public	bufin_
	public	comspec
	public	envpath
	public	envtemp
	public	dzexe
	public	dzcount
	public	numfblock
	public	mainswitch
	public	dzexitcode
	public	configfile
	public	configextp
	public	programpath
	public	argvfile

	extrn	_argc:word
	extrn	_argv:word
	extrn	dzmodal:near
	extrn	menusinit_OIDD:near
	extrn	com_info:S_TINFO

	.186

_DATA	SEGMENT

_stklen	dw	4000h

ifdef DEBUG_PROCESS
cp_debugprocess	DB 'Execute command:',10,'%s %s',0
endif
	db	13,10
	db	13,10
	db	'The Doszip Commander Version ', DOSZIP_VSTR, ',', 13,10
_bufin	db	'Copyright (c) 1996-2010 Hjort Nidudsson', 13,10
	db	13,10
	db	'http://sourceforge.net/projects/doszip/', 13,10
	db	13,10
	db	'Hjort Nidudsson - nidud@users.sourceforge.net',13,10
	db	'Robert Riebisch - bttr@users.sourceforge.net',13,10
	db	13,10
	db	'A special thanks to Kennedy Software & Systems',13,10
	db	'Ltd in Dublin for technical support and advice',13,10
	db	13,10
	db	13,10

cp_usage label byte
	db 'Command line switches',10
	db ' The following switches may be used in the command line:',10
	db 10
	db '  -T (tiny)  - read maximum 500 files in each panel',10
	db '  -L (large) - read maximum 5000 files in each panel',10
	db '     default is 3000.',10
	db 10
	db '  -XP (WinXP)     - trigger a mode change on startup', 10
	db '  -C<config_path> - Read/Write setup from/to <config_path>',10
	db 10
	db '  DZ <filename> command starts DZ and forces it to show <filename>',10
	db 'contents if it is an archive or show folder contents if <filename>',10
	db 'is a folder.',10,0

	db 13,10

default_ini label byte
	db '; DZ.INI - DOSZIP Configuration file',10
	db ';',10
	db '; This file contains all the variables that "customize"',10
	db '; DOSZIP to your particular needs.',10
	db ';',10
	db '; The entries have the following format:',10
	db ';',10
	db '; [<Section name>]',10
	db '; <Entry name>=<properties>',10
	db ';',10
	db '; Space and tabs may appear before or after the equal sign.',10
	db ';',10
	db '; Last Updated: 20 Aug 2011',10
	db ';',10

	db '[View]',10
	db 'F3      = ; You can override the internal viewer by redefine F3',10
	db 'Alt     = ; Viewer for Alt+F3',10
	db 'Ctrl    = ; Viewer for Ctrl+F3',10
	db 'Shift   = ; Viewer for Shift+F3',10
	db 10

	db '[Edit]',10
	db 'F4      = edit',10
	db 'Alt     = notepad',10
	db 'Ctrl    = ; Editor for Ctrl+F4',10
	db 'Shift   = ; Editor for Shift+F4',10
	db 10

	db '[Filetype]',10
	db 'txt     = edit',10
	db 'idd     = rcedit',10
	db '; Borland C++ v3.1',10
	db 'asm     = bc ~!.!~',10
	db '; Open Watcom Make',10
	db 'mak     = wmake -f',10
	db 'makefile= wmake -f',10
	db 10

	db '[Directory] ; Directories for Ctrl-[0..9] and Alt-P',10
	db '00=Doszip &Directory          Ctrl-0, %doszip%',10
	db '01=<>',10
	db '02=System &Root               Ctrl-2, %SYSTEMROOT%',10
	db '03=&Program Files             Ctrl-3, %PROGRAMFILES%',10
	db '04=&Home Path                 Ctrl-4, %HOMEDRIVE%%HOMEPATH%',10
	db '05=&User Profile              Ctrl-5, %USERPROFILE%',10
	db '06=<>',10
	db '07=&Temp Directory            Ctrl-7, %TEMP%',10
	db 10

	db '[Tools] ; Tools [0..9] use key Alt-[0..9]',10
	db '00=&Add tool                   Alt-0, %edit% %doszip%\dz.ini',10
	db '01=<>',10
	db '02=&Doszip Commandline         Alt-2, %doszip%\dz -?',10
	db '03=&View DZ.INI                Alt-3, %view% %doszip%\dz.ini',10
	db '04=View &README.TXT            Alt-4, %view% %doszip%\doszip.txt',10
	db 10

	db '[Filter]',10
	db '00=&Executable, *.exe *.com *.bat',10
	db '01=&Compressed, *.lzh *.zoo *.zip *.arj *.pak *.arc *.7z *.bz2 *.tar',10
	db '02=&Source code, *.asm *.inc *.c *.h',10
	db 10

	db '[Load]',10
	db '00=; Program(s) to load on startup',10
	db '01=;',10
	db 10

ifdef __EDIT__
	db '; Internal editor',10
	db '[at_debug]',10
	db '00=attrib',10
	db '01=07 FAh',10
	db '[at_blue]',10
	db '00=attrib',10
	db '01=17',10
	db '[at_black]',10
	db '00=attrib',10
	db '01=07',10
	db '[control]',10
	db '00=control',10
	db '01=40',10
	db '[quote]',10
	db '00=quote',10
	db '01=XB',10
	db '[number]',10
	db '00=number',10
	db '01=XB',10
	db '[operator]',10
	db '00=char',10
	db '01=XF',10
	db '02=&.:<({[*+-=]})>?!%,',10
	db '[ifdef]',10
	db '00=start',10
	db '01=X2',10
	db '02=if else ifdef ifndef endif',10
	db '[#]',10
	db '00=start',10
	db '01=X2',10
	db '02=#',10
	db '[//]',10
	db '00=start',10
	db '01=X8',10
	db '02=//',10
	db '[comment]',10
	db '00=start',10
	db '01=X8',10
	db '02=";"',10
	db '[/**/]',10
	db '00=nested',10
	db '01=X8',10
	db '02=/* */',10
	db '[include]',10
	db '00=start',10
	db '01=X2',10
	db '02=include',10
	db '[segment]',10
	db '00=word',10
	db '01=X5',10
	db '02=cs ds es ss',10
	db '[c_keyword]',10
	db '00=word',10
	db '01=XF',10
	db '02=const operator char int long void',10
	db '03=if else for do while break continue goto return',10
	db '04=switch case default public extern',10
	db 10
	db '[common]',10
	db '00=control',10
	db '01=quote',10
	db '02=number',10
	db '03=operator',10
	db 10
	db '[common_asm]',10
	db '00=at_black',10
	db '01=[common]',10
	db '02=include',10
	db '03=segment',10
	db '04=comment',10
	db '[common_c]',10
	db '00=at_blue',10
	db '01=[common]',10
	db '02=c_keyword',10
	db '03=//',10
	db '04=#',10
	db '05=/**/',10
	db 10
	db '[file_*]',10
	db '00=[common]',10
	db '[file_ini]',10
	db '00=[common_asm]',10
	db '[file_asm]',10
	db '00=[common_asm]',10
	db '[file_inc]',10
	db '00=[common_asm]',10
	db '[file_c]',10
	db '00=[common_c]',10
	db '[file_h]',10
	db '00=[common_c]',10
	db 10
endif

if USE_PACKER
	db '[Packer]',10
	db '00=ZIP',10
	db '01=7Z',10
	db '02=TAR',10
	db '03=BZ2',10
	db '04=GZ',10
	db '05=ARJ',10
	db '06=ARC',10
	db '07=PAK',10
	db '08=LZH',10
	db '09=ZOO',10
	db 10
	db '[ZIP]',10
	db '00=pkzip -u -wHS',10
	db '01=pkzip -u -P -wHS',10
	db '02=pkunzip -o',10
	db '03=pkunzip -o -d',10
	db '04=pkzip -d',10
	db '05=-ex',10
	db '06=-es',10
	db '07=-s',10
	db '09=@',10
	db '10=7za u -tzip -y',10
	db '11=7za u -tzip -y',10
	db '12=7za e -y',10
	db '13=7za x -y',10
	db '14=7za d -y',10
	db '15=-mx9',10
	db '16=-mx1',10
	db '17=-p',10
	db '18=-o',10
	db '19=-scsDOS @',10
	db 10
	db '[7Z]',10
	db '10=7za u -y',10
	db '11=7za u -y',10
	db '12=7za e -y',10
	db '13=7za x -y',10
	db '17=-p',10
	db '18=-o',10
	db '19=-scsDOS @',10
	db 10
	db '[TAR]',10
	db '10=7za u -ttar -y',10
	db '11=7za u -ttar -y',10
	db '12=7za e -y',10
	db '13=7za x -y',10
	db '17=-p',10
	db '18=-o',10
	db '19=-scsDOS @',10
	db 10
	db '[BZ2]',10
	db '10=7za u -tbzip2 -y',10
	db '11=7za u -tbzip2 -y',10
	db '12=7za e -y',10
	db '13=7za x -y',10
	db '17=-p',10
	db '18=-o',10
	db '19=-scsDOS @',10
	db 10
	db '[GZ]',10
	db '10=7za u -tgzip -y',10
	db '11=7za u -tgzip -y',10
	db '12=7za e -y',10
	db '13=7za x -y',10
	db '17=-p',10
	db '18=-o',10
	db '19=-scsDOS @',10
	db 10
	db '[ARJ]',10
	db '00=arj u -y',10
	db '01=arj u -y',10
	db '02=arj e -y -e',10
	db '03=arj x -y',10
	db '05=-m4',10
	db '06=-m1',10
	db '07=-g',10
	db '09=!',10
	db 10
	db '[ARC]',10
	db '00=arc a',10
	db '01=arc a',10
	db '02=arc eow',10
	db '03=arc xow',10
	db '09=@',10
	db 10
	db '[PAK]',10
	db '00=pak u',10
	db '01=pak u',10
	db '02=pak e -wa',10
	db '03=pak e -i -wa',10
	db '05=/C',10
	db '06=/CR',10
	db '09=@',10
	db 10
	db '[LZH]',10
	db '00=lharc u -am',10
	db '01=lharc a -apm',10
	db '02=lharc e -m',10
	db '03=lharc e -m',10
	db 10
	db '[ZOO]',10
	db '00=zoo -add',10
	db '01=zoo -add',10
	db '02=zoo -extract',10
	db '03=zoo -extract',10
	db '04=zoo -delete',10
	db '09=@',10
	db 10
endif
	db '[%%EOF]',10
	db  0

cp_dz		db 'DZ',0
cp_temp		db 'TEMP',0
cp_path		db 'PATH',0
cp_comspec   	db 'COMSPEC',0
cp_ercfgpath 	db 'Error open config path: %s',10,10,0
cp_ercomspec 	db 'Error loading COMMAND.COM',10,0

ifndef __EDIT__
	db	1000h - ($ - _bufin) dup(?)
endif

bufin_	dw	0
envconf	dd	0
envtemp	dd	0
envpath	dd	0
comspec	dd	0
dzexe	dd	0
dzerrno	dw	0
dzerflag dw	0
dzcount	dw	0
mainswitch dw	0
dzexitcode dw	0
numfblock dw	MAXFBLOCK
programpath db	0
	db	MAXPATH-1 dup(0)
configfile db	0
	db	MAXPATH-1 dup(0)
configextp dw	0
argvfile dw	0
cp_dzdot db	'dz.',0
defcomspec db	'COMMAND',0
cp_load db	'Load',0

ifdef USE_MEMCONFIG
 memcfg	dd	0
 public	memcfg
endif

ifdef DEBUG_PROCESS
VECTOR label word
	dd	50495A44h
	dw	$ + 512
	dw	SEG _DATA
	db 1024 dup(0)
endif

_DATA	ENDS

_DZIP	SEGMENT

ioupdate PROC DIST	; stream:BYTE
	push	bp
	mov	bp,sp
	cmp	byte ptr [bp+ARG1],1
	je	ioupdate_stdo
	push	STDI.ios_total_dx
	push	STDI.ios_total_ax
	jmp	ioupdate_upd
    ioupdate_stdo:
	push	STDO.ios_total_dx
	push	STDO.ios_total_ax
    ioupdate_upd:
	call	progress_update
	or	ax,ax
	mov	ax,1
	jz	ioupdate_end
	dec	ax
    ioupdate_end:
	pop	bp
	ret	2
ioupdate ENDP

cmp_envstring PROC
	push	di
    cmp_next:
	mov	ah,es:[di]
	lodsb
	inc	di
	cmp	al,ah
	je	cmp_next
	add	al,ah
	cmp	al,'='
	pop	di
	ret
cmp_envstring ENDP

cmp_environ PROC
	mov	si,offset cp_dz
	call	cmp_envstring
	jnz	cmp_temp
	mov	si,offset envconf
	mov	ax,3
	jmp	cmp_found
    cmp_temp:
	mov	si,offset cp_temp
	call	cmp_envstring
	jnz	cmp_path
	mov	si,offset envtemp
	mov	ax,5
	jmp	cmp_found
    cmp_path:
	mov	si,offset cp_path
	call	cmp_envstring
	jnz	cmp_comspec
	mov	si,offset envpath
	mov	ax,5
	jmp	cmp_found
    cmp_comspec:
	mov	si,offset cp_comspec
	call	cmp_envstring
	jnz	cmp_end
	mov	si,offset comspec
	mov	ax,8
    cmp_found:
	add	ax,di
	mov	[si],ax
	mov	[si+2],es
    cmp_end:
	ret
cmp_environ ENDP

get_environ PROC
	mov	ax,envseg
	mov	es,ax
	xor	di,di
	mov	cx,7FFFh
	cld
    environ_loop:
	call	cmp_environ
	mov	al,0
	repnz	scasb
	cmp	es:[di],al
	jnz	environ_loop
	ret
get_environ ENDP

init_args PROC
	mov	si,ax
    args_loop:
	mov	bx,si
	shl	bx,2
	add	bx,_argv
	mov	bx,[bx]
	mov	al,[bx]
	cmp	al,'?'
	je	arg_?
	cmp	al,'/'
	je	arg_x
	cmp	al,'-'
	je	arg_x
	mov	argvfile,bx
	jmp	next_arg
    arg_x:
	inc	bx
	mov	al,[bx]
	or	al,20h
	cmp	al,'x'
	jne	arg_t
	mov	ax,dzcount
	or	ax,ax
	jnz	next_arg
	mov	ax,0003h
	int	10h
	call	_screct
	jmp	next_arg
    arg_t:
	cmp	al,'t'
	jne	arg_l
	mov	numfblock,500
	jmp	next_arg
    arg_l:
	cmp	al,'l'
	jne	arg_c
	mov	numfblock,5000
	jmp	next_arg
    arg_c:
	cmp	al,'c'
	jne	arg_?
	inc	bx
	push	es
	push	bx
	push	es
	push	bx
	call	filexist
	cmp	ax,2
	pop	ax
	pop	dx
	jne	arg_?
	push	ds
	push	offset programpath
	push	dx
	push	ax
	call	strcpy
	jmp	next_arg
    arg_?:
	mov	ax,offset cp_usage
	call	@printf
	push	0
	call	exit
    next_arg:
	inc	si
	cmp	si,_argc
	jae	end_args
	jmp	args_loop
    end_args:
	ret
init_args ENDP

copy_axdi PROC
	push	ds
	push	ax
	push	ds
	push	di
	call	strcpy
	xor	ax,ax
	ret
copy_axdi ENDP

test_path PROC
	mov	ax,[si]
	or	al,al
	jz	test_path_02
	cmp	al,'\'
	je	test_path_03
	cmp	ah,':'
	jne	test_path_02
	and	al,not 20h
	sub	al,'A'
	mov	ah,0
	push	ax
	call	_disk_type
	or	ax,ax
	jz	test_path_02
    test_path_00:
	mov	al,[si]
	call	@drvexist
	jz	test_path_01
	push	ds
	push	si
	call	filexist
	or	ax,ax
	jnz	test_path_03
	push	ds
	push	si
	push	'\'
	call	strrchr
	jz	test_path_01
	mov	bx,ax
	mov	ax,3A00h
	cmp     [bx-1],ah
	je	test_path_01
	mov	[bx],al
	cmp	sys_erflag,al
	je	test_path_00
    test_path_01:
	call	trace
    test_path_02:
	mov	ax,si
	call	copy_axdi
	ret
    test_path_03:
	xor	ax,ax
	inc	ax
	ret
test_path ENDP

init_panels PROC
	xor	ax,ax
	mov	di,offset cp_stdmask
	cmp	path_a.wp_mask,al
	jnz	ipanels_00
	mov	ax,offset path_a.wp_mask
	call	copy_axdi
    ipanels_00:
	cmp	path_b.wp_mask,al
	jnz	ipanels_01
	mov	ax,offset path_b.wp_mask
	call	copy_axdi
    ipanels_01:
  ifdef __LFN__
	test	console,CON_IOLFN
	jnz	ipanels_02
	mov	_ifsmgr,ax
    ipanels_02:
	cmp	_ifsmgr,ax
	jnz	ipanels_03
  endif
	and	path_a.wp_flag,not _W_LONGNAME
	and	path_b.wp_flag,not _W_LONGNAME
    ipanels_03:
	cmp	dzcount,ax
	jnz	ipanels_08
	cmp	argvfile,ax
	jz	ipanels_08
	push	ds
	push	argvfile
	push	ax
	call	access
	or	ax,ax
	jnz	ipanels_08
	and	cx,_A_SUBDIR
	jz	ipanels_07
    ipanels_04:
	and	cflag,not _W_PANELID
	mov	bx,argvfile
	mov	dx,':'
	cmp	[bx+1],dl
	jne	ipanels_05
	mov	dl,[bx]
	or	dl,20h
	sub	dl,'a'
	mov	ah,0Eh
	int	21h
    ipanels_05:
	push	ds
	push	argvfile
	call	chdir
    ipanels_06:
	push	ds
	push	offset path_a.wp_path
	push	0
	call	fullpath
	jmp	ipanels_08
    ipanels_07:
	push	ds
	push	argvfile
	call	readword
	cmp	ax,4B50h
	je	ipanels_09
	xor	ax,ax
    ipanels_08:
	ret
    ipanels_09:
	and	path_a.wp_flag,not _W_ARCHIVE
	and	path_b.wp_flag,not _W_ARCHIVE
	or	path_a.wp_flag,_W_VISIBLE or _W_ARCHZIP
	mov	path_a.wp_arch,0
	push	ds
	push	argvfile
	call	strfn
	push	dx
	push	ax
	push	ds
	push	offset path_a.wp_file
	push	dx
	push	ax
	call	strcpy
	pop	ax
	pop	dx
	cmp	ax,argvfile
	je	ipanels_10
	mov	es,dx
	dec	ax
	mov	bx,ax
	xor	al,al
	mov	es:[bx],al
	jmp	ipanels_04
    ipanels_10:
	and	cflag,not _W_PANELID
	jmp	ipanels_06
init_panels ENDP

dzmain	PROC DIST
	call	get_environ
	call	menusinit_OIDD
  ifdef DEBUG_PROCESS
	mov	word ptr dzexe,offset VECTOR
	mov	word ptr dzexe+2,ds
  endif
	les	bx,dzexe
  ifndef DEBUG_PROCESS
	add	bx,03C4h
	les	bx,es:[bx]
  endif
	mov	si,es:[bx]
	mov	di,es:[bx+2]
	mov	ax,es:[bx+6]
  ifdef USE_MEMCONFIG
	mov	dx,bx
	add	dx,8
  endif
	mov	bx,es:[bx+4]
	mov	es,ax
	cmp	di,5049h
	jne	dzmain_00
	cmp	si,5A44h
	jne	dzmain_00
  ifdef USE_MEMCONFIG
	mov	word ptr memcfg,dx
	mov	word ptr memcfg+2,es
  endif
	mov	word ptr dzexe,bx
	mov	word ptr dzexe+2,es
	add	bx,208
	mov	ax,es:[bx]
	mov	dzerrno,ax
	mov	ax,es:[bx+2]
	mov	dzerflag,ax
	mov	ax,es:[bx+4]
	mov	dzcount,ax
    dzmain_00:
	push	ds
	push	offset programpath
	mov	bx,_argv
	push	ds
	push	word ptr [bx]
	call	strcpy
	push	dx
	push	ax
	push	'\'
	call	strrchr
	jz	dzmain_01
	mov	bx,ax
	mov	byte ptr [bx],0
    dzmain_01:
	mov	ax,1
	cmp	ax,_argc
	jnb	dzmain_02
	call	init_args
    dzmain_02:
	push	ds
	push    offset configfile
	mov	ax,word ptr envconf
	mov	dx,word ptr envconf+2
	or	ax,ax
	jz	dzmain_03
	push	dx
	push	ax
	push	dx
	push	ax
	call	filexist
	cmp	ax,2
	je	dzmain_04
	mov	ax,offset cp_ercfgpath
	call	@printf
	add	sp,4
    dzmain_03:
	push	ds
	push	offset programpath
    dzmain_04:
	push	ds
	push	offset cp_dzdot
	call	strfcat
	push	dx
	push	ax
	push	'.'
	call	strrchr
	inc	ax
	mov	configextp,ax
	call	config_read
	cmp	word ptr comspec,0
	jne	dzmain_05
	mov	ax,offset cp_ercomspec
	call	@printf
	mov	word ptr comspec,offset defcomspec
	mov	word ptr comspec+2,ds
    dzmain_05:
	call	getinifile
	push	dx
	push	ax
	call	filexist
	or	ax,ax
	jnz	dzmain_06
	;
	; virgin call..
	;
	call	getinifile
	push	dx
	push	ax
	push	_A_NORMAL
	push    M_WRONLY
	push	A_CREATE or A_TRUNC
	call	osopen
	inc	ax
	jz	dzmain_06
	dec	ax
	push	ax
	push	ax
	mov	bx,ax
	or	_osfile[bx],FH_TEXT
	push	ds
	push	offset default_ini
	push	ds
	push	offset default_ini
	call	strlen
	push	ax
	call	write
	call	close
	mov	config.c_cel_indexa,5
  ifdef __LFN__
	xor	ax,ax
	cmp	_ifsmgr,ax
	je	dzmain_06
	or	path_a,_W_LONGNAME
	or	path_b,_W_LONGNAME
  endif
    dzmain_06:
	LPUSH	cs
	push	offset cmhelp
	call	thelpinit
	LMOV	ax,cs
	LMOV	word ptr oupdate+2,ax
	mov	word ptr oupdate,offset ioupdate
	mov	ax,numfblock
	mov	wsmaxfbb,ax
	mov	wsmaxfba,ax
	call	setconfirmflag
	mov	bx,offset config.c_pending_file
	cmp	byte ptr [bx],0
	jz	dzmain_07
	push	ds
	push	bx
	call	removefile
	mov	config.c_pending_file,0
    dzmain_07:
	test	cflag,_C_DELTEMP
	jz	dzmain_08
	push	ds
	push	offset cp_ziplst
	call	removetemp
	push	ds
	push	offset cp_dzcmd
	call	removetemp
    dzmain_08:
	and	cflag,not _C_DELTEMP
  ifdef __INI_LOAD__
	cmp	dzcount,0
	jne	dzmain_open
	mov	di,offset _dsstack
	xor	si,si
	mov	[di],si
    dzmain_load:
	push	ds
	push	offset cp_load
	push	si
	call	inientryid
	jz	dzmain_eofload
	inc     si
	push	dx
	push	di
	push	dx
	push	ax
	call	strcat
	push	dx
	push	ax
	push	dx
	push	offset CRLF$
	call	strcat
	jmp	dzmain_load
    dzmain_eofload:
	or	si,si
	jz	dzmain_open
	push	ss
	push	di
	call	command
	mov	ax,23
  ifndef DEBUG
	ret
  endif
    dzmain_open:
  endif
	call	init_panels
	call	apiopen
	call	cursoroff
  ifdef __MOUSE__
	test	console,CON_MOUSE
	jz	dzmain_09
	call	mouseinit
	call	mouseon
  endif
    dzmain_09:
	call	history_open
	call	getinifile
	call	prect_open_ab
	mov	ax,offset spanelb
	cmp	cpanel,ax
	jne	dzmain_10
	mov	ax,offset spanela
    dzmain_10:
	call	panel_openmsg
	mov	di,offset programpath
	mov	si,offset path_a.wp_path
	call	test_path
	jnz	dzmain_11
	and	path_a,not _W_ARCHIVE
    dzmain_11:
	mov	si,offset path_b.wp_path
	call	test_path
	jnz	dzmain_12
	and	path_b,not _W_ARCHIVE
    dzmain_12:
	test	cflag,_C_COMMANDLINE
	jz	dzmain_13
	call	cursoron
    dzmain_13:
	call	panel_open_ab
	or	ax,ax
	jz	dzmain_14
  if USE_FILEFIND
	test	cflag,_C_SWAPFF
	jz	dzmain_modal
	call	cmsearch
	cmp	mainswitch,0
	jne	dzmain_14
    dzmain_modal:
  endif
  ifdef DEBUG_PROCESS
    dzmain_debug:
	call	dzmodal
	cmp	dzexitcode,23
	jne	dzmain_14
	mov	dzexitcode,0
	mov	mainswitch,0
	mov	dx,WORD PTR dzexe+2
	mov	ax,WORD PTR dzexe
	add	ax,82
	push	dx
	push	ax
	push	dx
	sub	ax,82
	push	ax
	mov	ax,offset defcomspec
	mov	dx,offset cp_debugprocess
	call	@stdmsg
	add	sp,8
	jmp	dzmain_debug
  else
	call	dzmodal
  endif
    dzmain_14:
	mov	ax,spanela.pn_fcb_index
	mov	config.c_fcb_indexa,ax
	mov	ax,spanela.pn_cel_index
	mov	config.c_cel_indexa,ax
	mov	ax,spanelb.pn_fcb_index
	mov	config.c_fcb_indexb,ax
	mov	ax,spanelb.pn_cel_index
	mov	config.c_cel_indexb,ax
	test	cflag,_C_AUTOSAVE
	jz	dzmain_15
	call	config_save
    dzmain_15:
	mov	ax,panela
	call	panel_close
	mov	ax,panelb
	call	panel_close
	call	apiclose
	push	0
	push	com_info.ti_ypos
	call	gotoxy
	call	history_close
	cmp	dzexitcode,23
	je	dzmain_16
	test	cflag,_C_SAVEHISTORY
	jnz	dzmain_16
	call	history_delete
    dzmain_16:
	mov	ax,dzexitcode
	ret
dzmain	ENDP

_DZIP	ENDS

	END
