include doszip.inc
include conio.inc
include io.inc
include malloc.inc
include string.inc
include stdio.inc
include tview.inc
include keyb.inc

	.186

	extrn	IDD_DZHISTOR:WORD

	public	history
	public	history_open
	public	history_close
	public	history_move
	public	history_save
	public	history_delete
	public	cmhistory
	public	doskey_save
	public	getcmdfile

	public	cmpathleft      ; Alt-Left  - Previous Directory
	public	cmpathright	; Alt-Right - Next Directory
	public	cmdoskey_up	; Alt-Up    - Previous Command
	public	cmdoskey_dn	; Alt-Down  - Next Command

	public	searchstring
	public	findfilemask
	public	filelist_bat
	public	format_lst
	public	mklist
	public	cp_selectmask

  if USE_TVCLASS
	public	tv_class
	public	tv_clversion
	public	tv_classsize
	public	tv_classrow
  endif

MAXDOSKEY	= 128
MAXDOSKEYS	= 16
HISTORY_MAX	= 16

S_DZPATH	STRUC
dzp_dir		db MAXPATH dup(?)
dzp_flag	dw ?
dzp_bufid	dw ?
dzp_celid	dw ?
S_DZPATH	ENDS

DOSKEY_SIZE	= MAXDOSKEYS * MAXDOSKEY
HISTORY_SIZE	= HISTORY_MAX * SIZE S_DZPATH

S_DZ_CMD	STRUC
hi_dzpath	db HISTORY_SIZE dup(?)
hi_doskey	db DOSKEY_SIZE dup(?)
hi_search	db 128 dup(?)
hi_ffmask	db 128 dup(?)
hi_filelist_bat	db 80 dup(?)
hi_format_lst	db 80 dup(?)
hi_mklist	S_MKLST <?>
hi_selectmask	db 32 dup(?)
if USE_TVCLASS
hi_clversion	dw ?
hi_classsize	dw ?
hi_classrow	dw ?
hi_class	S_CLASS CLCOUNT dup(?)
endif
S_DZ_CMD	ENDS

_DATA	SEGMENT

history		label dword
history_ax	dw ?
history_dx	dw ?

searchstring	db ?
		db 127 dup(0)
findfilemask    db '*.*',0
		db 124 dup(0)
filelist_bat	db 'filelist.bat',0
		db 80-13 dup(?)
format_lst	db '%f\n',0
		db 80-5 dup(?)
mklist		S_MKLST	<?,?,?,?,?,?,?,-1,?,?>
cp_selectmask	db 32 dup(?)
if USE_TVCLASS
tv_clversion	dw CLVERSION
tv_classsize	dw CLCOUNT
tv_classrow	dw CLCOUNT
tv_class	S_CLASS CLCOUNT dup(<'byte',1,CLTYPE_BYTE,CLFORM_HEX>)
endif

doskey_bindex db 0
doskey_isnext db 0

_DATA	ENDS

_DZIP	SEGMENT

getcmdfile PROC
	mov	bx,configextp
	mov	word ptr [bx],'mc'
	mov	word ptr [bx+2],'d'
	mov	dx,ds
	mov	ax,offset configfile
	ret
getcmdfile ENDP

history_delete PROC
	call	getcmdfile
	push	dx
	push	ax
	push	dx
	push	ax
	push	0
	call	setfattr
	call	remove
	ret
history_delete ENDP

history_open PROC
	push	SIZE S_DZ_CMD
	call	malloc
	jz	history_open_end
	mov	history_ax,ax
	mov	history_dx,dx
	push	dx
	push	ax
	push    SIZE S_DZ_CMD
	call	memzero
	call	getcmdfile
	push	dx
	push	ax
	push	_A_NORMAL
	push    M_RDONLY
	push	A_OPEN
	call	osopen
	inc	ax
	jz	history_open_end
	dec	ax
	push	ax
	push	ax
	push	history_dx
	push	history_ax
	push    SIZE S_DZ_CMD
	call	osread
	push	ds
	push	offset searchstring
	push	history_dx
	mov	ax,history_ax
	add	ax,hi_search
	push	ax
	push	SIZE S_DZ_CMD - HISTORY_SIZE - DOSKEY_SIZE
	call	memcpy
	call	close
	inc	ax
    history_open_end:
	ret
history_open ENDP

history_close PROC
	mov	ax,history_ax
	or	ax,ax
	jz	history_close_end
	push	history_dx
	add	ax,HISTORY_SIZE + DOSKEY_SIZE
	push	ax
	push	ds
	push	offset searchstring
	push	SIZE S_DZ_CMD - HISTORY_SIZE - DOSKEY_SIZE
	call	memcpy
	call	getcmdfile
	push	dx
	push	ax
	push	_A_NORMAL
	push    M_WRONLY
	push	A_CREATE or A_TRUNC
	call	osopen
	inc	ax
	jz	history_close_end
	dec	ax
	push	ax
	push	ax
	push	history_dx
	push	history_ax
	push    SIZE S_DZ_CMD
	call	oswrite
	push	history_dx
	push	history_ax
	call	free
	call	close
	inc	ax
    history_close_end:
	ret
history_close ENDP

history_move PROC 	; AL direction
	push	si
	push	di
	cmp	history_dx,0
	je	history_move_end
	mov	di,ds
	mov	es,di
	mov	di,offset convbuf
	lds	si,history
	mov	cx,size S_DZPATH
	mov	bx,size S_DZPATH * (HISTORY_MAX-1)
	cld
	or	al,al
	push	si
	jnz	history_move_00
	add	si,bx
    history_move_00:
	rep	movsb
	pop	di
	mov	si,di
	add	si,size S_DZPATH
	push	ds
	pop	es
	mov	cx,bx
	or	al,al
	jnz	history_move_01
	xchg	si,di
	dec	bx
	add	si,bx
	add	di,bx
	inc	bx
	std
    history_move_01:
	rep	movsb
	push	ss
	pop	ds
	mov	si,offset convbuf
	mov	di,history_ax
	mov	cx,size S_DZPATH
	cld
	or	al,al
	jz	history_move_02
	add	di,bx
    history_move_02:
	rep	movsb
    history_move_end:
	pop	di
	pop	si
	ret
history_move ENDP

history_save PROC
	mov	bx,cpanel
	mov	bx,[bx]
	mov	ax,[bx]
	and	ax,_W_ARCHIVE
	jz      history_save_00
	xor	ax,ax
	jmp	history_save_02
    history_save_00:
	push	si
	mov	si,offset _bufin
	xor	ax,ax
	push	ds
	push	si
	push	ax
	call	fullpath
	or	ax,ax
	jz	history_save_01
	push	ds
	push	si
	push	history_dx
	push	history_ax
	call	strcmp
	or	ax,ax
	jz	history_save_01
	xor	ax,ax
	call	history_move
	push	history_dx
	push	history_ax
	push	ds
	push	offset _bufin
	call	strcpy
	mov	si,cpanel
	mov	ax,[si.pn_fcb_index]
	les	bx,history
	mov	es:[bx.dzp_bufid],ax
	mov	ax,[si.pn_cel_index]
	mov	es:[bx.dzp_celid],ax
	mov	si,[si]
	mov	ax,[si]
	and	ax,not (_W_PANELID or _W_VISIBLE)
	mov	es:[bx.dzp_flag],ax
	inc	ax
    history_save_01:
	pop	si
    history_save_02:
	ret
history_save ENDP

cmhistory PROC DIST
	push	si
	push	di
	les	bx,DLG_Commandline
	mov	ax,es:[bx]
	and	ax,_D_ONSCR
	jz	cmhistory_end
	push	ds
	push	IDD_DZHISTOR
	call	rsopen
	jz	cmhistory_end
	push	dx		; twclose
	push	ax
	push	ds		; rsevent
	push	IDD_DZHISTOR
	push	dx
	push	ax
	push	dx		; tdinit
	push	ax
	push	dx		; twshow
	push	ax
	push	dx		; .copy
	push	ax
	mov	di,history_ax
	add	di,HISTORY_SIZE
	add	bx,16
	push	ds
	mov	si,history_dx
	mov	es,si
	mov	ds,dx
	mov	dx,not _O_STATE
	xor	cx,cx
    cmhistory_init:
	mov	[bx.to_data_ax],di
	mov	[bx.to_data_dx],si
	cmp	byte ptr es:[di],0
	jz	cmhistory_event
	and	[bx],dx
	add	bx,size S_TOBJ
	add	di,MAXDOSKEY
	inc	cx
	cmp	cx,MAXDOSKEYS
	jb	cmhistory_init
	jmp	cmhistory_event
    cmhistory_end:
	pop	di
	pop	si
	ret
    cmhistory_close:
	call	twclose
	mov	ax,dx
	jmp	cmhistory_end
    cmhistory_event:
	pop	ds
	pop	bx
	pop	es
	mov	ax,cx
	mov	es:[bx.dl_count],al
	mov	al,doskey_bindex
	mov	es:[bx.dl_index],al
	cmp	al,cl
	jb	cmhistory_02
	mov	es:[bx.dl_index],ch
    cmhistory_02:
	call	twshow
	call	tdinit
	call	rsevent
	or	ax,ax
	jz	cmhistory_close
	dec	ax
	mov	doskey_bindex,al
	inc	ax
	shl	ax,4
	add	bx,ax
	push	ds
	push	offset com_base
	pushm	es:[bx.to_data_ax]
	call	strcpy
	call	twclose
	push	KEY_END
	call	comevent
	mov	ax,1
	jmp	cmhistory_end
cmhistory ENDP

doskey_save PROC
	push	si
	push	di
	push	ds
	push	offset com_base
	call	strtrim
	or	ax,ax
	jz	doskey_save_end
	mov	si,history_ax
	mov	di,history_dx
	or	di,di
	jz	doskey_save_end
	add	si,HISTORY_SIZE
	push	ds
	push	offset com_base
	push	di
	push	si
	call	strcmp
	or	ax,ax
	jz	doskey_save_equ
	mov	ax,si
	add	ax,MAXDOSKEY
	push	di
	push	ax
	push	di
	push	si
	push	MAXDOSKEY * (MAXDOSKEYS-1)
	call	memmove
	push	di
	push	si
	push	ds
	push	offset com_base
	call	strcpy
    doskey_save_equ:
	mov	ax,1
    doskey_save_end:
	pop	di
	pop	si
	ret
doskey_save ENDP

doskeytocommand PROC
	push	ds
	push	offset com_base
	push	history_dx
	mov	ah,doskey_bindex
	mov	al,00h
	shr	ax,1
	add	ax,history_ax
	add	ax,HISTORY_SIZE
	push	ax
	call	strcpy
	ret
doskeytocommand ENDP

cmdoskey_up PROC DIST
	les	bx,DLG_Commandline
	mov	ax,es:[bx]
	and	ax,_D_ONSCR
	jz	cmdoskey_up_end
	mov	al,1
	cmp	doskey_isnext,al
	jne	cmdoskey_up_00
	mov	com_base,ah
	jmp	cmdoskey_up_01
    cmdoskey_up_00:
	call	doskeytocommand
	inc	doskey_bindex
	cmp	doskey_bindex,MAXDOSKEYS
	jb	cmdoskey_up_01
	mov	doskey_bindex,0
    cmdoskey_up_01:
	push	KEY_END
	call	comevent
	mov	ax,1
	mov	doskey_isnext,ah
    cmdoskey_up_end:
	ret
cmdoskey_up ENDP

cmdoskey_dn PROC DIST
	les	bx,DLG_Commandline
	mov	ax,es:[bx]
	and	ax,_D_ONSCR
	jz	cmdoskey_dn_end
	cmp	doskey_isnext,ah
	jne	cmdoskey_dn_00
	mov	com_base,ah
	jmp	cmdoskey_dn_03
    cmdoskey_dn_00:
	cmp	doskey_bindex,0
	jne	cmdoskey_dn_01
	mov	doskey_bindex,(MAXDOSKEYS-1)
	jmp	cmdoskey_dn_02
    cmdoskey_dn_01:
	dec	doskey_bindex
    cmdoskey_dn_02:
	call	doskeytocommand
    cmdoskey_dn_03:
	push	KEY_END
	call	comevent
	mov	ax,1
	mov	doskey_isnext,al
    cmdoskey_dn_end:
	ret
cmdoskey_dn ENDP

historytocpanel PROC
	push	si
	push	di
	les	si,history
	xor	ax,ax
	or	si,si
	jz	historytocpanel_end
	cmp	al,es:[si]
	jz	historytocpanel_end
	mov	di,cpanel
	mov	di,[di]
	mov	dx,[di]
	test	dx,_W_ARCHIVE
	jnz	historytocpanel_end
	mov	ax,dx
	and	ax,_W_PANELID or _W_VISIBLE
	or	ax,es:[si.dzp_flag]
	mov	[di],ax
	mov	ax,es:[si.dzp_bufid]
	mov	dx,es:[si.dzp_celid]
	mov	bx,cpanel
	mov	[bx.pn_fcb_index],ax
	mov	[bx.pn_cel_index],dx
	mov	dx,es
	mov	ax,si
	call	cpanel_setpath
	mov	ax,cpanel
	call	panel_redraw
	mov	ax,1
    historytocpanel_end:
	or	ax,ax
	pop	di
	pop	si
	ret
historytocpanel ENDP

cmpathleft PROC DIST	; Alt-Left - Previous Directory
	call	history_save
	mov	ax,1
	call	history_move
	call	historytocpanel
	jz	cmpathleft_00
	ret
    cmpathleft_00:
	call	history_move
	ret
cmpathleft ENDP

cmpathright PROC DIST	; Alt-Right - Next Directory
	call	history_save
	xor	ax,ax
	call	history_move
	call	historytocpanel
	jz	cmpathright_00
	ret
    cmpathright_00:
	inc	ax
	call	history_move
	ret
cmpathright ENDP

_DZIP	ENDS

	END
