include	doszip.inc
include	dos.inc
include	keyb.inc
include	conio.inc
include	string.inc

	.186

	public	cmquicksearch

; (PG)UP,DOWN: 	Move
; ESC,TAB,ALTX:	Quit
; ENTER:  	Quit
; BKSP:		Search from start
; insert char:	Search from current pos.

;SKIPSUBDIR = 1 ; Exclude directories in search

_DATA	SEGMENT

cp_quicksearch	db '&Quick Search: ',1Ah,'   ',0

_DATA	ENDS

_DZIP	SEGMENT

psearch PROC	; (char *__name, int length), AX: direction (-1,0,1)
	push	bp
	mov	bp,sp
	sub	sp,8
	push	si
	push	di
	mov	bx,cpanel		; current index
	mov	si,[bx.pn_fcb_index]
	add	si,[bx.pn_cel_index]
	mov	[bp-6],si
	mov	[bp-8],si
	mov	di,[bx.pn_fcb_count]
	mov	bx,word ptr [bx.pn_wsub]
	or	ax,ax			; if (AX == 0) search from start
	movmx	[bp-4],[bx.ws_fcb]
	jz	psearch_all		; (case BKSP)
    psearch_loop:
	cmp	si,di			; search from current to end
	jnb	psearch_start
	les	bx,[bp-4]
	mov	ax,si
	shl	ax,2
	add	bx,ax
	les	bx,es:[bx]
  ifdef	SKIPSUBDIR
	test	byte ptr es:[bx],_A_SUBDIR
	jnz	psearch_next
  endif
	pushm	[bp+6]
	push	es
	add	bx,fb_name
	push	bx
	push	word ptr [bp+4]
	call	strnicmp
	or 	ax,ax
	jz	psearch_match
    psearch_next:
	inc	si
	jmp	psearch_loop
    psearch_all:
	mov	[bp-6],di
    psearch_start:
	xor	si,si
	mov	di,[bp-6]
	mov	[bp-6],si
	cmp	si,di
	jne	psearch_loop
	xor	ax,ax
	jmp	psearch_end
    psearch_match:
	mov	bx,cpanel
	push	bx
	push	0
	invoke	dlclose, [bx.pn_xl]
	mov	ax,cpanel
	mov	dx,si
	call	panel_setid
	call	panel_putitem
	mov	ax,cpanel
	call	pcell_show
	mov	ax,1
    psearch_end:
	mov	dx,[bp-8]
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
	ret	6
psearch	ENDP

quicksearch_close PROC
	push	ss
	mov	ax,bp
	add	ax,60
	push	ax
	call	wcpopst
	pushm	[bp+220]
	call	setcursor
	ret
quicksearch_close ENDP

cmquicksearch PROC DIST
	push	bp
	push	si
	push	di
	sub	sp,232
	mov	bp,sp
	call	cpanel_state
	jz	cmquicksearch_end
	push	ss      		; save cursor
	lea	ax,[bp+220]
	push	ax
	call	getcursor
	call	cursoron		; cursor on
	push	ss      		; save last screen-line
	mov	ax,bp
	add	ax,60
	push	ax
	push	ds
	push	offset cp_quicksearch
	call	wcpushst
	mov	si,15			; SI = x-pos
	xor	ax,ax
	mov	al,_scrrow
	mov	di,ax			; DI = y-pos
    cmquicksearch_loop:
	call	tupdate
	push	si
	push	di
	call	gotoxy			; cursor to (x,y)
	call	getkey			; get key
	mov	cx,cmquicksearch_count	; test key
	xor	bx,bx
    cmquicksearch_next:
	cmp	ax,cs:[bx+cmquicksearch_keys]
	je	cmquicksearch_found
	add	bx,2
	dec	cx
	jnz	cmquicksearch_next
	jmp	cmquicksearch_find	; add char to search string
    cmquicksearch_found:
	jmp     cs:[bx+cmquicksearch_label]
    cmquicksearch_pevent:
	push	cpanel
	push	ax
	call	panel_event
	jmp	cmquicksearch_loop
    cmquicksearch_bksp:			; delete char and search from start
	cmp	si,15
	jle	cmquicksearch_loop
	dec	si
	mov	dx,di
	mov	bx,si
	mov	bh,dl
	mov	cx,2
	mov	ax,' '
	call	@scputw
	xor	ax,ax
	mov	cx,15
	jmp	cmquicksearch_back
    cmquicksearch_enter:
	push	ss
	push	bp
	mov	ax,si
	sub	ax,15
	push	ax
	call	psearch
  ifdef	SKIPSUBDIR
	jmp	cmquicksearch_loop
  else
	or	ax,ax
	jz	cmquicksearch_loop
	mov	bx,cpanel
	mov	ax,[bx.pn_fcb_index]
	add	ax,[bx.pn_cel_index]
	cmp	ax,dx
	jne	cmquicksearch_loop
	jmp	cmquicksearch_break
  endif
    cmquicksearch_find:
	mov	ah,0
	mov	[bp+si-15],al
	mov	cx,14
    cmquicksearch_back:
	push	ax
	push	ss
	push	bp
	mov	dx,si
	sub	dx,cx
	push	dx
	call	psearch
	or	ax,ax
	pop	ax
	jz	cmquicksearch_loop
	or	ax,ax
	jz	cmquicksearch_loop
	mov	dx,di
	mov	bx,si
	mov	bh,dl
	mov	cx,1
	call	@scputw
	cmp	si,78
	jge	cmquicksearch_loop
	inc	si
	jmp	cmquicksearch_loop
    cmquicksearch_break:
	call	quicksearch_close
    cmquicksearch_end:
	xor	ax,ax
	add	sp,232
	pop	di
	pop	si
	pop	bp
	ret
    cmquicksearch_keys label word
	dw	0
	dw	KEY_ESC
	dw	KEY_TAB
	dw	KEY_ALTX
	dw	KEY_ENTER
	dw	KEY_KPENTER
	dw	KEY_LEFT
	dw	KEY_RIGHT
	dw	KEY_UP
	dw	KEY_PGUP
	dw	KEY_DOWN
	dw	KEY_PGDN
	dw	KEY_HOME
	dw	KEY_END
	dw	KEY_BKSP
    cmquicksearch_label label word
	dw	cmquicksearch_loop
	dw	cmquicksearch_break
	dw	cmquicksearch_break
	dw	cmquicksearch_break
	dw	cmquicksearch_enter
	dw	cmquicksearch_enter
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_pevent
	dw	cmquicksearch_bksp
    cmquicksearch_count = ($ - cmquicksearch_label) / 2
cmquicksearch ENDP

_DZIP	ENDS

	END
