include	clib.inc
ifdef __CLIP__
include	clip.inc
include	keyb.inc
include	string.inc
include	iost.inc
include	mouse.inc
include	conio.inc
include	tinfo.inc
include	alloc.inc

tigetline	proto
tiremline	proto
tidelete	proto
tiseto		proto
ticontinue	proto
tiflushl	proto
tiputc		proto
tievent		proto

	.data
	winoldap  d? ?
	clipbsize d? ?
	clipboard dd ?

	public	clipbsize
	public	clipboard

	.code

ifndef __f__

OpenClipboard PROC
	mov ax,winoldap
	.if ax
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    inc ax
	.endif
	ret
OpenClipboard ENDP

CloseClipboard PROC
	push	dx
	push	ax
	mov	ax,1708h	; INT 2F - MS Windows - CloseClipboard
	int	2Fh
	pop	ax
	pop	dx
	ret
CloseClipboard ENDP

endif

ClearClipboard proc
	mov clipbsize,0
;    ifndef __f__
	invoke free,clipboard
;    endif
	sub	ax?,ax?
	mov?	dx,ax
	stom	clipboard
	ret
ClearClipboard endp

ClipboardFree proc _CType public
	call ClearClipboard
	ret
ClipboardFree endp

ClipboardCopy proc _CType public uses si? di? bx? string:dword, len:size_t
	mov di?,len
	call ClearClipboard
	.if console & CON_CLIPB
      ifndef __f__
	    call OpenClipboard
	    .if !ZERO?
		mov  ax,1702h	; EMPTY CLIPBOARD
		int  2Fh	; AX nonzero clipboard has been emptied
		mov  dx,1	; set type to text
		mov  cx,di	; SI:CX = size of data
		xor  si,si	; HSIZE = 0
		les  bx,string	; ES:BX = data
		mov  ax,1703h	; SET CLIPBOARD DATA
		int  2Fh
		call CloseClipboard
		test ax,ax	; nonzero data copied into the Clipboard
		mov  ax,di
		jnz  @F
	    .endif
	    mov ax,di
	    inc ax
	    .if func(malloc,ax)
	    	stom clipboard
		mov clipbsize,di
	    	mov es,dx
	    	mov bx,ax
	    	add bx,di
	    	mov byte ptr es:[bx],0
	    	invoke memcpy,dx::ax,string,di
	    	mov ax,di
	    .endif
      else
	    .if func(OpenClipboard,0)
		invoke EmptyClipboard
		inc edi
		.if func(GlobalAlloc,GMEM_MOVEABLE or GMEM_DDESHARE,edi)
		    dec edi
		    mov esi,eax
		    invoke GlobalLock,eax
		    invoke memcpy,eax,string,edi
		    mov ebx,eax
		    mov byte ptr [ebx+edi],0
		    invoke GlobalUnlock,esi
		    invoke SetClipboardData,CF_TEXT,ebx
;		    invoke GlobalFree,esi
		    mov eax,edi
		.endif
		push eax
   	    	invoke CloseClipboard
		pop eax
	    .endif
      endif
	.endif
      @@:
	ret
ClipboardCopy endp

ClipboardPaste proc _CType public uses bx?
	.if (console & CON_CLIPB)
  ifdef __f__
    	    .if func(IsClipboardFormatAvailable,CF_TEXT)
	    	.if func(OpenClipboard,0)
		    .if func(GetClipboardData,CF_TEXT)
			mov ebx,eax
			.if func(strlen,eax)
			    mov clipbsize,eax
			    inc eax
			    .if func(malloc,eax)
			    	invoke strcpy,eax,ebx
				mov clipboard,eax
			    .endif
			.endif
		    .endif
		    push eax
		    call CloseClipboard
		    pop  eax
		.endif
	    .endif
  else
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    mov ax,1704h	; GET CLIPBOARD DATA SIZE
	    mov dx,1		; DX = clipboard format supported
	    int 2Fh		; DX:AX = size of data in bytes
	    .if dx
	    	sub ax,ax	; to big..
	    .endif
	    call CloseClipboard
	    .if !ax || ax >= MAXCLIPSIZE
	    	sub ax,ax
	    	.if clipbsize != ax
		    lodm clipboard
	    	.endif
	    .else
	    	push ax
	    	push ax
	    	call ClearClipboard
	    	call malloc
	    	pop cx
		.if ax
		    mov clipbsize,cx
		    stom clipboard
		    invoke memzero,dx::ax,cx
		    mov ax,1701h
		    int 2Fh
		    mov dx,1
		    les bx,clipboard
		    mov ax,1705h
		    int 2Fh
		    call CloseClipboard
		    lodm clipboard
		.endif
	    .endif
  endif
	.else
	    .if clipbsize
		lodm clipboard
	    .else
		sub ax?,ax?
		mov? dx,ax
	    .endif
  	.endif
	test ax?,ax?
	ret
ClipboardPaste endp

ifndef __f__

Install:
	.if console & CON_CLIPB
	    mov ax,1700h
	    int 2Fh
	    mov dx,ax
	    xor ax,ax		; AX <> 1700h
	    .if dx != 1700h   	; - AL = WINOLDAP major version
		inc ax		; - AH = WINOLDAP minor version
	    .endif
	    mov winoldap,ax
	.endif
	ret

_TEXT	ENDS

pragma_init Install,50

endif ; __f__


externdef IDD_ClipboardWarning:DWORD
;
; Cut		Shift-Del	Ctrl-X
; Copy		Ctrl-Ins	Ctrl-C
; Paste		Shift-Ins	Ctrl-V
; Clear		Del		Ctrl-Del
;

	.code
	ASSUME	bx?:ptr S_TINFO

tiselected proc public uses bx?
	mov	bx?,tinfo
    ifdef __TE__
	mov	ax?,[bx?].ti_clel	; CX line count
	sub	ax?,[bx?].ti_clsl
	mov	cx?,ax?
	jnz	@F
    endif
	mov	ax?,[bx?].ti_cleo	; AX byte count
	sub	ax?,[bx?].ti_clso
      @@:
	ret
tiselected endp

ticlipset proc public uses bx?	; set clipboard to current position
	mov	bx?,tinfo
	mov	ax?,[bx?].ti_boff
	add	ax?,[bx?].ti_xoff
	mov	[bx?].ti_clso,ax?
	mov	[bx?].ti_cleo,ax?
    ifdef __TE__
	test	[bx?].ti_flag,_T_LINEBUF
	jz	@F
	mov	ax?,[bx?].ti_loff
	add	ax?,[bx?].ti_yoff
	mov	[bx?].ti_clsl,ax?
	mov	[bx?].ti_clel,ax?
      @@:
    endif
	ret
ticlipset endp

alignxy:
	test	cx?,cx?		; subtract ax then dx while cx--
	je	alignxy_end
	cmp     ax?,cx?
	jb	alignxy_00
	sub	ax?,cx?
    alignxy_end:
	ret
    alignxy_00:
	sub	cx?,ax?
	xor	ax?,ax?
	sub	dx?,cx?
	ret

tialigncl:
	push	bx?		; goto start of selection
	mov	bx?,tinfo
    ifdef __TE__
	test	[bx?].ti_flag,_T_LINEBUF
	jz	@F
	mov	dx?,[bx?].ti_loff
	mov	ax?,[bx?].ti_yoff
	mov	cx?,dx?
	add	cx?,ax?
	sub	cx?,[bx?].ti_clsl
	call	alignxy
	mov	[bx?].ti_loff,dx?
	mov	[bx?].ti_yoff,ax?
      @@:
    endif
	mov	dx?,[bx?].ti_boff
	mov	ax?,[bx?].ti_xoff
	mov	cx?,dx?
	add	cx?,ax?
	sub	cx?,[bx?].ti_clso
	call	alignxy
	mov	[bx?].ti_boff,dx?
	mov	[bx?].ti_xoff,ax?
	pop	bx?
	ret

ifdef __TE__

tiremline proc public uses si? di? bx? bp?
	mov	bx?,ax?      	; AX index of line to remove
	mov	bp?,tinfo      	; DX number of lines to remove
	mov	cx?,[bp?].S_TEDIT.ti_lcnt
	mov	ax?,[bp?].S_TINFO.ti_bcol
	sub	sp?,ax?
	mov	bp?,sp?
	push	ax?		; [bp-2] line size
	mov	ax?,dx?
	sub	cx?,bx?
	push	cx?		; [bp-4] max lines
	add	dx?,bx?
	push	dx?		; [bp-6] last line
	push	ax?		; [bp-8] count
      @@:
	mov	ax?,[bp?-size_l*3]
	call	tigetline
	jc	@F
	mov?	ds,dx
	mov	si?,ax?
	mov	cx?,[bp?-size_l*1]
	shr	cx?,1
	push?	ss
	pop?	es
	mov	di?,bp?
	rep	movsw
	push?	ss
	pop?	ds
	mov	ax?,bx?
	call	tigetline
	jc	tiremlines_err
	mov?	es,dx
	mov	di?,ax?
	mov	cx?,[bp?-size_l*1]
	shr	cx?,1
	mov	si?,bp?
	rep	movsw
	inc	bx?
      ifdef __f__
	inc	dword ptr [ebp-12]
	dec	dword ptr [ebp-8]
      else
	inc	word ptr [bp-6]
	dec	word ptr [bp-4]
      endif
	jnz	@B
      @@:
	mov	bx?,[bp?-size_l*4]
	mov	si?,tinfo
      @@:
	mov	ax?,[si?].S_TEDIT.ti_lcnt
	dec	ax?
	call	tigetline
	jz	tiremlines_end
	mov?	es,dx
	mov	di?,ax?
	xor	ax?,ax?
	mov	cx?,[bp?-size_l*1]
	shr	cx?,1
	rep	stosw
	dec	[si?].S_TEDIT.ti_lcnt
	dec	bx?
	jnz	@B
	inc	ax?
    tiremlines_end:
	add	sp?,[bp?-size_l*1]
	add	sp?,size_l*4
	or	ax?,ax?
	ret
    tiremlines_err:
	xor	ax?,ax?
	jmp	tiremlines_end
tiremline endp

endif

ticlipdel proc public uses si? di? bx?
	invoke	tiselected
  ifdef __TE__
	mov	di?,cx?		; DI line count selected
	jz	ticlipdel_end
	call	tialigncl	; goto start
	mov	bx?,tinfo
	mov	ax?,[bx?].ti_clsl
	call	tigetline	; get line
	jz	ticlipdel_end
	test	di?,di?
	jnz	@F
	or	[bx?].ti_flag,_T_MODIFIED
      ifdef __f__
	mov	edx,eax		; single line -- copy(start,end)
	add	eax,[ebx].ti_clso
	add	edx,[ebx].ti_cleo
	invoke	strcpy,eax,edx
      else
	mov	cx,ax
	add	ax,[bx].ti_clso
	add	cx,[bx].ti_cleo
	invoke	strcpy,dx::ax,dx::cx
      endif
	jmp	ticlipdel_set
      @@:
	mov?	es,dx		; multi line
	mov	si?,ax?
	sub	ax?,ax?
	add	si?,[bx?].ti_clso
      ifdef __f__
	mov	[esi],al
      else
	mov	es:[si],al	; start=0
      endif
	mov	ax?,[bx?].ti_clel
	call	tigetline	; get last selected line
	jz	ticlipdel_end
	or	[bx?].ti_flag,_T_MODIFIED
      ifdef __f__
	mov	edx,eax		; copy(last line,end)
	add	edx,[ebx].ti_cleo
	invoke	strcpy,eax,edx
      else
	mov	cx,ax
	add	cx,[bx].ti_cleo
	invoke	strcpy,dx::ax,dx::cx
      endif
	dec	di?
	jz	ticlipdel_del
	mov     si?,[bx?].ti_clsl
	inc	si?
    ticlipdel_lines:
	mov	ax?,si?
	mov	dx?,di?
	call	tiremline
    ticlipdel_del:
	call	tidelete
  else	; __TE__
	jz	ticlipdel_end
	mov	bx?,tinfo
	lodm	[bx?].ti_bp
	mov	si?,ax?
	mov	di?,[bx?].ti_cleo
	add	ax?,[bx?].ti_clso
      ifdef __f__
	mov	edx,esi
	add	edx,edi
	invoke	strcpy,eax,edx
      else
	mov	cx,si
	add	cx,di
	invoke	strcpy,dx::ax,dx::cx
      endif
	mov	dx?,si?
	add	dx?,di?
	sub	dx?,ax?
	mov	cx?,si?
	add	cx?,[bx?].ti_boff
	add	cx?,[bx?].ti_xoff
	cmp	ax?,cx?
	je	ticlipdel_set
	sub	[bx?].ti_xoff,dx?
  endif
    ticlipdel_set:
	call	tiseto
	call	ticlipset
	sub	ax?,ax?
	inc	ax?
    ticlipdel_end:
	ret
ticlipdel endp

ifdef __TE__

tiselectall proc public
	push	bx?
	mov	bx?,tinfo
	xor	ax?,ax?
	mov	[bx?].ti_clsl,ax?
	mov	[bx?].ti_clso,ax?
	mov	[bx?].ti_clel,ax?
	mov	ax?,[bx?].ti_bcol
	mov	[bx?].ti_cleo,ax?
	cmp	[bx?].S_TEDIT.ti_lcnt,ax?
	je	@F
	mov	ax?,[bx?].S_TEDIT.ti_lcnt
	dec	ax?
	mov	[bx?].ti_clel,ax?
      @@:
	pop	bx?
	jmp	ticontinue
tiselectall endp

	ASSUME	bx?:nothing
endif
	ASSUME	si?:ptr S_TINFO

ifdef	__TE__
ticopyselection:
	push	di?
	push	bx?
	xor	di?,di?
	invoke	oinitst,addr STDO,MAXCLIPSIZE
    	jnz	@F
	invoke	oinitst,addr STDO,1000h
	jz	ticopyselection_eof
      @@:
	inc	di?
	mov	STDO.ios_flag,IO_CLIPBOARD
	mov	ax?,[si?].ti_clsl
	mov	dx?,[si?].ti_clso
	mov	cx?,[si?].ti_clel
	mov	bx?,[si?].ti_cleo
	call	tiflushl
	jnz	@F
	mov	ax?,bx?
	mov	[si?].ti_clsl,dx?
	mov	[si?].ti_clso,ax?
	inc	di?
	invoke	rsmodal,IDD_ClipboardWarning
      @@:
	call	oflush
	invoke	ofreest,addr STDO
    ticopyselection_eof:
	mov	ax?,di?
	test	ax?,ax?
	pop	bx?
	pop	di?
	ret
endif

ticlipcut proc public uses si? di?
	mov	si?,tinfo
	mov	di?,ax?			; AX: Copy == 0, Cut == 1
	call	tiselected		; get size of selection
	jz	ticlipcut_set
    ifdef __TE__
	call	ticopyselection
	jz	ticlipcut_eof
	dec	ax?
	jnz	ticlipcut_eof
    else
	mov	cx?,ax?
	lodm	[si?].ti_bp
	add	ax?,[si?].ti_clso
	invoke	ClipboardCopy,dxax,cx?
    endif
	test	di?,di?
	jz	ticlipcut_set
	call	ticlipdel
    ticlipcut_set:
	call	ticlipset
    ticlipcut_eof:
	sub	ax?,ax?
	ret
ticlipcut endp

ticlipget proc public uses si? di? bx?
	mov	si?,tinfo
	mov	ax?,[si?].ti_flag
	and	ax?,_T_OVERWRITE
	jnz	@F
	call	ticlipset
	jmp	ticlipget_get
      @@:
	call	ticlipdel
    ticlipget_get:
	call	ClipboardPaste
	jz	ticlipget_end
  ifdef __TE__
	push	[si?].ti_yoff
	push	[si?].ti_loff
  endif
	push	[si?].ti_xoff
	push	[si?].ti_boff
	mov	si?,clipbsize
	mov	di?,ax?
	mov?	es,dx
  ifdef __TE__
	mov	dx?,ax?		; Problem of inserting text by pushing
	mov	cx?,si?		; a long line in front - EOL == abort
	cld?
	mov	ax?,0Ah		; Insert '\n' if clipboard contain a '\n'
	repne	scasb		; then move back to prev pos
	mov	di?,dx?
	jne	ticlipget_00
	mov	bx?,si?
      ifdef __f__
	cmp	[edi+ebx-2],al
	jne	@F
	mov	[edi+ebx-2],ah
      else
	cmp	es:[di+bx-2],al	; remove '\n' from end if exist
	jne	@F		; This align line-based clip-set
	mov	es:[di+bx-2],ah
      endif
      @@:
	push?	es
	call	tiputc
	pop?	es
	test	ax?,ax?
	jnz	ticlipget_01
	pop	dx?
	pop	ax?
	pop	cx?
	pop	bx?
	push	bx?
	push	cx?
	push	ax?
	push	dx?
	mov	si?,tinfo
	mov	[si?].ti_xoff,ax?
	mov	[si?].ti_boff,dx?
	mov	[si?].ti_yoff,cx?
	mov	[si?].ti_loff,bx?
	mov	si?,Clipbsize
  endif
    ticlipget_00:
	mov	al,edi?
	test	al,al
	jz	ticlipget_01
	inc	di?
	push?	es
	call	tiputc
	pop?	es
	test	ax?,ax?
	jnz	ticlipget_01
	dec	si?
	jnz	ticlipget_00
    ticlipget_01:
	pop	dx?
	pop	ax?
	mov	si?,tinfo
	mov	[si?].ti_xoff,ax?
	mov	[si?].ti_boff,dx?
  ifdef __TE__
	pop	dx?
	pop	ax?
	mov	[si?].ti_yoff,ax?
	mov	[si?].ti_loff,dx?
  endif
    ticlipget_end:
	xor	ax?,ax?
	ret
ticlipget endp

	ASSUME	si?:nothing

	.data
	cl_proctable label size_t
		d? ticlip_Copy
		d? ticlip_Copy
		d? ticlipget
		d? ticlip_Cut
		d? ticlip_Cut
	cl_keytable label size_t
		d? KEY_CTRLINS
		d? KEY_CTRLC
		d? KEY_CTRLV
		d? KEY_CTRLX
		d? KEY_CTRLDEL
	cl_keycount = (($ - offset cl_keytable) / size_l)
	cl_shiftkeytable label size_t
		d? KEY_HOME
		d? KEY_LEFT
		d? KEY_RIGHT
		d? KEY_END
	    ifdef __TE__
		d? KEY_UP
		d? KEY_DOWN
		d? KEY_PGUP
		d? KEY_PGDN
	    endif
	cl_shiftkeycount = (($ - offset cl_shiftkeytable) / size_l)
	cl_nodeletekeys label size_t
		d? KEY_ESC
	    ifdef __MOUSE__
		d? MOUSECMD
	    endif
		d? KEY_BKSP
;		d? KEY_TAB
		d? KEY_ENTER
		d? KEY_KPENTER
	cl_nodeletecount = (($ - offset cl_nodeletekeys) / size_l)

	.code

ticlip_Copy:
	sub	ax?,ax?
	jmp	ticlipcut

ticlip_Cut:
	mov	ax?,1
	jmp	ticlipcut

ticlipevent proc public uses si? di? bx?
	mov	si?,ax?
	call	tiselected
	jnz	@F
	call	ticlipset
      @@:
	xor	di?,di?
	mov	cx?,cl_keycount
	jmp     ticlipevent_loop
    ticlipevent_found:
	call	cl_proctable[di?]
	jmp     ticlipevent_end
    ticlipevent_loop:
	cmp	si?,cl_keytable[di?]
	je	ticlipevent_found
	add	di?,size_l
	dec	cx?
	jnz	ticlipevent_loop
	les?	bx?,keyshift
	mov	al,ebx?
	and	al,KEY_SHIFT
	jnz	@F
	cmp	si?,KEY_DEL
	jne	ticlipevent_ESC
	call	ticlipdel
	jz	ticlipevent_set
	xor	ax?,ax?
	jmp	ticlipevent_end
      @@:
	cmp	si?,KEY_INS
	jne	@F
	call	ticlipget
	jmp	ticlipevent_end
      @@:
	cmp	si?,KEY_DEL
	jne	@F
	mov	ax?,1
	call	ticlipcut
	jmp	ticlipevent_end
      @@:
	mov	di?,offset cl_shiftkeytable
	mov	cx?,cl_shiftkeycount
	ASSUME	bx?:ptr S_TINFO
  ifdef __TE__
	mov	bx?,tinfo
	test	[bx?].ti_flag,_T_LINEBUF
	jnz	@F
	sub	cx?,4
  endif
      @@:
	cmp	si?,[di?]
	je	ticlipevent_MOVE
	add	di?,size_l
	dec	cx?
	jnz	@B
    ticlipevent_ESC:
	mov	cx?,cl_nodeletecount
	xor	di?,di?
      @@:
	cmp	si?,cl_nodeletekeys[di?]
	je	ticlipevent_set
	add	di?,size_l
	dec	cx?
	jnz	@B
	mov	ax?,si?
	test	al,al
	jz	ticlipevent_set
    ifdef __TE__
	mov	bx?,tinfo
	test	[bx?].ti_flag,_T_LINEBUF
	jnz	@F
	cmp	si?,KEY_TAB
	je	ticlipevent_set
      @@:
    endif
	call	ticlipdel
    ticlipevent_set:
	call	ticlipset
	mov	ax?,si?
    ticlipevent_end:
	ret
    ticlipevent_MOVE:
	mov	ax?,si?
	call	tievent
	test	ax?,ax?
	jnz	ticlipevent_nul
	mov	bx?,tinfo
    ifdef __TE__
	mov	cx?,[bx?].ti_loff
	add	cx?,[bx?].ti_yoff
	cmp	cx?,[bx?].ti_clsl
	jb	ticlipevent_MOVEBACK
    endif
	mov	ax?,[bx?].ti_boff
	add	ax?,[bx?].ti_xoff
	cmp	ax?,[bx?].ti_clso
	jb	ticlipevent_MOVEBACK
	cmp	si?,KEY_RIGHT
	jne	@F
	mov	dx?,ax?
	dec	dx?
	cmp	dx?,[bx?].ti_clso
	jne	@F
	cmp	dx?,[bx?].ti_cleo
	jne	ticlipevent_MOVEBACK
      @@:
	mov	[bx?].ti_cleo,ax?
    ifdef __TE__
	mov	[bx?].ti_clel,cx?
    endif
	jmp	ticlipevent_nul
    ticlipevent_MOVEBACK:
	mov	[bx?].ti_clso,ax?
    ifdef __TE__
	mov	[bx?].ti_clsl,cx?
    endif
    ticlipevent_nul:
	xor	ax?,ax?
	jmp	ticlipevent_end
ticlipevent endp

endif ; __CLIP__

	end
