include	clib.inc
include io.inc
include	dos.inc
include share.inc
include stdio.inc
include fcntl.inc
include stat.inc
include errno.inc
ifndef __DZ__
externdef _fmode:size_t
externdef _umaskval:size_t

	.code

sopen	proc _CDecl public uses rsi rdi path:dword, oflag:size_t, shflag:size_t, args:VARARG
	mov	rsi,FH_TEXT
	cmp	_fmode,O_BINARY
	je	sopen_start
	mov	rax,oflag
	test	rax,O_BINARY
	jz	sopen_start
	sub	rsi,rsi
    sopen_start:
	and	rax,O_RDONLY or O_WRONLY or O_RDWR
	cmp	rax,O_RDONLY
	je	sopen_valid
	cmp	rax,O_WRONLY
	je	sopen_valid
	cmp	rax,O_RDWR
	je	sopen_valid
    sopen_einval:
	mov	errno,EINVAL
	sub	rax,rax
	mov	doserrno,rax
	dec	rax
	jmp	sopen_end
    sopen_valid:
	mov	rdi,rax
	mov	rax,oflag
	and	rax,O_CREAT or O_EXCL or O_TRUNC
	jz	sopen_a_open
	cmp	rax,O_EXCL
	je	sopen_a_open
	cmp	rax,O_CREAT
	je	sopen_a_open_create
	cmp	rax,O_CREAT or O_TRUNC
	je	sopen_a_create_trunc
	cmp	rax,O_CREAT or O_EXCL
	je	sopen_a_create_trunc
	cmp	rax,O_CREAT or O_TRUNC or O_EXCL
	je	sopen_a_create_trunc
	cmp	rax,O_TRUNC
	je	sopen_a_trunc
	cmp	rax,O_TRUNC or O_EXCL
	je	sopen_a_trunc
	jmp	sopen_einval
    sopen_a_open:
	mov	rax,A_OPEN
	jmp	sopen_flag
    sopen_a_open_create:
	mov	rax,A_OPEN or A_CREATE
	jmp	sopen_flag
    sopen_a_create_trunc:
	mov	rax,A_CREATE or A_TRUNC
	jmp	sopen_flag
    sopen_a_trunc:
	mov	rax,A_TRUNC
    sopen_flag:
	mov	rcx,_A_NORMAL
	mov	rdx,oflag
	test	rdx,O_CREAT
	jz	sopen_del
	lea	rbx,args
	push	rax
	mov	rax,[rbx]
	mov	rbx,_umaskval
	not	rbx
	and	rax,rbx
	and	rax,S_IWRITE
	pop	rax
	jnz	sopen_del
	mov	rcx,_A_RDONLY
    sopen_del:
	test	rdx,O_TEMPORARY
	jz	sopen_tmp
	or	rcx,_A_DELETE
	or	rdi,O_SHORT_LIVED
    sopen_tmp:
	test	rdx,O_SHORT_LIVED
	jz	sopen_seq
	or	rcx,_A_TEMPORARY
    sopen_seq:
	test	rdx,O_SEQUENTIAL
	jz	sopen_ran
	or	rcx,_A_SEQSCAN
	jmp	sopen_os
    sopen_ran:
	test	rdx,O_RANDOM
	jz	sopen_os
	or	rcx,_A_RANDOM
    sopen_os:
	invoke	osopen,path,rcx,rdi,rax
	cmp	rax,-1
	je	sopen_end
	mov	rdi,rax
	invoke	osfiletype,rax
	cmp	rax,DEV_UNKNOWN
	je	sopen_doserr
	cmp	rax,DEV_CHAR
	jne	sopen_osf
	or	rsi,FH_DEVICE
    sopen_osf:
	or	rsi,FH_OPEN
	mov	rax,rsi
	mov	_osfile[rdi],al
	test	al,FH_DEVICE or FH_PIPE
	jnz	sopen_append
	test	al,FH_TEXT
	jz	sopen_append
	test	oflag,O_RDWR
	jz	sopen_append
	invoke	lseek,rdi,-1,SEEK_END
	cmp	rdx,-1
	jne	sopen_read
	cmp	rax,-1
	jne	sopen_read
	cmp	errno,EINVAL
	jne	sopen_error
	jmp	sopen_append
    sopen_read:
	push	rdx
	push	rax
	sub	rax,rax
	mov	WORDP path,rax
	invoke	osread,rdi,addr path,1
	test	rax,rax
	pop	rax
	pop	rdx
	jnz	sopen_chsize
	cmp	byte ptr path,26
	jne	sopen_seek
    sopen_chsize:
	invoke	chsize,rdi,dxax
	cmp	rax,-1
	je	sopen_error
    sopen_seek:
	invoke	lseek,rdi,0,SEEK_SET
	cmp	rdx,-1
	jne	sopen_append
	cmp	rax,-1
	je	sopen_error
    sopen_append:
	mov	rax,rsi
	and	rax,FH_DEVICE or FH_PIPE
	jnz	sopen_done
	test	oflag,O_APPEND
	jz	sopen_done
	or	_osfile[rdi],FH_APPEND
    sopen_done:
	mov	rax,rdi
    sopen_end:
	ret
    sopen_doserr:
	mov	rax,doserrno
	call	osmaperr
    sopen_error:
	invoke	close,rdi
	mov	rax,-1
	jmp	sopen_end
sopen	endp
endif
	end
