include	clib.inc
ifdef __TE__
include	clip.inc
include	wsub.inc
include	string.inc
include	stdio.inc
include	conio.inc
include	tinfo.inc
include	keyb.inc
include	mouse.inc
include	alloc.inc
include	io.inc
include	iost.inc
include	ctype.inc
ifdef __DLL__
 include io.inc
 include dos.inc
 include plugins.inc
endif
ifdef __DZ__
 include fblk.inc
 externdef configfile:byte
else
externdef	IDD_TEHelp:dword
endif
externdef	IDD_TEReload:dword
externdef	IDD_TEReload2:dword
externdef	IDD_TESave:dword
externdef	IDD_TEOpenFiles:dword
externdef	IDD_TESeek:dword
externdef	IDD_Replace:dword
externdef	IDD_ReplacePrompt:dword
;externdef	IDD_TEUseTabs:dword

externdef	cp_noname:byte
externdef	CP_ENOMEM:byte
externdef	format_u:byte
externdef	cp_linetolong:byte
ifdef __DZ__
externdef	cp_erexcommand:byte
endif

ticurcp		proto
ticurlp		proto
tiseto		proto
tiputs		proto
ticontinue	proto
tihome		proto
tidown		proto
tialignx	proto
tialigny	proto
tinocando	proto
tireadstyle	proto
tihome		proto
tiputc		proto
titoend		proto
tievent		proto
tiprevword	proto
tinextword	proto
tidoiflines	proto
tiretevent	proto

ifdef __DZ__
DZHELP_EDIT	equ 4003
view_readme	proto _CType
event_reload	proto _CType
endif

;-----------------------------------------------------------------------------
; Alloc file buffer
;-----------------------------------------------------------------------------

	.data
	emmp	dd 0		; Allocated page
	curh	d? -1		; Current owners handle
	curp	d? -1		; Current page for this handle

	.code

	;--------------------------------------------------------------
	; Validate tinfo (AX)
	; return CX .ti_flag, DL .dl_flag, ES:AX dialog
	;--------------------------------------------------------------

tistate proc _CType public uses rbx
	mov	rbx,rax
	test	rax,rax
	jz	@F
	sub	rax,rax
	mov	rcx,[rbx].S_TINFO.ti_flag
	LPES	rbx,[rbx].S_TEDIT.ti_dialog
	test	rbx,rbx
	jz	@F
	test	rcx,_T_MALLOC
	jz	@F
	test	rcx,_T_LINEBUF
	jz	@F
	mov	dl,byte ptr PEBX.S_DOBJ.dl_flag
	test	dl,_D_DOPEN
	jz	@F
	mov	rax,rbx
      @@:
	ret
tistate endp

tialloc proc public uses rsi rdi rbx
	xor	rdi,rdi
	mov	rsi,rax
	cmp	tepages,EMSMINPAGES
	jb	tialloc_lokal
	call	emminit
	jz	tialloc_lokal
	call	emmcoreleft
	jz	tialloc_lokal
	mov	rax,rcx
	cmp	rax,EMSMINPAGES
	jb	tialloc_lokal
	cmp	rax,tepages
	jb	@F
	mov	rax,tepages
      @@:
	mov	rdi,rax
	lodm	emmp
    ifdef __f__
	test	eax,eax		; same page for all files..
    else
	test	rdx,rdx		; same page for all files..
    endif
	jnz	@F
	mov	rax,0402h
	call	palloc
	jz	tialloc_fail
    ifndef __f__
	inc	rdx		; + 16
	xor	rax,rax		; zero offset
    endif
	stom	emmp
      @@:
	stom	[rsi].S_TINFO.ti_bp	; base pointer to page
	or	[rsi].S_TINFO.ti_flag,_T_MALLOC
	invoke	emmalloc,rdi
    ifndef __f__
	inc	rax
	jz	tialloc_emmfail
	mov	[rsi].S_TEDIT.ti_emmh,rdx
    else
	test	eax,eax
	jz	tialloc_emmfail
	mov	[esi].S_TEDIT.ti_emmh,eax
    endif
	mov	[rsi].S_TEDIT.ti_emmp,0
	or	[rsi].S_TINFO.ti_flag,_T_EMMBUF
	jmp	tialloc_style
    tialloc_fail?:
	mov	rax,rsi
	call	tifree
    tialloc_fail:
	invoke	ermsg,0,addr CP_ENOMEM
	sub	rax,rax
	jmp	tialloc_end
    tialloc_emmfail:
	mov	rax,rsi
	call	tifree
    tialloc_lokal:
	mov	rax,tinfo
	call	tistate
	jnz	tialloc_fail
	mov	rax,4004h
	call	palloc
	jz	tialloc_fail
	inc	rdx
	sub	rax,rax
	or	[rsi].S_TINFO.ti_flag,_T_MALLOC
	stom	[rsi].S_TINFO.ti_bp
	mov	rdi,16
    tialloc_style:
	mov	rax,((STYLESIZE + WMAXPATH) / 16) + 1
	call	palloc
	jz	tialloc_fail?
	invoke	strcpy,dxax,addr cp_noname
	stom	[rsi].S_TEDIT.ti_file
	add	ax,WMAXPATH
	stom	[rsi].S_TEDIT.ti_style
	invoke	memzero,dxax,STYLESIZE
	mov	rax,128
	mov	cl,telsize
	shl	rax,cl
	mov     [rsi].S_TINFO.ti_bcol,rax
	mov	rbx,rax
    ifdef __f__
	mov	eax,4000h
	sub	edx,edx
	mul	edi
	div	ebx
    else
	sub	ax,ax
	cwd
	inc	dx
	div	bx
	shr	di,2
	mul	di
    endif
	mov	[rsi].S_TINFO.ti_brow,rax
	mov	rax,rsi
	call	timemzero
	inc	rax
    tialloc_end:
	ret
tialloc endp

tifree	proc public uses rsi
	mov	rsi,rax
	mov	rax,[rsi].S_TINFO.ti_flag
	test	rax,_T_MALLOC or _T_EMMBUF
	jz	tifree_end
	test	rax,_T_EMMBUF
	jz	@F
	invoke	emmfree,[rsi].S_TEDIT.ti_emmh
	mov	rax,-1
	mov	curh,rax		; Force a reread of the page
	mov	curp,rax
	jmp	tifree_name
      @@:
	mov	rax,[rsi].S_TINFO.ti_flag
	test	rax,_T_MALLOC
	jz	tifree_end
      ifdef __f__
	invoke	free,[esi].S_TINFO.ti_bp
      else
	mov	ax,word ptr [si].S_TINFO.ti_bp[2] ; free seg - 1
	dec	ax
	invoke	free,ax::ax		; free() only use segment..
      endif
    tifree_name:
	invoke	free,[rsi].S_TEDIT.ti_file
    tifree_end:
	and	[rsi].S_TINFO.ti_flag,not (_T_MALLOC or _T_EMMBUF)
	ret
tifree	endp

;-----------------------------------------------------------------------------
; Open
;-----------------------------------------------------------------------------

tigetfile proc _CType public uses rbx
	sub rax,rax	; AX first file
	mov rdx,rax	; DX last file
	mov rbx,tinfo
	.if rbx
	    .if [rbx].S_TINFO.ti_flag & _T_FILE
		mov rdx,rbx
		.repeat
		    mov rax,rbx
		    mov rbx,[rbx].S_TEDIT.ti_prev
		    .break .if !rbx
		.until rbx == rdx
		mov rbx,rdx
		.repeat
		    mov rdx,rbx
		    mov rbx,[rbx].S_TEDIT.ti_next
		    .break .if !rbx
		.until rbx == rax
		inc rbx
	    .endif
	.endif
	ret
tigetfile endp

tiopen proc public uses rsi rbx
	.if func(nalloc,SIZE S_TEDIT)
	    push rax
	    invoke memzero,ssax,SIZE S_TEDIT
	    pop rsi
	    mov al,at_background[B_Desktop]
	    or  al,at_foreground[F_Desktop]
	    mov [rsi].S_TINFO.ti_clat,al
	    mov [rsi].S_TEDIT.ti_stat,al
	    mov dl,al
	    .if func(dlscreen,addr [rsi].S_TEDIT.ti_DOBJ,rdx)
		stom [rsi].S_TEDIT.ti_dialog
		xor rax,rax
		mov [rsi].S_TINFO.ti_xpos,rax
		mov [rsi].S_TINFO.ti_ypos,rax
		mov [rsi].S_TINFO.ti_cursor.cr_xy,rax
		mov [rsi].S_TINFO.ti_cursor.cr_type,CURSOR_NORMAL
		mov al,[rsi].S_TEDIT.ti_DOBJ.dl_rect.rc_col
		mov [rsi].S_TINFO.ti_cols,rax
		mov al,[rsi].S_TEDIT.ti_DOBJ.dl_rect.rc_row
		mov [rsi].S_TINFO.ti_rows,rax
		mov al,' '
		mov [rsi].S_TINFO.ti_clch,al
		mov [rsi].S_TEDIT.ti_stch,al
		mov rax,rsi
		.if func(tialloc)
		    .if func(tigetfile)
			mov rbx,rdx
			mov [rsi].S_TEDIT.ti_prev,rbx	; Link to last file
			mov [rbx].S_TEDIT.ti_next,rsi
		    .endif
		    mov  rax,teflag
		    or   [rsi].S_TINFO.ti_flag,rax
		    mov  rax,rsi
		    test rax,rax
		    jmp  @F
		.endif
		invoke dlclose,[rsi].S_TEDIT.ti_dialog
	    .endif
	    invoke nfree,rsi
	    xor rax,rax
	.endif
      @@:
	ret
tiopen endp

;-----------------------------------------------------------------------------
; Get line from buffer
;-----------------------------------------------------------------------------

tipushh	proc
	mov	rax,curh
	cmp	rax,-1
	je	@F
	cmp	rax,[rsi].S_TEDIT.ti_emmh
	je	tipushh_end
	invoke	emmwrite,emmp,curh,curp
      @@:
	mov	rax,[rsi].S_TEDIT.ti_emmh
	mov	curh,rax
	mov	rax,[rsi].S_TEDIT.ti_emmp
	mov	curp,rax
	invoke	emmread,emmp,curh,curp
    tipushh_end:
	ret
tipushh	endp

tigetline proc public 	; Get line from <tinfo> - tigetline(AX) --> DX:AX
	mov	rdx,tinfo
tigetline endp

timemline proc public 	; Get line from <[dx]> - timemline(AX,DX) --> DX:AX
	push	rsi
	push	rdi
	mov	rdi,rax				; line
	mov	rsi,rdx				; &tinfo
	mov	rax,[rsi].S_TINFO.ti_flag
	test	rax,_T_LINEBUF
	jz	timemline_nol
	cmp	rdi,[rsi].S_TINFO.ti_brow
	jnb	timemline_null
	test	rax,_T_EMMBUF
	mov	rax,[rsi].S_TINFO.ti_bcol
	jz	timemline_malloc
	mov	rax,[rsi].S_TEDIT.ti_emmh	; Init current EMM handle
	cmp	curh,rax			; same handle ?
	je	@F
	call	tipushh
      @@:
	mov	rax,[rsi].S_TINFO.ti_bcol	; size of line
	shl	rax,2				; * 4 (align segment)
	mul	rdi   				; * line (DX to page)
    ifdef __f__
    	mov	edx,eax
	shr	edx,16
	and	eax,0FFFFh
    endif
	cmp	rdx,[rsi].S_TEDIT.ti_emmp
	je	timemline_pageok
	push	rdx
	push	rax
	push	rdx
	invoke	emmwrite,[rsi].S_TINFO.ti_bp,[rsi].S_TEDIT.ti_emmh,[rsi].S_TEDIT.ti_emmp
	pop	rax
	invoke	emmread,[rsi].S_TINFO.ti_bp,[rsi].S_TEDIT.ti_emmh,rax
	test	rax,rax
	pop	rax
	pop	rdx
	jnz	timemline_null
    timemline_pageok:
	mov	[rsi].S_TEDIT.ti_emmp,rdx	; save page offset
	mov	curp,rdx
	shr	rax,6
    timemline_ok:
      ifdef __f__
	add	eax,[esi].S_TINFO.ti_bp
	cmp	rdi,[rsi].S_TEDIT.ti_lcnt
	jnb	timemline_new
	test	eax,eax
      else
	add	ax,word ptr [si].S_TINFO.ti_bp+2 ; + segment
	mov	rdx,rax
	xor	rax,rax
	cmp	rdi,[rsi].S_TEDIT.ti_lcnt
	jnb	timemline_new
	test	rdx,rdx
      endif
	clc       			; Carry set if new line
    timemline_end:
	pop	rdi
	pop	rsi
	ret
    timemline_null:			; ZF and CF set on error
	xor	rax,rax
	mov	rdx,rax
	jmp	timemline_new
    timemline_nol:
	lodm	[rsi].S_TINFO.ti_bp
    timemline_new:
      ifdef __f__
	test	eax,eax
      else
	test	rdx,rdx
      endif
	stc
	jmp	timemline_end
    timemline_malloc:
	shr	rax,4			; line size in para
	mul	rdi			; * line offset
	jmp	timemline_ok
timemline endp

timemzero proc public uses rsi rdi rbx
	mov	rbx,rax
	sub	rsi,rsi
	cld?
      @@:
	mov	rax,rsi
	mov	rdx,rbx
	call	timemline
	jz	@F
	mov16	es,dx
	mov	rdi,rax
	sub	rax,rax
	mov	rcx,[rbx].S_TINFO.ti_bcol
    ifdef __f__
	shr	rcx,2
	rep	stosd
    else
	shr	rcx,1
	rep	stosw
    endif
	inc	rsi
	jmp	@B
      @@:
	ret
timemzero endp

ticlose proc public uses rsi rdi rbx
	mov rsi,rax
	sub rdi,rdi
	.if [rsi].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
	    call tifree
	    invoke dlclose,[rsi].S_TEDIT.ti_dialog
	.endif
	.if func(tigetfile)
	    mov rdi,[rsi].S_TEDIT.ti_prev
	    mov rbx,[rsi].S_TEDIT.ti_next
	    mov [rsi].S_TEDIT.ti_prev,0
	    mov [rsi].S_TEDIT.ti_next,0
	    .if rbx && [rbx].S_TEDIT.ti_prev == rsi
		mov [rbx].S_TEDIT.ti_prev,rdi
	    .endif
	    .if rdi && [rdi].S_TEDIT.ti_next == rsi
		mov [rdi].S_TEDIT.ti_next,rbx
	    .else
		mov rdi,rbx
	    .endif
	.endif
	mov tinfo,rdi
	invoke nfree,rsi
	sub rax,rax
	ret
ticlose endp

tisavechanges proc pascal uses rdi
local DLG_TESave:dword
	.if func(rsopen,IDD_TESave)
	    stom   DLG_TESave
	    invoke dlshow,dxax
	    LPES   rdi,DLG_TESave
	    sub    rcx,rcx
	    mov    cl,PEDI[6]
	    sub    cl,10
	    mov    ax,PEDI[4]
	    add    ax,0205h
	    mov    dl,ah
	    mov    rdi,tinfo
	    invoke scpath,rax,rdx,rcx,[rdi].S_TEDIT.ti_file
	    invoke rsevent,IDD_TESave,DLG_TESave
	    invoke dlclose,DLG_TESave
	    mov    rax,rdx
	.endif
	ret
tisavechanges endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

	.data
	cp_linefeed db 0Dh,0Ah,0
	.code

tiofread proc public uses rsi rdx
	mov	rax,STDI.ios_l	; current line
	cmp     STDI.ios_c,0	; first line ?
	je	@F
	inc	STDI.ios_l	; get next line
	inc	rax
      @@:
	call	tigetline
	jc 	tiofread_eof
	invoke	strcpy,STDI.ios_bp,dxax
	invoke	strcat,dxax,addr cp_linefeed
	mov	rsi,rax
	mov	ah,' '
	cld?
      @@:
	lodsb
	test	al,al
	jz	@F
	cmp	al,TITABCHAR
	jne	@B
	mov	[rsi-1],ah
	jmp	@B
      @@:
	invoke	strlen,STDI.ios_bp
	mov	STDI.ios_c,rax
	sub	rax,rax
	mov	STDI.ios_i,rax
	inc	rax
    tiofread_end:
	ret
    tiofread_eof:
	sub	rax,rax
	jmp	tiofread_end
tiofread endp

tiseekst proc public	; cx dx:ax | ecx eax
    ifdef __f__
	mov	edx,eax
	shr	edx,16
	and	eax,0FFFFh
    endif
      @@:
	push	rax			; ax: offset
	mov	[rsi].S_IOST.ios_l,rdx	; dx: line
	mov	[rsi].S_IOST.ios_c,0
	call	tiofread
	pop	rax
	jz	tiseekst_fail
	cmp	[rsi].S_IOST.ios_c,rax
	ja	tiseekst_end
	inc	rcx
	sub	rax,rax
	jmp	@B
    tiseekst_end:
	mov	[rsi].S_IOST.ios_i,rax
	inc	rax
	ret
    tiseekst_fail:
	sub	rax,rax
	ret
tiseekst endp

	;----------------------------------------------------
	; This is used by all search funtions
	; lines is copyed to _bufin and converted
	;
	; .ios_l - current line
	; .ios_i - current offset
	; .ios_c - strlen line
	; ?
	; .ios_bb (low word) -- offset
	; .ios_bb (high word) - line
	;----------------------------------------------------

titostdi proc public uses rbx
	invoke	oinitst,addr STDI,0
	mov	al,fsflag
	and	al,IO_SEARCHMASK
	or	rax,IO_LINEBUF
	mov	STDI.ios_flag,rax
	call	ticurcp
	mov16	es,dx
	mov	rbx,rax		; cursor may be set above actual line size
	cmp	byte ptr PEBX,0
	jne	@F
	call	titoend
      @@:
	mov	rbx,tinfo
	mov	rax,[rbx].S_TINFO.ti_boff
	add	rax,[rbx].S_TINFO.ti_xoff
	mov	WORDP STDI.ios_bb,rax
	mov	rax,[rbx].S_TINFO.ti_loff
	add	rax,[rbx].S_TINFO.ti_yoff
	mov	STDI.ios_l,rax
	mov	word ptr STDI.ios_bb+2,ax
	call	tiofread
	mov	rax,WORDP STDI.ios_bb
	mov	STDI.ios_i,rax
	ret
titostdi endp

;-----------------------------------------------------------------------------
;
;-----------------------------------------------------------------------------

	.data
	cp_filetolong	db 'File too big, no more memory',0
	tab_c1 db ?
	tab_c2 db ?
	usetab db ?

	.code

tilineerror:
	push	rdx
	call	oungetc
	test	[rsi].S_TINFO.ti_flag,_T_MODIFIED
	jnz	@F
	or	[rsi].S_TINFO.ti_flag,_T_MODIFIED
	invoke	ermsg,0,addr cp_linetolong
      @@:
	pop	rdx
	ret

tireaderror:
	invoke	ermsg,0,addr cp_filetolong
	ret

tiiost:
	push	rax
	invoke	memzero,ssbx,SIZE S_IOST
	pop	rax
	mov	[rbx].S_IOST.ios_file,rax
	mov	[rbx].S_IOST.ios_size,2048
	mov	WORDP [rbx].S_IOST.ios_bp,offset _bufin + 2048
	mov16	word ptr [bx].S_IOST.ios_bp[2],ds
	ret

tiread	proc
	push	rsi	; AX tinfo
	push	rdi
	push	rbx
	push	rbp
	mov	rsi,rax
	mov	tab_c1,' '	; v2.39 - include Use Tabs and Tab Size
	mov	tab_c2,' '
	mov	usetab,0
	test	[rsi].S_TINFO.ti_flag,_T_USETABS
	jz	@F
	mov	tab_c1,9
	mov	tab_c2,TITABCHAR
	mov	usetab,1
      @@:
	call	tiftime
	stom	[rsi].S_TEDIT.ti_time
	invoke	openfile,[rsi].S_TEDIT.ti_file,M_RDONLY,A_OPEN
	inc	rax
	mov	rbp,rax
	jz	tiread_end
	dec	rax
	mov	rbx,offset STDI
	call	tiiost
	invoke	lseek,STDI.ios_file,0,SEEK_END
	stom	[rsi].S_TEDIT.ti_size
	invoke	lseek,STDI.ios_file,0,SEEK_SET
	xor	rax,rax
	mov	rbp,rax
	call	tigetline
	jz	tiread_error
      ifdef __f__
	mov	ebx,eax
      endif
	mov	rdi,rbp
    tiread_read:
	call	ogetc
	mov16	es,dx
	jz	tiread_eof
	test	al,al
	jz	tiread_line	; binary file
	cmp	al,0Dh
	je	tiread_read
	cmp	al,0Ah
	je	tiread_line
	cmp	al,09h
	je	tiread_tab
	cmp	rdi,[rsi].S_TINFO.ti_bcol
	je	tiread_maxlen
      ifdef __f__
	mov	[edi+ebx],al
	inc	edi
      else
	stosb
      endif
	jmp	tiread_read
    tiread_tab:
	cmp	usetab,0
	jne	tiread_do
if 1
	inc	usetab
	or	[rsi].S_TINFO.ti_flag,_T_MODIFIED
else
	push	rdx
	invoke	rsmodal,IDD_TEUseTabs
	pop	rdx
	mov16	es,dx
	inc	usetab
	.if rax
	    or [rsi].S_TINFO.ti_flag,_T_USETABS
	    mov tab_c1,9
	    mov tab_c2,TITABCHAR
	.else
	    or [rsi].S_TINFO.ti_flag,_T_MODIFIED
	.endif
endif
    tiread_do:
	mov	al,tab_c1
      ifdef __f__
	mov	[edi+ebx],al
	inc	edi
      else
	stosb
      endif
	mov	al,tab_c2
	mov	cl,tetabsize
	dec	cl
	and	rcx,TIMAXTABSIZE-1
    tiread_tloop:
	test	rdi,rcx
	jz	tiread_read
	cmp	rdi,[rsi].S_TINFO.ti_bcol
	je	tiread_maxlen
      ifdef __f__
	mov	[edi+ebx],al
	inc	edi
      else
	stosb
      endif
	jmp	tiread_tloop
    tiread_maxlen:			; line to big..
      ifdef __f__
	mov	[edi+ebx-1],ah
      else
	mov	es:[di-1],ah
      endif
	call    tilineerror
    tiread_line:
	inc	rbp
	mov	rax,rbp
	call	tigetline
      ifdef __f__
	mov	ebx,eax
      endif
	jz	tiread_tobig
	xor	rdi,rdi
	jmp	tiread_read
    tiread_tobig:
	call	tireaderror		; file to big..
    tiread_error:
	mov	rbp,-1
    tiread_eof:
	invoke	close,STDI.ios_file
	inc	rbp
	mov	[rsi].S_TEDIT.ti_lcnt,rbp
    tiread_end:
	mov	rax,rbp
	test	rax,rax
	pop	rbp
	pop	rbx
	pop	rdi
	pop	rsi
	ret
tiread	ENDP

topen proc _CType public uses rsi file:dword
	xor rax,rax
	.if func(tiopen)
	    mov rsi,rax
	    or [rsi].S_TINFO.ti_flag,_T_FILE
	    mov tinfo,rax
	    lodm file
	    .if rax
		invoke wlongpath,0,dxax
	    .else
		mov16 dx,ds
		mov rax,offset cp_noname
		inc [rsi].S_TEDIT.ti_lcnt ; set line count to 1
	    .endif
	    invoke strcpy,[rsi].S_TEDIT.ti_file,dxax
	    .if rax != offset cp_noname
		call tireadstyle
		mov rax,rsi
		call tiread
		.if ZERO?
		    mov rax,rsi
		    call ticlose
		    sub rsi,rsi
		.endif
	    .endif
	    mov rax,rsi
	.endif
	test rax,rax
	ret
topen endp

tclose proc _CType public uses rbx
	mov rax,tinfo
	.if func(tistate)
	    mov rbx,tinfo
	    .if [rbx].S_TINFO.ti_flag & _T_MODIFIED
		.if func(tisavechanges)
		    mov rax,tinfo
		    call tiflush
		.endif
	    .endif
	    mov rax,tinfo
	    call ticlose
	    mov rax,tinfo
	.endif
	test rax,rax
	ret
tclose endp

tcloseall proc _CType public
	call	tclose
	jnz	tcloseall
	ret
tcloseall endp

;-----------------------------------------------------------------------------
; Open files
;-----------------------------------------------------------------------------

	.data

DLG_OpenFiles	dd ?
FCB_OpenFiles	d? ?
MAXDLGOBJECT	equ 16
MAXOBJECTLEN	equ 38
MAXOPENFILES	equ 64

	.code

event_xcell:
	push	rbx
	LPES	rbx,DLG_OpenFiles
	xor	rax,rax
	mov	al,PEBX.S_DOBJ.dl_index
	mov	rbx,FCB_OpenFiles
	mov	[rbx].S_LOBJ.ll_celoff,rax
	call	dlxcellevent
	pop	rbx
	retx

event_list:
	push rbp
	push rsi
	push rdi
	push rbx
	invoke dlinit,DLG_OpenFiles
	LPES rbx,DLG_OpenFiles
	add rbx,SIZE S_TOBJ
	mov rcx,MAXDLGOBJECT
	.repeat
	    or PEBX.S_TOBJ.to_flag,_O_STATE
	    add rbx,SIZE S_TOBJ
	.untilcxz
	mov rbx,WORDP DLG_OpenFiles
	sub rax,rax
	mov al,PEBX[4]
	add al,3
	mov rsi,rax		; x-pos
	mov al,PEBX[5]
	add rax,1
	mov rdi,rax		; y
	xor rbp,rbp		; loop
	mov16 dx,es
	mov rcx,rbx
	.repeat
	    mov rax,rbp
	    mov rbx,FCB_OpenFiles
	    .break .if rax >= [rbx].S_LOBJ.ll_numcel
	    add rax,[rbx].S_LOBJ.ll_index
	    add rax,rax
	    LPES rbx,[rbx].S_LOBJ.ll_list
	    add rbx,rax
	    mov rbx,PEBX
	    .if [rbx].S_TINFO.ti_flag & _T_MODIFIED
		mov rax,rsi
		dec rax
		invoke scputc,rax,rdi,1,'*'
	    .endif
	    invoke scpath,rsi,rdi,MAXOBJECTLEN,[rbx].S_TEDIT.ti_file
	    add rcx,SIZE S_TOBJ
	    mov16 es,dx
	    mov rbx,rcx
	    and PEBX.S_TOBJ.to_flag,not _O_STATE
	    inc rdi
	    inc rbp
	.until 0
	mov rax,1
	pop rbx
	pop rdi
	pop rsi
	pop rbp
	retx

tdlgopen proc _CType public uses rsi rdi rbx
local ll:S_LOBJ
local ti[MAXOPENFILES]:word
	lea	rax,ll
	mov	FCB_OpenFiles,rax
	invoke	memzero,ssax,SIZE S_LOBJ
	lea	rax,ti
	mov	WORDP ll.ll_list,rax
	mov16	word ptr ll.ll_list+2,ss
	invoke	memzero,ssax,MAXOPENFILES*2
	mov	ll.ll_dcount,MAXDLGOBJECT	; number of cells (max)
	movp	ll.ll_proc,event_list
	.if func(tigetfile)
	    mov rsi,rax
	    sub rbx,rbx
	    mov rdi,WORDP ll.ll_list
	    .repeat
		mov rax,rsi
		.break .if !func(tistate)
		mov [rdi],rsi
		add rdi,2
		mov rsi,[rsi].S_TEDIT.ti_next
		inc rbx
	    .until rbx == MAXOPENFILES
	    mov ll.ll_count,rbx
	    mov rax,rbx
	    .if rax >= MAXDLGOBJECT
		mov rax,MAXDLGOBJECT
	    .endif
	    mov ll.ll_numcel,rax
	    .if func(rsopen,IDD_TEOpenFiles)
		stom DLG_OpenFiles
		mov  rdi,rax
		mov  rcx,MAXDLGOBJECT
		mov  rax,offset event_xcell
		movl dx,cs
		.repeat
		    add  rdi,SIZE S_TOBJ
		    stom PEDI.S_TOBJ.to_proc
		.untilcxz
		invoke dlshow,DLG_OpenFiles
		pushl  cs
		call   event_list
		invoke dllevent,DLG_OpenFiles,addr ll
		LPES   rbx,DLG_OpenFiles
		mov    dx,PEBX[4]
		LPES   rbx,IDD_TEOpenFiles
		mov    PEBX[6],dx
		invoke dlclose,DLG_OpenFiles
		mov rax,rdx
		.if rax
		    sub rax,rax
		    mov rbx,FCB_OpenFiles
		    .if [rbx].S_LOBJ.ll_count
			mov rax,[rbx].S_LOBJ.ll_index
			add rax,[rbx].S_LOBJ.ll_celoff
			add rax,rax
			lea rbx,ti
			add rbx,rax
			mov rax,[rbx]
		    .endif
		.endif
	    .endif
	.endif
	test rax,rax
	ret
tdlgopen endp

titogglemenus proc public
	mov rax,tinfo
	.if func(tistate)
	    push rsi
	    push rbx
	    mov rbx,rax
	    mov dx,PEBX[4]
	    mov cx,PEBX[6]
	    mov rsi,tinfo
	    mov rax,[rsi].S_TINFO.ti_flag
	    xor rax,_T_USEMENUS
	    mov [rsi].S_TINFO.ti_flag,rax
	    and rax,_T_USEMENUS
	    .if !ZERO?
		mov al,dh
		inc al
		mov [rsi].S_TINFO.ti_ypos,rax
		mov al,ch
		dec al
		mov [rsi].S_TINFO.ti_rows,rax
		mov rcx,[rsi].S_TINFO.ti_cols
		mov bl,dh
		mov ah,at_background[B_Menus]
		mov al,' '
		invoke scputw,rdx,rbx,rcx,rax
		inc dl
		sub rcx,19
		invoke scpath,rdx,rbx,rcx,[rsi].S_TEDIT.ti_file
	    .else
		mov al,dh
		mov [rsi].S_TINFO.ti_ypos,rax
		mov al,ch
		mov [rsi].S_TINFO.ti_rows,rax
		mov rcx,[rsi].S_TINFO.ti_cols
		mov ah,[rsi].S_TINFO.ti_clat
		mov al,[rsi].S_TINFO.ti_clch
		.if [rsi].S_TINFO.ti_flag & _T_USESTYLE
		    mov ah,[rsi].S_TEDIT.ti_stat
		    mov al,[rsi].S_TEDIT.ti_stch
		.endif
		mov bl,dh
		invoke scputw,rdx,rbx,rcx,rax
	    .endif
	    pop rbx
	    pop rsi
	    call tiputs
	.endif
	jmp ticontinue
titogglemenus endp

	.data
	cp_extbak db '.bak',0
	cp_exttmp db '.$$$',0

	.code

tistrip proc public uses rsi rdi rax rcx
	push16	ds
	mov	cl,tetabsize
	dec	cl
	and	rcx,TIMAXTABSIZE-1
	mov16	es,dx
	mov16	ds,dx
	mov	rsi,rax
	mov	rdi,rax
	cld?
	mov	ah,cl
	inc	ah
      @@:
	lodsb
	dec	ah
	jz	@F
	cmp	al,TITABCHAR
	je	@B
      @@:
	dec	rsi
    tistrip_lod:
	lodsb
	test	al,al
	jz	tistrip_eof
	cmp	al,9
	je      tistrip_09h
    tistrip_sto:
	stosb
	jmp	tistrip_lod
    tistrip_09h:
	stosb
	test	rsi,rcx
	jz	tistrip_lod
	mov	ah,cl
	inc	ah
      @@:
	lodsb
	test	al,al
	jz	tistrip_eof
	cmp	al,9
	je	tistrip_09h
	cmp	al,TITABCHAR
	jne	tistrip_sto
	dec	ah
	jz	tistrip_sto
	jmp	@B
    tistrip_eof:
	stosb
    tistrip_end:
	pop16	ds
	ret
tistrip endp

; strip space, BH and BL from end of line (DX:AX)
; uses CX, tinfo.ti_bcnt
; return CX strlen(line)

tistripl proc public uses rsi rdi rbx rbp
	mov	rbp,tinfo
	push16	es
	mov	rsi,rax
	invoke	strlen,dxax
	mov	rdi,rsi
	add	rdi,rax
	mov	rcx,rax
	mov	rax,[rbp].S_TINFO.ti_flag
	test	rax,_T_LINEBUF
	jz	tistripl_end
	and	rax,_T_USECONTROL
	jnz	tistripl_end
    tistripl_len:
	dec	rdi
	cmp	rdi,rsi
	jl      tistripl_end
	mov	al,PEDI
	cmp	al,bl
	je	@F
	cmp	al,bh
	je	@F
	cmp	al,' '
	jne	tistripl_end
      @@:
	mov	PEDI,ah
	dec	rcx
	jnz	tistripl_len
    tistripl_end:
	test	rcx,rcx
	mov	[rbp].S_TINFO.ti_bcnt,rcx
	mov	rax,rsi
	pop16	es
	ret
tistripl endp

tistripline proc public uses rbx
	call	ticurlp
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	ret
tistripline endp

size_of_line	equ [rbp-size_l]

; xchange line [AX] <--> [BP]
; size of line: [BP-2]
; uses DI
;
; while (getline(AX++))
;     xchange(AX, BP);
;
; return AX + 1 or -1

tixchgl	proc public uses rsi
    tixchgl_get:
	push	rax
	call	tigetline
	mov	rcx,size_of_line
	mov16	es,dx
	mov	rdi,rax
	mov	rsi,rbp
	jc	tixchgl_eof
      @@:
	mov	al,PEDI
	movsb
	mov	[rsi-1],al
	dec	rcx
	jnz	@B
	pop	rax
	inc	rax
	jmp	tixchgl_get
    tixchgl_eof:
	jz	tixchgl_end
      @@:
	mov	al,PEDI
	movsb
	mov	[rsi-1],al
	dec	rcx
	jnz	@B
	inc	rcx
    tixchgl_end:
	pop	rax
	ret
tixchgl	endp

; Insert a line below line[AX]

tinsline proc public uses rsi rdi rbp
	mov	rsi,tinfo
	mov	rbx,rax		; BX to line index
	mov	rax,[rsi].S_TINFO.ti_bcol
	sub	rsp,rax		; create a line buffer on the stack
	mov	rbp,rsp		; buffer to BP
	push	rax
      ifdef __f__
	invoke	memzero,ebp,eax	; blank line
      else
	invoke	memzero,ss::bp,ax
      endif
	mov	rax,[rsi].S_TEDIT.ti_lcnt ; room for one more line ?
	cmp	rax,[rsi].S_TINFO.ti_brow
	jae	tinsline_eof
	mov	rax,rbx		; insert the blank line
	inc	rax
	call	tixchgl		; return index to last line
	cmp	rax,[rsi].S_TEDIT.ti_lcnt
	jne	tinsline_eof
	inc	[rsi].S_TEDIT.ti_lcnt
    tinsline_end:
	add	rsp,[rbp-size_l]; free buffer
	pop	rcx		; line size
	test	rax,rax		; line count
	ret
    tinsline_eof:
	xor	rax,rax
	jmp     tinsline_end
	ret
tinsline endp

simove:				; move string to &string[1]
	lodsb
	cmp	rsi,rcx		; CX max offset
	jae	simove_eof
	mov     [rsi-1],ah
	mov	ah,al
	test	al,al
	jnz	simove
	test	rcx,rcx
    simove_end:
	mov     [rsi],al	; terminate string
	ret
    simove_eof:
	xor	rax,rax
	jmp	simove_end

tiexpand proc public uses rsi rdi rbp rbx rax
	push16	ds
	mov	bl,tetabsize
	mov	rbp,tinfo
	test	[rbp].S_TINFO.ti_flag,_T_USETABS
	jz	tiexpand_ret
    ifndef __f__
	mov	es,dx
	mov	ds,dx
    endif
	dec	bl
	and     rbx,TIMAXTABSIZE-1
	mov	rsi,rax
	mov	rdi,rax
	cld?
	mov	rcx,[rbp].S_TINFO.ti_bcol
	dec	rcx
    tiexpand_next:
	lodsb
	test	al,al
	jz	tiexpand_eos
	cmp	al,9
	je	tiexpand_09h
	cmp	rdi,rcx
	je	tiexpand_end
	stosb
	jmp	tiexpand_next
    tiexpand_end:
	mov	al,0
	stosb
    tiexpand_ret:
	pop16	ds
	ret
    tiexpand_eos:
	test	rcx,rcx
	jmp	tiexpand_end
    tiexpand_09h:		; insert TAB char
	stosb
	cmp	rdi,rcx
	jae	tiexpand_end
      @@:			; insert "spaces" to next Tab offset
	mov	ah,TITABCHAR
	test	rsi,rbx
	jz	tiexpand_next
	push	rsi
	call	simove
	pop	rsi
	jz	tiexpand_ret
	inc	rsi
	mov	rdi,rsi
	jmp	@B
tiexpand endp

tienterni proc public uses rsi rdi rbp rbx
	mov	rsi,tinfo
	mov	rbx,[rsi].S_TINFO.ti_brow
	mov	rax,[rsi].S_TINFO.ti_loff
	add	rax,[rsi].S_TINFO.ti_yoff
	mov	rdi,rax
	inc	rax
	cmp	rax,rbx
	mov	rax,_TI_RETEVENT
	jb	tienterni_do
	dec	rbx
	jz	tienterni_end
    tienterni_nocando:
	call	tinocando
	jmp	tienterni_end
    tienterni_CONTINUE:
	mov	rax,_TI_CONTINUE
    tienterni_end:
	ret
    tienterni_do:
	mov	rax,rdi
	call	tinsline
	jz	tienterni_nocando
	mov	rcx,[rsi].S_TINFO.ti_bcol
	or	[rsi].S_TINFO.ti_flag,_T_MODIFIED
	sub	rsp,rcx
	mov	rbp,rsp
	call	ticurcp
	push16	dx
	push	rax
      ifdef __f__
	invoke	strcpy,ebp,eax
      else
	invoke	strcpy,ss::bp,dx::ax
      endif
	pop	rbx
	pop16	es
	sub	rax,rax
	mov	PEBX,al
	;
	; need to get indent if line above if stripped..
	;
	call	ticurlp
	mov	rbx,rax
	sub	rcx,rcx
      @@:
    	mov	al,PEBX
	inc	rcx
	inc	rbx
	call	isspace
	jnz	@B
	mov	bl,al		; add indent if last char is zero
	mov	bh,0
	mov	rax,rdi
	inc	rax
	call	tigetline
	jz	tienterni_home
	mov	rdi,rax
	dec	rcx
	jz	tienterni_home
	test	bl,bl
	jnz	tienterni_home
	mov	al,' '
	mov16	es,dx
	mov	rbx,rcx
	rep	stosb
    tienterni_push:
	mov	al,TITABCHAR
      @@:
	cmp	[rbp],al
	jne	tienterni_cpy
	inc	rbp
	jmp	@B
    tienterni_home:
	sub	rbx,rbx
	jmp	tienterni_push
    tienterni_cpy:
      ifdef __f__
	invoke	strcpy,edi,ebp
      else
	invoke	strcpy,dx::di,ss::bp
      endif
	test    [rsi].S_TINFO.ti_flag,_T_USETABS
	jz	tienterni_done
	call	tistrip
	call	tiexpand
    tienterni_done:
	add	rsp,[rsi].S_TINFO.ti_bcol
	test	rbx,rbx		; just move down if indent
	jz	@F
	call	tidown
	call	tiprevword
	call	tinextword
	jmp	tienterni_end
      @@:
    	call	tihome
	call	tidown
	jmp	tienterni_end
tienterni endp

tienter_putc:
	mov	rax,[rsi].S_TINFO.ti_xoff
	add	rax,[rsi].S_TINFO.ti_boff
	push	rax
	mov	al,dl
	call	tiputc
	cmp	rax,_TI_CONTINUE
	pop	rdx
	mov	rax,0
	jne	@F
	mov	rax,[rsi].S_TINFO.ti_xoff
	add	rax,[rsi].S_TINFO.ti_boff
	sub	rax,rdx
      @@:
	test	rax,rax
	ret

tigetindent proc public
	push	rsi
	push	rdi
	mov	rsi,tinfo
	call	tigetline
	jz	tigetindent_end
	mov16	es,dx
	mov	rdi,rax
	add	rax,[rsi].S_TINFO.ti_bcol
	mov	rdx,rax
	xor	rcx,rcx
      @@:
	mov	al,PEDI
	call	isspace
	jz	@F
	inc	rcx
	inc	rdi
	cmp	rdi,rdx
	jb	@B
      @@:
	mov	rax,rcx
    tigetindent_end:
	pop	rdi
	pop	rsi
	ret
tigetindent endp

tienter proc public
	call	tidoiflines
	push	rsi
	push	rdi
	mov	rsi,tinfo
	call	tienterni
	cmp	rax,_TI_CONTINUE
	je	@F
	cmp	rax,_TI_RETEVENT
	je	tienter_ret
	jmp	tienter_end
      @@:
	mov	rax,[rsi].S_TINFO.ti_flag
	and	rax,_T_USEINDENT
	jz	tienter_end
	mov	rax,[rsi].S_TINFO.ti_loff
	add	rax,[rsi].S_TINFO.ti_yoff
	dec	rax
	call	tigetindent
if 0
	call	tigetline
	jz	tienter_end
	mov16	es,dx
	mov	rdi,rax
	add	rax,[rsi].S_TINFO.ti_bcol
	mov	rdx,rax
	xor	rcx,rcx
      @@:
	mov	al,PEDI
	call	isspace
	jz	@F
	inc	rcx
	inc	rdi
	cmp	rdi,rdx
	jb	@B
      @@:
	test	rcx,rcx
	jz	tienter_end
	mov	rdi,rcx
endif
	test	rax,rax
	jz	tienter_end
	mov	rdi,rax
	test	[rsi].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	tienter_space
      @@:
	cmp	rdi,8
	jb	tienter_space
	mov	dl,9
	call	tienter_putc
	jz	tienter_end
	cmp	rdi,rax
	jbe	tienter_end
	sub	rdi,rax
	jmp	@B
    tienter_space:
	mov	dl,' '
	call	tienter_putc
	jz	tienter_end
	dec	rdi
	jnz	tienter_space
    tienter_end:
	pop	rdi
	pop	rsi
	jmp	ticontinue
    tienter_ret:
	pop	rdi
	pop	rsi
	jmp	tiretevent
tienter endp

tioptimalfill proc public uses rsi rbx rcx
	mov	bl,9
	mov	bh,TITABCHAR
	call	tistripl
	mov	rsi,tinfo
	test	[rsi].S_TINFO.ti_flag,_T_LINEBUF
	jz	optimalfill_end
	test	[rsi].S_TINFO.ti_flag,_T_OPTIMALFILL
	jz	optimalfill_end
	test	[rsi].S_TINFO.ti_flag,_T_USETABS
	jz	optimalfill_end
	cmp	tetabsize,8
	jne	optimalfill_end
	cmp	rcx,8
	jb	optimalfill_end
	push16	ds
	push	rax
	mov	rsi,rax
	mov16	ds,dx
	mov16	es,dx
    optimalfill_load:
	test	rsi,7
	jnz	optimalfill_skip
	mov	rbx,rsi
	lodsb
	cmp	al,' '
	jne	optimalfill_test
      @@:
	lodsb
	cmp	al,' '
	je	@B
	mov	rcx,rsi
	sub	rcx,rbx
	mov	rsi,rbx
	lodsb
	cmp	rcx,9
	jb	optimalfill_test
	xchg	rbx,rdi
	mov	al,9
	stosb
	mov	al,TITABCHAR
	mov	cx,7
	rep	stosb
	mov	rsi,rdi
	mov	rdi,rbx
	dec	rsi
    optimalfill_skip:
	lodsb
    optimalfill_test:
	test	al,al
	jnz	optimalfill_load
    optimalfill_eos:
	pop	rax
	pop16	ds
    optimalfill_end:
	ret
tioptimalfill endp

tiflushl proc public uses rsi rdi rbp
	;
	; Produce output to clipboard or file
	;
	; args:	AX start line	?, 0
	;	DX start offset	?, 0
	;	CX end line	?, line count - 1 ?
	;	BX end offset	?, -1
	;
	mov	rsi,tinfo
	mov	rbp,rax
	mov	rdi,rdx
	call	tigetline
	jz	tiflushl_eoi
	jnc	@F		; CF set if string buffer
	test	[rsi].S_TINFO.ti_flag,_T_LINEBUF
	jnz	tiflushl_eoi	; else CF is EOF
      @@:
	call	tioptimalfill
	add	rdi,rax
	add	rbx,rax
    tiflushl_loop:
	mov16	es,dx
	inc	rdi
	mov	rax,[rsi].S_TINFO.ti_bcol
	cmp	rbp,rcx
	jne	@F
	mov	rax,rbx
      @@:
	cmp	rdi,rax
	ja	tiflushl_eob
	mov	al,PEDI[-1]
	or	al,al
	jz	tiflushl_eol
	cmp	al,9
	je	tiflushl_tab
    tiflushl_put:
	assert	al,0,jne,"tiflushl: al=0"
	call	oputc
	jnz	tiflushl_loop	; out of space..
    tiflushl_eof:
	xor	rax,rax
	stc
	jmp	tiflushl_end
    tiflushl_tab:
	mov	rax,rdi
	mov	ah,tetabsize
	dec	ah
	and	ah,TIMAXTABSIZE-1
	and	al,ah
	jz 	tiflushl_putt
      @@:
	mov	ah,PEDI
	cmp	ah,TITABCHAR
	jne	tiflushl_putt
	inc	rdi
	inc	al
	cmp	al,tetabsize
	jb	@B
    tiflushl_putt:
	mov	al,9
	jmp	tiflushl_put
    tiflushl_eob:		; end of selection buffer
	cmp	rbp,rcx		; break if last line
	je	tiflushl_eok
    tiflushl_eol:		; end of line
	inc	rbp
	cmp	rbp,rcx
	ja	tiflushl_last	; break if last line (BP==CX)
	mov	rax,rbp
	call	tigetline
	jbe	tiflushl_eoi	; break if last line (EOF)
	call	tioptimalfill
	mov	rdi,rax
	test	[rsi].S_TINFO.ti_flag,_T_USECRLF
	jz	@F		; insert line: 0D0A or 0A
	mov	al,0Dh
	call	oputc
      @@:
	mov	al,0Ah
	call	oputc
	jz	tiflushl_eof
	mov	rax,rdi
	jmp	tiflushl_loop
    tiflushl_eoi:		; end of input (CF)
	xor	rax,rax
	inc	rax
	stc
	jmp	tiflushl_end
    tiflushl_last:
	dec	rbp
    tiflushl_eok:
	xor	rax,rax
	inc	rax
	clc
    tiflushl_end:		; out:	AX result
	mov	rbx,rdi		;	DX line index
	mov	rdx,rbp		;	BX line offset
	ret
tiflushl endp

tisave	proc public
	mov  rbx,rax
	test [rbx].S_TINFO.ti_flag,_T_FILE
	jnz  tiflush
	jmp  ticontinue
tisave endp

tiflush	proc pascal public uses rsi rdi
local path[WMAXPATH]:byte
	mov rsi,rax
	lea rdi,path
	invoke strcpy,ssdi,[rsi].S_TEDIT.ti_file
	invoke setfext,ssdi,addr cp_exttmp
	.if func(oopen,dxax,M_WRONLY)
	    xor rax,rax
	    mov rdx,rax
	    mov rcx,[rsi].S_TEDIT.ti_lcnt
	    dec rcx
	    mov rbx,rax
	    dec rbx
	    .if !func(tiflushl)
		invoke oclose,addr STDO
		invoke remove,ssdi
		xor rdi,rdi
	    .else
		call oflush
		invoke oclose,addr STDO
		.if [rsi].S_TINFO.ti_flag & _T_USEBAKFILE
		    invoke setfext,ssdi,addr cp_extbak
		    invoke remove,ssdi
		    invoke rename,[rsi].S_TEDIT.ti_file,ssdi
		    invoke setfext,ssdi,addr cp_exttmp
		.endif
		invoke remove,[rsi].S_TEDIT.ti_file
		invoke rename,ssdi,[rsi].S_TEDIT.ti_file
		inc rax
		mov rdi,rax
		and [rsi].S_TINFO.ti_flag,not _T_MODIFIED
		mov rax,rsi
		call tiftime
		stom [rsi].S_TEDIT.ti_time
	    .endif
	.endif
	mov  rax,rdi
	test rax,rax
	ret
tiflush endp

tilseek proc public uses rbx
local DLG_TESeek:dword
	.if func(rsopen,IDD_TESeek)
	    stom DLG_TESeek
	    mov rbx,tinfo
	    mov rcx,[rbx].S_TINFO.ti_loff
	    add rcx,[rbx].S_TINFO.ti_yoff
	    mov rbx,rax
	    invoke sprintf,PEBX[24],addr format_u,rcx
	    invoke dlinit,DLG_TESeek
	    .if func(rsevent,IDD_TESeek,DLG_TESeek)
		LPES rbx,DLG_TESeek
		invoke strtol,PEBX[24]
		call tialigny
	    .endif
	    invoke dlclose,DLG_TESeek
	    call tiputs
	.endif
	sub rax,rax
	ret
tilseek	endp

	.data
	;
	; These are characters used as valid identifiers (Alt-S)
	;
	idchars db '0123456789_?@abcdefghijklmnopqrstuvwxyz',0

	.code

tisearchfound proc public
	push	rbx
	mov	rax,STDI.ios_l
	call	tialigny
	invoke	strlen,addr searchstring
	mov	rdx,STDI.ios_i
	sub	rdx,rax
	push	rax
	mov	rax,rdx
	dec	rax
	call	tialignx

	call	ticurcp	; v2.38 - line may be short by 1
	pop	rcx	; - the real reason is currently unknown..
	push	rcx
	invoke	strnicmp,dxax,addr searchstring,rcx
	jz	@F
	mov	rbx,tinfo
	inc	[rbx].S_TINFO.ti_loff
      @@:

	call	ticlipset
	pop	rax
	push	rax
	mov	rbx,tinfo
	add	[rbx].S_TINFO.ti_cleo,rax
	call	tiputs
	call	ticlipset
	pop	rcx
	pop	rbx
	jmp	ticontinue
tisearchfound endp

tisearch proc public
	call	titostdi
	call	ogetc
	invoke	cmdsearch,00010000h
	push	rax
	and	fsflag,not IO_SEARCHMASK
	mov	rax,STDI.ios_flag
	and	al,IO_SEARCHMASK
	or	fsflag,al
	pop	rax
	test	rax,rax
	jnz	tisearchfound
	jmp	ticontinue
tisearch endp

ticontinuesearch proc public
	call	titostdi
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	call	continuesearch
	test	rax,rax
	jnz	tisearchfound
	inc	rax
	ret
ticontinuesearch endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ID_YES	equ	1
ID_ALL	equ	2
ID_NO	equ	3

iddreplaceprompt proc
	mov rax,1
	mov rbx,tinfo
	.if [rbx].S_TINFO.ti_flag & _T_PROMPTONREP
	    .if func(rsmodal,IDD_ReplacePrompt)
		mov rdx,rax
		.if rax
		    dec rdx
		.endif
		mov rbx,WORDP IDD_ReplacePrompt
		mov [rbx].S_ROBJ.rs_index,dl
		mov rbx,tinfo
		.if rax == ID_ALL
		    xor [rbx].S_TINFO.ti_flag,_T_PROMPTONREP
		.endif
	    .endif
	.endif
	test rax,rax
	ret
iddreplaceprompt endp

ID_OLDSTRING	equ 1*16
ID_NEWSTRING    equ 2*16
ID_USECASE	equ 3*16
ID_PROMPT	equ 4*16
ID_CURSOR	equ 5*16
ID_GLOBAL	equ 6*16
ID_OK		equ 7
ID_CHANGEALL	equ 8

iddreplace proc pascal uses rbx sflag:size_t
local	DLG_Replace:dword
	.if func(rsopen,IDD_Replace)
	    stom DLG_Replace
	    mov  PEBX.S_TOBJ.to_count[ID_OLDSTRING],128 shr 4
	    mov  PEBX.S_TOBJ.to_count[ID_NEWSTRING],128 shr 4
	    mov16 dx,ds
	    mov  rax,offset searchstring
	    stom PEBX.S_TOBJ.to_data[ID_OLDSTRING]
	    mov  rax,offset replacestring
	    stom PEBX.S_TOBJ.to_data[ID_NEWSTRING]
	    mov  rax,sflag
	    mov  dl,_O_FLAGB
	    .if rax & IO_SEARCHCASE
		or PEBX[ID_USECASE],dl
	    .endif
	    .if rax & _T_PROMPTONREP
		or PEBX[ID_PROMPT],dl
	    .endif
	    mov dl,_O_RADIO
	    .if rax & IO_SEARCHCUR
		or PEBX[ID_CURSOR],dl
	    .else
		or PEBX[ID_GLOBAL],dl
	    .endif
	    invoke dlinit,DLG_Replace
	    .if func(rsevent,IDD_Replace,DLG_Replace)
		mov rax,sflag
		and rax,not (IO_SEARCHMASK or _T_PROMPTONREP)
		mov dl,_O_FLAGB
		.if PEBX[ID_USECASE] & dl
		    or rax,IO_SEARCHCASE
		.endif
		.if PEBX[ID_PROMPT] & dl
		    or rax,_T_PROMPTONREP
		.endif
		.if byte ptr PEBX[ID_CURSOR] & _O_RADIO
		    or rax,IO_SEARCHCUR
		.else
		    or rax,IO_SEARCHSET
		.endif
		mov rdx,rax
		xor rax,rax
		.if searchstring != al
		    .if replacestring != al
			inc rax
		    .endif
		.endif
	    .endif
	    push rdx
	    invoke dlclose,DLG_Replace
	    mov rax,rdx
	    pop rdx
	.endif
	test rax,rax
	ret
iddreplace endp

tireplace proc public uses rsi rdi rbx
	mov rsi,tinfo
	mov rax,_T_PROMPTONREP
	or  [rsi].S_TINFO.ti_flag,rax
	mov al,fsflag
	and al,IO_SEARCHMASK
	.if func(iddreplace,rax)
	    and fsflag,not IO_SEARCHMASK
	    or  fsflag,dl
	    .if rax == ID_CHANGEALL || !(rdx & _T_PROMPTONREP)
		and [rsi].S_TINFO.ti_flag,not _T_PROMPTONREP
	    .endif
	    .if !func(ticontinuesearch)
		jmp @F
		.repeat
		    call titostdi
		    and STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
		    .break .if !func(continuesearch)
		    call tisearchfound
		    @@:
		    mov rdi,rcx
		    .break .if !func(iddreplaceprompt)
		    .if rax != ID_NO
			add  [rsi].S_TINFO.ti_cleo,rdi		; select text
			call ticlipdel			; delete text
			mov  rdi,offset replacestring	; add new text
			.repeat
			    mov al,[rdi]
			    inc rdi
			    .break .if !al
			    call tiputc
			.until 0
		    .else
			call ticontinuesearch
		    .endif
		.until 0
	    .endif
	.endif
	call tiputs
	xor rax,rax
	ret
tireplace endp

idtestal:
	push16	es
	push	rdi
	push	rcx
	push	rax
	cmp	al,'A'
	jb	@F
	cmp	al,'Z'
	ja	@F
	or	al,20h
      @@:
	push16	ds
	pop16	es
	mov	rdi,offset idchars
	mov	rcx,sizeof idchars
	cld?
	repne	scasb
	cmp	byte ptr [rdi-1],0
	pop	rax
	pop	rcx
	pop	rdi
	pop16	es
	ret

tisearchxy proc pascal public uses rsi rdi rbx
local	linebuf[128]:byte
	call	cursorx		; get cursor x,y pos
	mov	rdi,rax
	mov	rbx,rdx
	inc	rdi		; to start of line..
      @@:
	dec	rdi		; moving left seeking a valid character
	jz	@F
	invoke	getxyc,rdi,rbx
	call	idtestal
	jz	@B
	mov	rax,rdi
	dec	rax
	invoke	getxyc,rax,rbx
	call	idtestal
	jnz	@B
      @@:
	lea	rsi,linebuf
	mov	rcx,32
	xor	rax,rax
      @@:
	invoke	getxyc,rdi,rbx
	inc	rdi
	call	idtestal
	jz	@F
	mov	[rsi],al
	inc	rsi
	dec	rcx
	jnz	@B
      @@:
	sub	rax,rax
	mov	[rsi],al
	mov	al,linebuf
	test	al,al
	jz	@F
	invoke	strcpy,addr searchstring,addr linebuf
	call	tisearch
      @@:
	ret
tisearchxy endp

;-----------------------------------------------------------------------------
; Event handler
;-----------------------------------------------------------------------------

	.data

te_keytable label size_t
	d? KEY_F1,	__F1		; Help
	d? KEY_F2,	__F2		; Save file
	d? KEY_F3,	tisearch	; Search
	d? KEY_F4,	tireplace	; Replace
	d? KEY_F6,	__F6
  ifdef __DZ__
	d? KEY_F7,	tiloadfiles
	d? KEY_F8,	tisavefiles
	d? KEY_F9,	__Esc
	d? KEY_ESC,	__Esc		; Exit - leave files open
	d? KEY_ALTX,	__AltX		; Exit - Close all files
	d? KEY_CTRLX,	__CtrlX		; Close current file
  else
	d? KEY_F9,	__AltX
	d? KEY_ESC,	__AltX
	d? KEY_ALTX,	__AltX
	d? KEY_CTRLX,	__AltX
  endif
	d? KEY_F11,	titogglemenus	; Zoom (Ctrl-M)
	d? KEY_CTRLF2,	__CtrlF2	; Save as
	d? KEY_CTRLF9,	__CtrlF9	; Options

	d? KEY_CTRLA,	__CtrlA		; Select All
	d? KEY_CTRLB,	__CtrlB		; User screen
	d? KEY_CTRLF,	__CtrlF		; Optimal fill on/off
	d? KEY_CTRLG,	tilseek		; Goto line
	d? KEY_CTRLI,	__CtrlI		; Autoindent on/off
	d? KEY_CTRLL,	__CtrlL		; Search again
	d? KEY_CTRLM,	titogglemenus	; Toggle menus on/off
	d? KEY_CTRLO,	__CtrlB		;
	d? KEY_CTRLR,	__CtrlR		; Reload file
	d? KEY_CTRLS,	__CtrlS		; Toggle style on/off
	d? KEY_CTRLT,	__CtrlT		; Tabs mode on/off
	d? KEY_ALTL,	tilseek		;
	d? KEY_ALTS,	tisearchxy	; Word search
	d? KEY_ALT0,	__Alt0		; Window List
  ifdef __DLL__
	d? KEY_SHIFTF1,	__ShiftF1	; [Compile]
	d? KEY_SHIFTF2,	__ShiftF2
	d? KEY_SHIFTF3,	__ShiftF3
	d? KEY_SHIFTF4,	__ShiftF4
	d? KEY_SHIFTF5,	__ShiftF5
	d? KEY_SHIFTF6,	__ShiftF6
	d? KEY_SHIFTF7,	__ShiftF7
	d? KEY_SHIFTF8,	__ShiftF8
	d? KEY_SHIFTF9,	__ShiftF9
	d? KEY_ALTF1,	__AltF1
	d? KEY_ALTF2,	__AltF2
	d? KEY_ALTF3,	__AltF3
	d? KEY_ALTF4,	__AltF4
	d? KEY_ALTF5,	__AltF5
	d? KEY_ALTF6,	__AltF6
	d? KEY_ALTF7,	__AltF7	; Previous error
	d? KEY_ALTF8,	__AltF8	; Next error
	d? KEY_ALTF9,	__AltF9	; [Compile]
  endif
	tekeycount equ (($ - offset te_keytable) / (size_l * 2))
  ifdef __DLL__
	cp_AltFX	db 'AltF'
	cp_AltX		db '1',0
	cp_ShiftFX	db 'ShiftF'
	cp_ShiftX	db '1',0
	cp_te		db '*.te',0
	cp_pipe		db 'pipe'
	cp_errext	db '.err',0
	error_count	d? ?
	error_id	d? ?
  endif

	.code

tioption:
	call teoption
	mov rbx,tinfo
	mov rax,[rbx].S_TINFO.ti_flag
	mov rcx,teflag
	mov rdx,rax
	and rax,not _T_TECFGMASK
	or  rax,rcx
	mov [rbx].S_TINFO.ti_flag,rax
	mov rax,rdx
	and rax,_T_USETABS
	and rcx,_T_USETABS
	.if rax != rcx
	    mov rax,1
	    .if rdx & _T_MODIFIED
		.if func(tisavechanges)
		    mov rax,tinfo
		    call tiflush
		.endif
	    .endif
	    .if rax
		call __CtrlR
	    .endif
	.endif
	retx

__CtrlF9:
	pushl	cs
	call	tioption
	jmp	ticontinue

__F1:
  ifdef __DZ__
	mov  rax,DZHELP_EDIT
	call view_readme
  else
	invoke rsmodal,IDD_TEHelp
  endif
	jmp ticontinue

__F2:
	mov  rax,tinfo
	call tisave
	jmp  ticontinue

__F6:
	.if func(tigetfile)
	    mov rbx,tinfo
	    .if [rbx].S_TEDIT.ti_next
		mov rax,[rbx].S_TEDIT.ti_next
	    .endif
	    jmp titogglefile
	.endif
	ret

titogglefile:
	push rsi
	push rdi
	mov rdi,rax
	mov rsi,tinfo
	.if rdi != rsi
	    .if [di].S_TINFO.ti_flag & _T_MALLOC or _T_EMMBUF
		invoke	dlhide,[rsi].S_TEDIT.ti_dialog
		invoke	dlshow,[rdi].S_TEDIT.ti_dialog
		mov	tinfo,rdi
		xor	[rdi].S_TINFO.ti_flag,_T_USEMENUS
		call	titogglemenus
		invoke	cursorset,addr [rdi].S_TINFO.ti_cursor
	    .endif
	.endif
	pop rdi
	pop rsi
	jmp ticontinue

__Alt0:
	.if func(tdlgopen)
	    jmp titogglefile
	.endif
	ret

__CtrlF2:
	mov rbx,tinfo
	invoke strcpy,addr _bufin,[rbx].S_TEDIT.ti_file
	invoke strfn,dxax
	.if rax != offset _bufin
	    mov rbx,rax
	    mov byte ptr [rbx-1],0
	.endif
	.if func(wdlgopen,addr _bufin,dxax,0)
	    mov rbx,tinfo
	    invoke strcpy,[rbx].S_TEDIT.ti_file,dxax
	    mov rax,tinfo
	    call tiflush
	    mov rbx,tinfo
	    xor [rbx].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	.endif
    	sub rax,rax
	ret

__CtrlA:
	call tiselectall
	call tiseto
	jmp  titoggleupdate

__CtrlB:
	call consuser
	sub  rax,rax
	ret

__CtrlI:
	mov rax,_T_USEINDENT
	jmp @F
__CtrlF:
	mov rax,_T_OPTIMALFILL
	jmp @F
__CtrlS:
	mov rax,_T_USESTYLE
	jmp @F
__CtrlT:
	mov rax,_T_SHOWTABS
      @@:
	mov rbx,tinfo
	xor [rbx].S_TINFO.ti_flag,rax
	jmp titoggleupdate

__CtrlL:
	call	ticontinuesearch
	jmp	ticontinue

titoggleupdate:
	call	tiputs
	jmp	ticontinue

__CtrlR:
	push	rbx
	mov	rbx,tinfo
	test	[rbx].S_TINFO.ti_flag,_T_MODIFIED
	pop	rbx
	jz	@F
	invoke	rsmodal,IDD_TEReload2
	jnz	@F
	jmp	ticontinue
      @@:
	mov	rax,tinfo
	call	timemzero
	mov	rax,tinfo
	call	tiread
	jz	@F
	call	tiseto
	call	tiputs
	jmp	ticontinue
      @@:
	mov	rdi,KEY_ESC
	dec	rax
	ret

ifdef __DZ__
	;------------------------------------------
	; Close window and exit -- leave files open
	;------------------------------------------
__Esc:
	push	rbx
	mov	rbx,tinfo
	test	rbx,rbx
	jz	@F
	test	[rbx].S_TINFO.ti_flag,_T_EMMBUF
	lodm	[rbx].S_TEDIT.ti_dialog
      @@:
	pop	rbx
	jz	__CtrlX
	invoke	dlhide,dxax
	mov	rax,_TI_RETEVENT
	ret
	;----------------------------------------
	; Close current file -- exit if last file
	;----------------------------------------
__CtrlX:
	push	rbx
	call	tclose
	mov	rax,_TI_RETEVENT
	jz	@F
	mov	rbx,tinfo
	test	rbx,rbx
	jz	@F
	invoke	dlshow,[rbx].S_TEDIT.ti_dialog
	xor	[rbx].S_TINFO.ti_flag,_T_USEMENUS
	invoke	cursorset,addr [rbx].S_TINFO.ti_cursor
	call	titogglemenus
	mov	rax,_TI_CONTINUE
      @@:
	pop	rbx
	ret
endif
	;-----------------------------
	; Close all open files -- exit
	;-----------------------------
__AltX:
	call tcloseall
	mov  rax,_TI_RETEVENT
	ret

ifdef __DLL__

__AltF1:
	push si
	mov si,tinfo
	.if func(topen,addr configfile)
	    mov ax,tinfo
	    mov tinfo,si
	    call titogglefile
	.endif
	pop si
	ret

inicmd	macro l1,id
l1&id&:	mov al,id+'0'
	jmp &l1&X
	endm
;inicmd	__AltF,1
inicmd	__AltF,2
inicmd	__AltF,3
inicmd	__AltF,4
inicmd	__AltF,5
inicmd	__AltF,6
inicmd	__AltF,9
inicmd	__ShiftF,1
inicmd	__ShiftF,2
inicmd	__ShiftF,3
inicmd	__ShiftF,4
inicmd	__ShiftF,5
inicmd	__ShiftF,6
inicmd	__ShiftF,7
inicmd	__ShiftF,8
inicmd	__ShiftF,9
__AltFX:
	mov cp_AltX,al
	mov rax,offset cp_AltFX
	jmp tiexecuteini
__ShiftFX:
	mov cp_ShiftX,al
	mov rax,offset cp_ShiftFX
	jmp tiexecuteini

inicommand  proto _CType :dword, :dword, :dword

Message	struc
m_file	db WMAXPATH dup(?)
m_info	db 256 dup(?)
m_line	dd ?
Message	ends

GetMessageId proc pascal uses si di M:dword, id:word
    sub si,si
    .if func(filexist,addr cp_pipe) == 1
	.if func(osopen,addr cp_pipe,0,M_RDONLY,A_OPEN) != -1
	    mov di,ax
	    mov ax,SIZE Message
	    mul id
	    invoke lseek,di,dx::ax,SEEK_SET
	    invoke osread,di,M,SIZE Message
	    xchg ax,di
	    invoke close,ax
	    .if di == SIZE Message
		inc si
	    .endif
	.endif
    .endif
    mov ax,si
    ret
GetMessageId endp

LoadMessageFile proc pascal uses si di M:dword
    mov si,tinfo
    mov di,word ptr M
    invoke strfn,addr [di].Message.m_file
    push dx
    push ax
    invoke strfn,[si].S_TEDIT.ti_file
    push dx
    push ax
    call stricmp
    .if ax
	.if func(topen,addr [di].Message.m_file)
	    mov ax,tinfo
	    mov tinfo,si
	    call titogglefile
	    mov si,tinfo
	.else
	    jmp @F
	.endif
    .endif
    mov ax,word ptr [di].Message.m_line
    .if ax
	dec ax
    .endif
    call tialigny
    call tiseto
    call tiputs
    lea ax,[di].Message.m_info
    mov bx,[si].S_TINFO.ti_yoff
    .if bl <= 1
	add bl,2
    .endif
    .if !([si].S_TINFO.ti_flag & _T_USEMENUS)
	dec bl
    .endif
    invoke scputs,0,bx,4Fh,[si].S_TINFO.ti_cols,ss::ax
    mov ax,1
  @@:
    ret
LoadMessageFile endp

__AltF7	proc pascal	; Previous Error
    local M:Message
    .if error_count
	.if func(GetMessageId, addr M, error_id)
	    invoke LoadMessageFile, addr M
	    .if error_id
		dec error_id
	    .else
		mov ax,error_count
		dec ax
		mov error_id,ax
	    .endif
	.endif
    .endif
    mov ax,_TI_CONTINUE
    ret
__AltF7 endp

__AltF8	proc pascal	; Next Error
    local M:Message
    .if error_count
	.if func(GetMessageId,addr M,error_id)
	    invoke LoadMessageFile,addr M
	    mov ax,error_id
	    inc ax
	    .if ax >= error_count
		sub ax,ax
	    .endif
	    mov error_id,ax
	.endif
    .endif
    mov ax,_TI_CONTINUE
    ret
__AltF8 endp

	.data
	format_ss db '%s',10,'%s',0
	reload	  db 0
	.code
cmspawnini proc pascal IniSection:dword
	.if func(filexist,addr cp_pipe)
	    invoke remove,addr cp_pipe
	.endif
	sub ax,ax
	mov bx,tinfo
	.if [bx].S_TINFO.ti_flag & _T_EMMBUF
	    .if [bx].S_TINFO.ti_flag & _T_MODIFIED
		call __F2
		mov bx,tinfo
	    .endif
	    invoke dlhide,[bx].S_TEDIT.ti_dialog
	    mov bx,tinfo
	    invoke strfn,[bx].S_TEDIT.ti_file
	    push dx
	    push ax
	    .if func(filexist,dx::ax)
		pop ax
		pop dx
	    .else
		pop ax
		pop dx
		lodm [bx].S_TEDIT.ti_file
	    .endif
	    .if func(inicommand,addr __srcfile,dx::ax,IniSection)
		mov dx,ds
		mov reload,1
		mov bx,offset __srcfile
		mov ah,_DZ_command
		mov al,SPAWN_HIDE
		int DZ
		cld
		.if ax || dx
		    invoke ermsg,0,addr format_ss, addr cp_erexcommand,addr __srcfile
		    sub ax,ax
		.else
		    mov ax,1
		.endif
	    .endif
	.endif
	ret
cmspawnini endp

tiexecuteini:
	push si
	push di
	mov error_count,0
	mov si,tinfo
	invoke cmspawnini,ds::ax
	push ax
	invoke dlshow,[si].S_TEDIT.ti_dialog
	call __CtrlR
	pop ax
	.if ax
	    .if func(filexist,addr cp_pipe) == 1
		.if func(osopen,addr cp_pipe,0,M_RDONLY,A_OPEN) != -1
		    mov di,ax
		    invoke lseek,di,0,SEEK_END
		    mov cx,SIZE Message
		    div cx
		    mov error_id,0
		    mov error_count,ax
		    invoke close,di
		.endif
		.if error_count
		    call __AltF8
		.endif
	    .endif
	.endif
	sub ax,ax
	pop di
	pop si
	ret

endif ; __DLL__

	.data
	cp_tionfo	db ' col %-3u ln %-5u',0
	tiupdate_line	d? -1
	tiupdate_offs	d? -1

	.code

timenus proc public
	push rsi
	mov  rsi,tinfo
	mov  rax,rsi
	.if func(tistate)
	    .if dl & _D_ONSCR && rcx & _T_USEMENUS
		mov  rbx,rax
		mov  rax,[rsi].S_TINFO.ti_loff
		add  rax,[rsi].S_TINFO.ti_yoff
		inc  rax
		push rax
		mov  rax,[rsi].S_TINFO.ti_xoff
		add  rax,[rsi].S_TINFO.ti_boff
		push rax
		mov  rax,PEBX[4]
		add  al,PEBX.S_DOBJ.dl_rect.rc_col
		sub  al,18
		mov  cl,ah
		invoke scputf,rax,rcx,0,0,addr cp_tionfo
		add rsp,size_l*2
		mov rax,' '
		.if [rsi].S_TINFO.ti_flag & _T_MODIFIED
		    mov al,'*'
		.endif
		invoke scputw,0,rcx,1,rax
	    .endif
	.endif
	pop rsi
	xor rax,rax
	ret
timenus endp

tiftime proc public uses rsi rdi
	local ft:S_FTIME
	mov rsi,rax
	sub rax,rax
	mov ft.ft_time,ax
	mov ft.ft_date,ax
	.if func(osopen,[rsi].S_TEDIT.ti_file,0,M_RDONLY,A_OPEN) != -1
	    mov rdi,rax
	    invoke getftime,rdi,addr ft
	    invoke close,rdi
	.else
	    or [rsi].S_TINFO.ti_flag,_T_MODIFIED
	.endif
	lodm ft
	test rax,rax
	ret
tiftime	endp

teevent proc public uses rsi rdi rbx
	call tiseto
	call tiputs
	.repeat
	    mov rax,tinfo
	    mov rsi,rax
	    .if func(tiftime)
		.if rax != WORDP [rsi].S_TEDIT.ti_time
		    .if func(rsmodal,IDD_TEReload)
			mov  rax,rsi
			call timemzero
			mov  rax,rsi
			call tiread
			mov  rdi,KEY_ESC
			.break .if ZERO?
			call tiseto
			call tiputs
		    .endif
		.endif
	    .endif
	    call timenus
	    call tgetevent
	    mov  rdi,rax
	    xor  rbx,rbx
	    mov  rcx,tekeycount
	    .repeat
		.if rax == te_keytable[rbx]
		    xor rax,rax
		    .break
		.endif
		add rbx,size_l*2
	    .untilcxz
	    .if rax
	      ifdef __CLIP__
		call ticlipevent
	      endif
		call tievent
		mov  rsi,rax
	    .else
		call te_keytable[rbx+size_l]
		.continue .if ax == _TI_CONTINUE
		.break
	    .endif
	    call tiseto
	    call tiputs
	.until 0
	mov rax,rdi
	ret
teevent endp

tiupdate:
	push rsi
	mov rsi,tinfo
	mov rax,rsi
	.if func(tistate)
	    .if dl & _D_ONSCR && rcx & _T_USEMENUS
		mov rax,[rsi].S_TINFO.ti_loff
		add rax,[rsi].S_TINFO.ti_yoff
		mov rdx,[rsi].S_TINFO.ti_xoff
		add rdx,[rsi].S_TINFO.ti_boff
		.if rax != tiupdate_line || rdx != tiupdate_offs
		    mov tiupdate_offs,rdx
		    mov tiupdate_line,rax
		    call timenus
		.endif
	    .endif
	.endif
	pop rsi
	xor rax,rax
	retx

tmodal proc _CType public uses rsi rdi rbx
local cursor:S_CURSOR
local update:dword
local ftime:dword
	.repeat
	    call mousep
	.until ZERO?
	mov rax,tinfo
	mov rsi,rax
	.if func(tistate)
	    movmx update,tupdate
	    movp tupdate,tiupdate
	    invoke cursorget,addr cursor
	    invoke dlshow,[rsi].S_TEDIT.ti_dialog
	    xor [rsi].S_TINFO.ti_flag,_T_USEMENUS
	    call titogglemenus
	    invoke cursorset,addr [rsi].S_TINFO.ti_cursor
	    mov rax,rsi
	    call tiftime
	    stom ftime
	    call teevent
	    mov rdi,rax
	    mov rax,tinfo
	    .if rsi == rax
		call tiftime
		mov rsi,WORDP ftime
		sub rsi,rax
	    .else
		mov rsi,0
	    .endif
	    mov rax,WORDP update
	    mov WORDP tupdate,rax
	    movl ax,word ptr update+2
	    movl word ptr tupdate+2,ax
	    invoke cursorset,addr cursor
	ifdef __DZ__
	    .if reload
		call event_reload
		mov reload,0
	    .endif
	endif
	    mov rdx,rsi		; zero if not modified
	    mov rax,rdi		; returned key value
	    test rax,rax
	.endif
	ret
tmodal endp

tedit proc _CType public fname:dword, line:size_t
	.if func(topen,fname)
	    mov rax,line
	    call tialigny
	    call tmodal
	.endif
	ret
tedit endp

ifdef __DZ__

topenh proc _CType public uses rsi handle:size_t
local tf:S_TFILE
	.repeat
	    .break .if func(osread,handle,addr tf,SIZE S_TFILE) != SIZE S_TFILE
	    .if func(filexist,addr tf) != 1
		.continue
	    .endif
	    .break .if !func(topen,addr tf)
	    mov rsi,tinfo
	    mov rax,tf.tf_xoff
	    mov [rsi].S_TINFO.ti_xoff,rax
	    mov rax,tf.tf_yoff
	    mov [rsi].S_TINFO.ti_yoff,rax
	    mov rax,tf.tf_boff
	    mov [rsi].S_TINFO.ti_boff,rax
	    mov rax,tf.tf_loff
	    mov [rsi].S_TINFO.ti_loff,rax
	.until 0
	ret
topenh endp

tsaveh	proc _CType public uses rsi rdi handle:size_t
local	tf:S_TFILE
	call tigetfile
	mov  rsi,rax
	mov  rdi,rax
	.while rsi
	    invoke memzero,addr tf,SIZE S_TFILE
	    invoke strcpy,addr tf,[rsi].S_TEDIT.ti_file
	    movmx  tf.tf_time,[rsi].S_TEDIT.ti_time
	    mov    rax,[rsi].S_TINFO.ti_xoff
	    mov    tf.tf_xoff,rax
	    mov    rax,[rsi].S_TINFO.ti_yoff
	    mov    tf.tf_yoff,rax
	    mov    rax,[rsi].S_TINFO.ti_boff
	    mov    tf.tf_boff,rax
	    mov    rax,[rsi].S_TINFO.ti_loff
	    mov    tf.tf_loff,rax
	    invoke oswrite,handle,addr tf,SIZE S_TFILE
	    mov    rax,[rsi].S_TEDIT.ti_next
	    mov    rsi,rax
	    .break .if rdi == rax
	    .break .if !func(tistate)
	.endw
	ret
tsaveh	endp

tiloadfiles proc public
	.if func(wgetfile,addr cp_te,3)
	    push rsi
	    push rdi
	    mov rdi,rax
	    mov rax,tinfo
	    mov rsi,rax
	    .if func(tistate)
		invoke dlhide,[rsi].S_TEDIT.ti_dialog
	    .endif
	    invoke topenh,rdi
	    invoke close,rdi
	    mov rax,tinfo
	    mov rsi,rax
	    .if func(tistate)
		xor [rsi].S_TINFO.ti_flag,_T_USEMENUS
		invoke dlshow,[rsi].S_TEDIT.ti_dialog
	    .endif
	    pop rdi
	    pop rsi
	    jmp titogglemenus
	.endif
	ret
tiloadfiles endp

topensession proc _CType public
local cu:S_CURSOR
	invoke	cursorget,addr cu
	call	tiloadfiles
	sub	rax,rax
	call	tmodal
	invoke	cursorset,addr cu
	ret
topensession endp

tisavefiles proc public uses rsi
	.if func(wgetfile,addr cp_te,2)
	    mov rsi,rax
	    invoke tsaveh,rsi
	    invoke close,rsi
	.endif
	mov rax,_TI_CONTINUE
	ret
tisavefiles endp

wedit proc _CType public uses rsi rdi rbx fcb:dword, count:size_t
	.repeat
	    invoke fbffirst,fcb,count
	    .break .if ZERO?
	    mov rdi,rax
	    and	PEDI.S_FBLK.fb_flag,not _A_SELECTED
	    .if !(rcx & _A_ARCHIVE or _A_SUBDIR)
		add rax,S_FBLK.fb_name
		invoke topen,dxax
	    .endif
	.until ZERO?
	sub rax,rax
	call tmodal
	ret
wedit	endp
endif
endif
	end
