malloc	proc pascal msize:word
	mov cx,msize
	mov ah,_DZ_malloc
	int DZ
	jc malloc_fail	; Zero flag set if fail
	or dx,dx
    malloc_end:
	ret
    malloc_fail:
	xor ax,ax
	jmp malloc_end
malloc	endp

free	proc pascal mseg:dword
	mov dx,word ptr mseg+2
	mov ah,_DZ_free
	int DZ
	ret
free	endp

osopen	proc pascal fname:dword, attrib:word, mode:word, action:word
	mov ah,_DZ_open
	mov al,byte ptr attrib
	mov dx,word ptr fname+2
	mov bx,word ptr fname
	mov ch,byte ptr mode
	mov cl,byte ptr action
	int DZ
	ret
osopen	endp

close	proc pascal osfhnd:word
	mov ah,_DZ_close
	mov bx,osfhnd
	int DZ
	ret
close	endp

dosmaper proc
	mov ah,_DZ_dosmaperr
	int DZ	; Carry flag set if function not supported
	ret
dosmaper endp

ermsg	proc fastcall xtitle:word, format:word
	mov ax,format
	mov bx,xtitle
	.if !bx
	    mov bx,CStr(<"Error">)
	.endif
	call @vsbufin
	mov al,1	; _D_STERR
ermsg	endp

ermsgint proc
	mov dx,cs
	mov ah,_DZ_tmsgbox
	int DZ
	xor ax,ax
	ret
ermsgint endp

stdmsg	proc fastcall xtitle:word, format:word
	mov bx,xtitle
	mov ax,format
	call @vsbufin
	mov al,0
	jmp ermsgint
stdmsg	endp

dzedit	proc pascal fname:dword, line:word
	mov dx,word ptr fname+2
	mov bx,word ptr fname
	mov cx,line
	mov ah,_DZ_edit
	int DZ
	ret
dzedit	endp

rsmodal	proc pascal res:dword
	mov dx,word ptr res+2
	mov bx,word ptr res
	mov ah,_DZ_rsmodal
	int DZ
	or ax,ax
	ret
rsmodal	endp

dzexec	proc pascal command:dword, exe_type:byte
local	mouse:word
local	temp[WMAXPATH]:byte
	push si
	push di
  ifdef __MOUSE__
	call mousey		; save mouse location
	mov bx,ax
	call mousex
	mov ah,bl
	mov mouse,ax
  endif
	test exe_type,4
	jz dzexec_int
	mov dx,cs
	mov ax,CStr("NUL")
	test exe_type,8
	jnz @F
	invoke	strfcat, addr temp, envtemp, addr CString(<"ziplst.tmp">)
    @@:	invoke	osopen, dx::ax, _A_NORMAL, M_RDWR, A_TRUNC or A_CREATE
	mov si,ax
	inc ax
	jz dzexec_end
	mov bx,_STDOUT
	mov ah,45h		; duplicate stdout
	int 21h		; AX new file handle if successful
	assertf	jnc,"_dup()"
	mov di,ax
	mov ah,46h		; set stdout to pipe handle
	mov bx,si
	mov cx,_STDOUT
	int 21h
	assertf	jnc,"dup2()"
	invoke	close, si	; close the pipe handle
    dzexec_int:
	mov dx,word ptr command+2
	mov bx,word ptr command
	mov ah,_DZ_command
	mov al,exe_type
	int DZ
	jc dzexec_fail
	or ax,ax
	jnz dzexec_fail
	inc ax
	test exe_type,4
	jz dzexec_end
	mov ah,46h		; restore original standard output
	mov bx,di
	mov cx,_STDOUT
	int 21h
	invoke close, di	; close duplicate handle
	invoke osopen, addr temp, _A_NORMAL, M_RDONLY, A_OPEN
    dzexec_end:
  ifdef __MOUSE__
	mov si,ax
	mov ax,mouse		; restore mouse x,y
	call mousexy
	mov ax,si
  endif
	or ax,ax
	pop di
	pop si
	ret
    dzexec_fail:
	xor ax,ax
	jmp dzexec_end
dzexec	endp

dzmklist proc pascal o_name:word
	mov	ah,_DZ_mklist
	int	DZ
	test	ax,ax
	jz	dzmklist_count
	mov	ah,_DZ_getsyserr
	int	DZ
	push	dx
	push	ax
	invoke	ermsg, o_name, CStr(<'Error create listfile',10,10,'%s'>)
	add	sp,4
	dec	ax
	jmp	dzmklist_end
    dzmklist_count:
;	inc	ax
	or	cx,dx
	jnz	dzmklist_end
	invoke	ermsg, o_name, CStr(<'Nothing to do..'>)
	dec	ax
    dzmklist_end:
	test	ax,ax
	ret
dzmklist endp

dzview	proc pascal fname:dword, offs:dword
	les bx,fname
	mov dx,word ptr offs+2
	mov cx,word ptr offs
	mov ah,_DZ_view
	int DZ
	ret
dzview	endp
