include	clib.inc
ifdef __CLIP__
include	clip.inc
include	keyb.inc
include	string.inc
include	iost.inc
include	mouse.inc
include	conio.inc
include	tinfo.inc
include	alloc.inc

tigetline	proto
tiremline	proto
tidelete	proto
tiseto		proto
ticontinue	proto
tiflushl	proto
tiputc		proto
tievent		proto

	.data
	winoldap  d? ?
	clipbsize d? ?
	clipboard dd ?

	public	clipbsize
	public	clipboard

	.code

ifndef __f__

OpenClipboard PROC
	mov ax,winoldap
	.if ax
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    inc ax
	.endif
	ret
OpenClipboard ENDP

CloseClipboard PROC
	push	dx
	push	ax
	mov	ax,1708h	; INT 2F - MS Windows - CloseClipboard
	int	2Fh
	pop	ax
	pop	dx
	ret
CloseClipboard ENDP

endif

ClearClipboard proc
	mov clipbsize,0
;    ifndef __f__
	invoke free,clipboard
;    endif
	sub	rax,rax
	mov16	dx,ax
	stom	clipboard
	ret
ClearClipboard endp

ClipboardFree proc _CType public
	call ClearClipboard
	ret
ClipboardFree endp

ClipboardCopy proc _CType public uses rsi rdi rbx string:dword, len:size_t
	mov rdi,len
	call ClearClipboard
	.if console & CON_CLIPB
      ifndef __f__
	    call OpenClipboard
	    .if !ZERO?
		mov  ax,1702h	; EMPTY CLIPBOARD
		int  2Fh	; AX nonzero clipboard has been emptied
		mov  dx,1	; set type to text
		mov  cx,di	; SI:CX = size of data
		xor  si,si	; HSIZE = 0
		les  bx,string	; ES:BX = data
		mov  ax,1703h	; SET CLIPBOARD DATA
		int  2Fh
		call CloseClipboard
		test ax,ax	; nonzero data copied into the Clipboard
		mov  ax,di
		jnz  @F
	    .endif
	    mov ax,di
	    inc ax
	    .if malloc(ax)
	    	stom clipboard
		mov clipbsize,di
	    	mov es,dx
	    	mov bx,ax
	    	add bx,di
	    	mov byte ptr es:[bx],0
	    	invoke memcpy,dx::ax,string,di
	    	mov ax,di
	    .endif
      else
	    .if OpenClipboard(0)
		invoke EmptyClipboard
		inc edi
		.if GlobalAlloc(GMEM_MOVEABLE or GMEM_DDESHARE,edi)
		    dec edi
		    mov esi,eax
		    invoke GlobalLock,eax
		    invoke memcpy,eax,string,edi
		    mov ebx,eax
		    mov byte ptr [ebx+edi],0
		    invoke GlobalUnlock,esi
		    invoke SetClipboardData,CF_TEXT,ebx
;		    invoke GlobalFree,esi
		    mov eax,edi
		.endif
		push eax
   	    	invoke CloseClipboard
		pop eax
	    .endif
      endif
	.endif
      @@:
	ret
ClipboardCopy endp

ClipboardPaste proc _CType public uses rbx
	.if (console & CON_CLIPB)
  ifdef __f__
    	    .if IsClipboardFormatAvailable(CF_TEXT)
	    	.if OpenClipboard(0)
		    .if GetClipboardData(CF_TEXT)
			mov ebx,eax
			.if strlen(eax)
			    mov clipbsize,eax
			    inc eax
			    .if malloc(eax)
			    	invoke strcpy,eax,ebx
				mov clipboard,eax
			    .endif
			.endif
		    .endif
		    push eax
		    call CloseClipboard
		    pop  eax
		.endif
	    .endif
  else
	    mov ax,1701h	; OPEN CLIPBOARD
	    int 2Fh		; nonzero success, else already open
	    mov ax,1704h	; GET CLIPBOARD DATA SIZE
	    mov dx,1		; DX = clipboard format supported
	    int 2Fh		; DX:AX = size of data in bytes
	    .if dx
	    	sub ax,ax	; to big..
	    .endif
	    call CloseClipboard
	    .if !ax || ax >= MAXCLIPSIZE
	    	sub ax,ax
	    	.if clipbsize != ax
		    lodm clipboard
	    	.endif
	    .else
	    	push ax
	    	push ax
	    	call ClearClipboard
	    	call malloc
	    	pop cx
		.if ax
		    mov clipbsize,cx
		    stom clipboard
		    invoke memzero,dx::ax,cx
		    mov ax,1701h
		    int 2Fh
		    mov dx,1
		    les bx,clipboard
		    mov ax,1705h
		    int 2Fh
		    call CloseClipboard
		    lodm clipboard
		.endif
	    .endif
  endif
	.else
	    .if clipbsize
		lodm clipboard
	    .else
		sub rax,rax
		mov16 dx,ax
	    .endif
  	.endif
	test rax,rax
	ret
ClipboardPaste endp

ifndef __f__

Install:
	.if console & CON_CLIPB
	    mov ax,1700h
	    int 2Fh
	    mov dx,ax
	    xor ax,ax		; AX <> 1700h
	    .if dx != 1700h   	; - AL = WINOLDAP major version
		inc ax		; - AH = WINOLDAP minor version
	    .endif
	    mov winoldap,ax
	.endif
	ret

_TEXT	ENDS

pragma_init Install,50

endif ; __f__


externdef IDD_ClipboardWarning:DWORD
;
; Cut		Shift-Del	Ctrl-X
; Copy		Ctrl-Ins	Ctrl-C
; Paste		Shift-Ins	Ctrl-V
; Clear		Del		Ctrl-Del
;

	.code

tiselected proc public uses rbx
	mov	rbx,tinfo
    ifdef __TE__
	mov	rax,[rbx].S_TINFO.ti_clel	; CX line count
	sub	rax,[rbx].S_TINFO.ti_clsl
	mov	rcx,rax
	jnz	@F
    endif
	mov	rax,[rbx].S_TINFO.ti_cleo	; AX byte count
	sub	rax,[rbx].S_TINFO.ti_clso
      @@:
	ret
tiselected endp

ticlipset proc public uses rbx	; set clipboard to current position
	mov	rbx,tinfo
	mov	rax,[rbx].S_TINFO.ti_boff
	add	rax,[rbx].S_TINFO.ti_xoff
	mov	[rbx].S_TINFO.ti_clso,rax
	mov	[rbx].S_TINFO.ti_cleo,rax
    ifdef __TE__
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	mov	rax,[rbx].S_TINFO.ti_loff
	add	rax,[rbx].S_TINFO.ti_yoff
	mov	[rbx].S_TINFO.ti_clsl,rax
	mov	[rbx].S_TINFO.ti_clel,rax
      @@:
    endif
	ret
ticlipset endp

alignxy:
	test	rcx,rcx		; subtract ax then dx while cx--
	je	alignxy_end
	cmp     rax,rcx
	jb	alignxy_00
	sub	rax,rcx
    alignxy_end:
	ret
    alignxy_00:
	sub	rcx,rax
	xor	rax,rax
	sub	rdx,rcx
	ret

tialigncl:
	push	rbx		; goto start of selection
	mov	rbx,tinfo
    ifdef __TE__
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jz	@F
	mov	rdx,[rbx].S_TINFO.ti_loff
	mov	rax,[rbx].S_TINFO.ti_yoff
	mov	rcx,rdx
	add	rcx,rax
	sub	rcx,[rbx].S_TINFO.ti_clsl
	call	alignxy
	mov	[rbx].S_TINFO.ti_loff,rdx
	mov	[rbx].S_TINFO.ti_yoff,rax
      @@:
    endif
	mov	rdx,[rbx].S_TINFO.ti_boff
	mov	rax,[rbx].S_TINFO.ti_xoff
	mov	rcx,rdx
	add	rcx,rax
	sub	rcx,[rbx].S_TINFO.ti_clso
	call	alignxy
	mov	[rbx].S_TINFO.ti_boff,rdx
	mov	[rbx].S_TINFO.ti_xoff,rax
	pop	rbx
	ret

ifdef __TE__

tiremline proc public uses rsi rdi rbx rbp
	mov	rbx,rax      	; AX index of line to remove
	mov	rbp,tinfo      	; DX number of lines to remove
	mov	rcx,[rbp].S_TEDIT.ti_lcnt
	mov	rax,[rbp].S_TINFO.ti_bcol
	sub	rsp,rax
	mov	rbp,rsp
	push	rax		; [bp-2] line size
	mov	rax,rdx
	sub	rcx,rbx
	push	rcx		; [bp-4] max lines
	add	rdx,rbx
	push	rdx		; [bp-6] last line
	push	rax		; [bp-8] count
      @@:
	mov	rax,[rbp-size_l*3]
	call	tigetline
	jc	@F
	mov16	ds,dx
	mov	rsi,rax
	mov	rcx,[rbp-size_l*1]
	shr	rcx,1
	push16	ss
	pop16	es
	mov	rdi,rbp
	rep	movsw
	push16	ss
	pop16	ds
	mov	rax,rbx
	call	tigetline
	jc	tiremlines_err
	mov16	es,dx
	mov	rdi,rax
	mov	rcx,[rbp-size_l*1]
	shr	rcx,1
	mov	rsi,rbp
	rep	movsw
	inc	rbx
      ifdef __f__
	inc	dword ptr [ebp-12]
	dec	dword ptr [ebp-8]
      else
	inc	word ptr [bp-6]
	dec	word ptr [bp-4]
      endif
	jnz	@B
      @@:
	mov	rbx,[rbp-size_l*4]
	mov	rsi,tinfo
      @@:
	mov	rax,[rsi].S_TEDIT.ti_lcnt
	dec	rax
	call	tigetline
	jz	tiremlines_end
	mov16	es,dx
	mov	rdi,rax
	xor	rax,rax
	mov	rcx,[rbp-size_l*1]
	shr	rcx,1
	rep	stosw
	dec	[rsi].S_TEDIT.ti_lcnt
	dec	rbx
	jnz	@B
	inc	rax
    tiremlines_end:
	add	rsp,[rbp-size_l*1]
	add	rsp,size_l*4
	or	rax,rax
	ret
    tiremlines_err:
	xor	rax,rax
	jmp	tiremlines_end
tiremline endp

endif

ticlipdel proc public uses rsi rdi rbx
	invoke	tiselected
  ifdef __TE__
	mov	rdi,rcx		; DI line count selected
	jz	ticlipdel_end
	call	tialigncl	; goto start
	mov	rbx,tinfo
	mov	rax,[rbx].S_TINFO.ti_clsl
	call	tigetline	; get line
	jz	ticlipdel_end
	test	rdi,rdi
	jnz	@F
	or	[rbx].S_TINFO.ti_flag,_T_MODIFIED
      ifdef __f__
	mov	edx,eax		; single line -- copy(start,end)
	add	eax,[ebx].S_TINFO.ti_clso
	add	edx,[ebx].S_TINFO.ti_cleo
	invoke	strcpy,eax,edx
      else
	mov	cx,ax
	add	ax,[bx].S_TINFO.ti_clso
	add	cx,[bx].S_TINFO.ti_cleo
	invoke	strcpy,dx::ax,dx::cx
      endif
	jmp	ticlipdel_set
      @@:
	mov16	es,dx		; multi line
	mov	rsi,rax
	sub	rax,rax
	add	rsi,[rbx].S_TINFO.ti_clso
      ifdef __f__
	mov	[esi],al
      else
	mov	es:[si],al	; start=0
      endif
	mov	rax,[rbx].S_TINFO.ti_clel
	call	tigetline	; get last selected line
	jz	ticlipdel_end
	or	[rbx].S_TINFO.ti_flag,_T_MODIFIED
      ifdef __f__
	mov	edx,eax		; copy(last line,end)
	add	edx,[ebx].S_TINFO.ti_cleo
	invoke	strcpy,eax,edx
      else
	mov	cx,ax
	add	cx,[bx].S_TINFO.ti_cleo
	invoke	strcpy,dx::ax,dx::cx
      endif
	dec	rdi
	jz	ticlipdel_del
	mov     rsi,[rbx].S_TINFO.ti_clsl
	inc	rsi
    ticlipdel_lines:
	mov	rax,rsi
	mov	rdx,rdi
	call	tiremline
    ticlipdel_del:
	call	tidelete
  else	; __TE__
	jz	ticlipdel_end
	mov	rbx,tinfo
	lodm	[rbx].S_TINFO.ti_bp
	mov	rsi,rax
	mov	rdi,[rbx].S_TINFO.ti_cleo
	add	rax,[rbx].S_TINFO.ti_clso
      ifdef __f__
	mov	edx,esi
	add	edx,edi
	invoke	strcpy,eax,edx
      else
	mov	cx,si
	add	cx,di
	invoke	strcpy,dx::ax,dx::cx
      endif
	mov	rdx,rsi
	add	rdx,rdi
	sub	rdx,rax
	mov	rcx,rsi
	add	rcx,[rbx].S_TINFO.ti_boff
	add	rcx,[rbx].S_TINFO.ti_xoff
	cmp	rax,rcx
	je	ticlipdel_set
	sub	[rbx].S_TINFO.ti_xoff,rdx
  endif
    ticlipdel_set:
	call	tiseto
	call	ticlipset
	sub	rax,rax
	inc	rax
    ticlipdel_end:
	ret
ticlipdel endp

ifdef __TE__

tiselectall proc public
	push	rbx
	mov	rbx,tinfo
	xor	rax,rax
	mov	[rbx].S_TINFO.ti_clsl,rax
	mov	[rbx].S_TINFO.ti_clso,rax
	mov	[rbx].S_TINFO.ti_clel,rax
	mov	rax,[rbx].S_TINFO.ti_bcol
	mov	[rbx].S_TINFO.ti_cleo,rax
	cmp	[rbx].S_TEDIT.ti_lcnt,rax
	je	@F
	mov	rax,[rbx].S_TEDIT.ti_lcnt
	dec	rax
	mov	[rbx].S_TINFO.ti_clel,rax
      @@:
	pop	rbx
	jmp	ticontinue
tiselectall endp

endif

ifdef	__TE__
ticopyselection:
	push	rdi
	push	rbx
	xor	rdi,rdi
	invoke	oinitst,addr STDO,MAXCLIPSIZE
    	jnz	@F
	invoke	oinitst,addr STDO,1000h
	jz	ticopyselection_eof
      @@:
	inc	rdi
	mov	STDO.ios_flag,IO_CLIPBOARD
	mov	rax,[rsi].S_TINFO.ti_clsl
	mov	rdx,[rsi].S_TINFO.ti_clso
	mov	rcx,[rsi].S_TINFO.ti_clel
	mov	rbx,[rsi].S_TINFO.ti_cleo
	call	tiflushl
	jnz	@F
	mov	rax,rbx
	mov	[rsi].S_TINFO.ti_clsl,rdx
	mov	[rsi].S_TINFO.ti_clso,rax
	inc	rdi
	invoke	rsmodal,IDD_ClipboardWarning
      @@:
	call	oflush
	invoke	ofreest,addr STDO
    ticopyselection_eof:
	mov	rax,rdi
	test	rax,rax
	pop	rbx
	pop	rdi
	ret
endif

ticlipcut proc public uses rsi rdi
	mov	rsi,tinfo
	mov	rdi,rax			; AX: Copy == 0, Cut == 1
	call	tiselected		; get size of selection
	jz	ticlipcut_set
    ifdef __TE__
	call	ticopyselection
	jz	ticlipcut_eof
	dec	rax
	jnz	ticlipcut_eof
    else
	mov	rcx,rax
	lodm	[rsi].S_TINFO.ti_bp
	add	rax,[rsi].S_TINFO.ti_clso
	invoke	ClipboardCopy,dxax,rcx
    endif
	test	rdi,rdi
	jz	ticlipcut_set
	call	ticlipdel
    ticlipcut_set:
	call	ticlipset
    ticlipcut_eof:
	sub	rax,rax
	ret
ticlipcut endp

ticlipget proc public uses rsi rdi rbx
	mov	rsi,tinfo
	mov	rax,[rsi].S_TINFO.ti_flag
	and	rax,_T_OVERWRITE
	jnz	@F
	call	ticlipset
	jmp	ticlipget_get
      @@:
	call	ticlipdel
    ticlipget_get:
	call	ClipboardPaste
	jz	ticlipget_end
  ifdef __TE__
	push	[rsi].S_TINFO.ti_yoff
	push	[rsi].S_TINFO.ti_loff
  endif
	push	[rsi].S_TINFO.ti_xoff
	push	[rsi].S_TINFO.ti_boff
	mov	rsi,clipbsize
	mov	rdi,rax
	mov16	es,dx
  ifdef __TE__
	mov	rdx,rax		; Problem of inserting text by pushing
	mov	rcx,rsi		; a long line in front - EOL == abort
	cld?
	mov	rax,0Ah		; Insert '\n' if clipboard contain a '\n'
	repne	scasb		; then move back to prev pos
	mov	rdi,rdx
	jne	ticlipget_00
	mov	rbx,rsi
      ifdef __f__
	cmp	[edi+ebx-2],al
	jne	@F
	mov	[edi+ebx-2],ah
      else
	cmp	es:[di+bx-2],al	; remove '\n' from end if exist
	jne	@F		; This align line-based clip-set
	mov	es:[di+bx-2],ah
      endif
      @@:
	push16	es
	call	tiputc
	pop16	es
	test	rax,rax
	jnz	ticlipget_01
	pop	rdx
	pop	rax
	pop	rcx
	pop	rbx
	push	rbx
	push	rcx
	push	rax
	push	rdx
	mov	rsi,tinfo
	mov	[rsi].S_TINFO.ti_xoff,rax
	mov	[rsi].S_TINFO.ti_boff,rdx
	mov	[rsi].S_TINFO.ti_yoff,rcx
	mov	[rsi].S_TINFO.ti_loff,rbx
	mov	rsi,clipbsize
  endif
    ticlipget_00:
	mov	al,PEDI
	test	al,al
	jz	ticlipget_01
	inc	rdi
	push16	es
	call	tiputc
	pop16	es
	test	rax,rax
	jnz	ticlipget_01
	dec	rsi
	jnz	ticlipget_00
    ticlipget_01:
	pop	rdx
	pop	rax
	mov	rsi,tinfo
	mov	[rsi].S_TINFO.ti_xoff,rax
	mov	[rsi].S_TINFO.ti_boff,rdx
  ifdef __TE__
	pop	rdx
	pop	rax
	mov	[rsi].S_TINFO.ti_yoff,rax
	mov	[rsi].S_TINFO.ti_loff,rdx
  endif
    ticlipget_end:
	xor	rax,rax
	ret
ticlipget endp

	.data
	cl_proctable label size_t
		d? ticlip_Copy
		d? ticlip_Copy
		d? ticlipget
		d? ticlip_Cut
		d? ticlip_Cut
	cl_keytable label size_t
		d? KEY_CTRLINS
		d? KEY_CTRLC
		d? KEY_CTRLV
		d? KEY_CTRLX
		d? KEY_CTRLDEL
	cl_keycount = (($ - offset cl_keytable) / size_l)
	cl_shiftkeytable label size_t
		d? KEY_HOME
		d? KEY_LEFT
		d? KEY_RIGHT
		d? KEY_END
	    ifdef __TE__
		d? KEY_UP
		d? KEY_DOWN
		d? KEY_PGUP
		d? KEY_PGDN
	    endif
	cl_shiftkeycount = (($ - offset cl_shiftkeytable) / size_l)
	cl_nodeletekeys label size_t
		d? KEY_ESC
	    ifdef __MOUSE__
		d? MOUSECMD
	    endif
		d? KEY_BKSP
;		d? KEY_TAB
		d? KEY_ENTER
		d? KEY_KPENTER
	cl_nodeletecount = (($ - offset cl_nodeletekeys) / size_l)

	.code

ticlip_Copy:
	sub	rax,rax
	jmp	ticlipcut

ticlip_Cut:
	mov	rax,1
	jmp	ticlipcut

ticlipevent proc public uses rsi rdi rbx
	mov	rsi,rax
	call	tiselected
	jnz	@F
	call	ticlipset
      @@:
	xor	rdi,rdi
	mov	rcx,cl_keycount
	jmp     ticlipevent_loop
    ticlipevent_found:
	call	cl_proctable[rdi]
	jmp     ticlipevent_end
    ticlipevent_loop:
	cmp	rsi,cl_keytable[rdi]
	je	ticlipevent_found
	add	rdi,size_l
	dec	rcx
	jnz	ticlipevent_loop
	LPES	rbx,keyshift
	mov	al,PEBX
	and	al,KEY_SHIFT
	jnz	@F
	cmp	rsi,KEY_DEL
	jne	ticlipevent_ESC
	call	ticlipdel
	jz	ticlipevent_set
	xor	rax,rax
	jmp	ticlipevent_end
      @@:
	cmp	rsi,KEY_INS
	jne	@F
	call	ticlipget
	jmp	ticlipevent_end
      @@:
	cmp	rsi,KEY_DEL
	jne	@F
	mov	rax,1
	call	ticlipcut
	jmp	ticlipevent_end
      @@:
	mov	rdi,offset cl_shiftkeytable
	mov	rcx,cl_shiftkeycount
  ifdef __TE__
	mov	rbx,tinfo
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	sub	rcx,4
  endif
      @@:
	cmp	rsi,[rdi]
	je	ticlipevent_MOVE
	add	rdi,size_l
	dec	rcx
	jnz	@B
    ticlipevent_ESC:
	mov	rcx,cl_nodeletecount
	xor	rdi,rdi
      @@:
	cmp	rsi,cl_nodeletekeys[rdi]
	je	ticlipevent_set
	add	rdi,size_l
	dec	rcx
	jnz	@B
	mov	rax,rsi
	test	al,al
	jz	ticlipevent_set
    ifdef __TE__
	mov	rbx,tinfo
	test	[rbx].S_TINFO.ti_flag,_T_LINEBUF
	jnz	@F
	cmp	rsi,KEY_TAB
	je	ticlipevent_set
      @@:
    endif
	call	ticlipdel
    ticlipevent_set:
	call	ticlipset
	mov	rax,rsi
    ticlipevent_end:
	ret
    ticlipevent_MOVE:
	mov	rax,rsi
	call	tievent
	test	rax,rax
	jnz	ticlipevent_nul
	mov	rbx,tinfo
    ifdef __TE__
	mov	rcx,[rbx].S_TINFO.ti_loff
	add	rcx,[rbx].S_TINFO.ti_yoff
	cmp	rcx,[rbx].S_TINFO.ti_clsl
	jb	ticlipevent_MOVEBACK
    endif
	mov	rax,[rbx].S_TINFO.ti_boff
	add	rax,[rbx].S_TINFO.ti_xoff
	cmp	rax,[rbx].S_TINFO.ti_clso
	jb	ticlipevent_MOVEBACK
	cmp	rsi,KEY_RIGHT
	jne	@F
	mov	rdx,rax
	dec	rdx
	cmp	rdx,[rbx].S_TINFO.ti_clso
	jne	@F
	cmp	rdx,[rbx].S_TINFO.ti_cleo
	jne	ticlipevent_MOVEBACK
      @@:
	mov	[rbx].S_TINFO.ti_cleo,rax
    ifdef __TE__
	mov	[rbx].S_TINFO.ti_clel,rcx
    endif
	jmp	ticlipevent_nul
    ticlipevent_MOVEBACK:
	mov	[rbx].S_TINFO.ti_clso,rax
    ifdef __TE__
	mov	[rbx].S_TINFO.ti_clsl,rcx
    endif
    ticlipevent_nul:
	xor	rax,rax
	jmp	ticlipevent_end
ticlipevent endp

endif ; __CLIP__

	end
