; DZ.ASM--
; Copyright (c) 1996-2011 Hjort Nidudsson
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;

	.186
	.model	small

include	version.inc
include	dz.inc

PROGRAMSIZE equ 1024

	.code

config label S_DZDS

start	PROC
	jmp	around
	db	10
copyright label byte
	db	'The Doszip Commander Version ',VERS?,', '
	db	'Copyright (c) 1997-2012 Hjort Nidudsson',13,10,13,10,'$'
invalid_environ label byte
	db	'Environment invalid',13,10,'$'
around:
	mov	ax,cs
	mov	ds,ax
	mov	ah,9
	mov	dx,offset copyright
	int	21h
	mov	si,offset config
	mov	bx,002Ch
	mov	bp,es
	mov	ax,es:[bx]
	mov	ds:[S_DZDS.dz_envseg],ax
	mov	bx,PROGRAMSIZE/16
	mov	ah,4Ah
	int	21h
	mov	ax,cs
	mov	ss,ax
	mov	sp,PROGRAMSIZE-256
	mov	bx,ds:[S_DZDS.dz_envseg]
	mov	es,bx
	xor	ax,ax
	mov	di,ax
	mov	cx,7FFFh
	cld
environ_loop:
	repnz	scasb
	or	cx,cx
	jz	errorlevel_10
	cmp	es:[di],al
	jne	environ_loop
	or	ch,80h
	neg	cx
	jmp	init_vector
errorlevel_10:
	mov	dx,offset invalid_environ
	mov	ah,9
	int	21h
	mov	ax,4C0Ah
	int	21h
init_vector:
	mov	ax,ds
	mov	vector+6,ax
	mov	vector+4,S_DZDS.dz_exeproc
	mov	ds:[S_DZDS.dz_fcb_0P+2],ax
	mov	ds:[S_DZDS.dz_fcb_1P+2],ax
	mov	ds:[S_DZDS.dz_fcb_0P],S_DZDS.dz_fcb_160
	mov	ds:[S_DZDS.dz_fcb_1P],S_DZDS.dz_fcb_161
	mov	ds:[S_DZDS.dz_command+2],ax
	mov	dx,ax
	mov	di,cx
	add	di,2
	mov	si,di
	mov	cx,-1
	xor	ax,ax
	repnz	scasb
	not	cx
	push	cx
	mov	es,dx
	mov	di,S_DZDS.dz_dzmain
	mov	ds,bx
	rep	movsb
	mov	ds,dx
	mov	es,dx
	mov	bx,di
	mov	di,S_DZDS.dz_fcb_160
	mov	si,S_DZDS.dz_dzmain
	mov	ax,2901h
	int	21h
	mov	ax,'LD'
	mov	[bx-4],ax
	mov	ax,'L'
	mov	[bx-2],ax
	mov	di,S_DZDS.dz_dzcommand
	mov	si,128
	mov	ds,bp
	mov	cx,128
	rep	movsb
	mov	ds,dx
	mov	ax,4300h
	mov	dx,S_DZDS.dz_dzmain
	int	21h
	pop	di
	jnc	file_found
file_not_found:
	mov	dx,offset cp_file_not_found
	mov	cx,15
	call	write
	mov	cx,di
	mov	dx,S_DZDS.dz_dzmain
	call	write
	mov	ax,2
	jmp	exit
write:	mov	ah,40h
	mov	bx,2
	int	21h
	ret
	db	13,10,10
%	db	'$Id: DZ.ASM &@Date &@Time',10
file_found:
	xor	ax,ax
	mov	vector+8,ax
	jmp	doszip
	db	13,10
	db	'DOS (errorlevel):',10
	db	' (2) '
cp_file_not_found label byte
	db      'File not found DZ.DLL',13,10
	db	' (5) Access',10
	db	' (8) Memory',10
	db	'(10) Environment'
	org	SIZE S_DZDS - 14
	dw	0
	dw	0	; dz_errno
	dw	0	; dz_eflag
	dw	0	; dz_count
	dw	0A00h	; dz_exename
	dw	4F44h	; dz_oldintF1
	dw	3A53h
START	ENDP

execute	PROC FAR
	mov	cs:old_ds,ds
	mov	ax,cs
	mov	es,ax
	mov	ds,ax
	mov	ds:[old_si],si
	mov	ds:[old_di],di
	mov	di,S_DZDS.dz_fcb_161
	mov	si,ds:[S_DZDS.dz_exename]
	mov	ax,2901h
	int	21h
	mov	bx,S_DZDS.dz_envseg
	mov	dx,ds:[S_DZDS.dz_exename]
	mov	ax,4B00h
	int	21h
	mov	dx,cs
	mov	ds,dx
	jc	execute_error
	xor	ax,ax
    execute_error:
	mov	si,ax
	mov	ax,4D00h
	int	21h
	mov	dx,si
	mov	ds:[S_DZDS.dz_eflag],dx
	mov	ds:[S_DZDS.dz_errno],ax
	mov	si,ds:[old_si]
	mov	di,ds:[old_di]
	mov	ds,ds:[old_ds]
	ret
execute	ENDP
old_si	dw ?
old_di	dw ?
old_ds	dw ?
doszip	PROC
	mov	ax,35F1h
	int	21h
	mov	word ptr ds:[S_DZDS.dz_oldintF1],bx
	mov	word ptr ds:[S_DZDS.dz_oldintF1+2],es
	mov	ax,25F1h
	mov	dx,offset vector
	int	21h
	mov	ds:[S_DZDS.dz_exename],S_DZDS.dz_dzmain
	mov	ds:[S_DZDS.dz_command],S_DZDS.dz_dzcommand
	call	execute
	mov	di,ax
	mov	si,offset config
	mov	ax,25F1h
	lds	dx,cs:[S_DZDS.dz_oldintF1]
	int	21h
	mov	ax,cs
	mov	ds,ax
	mov	ax,di
	cmp	al,23
	jne	exit
	inc	ds:[S_DZDS.dz_count]
	mov	ds:[S_DZDS.dz_exename],S_DZDS.dz_exeproc
	mov	ds:[S_DZDS.dz_command],S_DZDS.dz_execommand
	call	execute
	mov	ax,cs
	mov	ds,ax
	jmp	doszip
doszip	ENDP

exit	PROC
	mov	ah,4Ch
	int	21h
exit	ENDP

vector	label word
	dd	50495A44h
	dd	564A4A0Ah
	.stack	64
	end	start
