;
; Returns 0 if entry not part of basepath,
; else _A_ARCH or _A_SUBDIR.
;
testentryname proc pascal wsub:dword, ename:dword
	push	si
	push	di
	mov	bx,word ptr wsub
	invoke	strlen, [bx].ws_arch
	assert	ax,256,jb,"arch >= 256"
	mov	di,ax
	mov	si,word ptr ename
	invoke	strlen, ename
	assert	ax,256,jb,"entry >= 256"
	cmp	di,ax
	jae	testentryname_fail
	cmp	di,0
	jle	testentryname_flag
	invoke	strnicmp, ename, [bx].ws_arch, di
	or	ax,ax
	jnz	testentryname_fail
	mov	bx,di
	mov	al,[si+bx]
	cmp	al,'\'
	jne	testentryname_fail
    testentryname_copy:
	mov	ax,si
	add	ax,di
	inc	ax
	invoke	strcpy, ss::si, ss::ax
    testentryname_comma:
	cmp	byte ptr [si],','
	jne	testentryname_flag
	mov	ax,si
	inc	ax
	invoke	strcpy, ss::si, ss::ax
	jmp	testentryname_comma
    testentryname_flag:
	mov	di,_A_ARCH
	cld
    testentryname_loop:
	lodsb
	test	al,al
	jz	testentryname_find
	cmp	al,'\'
	jne	testentryname_loop
	xor	ax,ax
	mov	[si-1],al
	mov	di,_A_SUBDIR
    testentryname_find:
	mov	si,1
	mov	bx,word ptr wsub
	cmp	[bx.ws_count],si
	jbe	testentryname_ok
    testentryname_cmp:
	mov	bx,word ptr wsub
	cmp	[bx.ws_count],si
	jbe	testentryname_ok
	les	bx,[bx.ws_fcb]
	mov	ax,si
	shl	ax,2
	add	bx,ax
	push	es:[bx+2]
	mov	ax,es:[bx]
	add	ax,fb_name
	push	ax
	pushm	ename
	call	stricmp
	test	ax,ax
	jz	testentryname_fail
	inc	si
	jmp	testentryname_cmp
    testentryname_ok:
	mov	ax,di
	test	ax,ax
    testentryname_end:
	pop	di
	pop	si
	ret
    testentryname_fail:
	xor	ax,ax
	jmp	testentryname_end
testentryname endp
