include	conio.inc
include	keyb.inc
include	mouse.inc
include	dos.inc

scroll_delay	proto _CType

	public	tdialog
	public	tdllist

	.data
	tdialog	dd ?
	tdllist	dd ?
	tdoffss	d? ?
	ocurs	S_CURSOR <?>
	tobjp	dd ?
	oflag	d? ?
	orect	dd ?
	oxpos	d? ?
	oypos	d? ?
	oxlen	d? ?
	event	d? ?
	result	d? ?
	dlexit	d? ?
	xlbuf	dw 80 dup(?)

	_scancodes label byte	;  A - Z
	db 1Eh,30h,2Eh,20h,12h,21h,22h,23h,17h,24h,25h,26h,32h
	db 31h,18h,19h,10h,13h,1Fh,14h,16h,2Fh,11h,2Dh,15h,2Ch

	proctab label size_t
	d? case_ESC
	d? case_ESC
  ifndef SKIP_ALTMOVE
	d? case_ALTUP
	d? case_ALTDN
	d? case_ALTLEFT
	d? case_ALTRIGHT
  endif
	d? case_ENTER
	d? case_ENTER
  ifdef __MOUSE__
	d? cmdmouse
  endif
	d? case_LEFT
	d? case_UP
	d? case_RIGHT
	d? case_DOWN
	d? case_HOME
	d? case_END
	d? case_TAB
	d? case_PGUP
	d? case_PGDN

	keytable label size_t
	d? KEY_ESC
	d? KEY_ALTX
  ifndef SKIP_ALTMOVE
	d? KEY_ALTUP
	d? KEY_ALTDN
	d? KEY_ALTLEFT
	d? KEY_ALTRIGHT
  endif
	d? KEY_ENTER
	d? KEY_KPENTER
  ifdef __MOUSE__
	d? MOUSECMD
  endif
	d? KEY_LEFT
	d? KEY_UP
	d? KEY_RIGHT
	d? KEY_DOWN
	d? KEY_HOME
	d? KEY_END
	d? KEY_TAB
	d? KEY_PGUP
	d? KEY_PGDN
	key_count = ($ - offset keytable) / size_l

	eventproc label size_t
	d? dlpbuttevent
	d? dlradioevent
	d? dlcheckevent
	d? dlxcellevent
	d? dlteditevent
	d? dlmenusevent
	d? dlxcellevent

	.code

dummy_update:
	xor rax,rax
	ret

tdshortkey:
	push rax
	.if PEBX.S_TOBJ.to_flag & _O_DEACT || !PEBX.S_TOBJ.to_ascii
	    sub rax,rax
	.else
	    and al,0DFh
	    .if PEBX.S_TOBJ.to_ascii == al
	    	or al,1
	    .else
		mov al,PEBX.S_TOBJ.to_ascii
		and al,0DFh
		sub al,'A'
		push rbx
		ZXBX al
		cmp ah,[rbx+_scancodes]
		pop rbx
		.if ZERO?
		    or al,1
		.else
		    sub rax,rax
		.endif
	    .endif
	.endif
	pop rax
	ret

handle_event:
	test	rax,rax
	jnz	handle_event_do
	ret
    handle_event_do:
	push	rsi
	push	rdi
	xor	rdx,rdx
	mov	rsi,rdx
	mov	rcx,rdx
	LPES	rbx,tdialog
	mov	cl,PEBX.S_DOBJ.dl_count
	LPES	rbx,PEBX.S_DOBJ.dl_object
	cmp	rax,KEY_F1
	je	handle_event_help
	test	cl,cl
	jz	handle_event_null
    handle_event_loop:
	test	PEBX.S_TOBJ.to_flag,_O_GLCMD
	jz	handle_event_shkey
	mov	rdx,WORDP es:[bx].S_TOBJ.to_data
	mov16	di,word ptr es:[bx].S_TOBJ.to_data+2
    handle_event_shkey:
	call	tdshortkey
	jnz	handle_event_si_to_index
	add	rbx,16
	inc	rsi
	dec	rcx
	jnz	handle_event_loop
	test	rdx,rdx
	jz	handle_event_null
	mov	rbx,rdx
	mov16	es,di
    handle_event_gloop:
	cmp	PEBX.S_GLCMD.gl_key,0
	jz	handle_event_null
	cmp	PEBX.S_GLCMD.gl_key,rax
	je	handle_event_found
	add	rbx,SIZE S_GLCMD
	jmp	handle_event_gloop
    handle_event_found:
	call	PEBX.S_GLCMD.gl_proc
	jmp	handle_event_end
    handle_event_null:
	sub	rax,rax
	jmp	handle_event_end
    handle_event_si_to_index:
	test	PEBX.S_TOBJ.to_flag,_O_PBKEY
	mov	rax,rsi
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	mov	rax,_C_RETURN
	jnz	handle_event_end
    handle_event_one:
	mov	rax,_C_NORMAL
    handle_event_end:
	mov	result,rax
	pop	rdi
	pop	rsi
	ret
    handle_event_help:
	xor	rax,rax
	LPES	rbx,tdialog
	test	PEBX.S_DOBJ.dl_flag,_D_DHELP
	jz	handle_event_end
	cmp	WORDP thelp,rax
	jz	handle_event_end
	call	thelp
	mov	rax,_C_NORMAL
	jmp	handle_event_end

test_event:
	sub	rbx,rbx
    test_event_loop:
	cmp	rax,keytable[rbx]
	je	test_event_found
	add	rbx,size_l
	dec	rcx
	jnz	test_event_loop
	call	handle_event
	ret
    test_event_found:
	call	proctab[rbx]
	ret

LoadCurrentObjectSaveCursor:
	push	rax
	invoke	cursorget,addr ocurs
	pop	rax

LoadCurrentObject:
	LPES	rbx,tdialog
	cmp	PEBX.S_DOBJ.dl_count,0
	jne	@F
	sub	rax,rax
	ret
      @@:
      	test	rax,rax
	jnz	@F
	mov	al,PEBX.S_DOBJ.dl_index
	inc	rax
      @@:
	mov	dx,PEBX+4
	LPES	rbx,PEBX.S_DOBJ.dl_object
	dec	rax
	shl	rax,4
	add	rax,rbx
	mov	WORDP tobjp,rax
	mov16	word ptr tobjp+2,es
	mov	rbx,rax
	mov	ax,PEBX.S_DOBJ.dl_flag
	mov	oflag,rax
	movmx	orect,PEBX.S_TOBJ.to_rect
	add	word ptr orect,dx
	and	rax,0FFh
	add	al,dl
	mov	oxpos,rax
	mov	al,orect.S_RECT.rc_y
	mov	oypos,rax
	mov	al,orect.S_RECT.rc_col
	mov	oxlen,rax
	mov	ax,PEBX.S_TOBJ.to_flag
	ret

ifdef __MOUSE__
omousecmd:
	call	mousex
	push	rax
	call	mousey
	pop	rdx
	cmp	rax,oypos
	jne	omousecmd_nil
	mov	rax,oxpos
	dec	rax
	cmp	rdx,rax
	jb	omousecmd_nil
	add	rax,2
	cmp	rdx,rax
	jbe	omousecmd_one
    omousecmd_nil:
	sub	al,al
	mov	rax,MOUSECMD
	ret
    omousecmd_one:
	or	al,1
	ret
endif

ExecuteChild:
	inc rax
	call LoadCurrentObject
	.if WORDP PEBX.S_TOBJ.to_proc != 0
	    call PEBX.S_TOBJ.to_proc
	    mov result,rax
	    .if rax == _C_REOPEN
		LPES rbx,tdialog
		mov al,PEBX.S_DOBJ.dl_index
		push rax
		invoke dlinit,tdialog
		pop rax
		LPES rbx,tdialog
		mov PEBX.S_DOBJ.dl_index,al
	    .endif
	.endif
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

?item_init:
	pop	rax
	push16	ds
	push	rsi
	push	rdi
	push	rbx
	LPDS	rsi,tdialog
	LPES	rdi,[rsi].S_DOBJ.dl_object
	sub	rcx,rcx
	sub	rdx,rdx
	mov	dl,[rsi].S_DOBJ.dl_count
	add	cl,[rsi].S_DOBJ.dl_index
	jmp	rax

item_SetIndex?:
	mov rax,PEDI	;.S_TOBJ.to_flag
	.if rax & _O_DEACT
	    sub rax,rax
	    ret
	.endif
	;
item_SetIndex:
	dec rcx
	mov [rsi].S_DOBJ.dl_index,cl
	sub rax,rax
	inc rax
	ret

item_DoIfIndex:
	call item_SetIndex?
	.if ZERO?
	    ret
	.endif
	pop rbx
	jmp ?item_exit

previtem:
	call ?item_init
	.if !ZERO?
	    mov rax,rcx
	    dec rax
	    shl rax,4
	    add rdi,rax
	    .repeat
		call item_SetIndex?
		.break .if !ZERO?
		sub rdi,SIZE S_TOBJ
	    .untilcxz
	    .if !ax
	     @@:
		.if dl
		    mov rcx,rdx
		    mov bl,[rsi].S_DOBJ.dl_index
		    mov rdi,WORDP [rsi].S_DOBJ.dl_object
		    mov rax,rcx
		    dec rax
		    shl rax,4
		    add rdi,rax
		    sub rax,rax
		    .repeat
			.break .if bl > cl
			mov ax,PEDI.S_TOBJ.to_flag
			.if !(ax & _O_DEACT)
			    call item_SetIndex
			    jmp ?item_exit
			.endif
			sub rdi,SIZE S_TOBJ
		    .untilcxz
		.endif
		jmp ?item_null
	    .endif
	    jmp ?item_exit
	.else
	    jmp @B
	.endif
	jmp ?item_null

itemleft:
	call ?item_init
	.if !ZERO?
	    mov rax,rcx
	    dec rax
	    shl rax,4
	    add rdi,rax
	    mov rbx,PEDI[20]
	    .repeat
		.if bl > PEDI[4] && bh != PEDI[5]
		    call item_DoIfIndex
		.endif
		sub rdi,16
	    .untilcxz
	.endif

?item_null:
	sub	rax,rax
?item_exit:
	pop	rbx
	pop	rdi
	pop	rsi
	pop16	ds
	ret

nextitem:
	call	?item_init
	inc	rcx
	mov	rax,rcx
	shl	rax,4
	add	rdi,rax
	inc	rcx
      @@:
	cmp	rcx,rdx
	ja	@F
	call	item_DoIfIndex
	inc	rcx
	add	rdi,16
	jmp	@B
      @@:
	sub	rdx,rdx
	mov	dl,[rsi].S_DOBJ.dl_index
	inc	rdx
	mov	rcx,1
	mov	rdi,WORDP [rsi].S_DOBJ.dl_object
      @@:
	cmp	rcx,rdx
	ja	?item_null
	call	item_DoIfIndex
	inc	rcx
	add	rdi,16
	jmp	@B

itemright:
	call	?item_init
	inc	rcx
	mov	rax,rcx
	shl	rax,4
	add	rdi,rax
	mov	rbx,PEDI[-12]
	inc	rcx
    itemright_loop:
	cmp	rcx,rdx
	ja	?item_null
	cmp	bh,PEDI[5]
	jne	@F
	cmp	bl,PEDI[4]
	jnb	@F
	call	item_DoIfIndex
      @@:
	inc	rcx
	add	rdi,16
	jmp	itemright_loop

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

xbuttxchg:
	invoke	getxyc,oxpos,oypos
	xchg	rsi,rax
	invoke	scputc,oxpos,oypos,1,rax
	mov	rax,oxpos
	add	rax,oxlen
	dec	rax
	push	rax
	invoke	getxyc,rax,oypos
	xchg	rdi,rax
	pop	rbx
	invoke	scputc,rbx,oypos,1,rax
	ret

ifdef __MOUSE__

xbuttms:
	push	rsi
	push	rdi
	mov	rsi,' '
	mov	rdi,rsi
	call	xbuttxchg
	inc	rbx
	invoke	getxyc,rbx,oypos
	push	rax
	sub	rbx,oxlen
	mov	rax,oypos
	inc	rax
	inc	rbx
	invoke	getxyc,rbx,rax
	push	rax
	mov	rax,oflag
	and	rax,000Fh
	push	rax
	jnz	xbuttms_00
	mov	rax,oypos
	inc	rax
	invoke	scputc,rbx,rax,oxlen,' '
	add	rbx,oxlen
	dec	rbx
	invoke	scputc,rbx,oypos,1,' '
    xbuttms_00:
	call	msloop
	call	xbuttxchg
	pop	rdx
	pop	rax
	pop	rdi
	test	rdx,rdx
	jnz	xbuttms_end
	mov	rbx,oxpos
	inc	rbx
	mov	rdx,oypos
	inc	rdx
	invoke	scputc,rbx,rdx,oxlen,rax
	add	rbx,oxlen
	dec	rbx
	invoke	scputc,rbx,oypos,1,rdi
    xbuttms_end:
	pop	rdi
	pop	rsi
	ret

cmdmouse:
	push rsi
	push rdi
	push rbp
	LPES rbx,tdialog
	call mousex
	mov  rcx,rax
	call mousey
	mov  rbp,rax
	mov  result,_C_NORMAL
	.if rcxyrow(dword ptr PEBX.S_DOBJ.dl_rect,rcx,rax)
	    push rax
	    mov  rdi,WORDP PEBX.S_DOBJ.dl_rect
	    mov  al,PEBX.S_DOBJ.dl_count
	    mov  rsi,rax
	    LPES rbx,PEBX.S_DOBJ.dl_object
	    .while rsi
		lodm PEBX.S_TOBJ.to_rect
		add ax,di
		.if rcxyrow(dxax,rcx,rbp)
		    LPES rbx,tdialog
		    pop rax
		    sub rax,rax
		    push rax
		    mov al,PEBX.S_DOBJ.dl_count
		    sub rax,rsi
		    mov rsi,rax
		    inc rax
		    call LoadCurrentObject
		    .if !(rax & _O_DEACT)
			LPES rbx,tdialog
			mov rax,rsi
			mov PEBX.S_DOBJ.dl_index,al
			mov rax,oflag
			and al,0Fh
			.if al == _O_TBUTT || al == _O_PBUTT
			    call xbuttms
			.endif
			mov rax,oflag
			.if rax & _O_DEXIT
			    mov result,_C_ESCAPE
			.endif
			.if rax & _O_CHILD
			@@:
			    mov rax,rsi
			    call ExecuteChild
			.else
			    and rax,000Fh
			    .if al == _O_TBUTT || al == _O_PBUTT || \
			    	al == _O_MENUS || al == _O_XHTML
			    	mov result,_C_RETURN
			    .endif
			.endif
		    .else
			and rax,0Fh
			.if al == _O_LLMSU
			    call TDLListMouseUP
			.elseif al == _O_LLMSD
			    call TDLListMouseDN
			.elseif al == _O_MOUSE
			    .if rcx & _O_CHILD
				jnz  @B
			    .endif
			.endif
		    .endif
		    .break
		.endif
		add rbx,SIZE S_TOBJ
		dec rsi
	    .endw
	    pop rax
	    .if rax == 1
		invoke dlmove,tdialog
	    .elseif rax
		call msloop
	    .endif
	.else
	    mov result,_C_ESCAPE
	.endif
	pop rbp
	pop rdi
	pop rsi
	ret

MouseDelay:
	call	mousep
	jnz	@F
	ret
      @@:
	call	scroll_delay
	call	scroll_delay
	or	al,1
	ret

TDLListMouseUP:
	LPES	rbx,tdllist
	sub	rax,rax
	cmp	rax,PEBX.S_LOBJ.ll_count
	jz	TDReturnNormal
	mov	rdx,PEBX
	mov	PEBX.S_LOBJ.ll_celoff,rax
	LPES	rbx,tdialog
	cmp	dl,PEBX.S_DOBJ.dl_index
	mov	PEBX.S_DOBJ.dl_index,dl
	je	@F
	ret
      @@:
	call	case_UP
	test	rax,rax
	jz	TDReturnNormal
	call	MouseDelay
	jnz	@B
	jmp	TDReturnNormal

TDLListMouseDN:
	LPES	rbx,tdllist
	sub	rax,rax
	cmp	rax,PEBX.S_LOBJ.ll_count
	jz	TDReturnNormal
	mov	rax,PEBX.S_LOBJ.ll_numcel
	dec	rax
	mov	PEBX.S_LOBJ.ll_celoff,rax
	add	rax,PEBX
	LPES	rbx,tdialog
	cmp	al,PEBX.S_DOBJ.dl_index
	mov	PEBX.S_DOBJ.dl_index,al
	jz	@F
	sub	rax,rax
	ret
      @@:
	call	case_DOWN
	test	rax,rax
	jz	TDReturnNormal
	call	MouseDelay
	jnz	@B
else
case_MOUSE:
	mov	result,_C_NORMAL
	ret
endif ; __MOUSE__


TDReturnNormal:
      ifdef __MOUSE__
	call	msloop
	inc	rax	; _C_NORMAL
      else
	mov	rax,_C_NORMAL
      endif
	ret

TDListItem?:
	sub	rax,rax
	call	LoadCurrentObject
	test	rax,_O_LLIST
	jnz	@F
	and	rax,0Fh
	cmp	al,_O_MENUS
	je	@F
	mov	result,_C_NORMAL
	pop	rax
      @@:
	ret

case_HOME:
	call	TDListItem?
	mov	rax,0
	jz	@F
	LPES	rbx,tdllist
	mov	PEBX.S_LOBJ.ll_index,rax
	mov	PEBX.S_LOBJ.ll_celoff,rax
	push	PEBX.S_LOBJ.ll_dlgoff
	call    PEBX.S_LOBJ.ll_proc
	pop	rax
      @@:
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	call	nextitem
	call	previtem
	ret

case_LEFT:
	sub	rax,rax
	call	LoadCurrentObject
	test	rax,_O_LLIST
	jz	@F
	jmp	case_PGUP
      @@:
	and	rax,000Fh
	cmp	al,_O_MENUS
	jz	@F
	call	itemleft
	jz	case_UP
	ret
      @@:
	jmp	case_EXIT

case_RIGHT:
	sub	rax,rax
	call	LoadCurrentObject
	test	rax,_O_LLIST
	jz	@F
	jmp	case_PGDN
      @@:
	and	rax,000Fh
	cmp	al,_O_MENUS
	jz	@F
	call	itemright
	jz	case_DOWN
	ret
      @@:
	jmp	case_EXIT

case_UP:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_LLIST
	jz	case_UP_01
	sub	rax,rax
	LPES	rbx,tdllist
	cmp	rax,PEBX.S_LOBJ.ll_celoff
	jne	case_UP_01
	cmp	rax,PEBX.S_LOBJ.ll_index
	je	@F
	mov	rdx,PEBX.S_LOBJ.ll_dlgoff
	LPES	rbx,tdialog
	cmp	PEBX.S_DOBJ.dl_index,dl
	je	case_UP_02
	mov	PEBX.S_DOBJ.dl_index,dl
	inc	rax
      @@:
	ret
    case_UP_01:
	call	previtem
	ret
    case_UP_02:
	LPES	rbx,tdllist
	dec	PEBX.S_LOBJ.ll_index
	jmp	case_LLPROC

case_DOWN:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_LLIST
	jz	case_NEXT
	LPES	rbx,tdllist
	mov	rcx,PEBX.S_LOBJ.ll_dcount
	mov	rdx,PEBX.S_LOBJ.ll_celoff
	mov	rax,rcx
	dec	rax
	cmp	rax,rdx
	jz	@F
	mov	rax,rdx
	add	rax,PEBX.S_LOBJ.ll_index
	inc	rax
	cmp	rax,PEBX.S_LOBJ.ll_count
	jb	case_NEXT
      @@:
	mov	rax,PEBX.S_LOBJ.ll_dlgoff
	add	rax,rdx
	LPES	rbx,tdialog
	mov	ah,PEBX.S_DOBJ.dl_index
	mov	PEBX.S_DOBJ.dl_index,al
	cmp	al,ah
	jne	case_NORMAL
	LPES	rbx,tdllist
	mov	rax,PEBX.S_LOBJ.ll_count
	sub	rax,PEBX.S_LOBJ.ll_index
	sub	rax,rcx
	jle	return_NULL
	inc	PEBX.S_LOBJ.ll_index

case_LLPROC:
	call	PEBX.S_LOBJ.ll_proc
	jmp	return_AX

case_EXIT:
	inc	rdi
return_NULL:
	sub	rax,rax
return_AX:
	mov	result,rax
	ret
case_NORMAL:
	mov	result,_C_NORMAL
	ret

case_TAB:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_LLIST
	jz	case_NEXT
	LPES	rbx,tdllist
	mov	rax,PEBX.S_LOBJ.ll_dlgoff
	add	rax,PEBX.S_LOBJ.ll_dcount
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	jmp	case_NORMAL
case_NEXT:
	jmp	nextitem

case_ESC:
	mov	result,_C_ESCAPE
	ret

case_PGUP:
	call	TDListItem?
	jz	case_PGUP_02
	LPES	rbx,tdllist
	sub	rax,rax
	cmp	rax,PEBX.S_LOBJ.ll_celoff
	jz	case_PGUP_01
	mov	PEBX.S_LOBJ.ll_celoff,rax
	mov	rax,PEBX.S_LOBJ.ll_dlgoff
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
    case_PGUP_00:
	mov	result,_C_NORMAL
	ret
    case_PGUP_01:
	cmp	rax,PEBX.S_LOBJ.ll_index
	jz	case_PGUP_00
	mov	rax,PEBX.S_LOBJ.ll_dcount
	cmp	rax,PEBX.S_LOBJ.ll_index
	jbe	case_PGUP_03
    case_PGUP_02:
	jmp	case_HOME
    case_PGUP_03:
	sub	PEBX.S_LOBJ.ll_index,rax
	jmp	case_LLPROC

case_PGDN:
	call	TDListItem?
	jz	case_END
	LPES	rbx,tdllist
	mov	rax,PEBX.S_LOBJ.ll_dcount
	dec	rax
	cmp	rax,PEBX.S_LOBJ.ll_celoff
	jz	case_PGDN_00
	mov	rax,PEBX.S_LOBJ.ll_numcel
	add	rax,PEBX.S_LOBJ.ll_dlgoff
	dec	rax
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	mov	result,_C_NORMAL
	ret
    case_PGDN_00:
	add	rax,PEBX.S_LOBJ.ll_celoff
	add	rax,PEBX.S_LOBJ.ll_index
	inc	rax
	cmp	rax,PEBX.S_LOBJ.ll_count
	jnb	case_END
	mov	rax,PEBX.S_LOBJ.ll_dcount
	add	PEBX.S_LOBJ.ll_index,rax
	jmp	case_LLPROC

case_END:
	call	TDListItem?
	jnz	@F
	LPES	rbx,tdialog
	mov	al,PEBX.S_DOBJ.dl_count
	dec	al
	mov	PEBX.S_DOBJ.dl_index,al
	call	previtem
	call	nextitem
	ret
      @@:
	LPES	rbx,tdllist
	mov	rax,PEBX.S_LOBJ.ll_count
	cmp	rax,PEBX.S_LOBJ.ll_dcount
	jnb	@F
	mov	rax,PEBX.S_LOBJ.ll_numcel
	dec	rax
	mov	PEBX.S_LOBJ.ll_celoff,rax
	add	rax,PEBX.S_LOBJ.ll_dlgoff
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	mov	result,_C_NORMAL
	ret
      @@:
	sub	rax,PEBX.S_LOBJ.ll_dcount
	cmp	rax,PEBX.S_LOBJ.ll_index
	jz	@F
	mov	PEBX.S_LOBJ.ll_index,rax
	mov	rax,PEBX.S_LOBJ.ll_dcount
	dec	rax
	mov	PEBX.S_LOBJ.ll_celoff,rax
	add	rax,PEBX.S_LOBJ.ll_dlgoff
	LPES	rbx,tdialog
	mov	PEBX.S_DOBJ.dl_index,al
	LPES	rbx,tdllist
	jmp	case_LLPROC
      @@:
	jmp	return_NULL

case_ENTER:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_CHILD
	mov	rax,_C_RETURN
	jnz	@F
	mov	result,rax
	ret
      @@:
	LPES	rbx,tdialog
	ZXAX	PEBX.S_DOBJ.dl_index
	call	ExecuteChild
	ret

OGOTOXY:
	sub	rax,rax
	call	LoadCurrentObjectSaveCursor
	call	cursoron
	inc	oxpos
	invoke	gotoxy,oxpos,oypos
	ret

xorradioflag:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_RADIO
	jz	@F
  ifdef __MOUSE__
	call	msloop
  else
	xor	rax,rax
  endif
	ret
      @@:
	LPES	rbx,tdialog
	sub	rcx,rcx
	add	cl,PEBX.S_DOBJ.dl_count
	jz	XORRADIOFLAG_03
	LPES	rbx,PEBX.S_DOBJ.dl_object
    xorradioflag_loop:
	test	byte ptr PEBX.S_TOBJ.to_flag,_O_RADIO
	jz	@F
	and	byte ptr PEBX.S_TOBJ.to_flag,not _O_RADIO
	push16	bx
	push	rcx
	invoke	dlinitobj,tdialog,esbx
	pop	rcx
	pop16	bx
      @@:
	add	rbx,16
	dec	rcx
	jnz	xorradioflag_loop
	xor	rax,rax
	call	LoadCurrentObject
	or	byte ptr PEBX.S_TOBJ.to_flag,_O_RADIO
	invoke	dlinitobj,tdialog,esbx
      ifdef __MOUSE__
	call	msloop
      endif
	mov	rax,_C_NORMAL
    XORRADIOFLAG_03:
	ret

ORETURN:
	invoke	cursorset,addr ocurs
	ret

TDXORSWITCH:
	sub	rax,rax
	call	LoadCurrentObject
	xor	rax,_O_FLAGB
	mov	PEBX,ax
	test	rax,_O_FLAGB
	mov	rax,' '
	jz	@F
	mov	rax,'x'
      @@:
	mov	bx,word ptr orect
	mov	cl,bh
	inc	rbx
	invoke	scputc,rbx,rcx,1,rax
  ifdef __MOUSE__
	call	msloop
  endif
	sub	rax,rax
	ret

ifdef __MOUSE__
TDTestXYRow:
	call	mousey
	mov	rdx,rax
	call	mousex
	invoke	rcxyrow,orect,rax,rdx
	mov	rax,MOUSECMD
	ret
endif

TDSelectObject:
	invoke	rcread,orect,addr xlbuf
	mov	al,at_background[B_DarkGray]
	invoke	wcputbg,addr xlbuf,oxlen,rax
	invoke	rcxchg,orect,addr xlbuf
	ret

TDDeselectObject:
	push	rax
	invoke	rcwrite,orect,addr xlbuf
	pop	rax
	ret

ifndef SKIP_ALTMOVE
case_ALTUP:
	mov	rax,rcmoveup
	jmp	case_ALTMOVE
case_ALTDN:
	mov	rax,rcmovedn
	jmp	case_ALTMOVE
case_ALTLEFT:
	mov	rax,rcmoveleft
	jmp	case_ALTMOVE
case_ALTRIGHT:
	mov	rax,rcmoveright
case_ALTMOVE:
	LPES	rbx,tdialog
	test	PEBX.S_DOBJ.dl_flag,_D_DMOVE
	jz	@F
  ifdef __CDECL__
      ifdef __f__
	push	dword ptr [ebx].S_DOBJ.dl_flag
      else
	push	es:[bx].S_DOBJ.dl_flag
      endif
	pushm	PEBX.S_DOBJ.dl_wp
	pushm	PEBX.S_DOBJ.dl_rect
  else
	pushm	PEBX.S_DOBJ.dl_rect
	pushm	PEBX.S_DOBJ.dl_wp
      ifdef __f__
	push	dword ptr [ebx].S_DOBJ.dl_flag
      else
	push	es:[bx].S_DOBJ.dl_flag
      endif
  endif
	pushl	cs
	call	rax
	LPES	rbx,tdialog
	mov	word ptr PEBX.S_DOBJ.dl_rect,ax
      @@:
	ret
endif

;************** Public

dlpbuttevent proc _CType public
	push	rsi
	push	rdi
	sub	rax,rax
	call	LoadCurrentObjectSaveCursor
	call	cursoron
	mov	rax,oxpos
	inc	rax
	invoke	gotoxy,rax,oypos
	mov	al,byte ptr oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	@F
	call	cursoroff
      @@:
	mov	rsi,16
	mov	rdi,17
	call	xbuttxchg
	call	tgetevent
	push	rax
	call	xbuttxchg
	invoke	cursorset,addr ocurs
	pop	rax
	pop	rdi
	pop	rsi
	ret
dlpbuttevent endp

dlradioevent proc _CType public
	call OGOTOXY
	.repeat
	    call tgetevent
	  ifdef __MOUSE__
	    .if rax == MOUSECMD
		call omousecmd
		jz @F
	    .elseif rax != KEY_SPACE
	  else
	    .if rax != KEY_SPACE
	  endif
		jmp @F
	    .endif
	    call xorradioflag
	.until oflag & _O_EVENT
	mov rax,KEY_SPACE
      @@:
	call ORETURN
	ret
dlradioevent endp

dlcheckevent proc _CType public
	call	OGOTOXY
    tdcheckevent_00:
	call	tgetevent
  ifdef __MOUSE__
	cmp	rax,MOUSECMD
	je	@F
  endif
	cmp	rax,KEY_SPACE
	je	tdcheckevent_02
	jmp	tdcheckevent_03
  ifdef __MOUSE__
      @@:
	call	omousecmd
	jz	tdcheckevent_03
  endif
    tdcheckevent_02:
	call	TDXORSWITCH
	test	oflag,_O_EVENT
	jz	tdcheckevent_00
	mov	rax,KEY_SPACE
    tdcheckevent_03:
	call	ORETURN
	ret
dlcheckevent endp

dlxcellevent proc _CType public
	sub	rax,rax
	call	LoadCurrentObject
	jz	@F
	call	cursoroff
      @@:
    	test	oflag,_O_LLIST
	jz	@F
	LPES	rbx,tdialog
	mov	ah,0
	mov	al,PEBX.S_DOBJ.dl_index
	LPES	rbx,tdllist
	cmp	rax,PEBX.S_LOBJ.ll_dlgoff
	jb	@F
	sub	rax,PEBX.S_LOBJ.ll_dlgoff
	cmp	rax,PEBX.S_LOBJ.ll_numcel
	jnb	@F
	mov	PEBX.S_LOBJ.ll_celoff,rax
      @@:
    	call	TDSelectObject
    tdxcellevent_loop:
	call	tgetevent
  ifdef __MOUSE__
	cmp	rax,MOUSECMD
	jne	tdxcellevent_07
	call	TDTestXYRow
	jz	tdxcellevent_07
	invoke	mousewait,oxpos,oypos,oxlen
	mov	rax,oflag
	and	rax,000Fh
	cmp	rax,_O_XHTML
	mov	rax,KEY_ENTER
	jz	tdxcellevent_07
	push	rsi
	mov	rsi,10
      @@:
	invoke	delay,16
	call	mousep
	jnz	@F
	dec	rsi
	jnz	@B
      @@:
	call	mousep
	jz	@F
	call	TDTestXYRow
	jz	@F
	mov	rax,KEY_ENTER
	jmp	tdxcellevent_06
      @@:
	sub	rax,rax
    tdxcellevent_06:
	pop	rsi
  endif
    tdxcellevent_07:
	test	rax,rax
	jz	tdxcellevent_loop
	call	TDDeselectObject
	ret
dlxcellevent endp

dlteditevent proc _CType public
	push	rsi
	LPES	rbx,tdialog
	mov	si,PEBX[4]
	sub	rax,rax
	call	LoadCurrentObject
	mov16	dx,word ptr es:[bx].S_TOBJ.to_rect+2
	mov	rax,WORDP PEBX.S_TOBJ.to_rect
	add	ax,si
	ZXCX	PEBX.S_TOBJ.to_count
	shl	rcx,4
	invoke	dledit,PEBX.S_TOBJ.to_data,dxax,rcx,oflag
	pop	rsi
	ret
dlteditevent endp

dlmenusevent proc _CType public
	sub  rax,rax
	call LoadCurrentObjectSaveCursor
	call cursoroff
	.if WORDP PEBX.S_TOBJ.to_data
	    mov al,' '
	    mov ah,at_background[B_Menus]
	    or  ah,at_foreground[F_Menus]
	    mov cl,_scrrow
	    invoke scputw,20,rcx,60,rax
	    invoke scputs,20,rcx,0,60,PEBX.S_TOBJ.to_data
	.endif
	call TDSelectObject
	call tgetevent
	call TDDeselectObject
	invoke cursorset,addr ocurs
	ret
dlmenusevent endp

dlevent proc _CType public uses rsi rdi rbx dialog:dword
local	prevdlg:dword	; init tdialog
local	cursor:S_CURSOR	; init cursor
	movmx	prevdlg,tdialog
	movmx	tdialog,dialog
	LPES	rbx,tdialog
	mov	si,PEBX
	test	rsi,_D_ONSCR
	jnz	@F
	invoke	dlshow,dialog
	jz	tdevent_end
      @@:
	invoke	cursorget,addr cursor
	call	cursoroff
	sub	rax,rax
  ifndef __f__
	les	bx,tdialog
  endif
	cmp	PEBX.S_DOBJ.dl_count,al
	je	@F
	call	LoadCurrentObject
	test	rax,_O_DEACT
	jz	tdevent_modal
	call	nextitem
	jnz	tdevent_modal
      @@:
	call	tgetevent
	mov	rcx,9
	call	test_event
	mov	rax,result
	cmp	rax,_C_ESCAPE
	je	tdevent_cancel
	cmp	rax,_C_RETURN
	je	tdevent_cancel
	jmp	@B
    tdevent_modal:
  ifdef __MOUSE__
	call	msloop
  endif
	sub	rdi,rdi
    tdevent_continue:
	sub	rax,rax
	mov	result,rax
	call	LoadCurrentObject
	and	rax,_O_EVENT
	jz	@F
	call	PEBX.S_TOBJ.to_proc
	jmp	tdevent_test
      @@:
	mov	al,PEBX
	and	rax,0Fh
	cmp	al,6
	jbe	tdevent_event
	cmp	al,_O_TBUTT
	jne	@F
	call	dlpbuttevent
	jmp	tdevent_test
      @@:
	mov	rax,KEY_ESC
	jmp	tdevent_test
    tdevent_event:
	shl	rax,size_l/2
	xchg	rbx,rax
	pushl	cs
	call	eventproc[rbx]
    tdevent_test:
	mov	dlexit,rax
	mov	event,rax
	mov	rcx,key_count
	call	test_event
	mov	rax,result
	cmp	rax,_C_ESCAPE
	je	tdevent_cancel
	cmp	rax,_C_RETURN
	je	tdevent_return
	test	rdi,rdi
	jz	tdevent_continue
    tdevent_exit:
	invoke 	cursorset,addr cursor
	mov	rax,event
	test	rax,rax
	jmp	tdevent_end
    tdevent_return:
	sub	rax,rax
	call	LoadCurrentObject
	and	rax,_O_DEXIT
	jnz	tdevent_cancel
    tdevent_index:
	LPES	rbx,tdialog
	ZXAX	PEBX.S_DOBJ.dl_index
	inc	rax
	mov	event,rax
	jmp	tdevent_exit
    tdevent_cancel:
	mov	event,0
	jmp	tdevent_exit
    tdevent_end:
  ifndef __f__
	les	bx,dialog
  endif
	mov	rdx,rax
	movmx	tdialog,prevdlg
	mov	rax,rdx
	mov	rcx,dlexit
	test	rax,rax
	ret
dlevent	endp

	end
