include	clib.inc
ifdef __TE__
include	alloc.inc
include	conio.inc
include	tinfo.inc
include	ctype.inc
include	string.inc
include	stdlib.inc
include	ini.inc

tigetline	proto

ST_COUNT	equ 9

S_STYLE		STRUC
st_line		d? ?	; current line index
st_bp		dd ?	; current line adress
st_boff		d? ?	; offset start of visible line
st_bend		d? ?	; end of visible line
st_wbuf		d? ?	; screen buffer (int *)
st_type		DB ?	; current type
st_attr		DB ?	; current attrib
st_slen		d? ?	; length of line
st_string	d? ?	; offset of first word
st_quote_start	d? ?	; first " or ' in line
st_quote_end	d? ?	; last " or ' in line
S_STYLE		ENDS

	.data

format_label label size_t
	d? tidoattrib	; 1. A Attrib
	d? tidocontrol	; 2. O Control
	d? tidoquote	; 3. Q Quote
	d? tidonumber	; 4. D Digit
	d? tidochar	; 5. C Char
	d? tidostring	; 6. S String
	d? tidostart	; 7. B Begin
	d? tidoword	; 8. W Word
	d? tidonested	; 9. N Nested

	.code

tisetat:
	push	rax
	push	rbx
	mov	rax,rdi
	dec	rax   		; = offset in text line
	cmp	rax,[rbp].S_STYLE.st_boff
	jb	@F
	cmp	rax,[rbp].S_STYLE.st_bend
	ja	@F
	sub	rax,[rbp].S_STYLE.st_boff
	add	rax,rax
	mov	rbx,[rbp].S_STYLE.st_wbuf
	add	rbx,rax		; = offset in screen line (*int)
	mov	al,[rbp].S_STYLE.st_attr
	xchg	rbx,rbp
	mov	[rbp+1],al	; set attrib for this char
	mov	rbp,rbx
      @@:
	pop	rbx
	pop	rax
	ret

tisetlen:			; Set length of string in SI to BX
	push	rsi		; Increase SI if string[0] == '"'
	sub	rax,rax		; if string[0] == '"' AH = '"' on return
	mov	rbx,rax
	lodsb
	cmp	al,'"'
	jne	tisetlen_noquote
	mov	ah,al
    tisetlen_loop:
	lodsb
    tisetlen_noquote:
	test	al,al
	jz	@F
	cmp	al,'"'
	je	@F
	inc	rbx
	jmp	tisetlen_loop
      @@:
	pop	rsi
	cmp	ah,'"'
	jne	@F
	inc	rsi
      @@:
	test	rbx,rbx
	ret

tistrchr:			; scan for next char
	lodsb
	test	al,al
	jz	tistrchr_end
	repne	scasb
	je	@F
	test	rcx,rcx
	ret
      @@:
	test	al,al
    tistrchr_end:
	ret

ticmpi:			; scan for next char no case
	push	rbx
	lodsb
	test	al,al
	jz	ticmpi_nul
	call	isupper
	mov	bl,al
	jz	@F
	or	bl,20h
      @@:
	mov	al,PEDI
	inc	rdi
	call	isupper
	jz	@F
	or	al,20h
      @@:
	cmp	al,bl
    ticmpi_end:
	pop	rbx
	ret
    ticmpi_nul:
	or	bl,1
	jmp	ticmpi_end

tistrchri:			; scan for next char no case
	push	rbx
	lodsb
	test	al,al
	jz	tistrchri_end
	push	rax
	call	isupper
	mov	bl,al
	jz	tistrchri_scan
	or	bl,20h
    tistrchri_scan:
	mov	al,PEDI
	inc	rdi
	call	isupper
	jz	@F
	or	al,20h
      @@:
	cmp	al,bl
	je	@F
	dec	rcx
	jnz	tistrchri_scan
	pop	rax
	pop	rbx
	ret
      @@:
	pop	rax
	test	al,al
    tistrchri_end:
	pop	rbx
	ret

ticmpsbi:
	push	rcx
	push	rsi
	push	rdi
	push	rbx
	mov	rcx,rbx
    ticmpsbi_lup:
	lodsb
	mov	bl,PEDI
	inc	rdi
	cmp	ah,al		; AH == '"' or 0
	je	ticmpsbi_equal
	dec	rcx
	jz	ticmpsbi_end
	or	bl,20h
	or	al,20h
	cmp	al,bl
	je	ticmpsbi_lup
	xor	rcx,rcx
	jmp	ticmpsbi_end
    ticmpsbi_equal:
	inc	rcx
    ticmpsbi_end:
	pop	rbx
	pop	rdi
	pop	rsi
	pop	rcx
	ret

ticmpsb:
	push	rcx
	push	rsi
	push	rdi
	mov	rcx,rbx
	repe	cmpsb
	cmp	ah,[rsi-1]	; AH == '"' or 0
	je	ticmpsb_equal
	xor	rcx,rcx
	jmp	ticmpsb_end
    ticmpsb_equal:
	inc	rcx
    ticmpsb_end:
	pop	rdi
	pop	rsi
	pop	rcx
	ret

tistrstr:
	mov	rdi,rdx
	mov	rcx,[rbp].S_STYLE.st_slen

tistrstrdi:
	call	tisetlen
	jz	tistrstr_fail
	lodsb

tistrnext:
	repne	scasb
	je	@F
	test	rcx,rcx
	jz	tistrstr_fail
      @@:
	test	rcx,rcx
	jnz	@F
	mov	rcx,rbx
      @@:
	call	ticmpsb
	jz	tistrnext
	call	isquote
	jnz	tistrstr_fail
	test	al,al
	ret

tigetquote:
      ifdef __f__
	mov	al,[esi]
      else
	mov	al,es:[si]
      endif
	inc	rsi
	test	al,al
	jz	tigetquote_end
	cmp	al,"'"
	je	tigetquote_quote
	cmp	al,'"'
	jne	tigetquote
    tigetquote_quote:
	test	al,al
    tigetquote_end:
	ret

isquote:
	push	rsi
	push	rax
	mov	rax,rdi
	dec	rax
	cmp	rax,[rbp].S_STYLE.st_quote_end
	ja	isquote_00
	mov	rsi,[rbp].S_STYLE.st_quote_start
	cmp	rsi,rdi
	jae	isquote_00
    isquote_l1:
	call	tigetquote
	jz	isquote_00
	cmp	rdi,rsi
	jb	isquote_00
	mov	ah,al
    isquote_l2:
	call	tigetquote
	jz	isquote_01
	cmp	ah,al
	jne	isquote_l2
	cmp	rdi,rsi
	ja	isquote_l1
    isquote_01:
	test	rsi,rsi
	jmp	isquote_end
    isquote_00:
	xor	rax,rax
    isquote_end:
	pop	rax
	pop	rsi
	ret

; 01,attrib[,0,char],0,0

tidoattrib:
	mov	al,[rsi-1]
    ifdef __f__
	mov	ebx,tinfo
	mov	[ebx].S_TEDIT.ti_stat,al
    else
	mov	bx,ss:tinfo
	mov	ss:[bx].S_TEDIT.ti_stat,al
    endif
	mov	al,[rsi]
	test	al,al
	jz	tidoattrib_end
    ifdef __f__
	mov	[ebx].S_TEDIT.ti_stch,al
    else
	mov	ss:[bx].S_TEDIT.ti_stch,al
    endif
    tidoattrib_end:
	ret

; 05: <attrib>,<'chars'>,0,0

tidochar:
	mov	rdi,rdx
	mov	rcx,[rbp].S_STYLE.st_slen
	call	tistrchr
	jnz	tidochar_set
	or	al,al
	jnz	tidochar
	ret
    tidochar_scan:
	repne	scasb
	je	tidochar_set
	test	rcx,rcx
	jz	tidochar
    tidochar_set:
	call	isquote
	jnz	tidochar_scan
	call	tisetat
	jmp	tidochar_scan

tistrstr_fail:
	xor	al,al
	ret

; 03ATstring,0

tidostart:
	call	tistrstr
	jz	tidostart_end
    tidostart_set:
	call	tisetat
	mov	al,PEDI
	inc	rdi
	test	al,al
	jnz	tidostart_set
    tidostart_end:
	lodsb
	test	al,al
	jnz	tidostart_end
	cmp	[rsi],al
	jne	tidostart
	ret

; 04ATstring1,0,string2,0,0

MAXNLINES equ 3000

tifind	proc pascal string:size_t, line:size_t, max:size_t
	push	rsi
	push	rdi
	push	rbx
	call	tisetlen
	jz	tifind_end
	dec	line
    tifind_line:
	mov	rsi,string
	mov	al,[rsi]
	push16	ds
	push16	ss
	pop16	ds
if 0
;ifndef __f__
	; DX handle
	; AL char
	; CX line size
	; BX line
	mov di,tinfo
	.if dzemm && [di].S_TINFO.ti_flag & _T_EMMBUF
	    mov dx,[di].S_TEDIT.ti_emmh
	    mov cx,[di].S_TINFO.ti_bcol
	    mov di,line
	    xchg di,bx
	    mov ah,72h
	    int 67h
	    mov bx,di
	    test ah,ah
	    jnz @F
	    test ax,ax
	    jz tifind_notfound
	    mov ax,cx
	    .if bx == 1
		pop16 ds
		test bx,bx
		jmp tifind_end
	    .endif
	    mov line,ax
	.endif
	@@:
endif
	mov	rax,line
	call	tigetline
    tifind_notfound:
	pop16	ds
	jz	tifind_end
	push16	dx
	push	rax
	mov	rdi,rax
	call	strlen
	jz	tifind_next
	mov	rcx,rax
	add	rdi,rax
	dec	rdi
    tifind_scan:
	lodsb
	test	al,al
	jz	tifind_next
	std
	repne	scasb
	cld
	jne	tifind_next
	add	rdi,2
	mov	ah,0
	call	ticmpsb
	jnz	tifind_found
	sub	rdi,2
	dec	rsi
	jmp	tifind_scan
    tifind_next:
	dec	max
	jz	tifind_end
	dec	line
	jmp	tifind_line
    tifind_end:
	pop	rbx
	pop	rdi
	pop	rsi
	ret
    tifind_found:
	mov	rax,line
	mov	rdx,rdi
	dec	rdx
	inc	rbx
	jmp	tifind_end
tifind	endp

tinested:
	mov	rdi,rdx			; .st_bp
	push	rsi
	push	rdi
	push	rbx
	mov	rax,[rbp].S_STYLE.st_line
	test	rax,rax			; line index
	jz	tinested_end
	push	rsi			; find last start-string
	push	rax
	push	MAXNLINES
	call	tifind
	jz	tinested_notfound
	mov	rdi,rax			; match line
	mov	rbx,rdx			; match offset
    tinested_endword:
	lodsb
	test	al,al
	jnz	tinested_endword
	cmp	[rsi],al		; second word ?
	je	tinested_found		; start, no end - ok
	push	rsi			; DI end-string
	push	[rbp].S_STYLE.st_line
	push	MAXNLINES
	call	tifind
	jz	tinested_found		; start+end
	cmp	rax,rdi
	ja	tinested_notfound
	jb	tinested_found
	cmp	rdx,rbx
	ja	tinested_notfound
    tinested_found:			; open, find end..
	mov	rbx,1
	jmp	tinested_popl
    tinested_notfound:
	xor	rbx,rbx
    tinested_popl:
	mov	rax,[rbp].S_STYLE.st_line	; back to this line
	push16	ds
	push16	ss
	pop16	ds
	call	tigetline
	pop16	ds
	mov16	es,dx
	mov	rdx,rax
	test	rbx,rbx
    tinested_end:
	pop	rbx
	pop	rdi
	pop	rsi
	ret

stgetnextarg:
	lodsb
	test	al,al
	jnz	stgetnextarg
	ret

tidonested:
	call	tisetlen		; BX to length of first arg
	jz	tistrstr_fail
	call	tinested		; find start condition
	mov	rcx,[rbp].S_STYLE.st_slen	; CX to length of line
	jz	tidonested_line
	call	stgetnextarg
	jmp	tidonested_seek
    tidonested_next:
	mov	rsi,[rbp].S_STYLE.st_string
	mov	rcx,[rbp].S_STYLE.st_slen
	sub	rcx,rdi
	jle	tidonested_end
	call	tistrstrdi
	jz	tidonested_end
	jmp	tidonested_first
    tidonested_line:
	mov	rsi,[rbp].S_STYLE.st_string
	call	tistrstr
	jz	tidonested_end
    tidonested_first:
	call	tisetat
	lodsb
	test	al,al
	jz	tidonested_seek
	inc	rdi
	assert	cx,0,jne,"nested"
	dec	rcx
	jnz	tidonested_first
	call	tisetat
    tidonested_seek:
	test	rcx,rcx
	jz	tidonested_end
	lodsb
	test	al,al
	jz	tidonested_end
	push	rsi
	push	rdi
	call	tistrnext
	mov	rcx,rdi
	pop	rdi
	pop	rsi
	jz	tidonested_null
	sub	rcx,rdi
	jle	tidonested_end
    tidonested_pad:
	call	tisetat
	inc	rdi
	dec	rcx
	jnz	tidonested_pad
	add	rcx,rbx
	jz	tidonested_end
	dec	rdi
    tidonested_endtag:
	inc	rdi
	call	tisetat
	dec	rcx
	jnz	tidonested_endtag
    tidonested_end:
	cmp	rdi,[rbp].S_STYLE.st_slen
	jb	tidonested_next
	ret
    tidonested_null:
	dec	rdi
	mov	rcx,[rbp].S_STYLE.st_slen
	sub	rcx,rdi
	jg	tidonested_endtag
	jmp	tidonested_end

; 02FBstring1,0,string2,0,..,0

tiistart:		; test if di is the first char in a word
	push	rax	; di is match + 1, di-2 is char in front
	mov	rax,rdi
	dec	rax
	cmp	rax,WORDP [rbp].S_STYLE.st_bp
	je	tiistart_ok	; start of line
	assertf	jnb,"tiistart"
	mov	al,PEDI[-2]
	cmp	al,'_'
	je	@F
	call	getctype
	jz	tiistart_end
	and	ah,_UPPER or _LOWER or _DIGIT
	jz	tiistart_ok
      @@:
	sub	al,al
	jmp	tiistart_end
    tiistart_ok:
	inc	rax
    tiistart_end:
	pop	rax
	ret

tidoword:		; match on all equal words if not inside quote
	mov	rdi,rdx
	mov	rcx,[rbp].S_STYLE.st_slen
	call	tisetlen
	jz	tidoword_end
    tidoword_scan:
	call	tistrchri
	jnz	tidoword_set
      @@:
	test	al,al
	jz	@F
	lodsb
	jmp	@B
      @@:
	lodsb
	test	al,al
	jz	tidoword_end
	dec	rsi
	jmp	tidoword
    tidoword_find:
	dec	rsi
	jmp	tidoword_scan
    tidoword_set:
	call	ticmpsbi
	jz	tidoword_find
	push	rsi
	push	rbx
	push	rax
	call	isquote
	jnz	tidoword_pop	; = inside quote
	call	tiistart
	jz	tidoword_pop
	mov	al,PEBX[rdi-1]
	call	islabel
	jnz	tidoword_pop
      @@:
	call	tisetat
	inc	rdi
	dec	rbx
	jnz	@B
	dec	rdi
    tidoword_pop:
	pop	rax
	pop	rbx
	pop	rsi
	jmp	tidoword_find
    tidoword_end:
	ret

tidocontrol:		; match on all control chars
	mov	rdi,[rbp].S_STYLE.st_boff
    tidocontrol_loop:
	mov	al,PEDI
	inc	rdi
	test	al,al
	jz	tidocontrol_end
	call	getctype
	test	ah,ah
	jz	@F
	and	ah,_CONTROL
	jz	tidocontrol_next
	cmp	al,TITABCHAR
	je	tidocontrol_next
	cmp	al,9
	je	tidocontrol_next
     ifdef __f__
	mov	ebx,tinfo
	test	[ebx].S_TINFO.ti_flag,_T_SHOWTABS
     else
	mov	bx,ss:tinfo
	test	ss:[bx].S_TINFO.ti_flag,_T_SHOWTABS
     endif
	jz	tidocontrol_next
      @@:
	call	tisetat
    tidocontrol_next:
	cmp	rdi,[rbp].S_STYLE.st_bend
	jb	tidocontrol_loop
    tidocontrol_end:
	ret

tidostring:		; match on all equal strings if not inside quote
	mov	rdi,rdx
	mov	rcx,[rbp].S_STYLE.st_slen
	call	tisetlen
	jz	tidostring_end
	call	tistrchr
	jnz	tidostring_set
    tidostring_next:
	test	al,al
	jz	@F
	lodsb
	jmp	tidostring_next
      @@:
	lodsb
	test	al,al
	jz	tidostring_end
	dec	rsi
	jmp	tidostring
    tidostring_scan:
	repne	scasb
	test	rcx,rcx
	jz	tidostring_next
    tidostring_set:
	call	ticmpsb
	jz	tidostring_scan
	push	rsi
	push	rbx
	call	isquote
	jnz	tidostring_pop	; = inside quote
      @@:
	call	tisetat
	inc	rdi
	dec	rbx
	jnz	@B
	dec	rdi
    tidostring_pop:
	pop	rbx
	pop	rsi
	jmp	tidostring_scan
    tidostring_end:
	ret

tidoquote:		; match on '"' and "'", fail on "\"C\""
	mov	rdi,WORDP [rbp].S_STYLE.st_bp
    tidoquote_loop:
	mov	al,PEDI
	inc	rdi
	test	al,al
	jz	tidoquote_end
	call	isquote
	jz	@F
	call	tisetat
      @@:
	cmp	rdi,[rbp].S_STYLE.st_bend
	jb	tidoquote_loop
    tidoquote_end:
	ret

tidonumber:		; match on 0x 0123456789ABCDEF and Xh
	mov	rdi,[rbp].S_STYLE.st_boff
    tidonumber_loop:
	mov	al,PEDI
	inc	rdi
	call	getctype
	jz	tidonumber_end
	test	ah,_DIGIT
	jz	tidonumber_next
	call	isquote
	jnz	tidonumber_next
	call	tiistart
	jz	tidonumber_next
	mov	rsi,rdi
	cmp	al,'0'
	jne	@F
      ifdef __f__
	mov	al,[esi]
      else
	mov	al,es:[si]
      endif
	inc	rsi
	or	al,20h
	cmp	al,'x'
	je	@F
	dec	rsi
      @@:
      ifdef __f__
	mov	al,[esi]
      else
	mov	al,es:[si]
      endif
	inc	rsi
	call	getctype
	jz	tidonumber_set
	test	ah,_HEX
	jnz	@B
	or	al,20h
	cmp	al,'h'
	jne	@F
	inc	rsi
	jmp	tidonumber_set
      @@:
	and	ah,_UPPER or _LOWER
	jnz	tidonumber_next
    tidonumber_set:
	sub	rsi,rdi
      @@:
	call	tisetat
	inc	rdi
	dec	rsi
	jnz	@B
    tidonumber_next:
	cmp	rdi,[rbp].S_STYLE.st_bend
	jb	tidonumber_loop
    tidonumber_end:
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

tisetquote:	; "s\"C\"e"
	push	rsi
	xor	rax,rax
	mov	[rbp].S_STYLE.st_quote_start,rax
	mov	[rbp].S_STYLE.st_quote_end,rax
	mov	rsi,WORDP [rbp].S_STYLE.st_bp
	invoke	strlen,[rbp].S_STYLE.st_bp	; set ES:SI line
	mov	rcx,rax				; CX to eol
	add	rcx,rsi
    tisetquote_00:
	sub	rax,rax
	call	tigetquote
	jz	tisetquote_end
	mov	ah,al
	mov	rbx,rsi
	dec	rbx
	mov	[rbp].S_STYLE.st_quote_end,rcx
      @@:
	call	tigetquote
	jz	tisetquote_eof
	cmp	ah,al
	jne	@B
	cmp	rsi,rcx
	jbe	tisetquote_00
	mov     rax,rbx
	cmp	rax,rcx
	jnb	@F
	mov	rax,WORDP [rbp].S_STYLE.st_bp
      @@:
	mov	[rbp].S_STYLE.st_quote_start,rax
	mov	rbx,rsi
      @@:
	call	tigetquote
	jz	@F
	mov	rbx,rsi
	jmp	@B
      @@:
	mov	rax,rbx
	dec	rax
	mov	[rbp].S_STYLE.st_quote_end,rax
    tisetquote_end:
	pop	rsi
	ret
    tisetquote_eof:
	mov	rax,WORDP [rbp].S_STYLE.st_bp
	mov	[rbp].S_STYLE.st_quote_start,rax
	jmp	tisetquote_end

ifdef __f__
tistyle proc
else
tistyle PROC PASCAL public
endif
local	style:S_STYLE
	push	rsi
	push	rdi
	push	rbp
	push16	ds
	lea	rbp,style
	mov	[rbp].S_STYLE.st_line,rbx		; line id
	mov	WORDP [rbp].S_STYLE.st_bp,rax		; pointer to line
	mov16	word ptr [rbp].S_STYLE.st_bp[2],rdi
	mov	[rbp].S_STYLE.st_wbuf,rdx		; output buffer (*int) (SS)
	mov     [rbp].S_STYLE.st_slen,rcx		; length of line
	add	rax,[rsi].S_TINFO.ti_boff		; start of line
	mov     [rbp].S_STYLE.st_boff,rax
	mov	rdx,rax
	add	rax,rcx
	add	rdx,TIMAXSCRLINE
	cmp	rax,rdx
	jb	@F
	mov	rax,rdx
	dec	rax
      @@:
	mov	[rbp].S_STYLE.st_bend,rax		; end of line
	mov	rsi,tinfo
	LPDS	rsi,[rsi].S_TEDIT.ti_style		; DS:SI style
	test	rsi,rsi
	jz	tistyle_end
	call	tisetquote
    tistyle_loop:
	lodsw
	mov	[rbp].S_STYLE.st_attr,ah
	mov	[rbp].S_STYLE.st_type,al
	test	al,al
	je	tistyle_end
	mov	ah,0
	dec	rax
	cmp	al,ST_COUNT
	jnb	tistyle_end
	add	rax,rax
	mov	rdi,rax
	mov	[rbp].S_STYLE.st_string,rsi
	mov	rdx,WORDP [rbp].S_STYLE.st_bp
	push	rsi
     ifdef __f__
	call	format_label[edi]
     else
	call	ss:format_label[di]
     endif
	pop	rsi
      @@:
	lodsb
	test	al,al
	jnz	@B
	lodsb
	test	al,al
	jnz	@B
	jmp	tistyle_loop
    tistyle_end:
	pop16	ds
	pop	rbp
	pop	rdi
	pop	rsi
	ret
tistyle ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; 1. Attrib	A -	Set background and forground color
; 2. Control	O -	Set color of CONTROL characters
; 3. Quote	Q -	Set color of quoted text
; 4. Digit	D -	Set color of numbers
; 5. Char	C -	Set color of chars
; 6. String	S -	Set color of string
; 7. Begin	B -	Set color from start of string
; 8. Word	W -	Set color of words
; 9. Nested	N -	Set color of nested strings
;
	.data
	cp_defaultfile	db 'Styletype.*',0	; *.asm, *.c, ...
	cp_typech	db 'aoqdcsbwn',0

ID_TYPE		equ 0
ID_ATTRIB	equ 1

ST_ATTRIB	equ 1	; attrib	<at> [<char>]
ST_CHAR		equ 2	; char		<at> <chars>
ST_WORD		equ 3	; word		<at> <words> ...
ST_START	equ 4	; start		<at> <string>
ST_NESTED	equ 5	; nested	<at> <string1> <string2>
ST_CONTROL	equ 6	; control	<at>
;ST_STRING	equ 7	; string	<at> <string>
ST_QUOTE	equ 8	; quote		<at>
ST_NUMBER	equ 9	; number	<at>
ST_COUNT	equ ST_NUMBER

S_RDST		STRUC
st_section	db 64 dup(?)
st_label	db 64 dup(?)
st_sp		dd ?
st_eof		d? ?	; style + SIZE style - 2
st_style	db STYLESIZE dup(?)
S_RDST		ENDS

	.code

tireadlabel:
	push	rsi
	push	rdi
	lea	rsi,[rbp].S_RDST.st_label
      ifdef __f__
	invoke	inientryid,esi,ID_TYPE
      else
	invoke	inientryid,ss::si,ID_TYPE
      endif
	jz	tireadlabel_end
	LPES	rdi,[rbp].S_RDST.st_sp
	cmp	rdi,[rbp].S_RDST.st_eof
	ja	tireadlabel_end
	mov	rbx,rax
	mov	ah,[rbx]
	or	ah,20h
	xor	rcx,rcx
	xchg	rcx,rbx
      @@:
	mov	al,cp_typech[rbx]
	cmp	al,ah
	je	@F
	inc	rbx
	test	al,al
	jnz	@B
	jmp	tireadlabel_end
      @@:
	mov	al,bl
	inc	al
	mov	rbx,rcx
	stosb
	mov	ah,0
	mov	rsi,rax
	xor	rcx,rcx
      @@:
	inc	rbx
	mov	al,[rbx]
	call	islabel
	jnz	@B
	push	rsi
	mov	rsi,rbx
    tireadlabel_loop:
	lodsb
	cmp	al,' '
	jne	@F
	mov	rax,rsi
	pop	rsi
	jmp	tireadlabel_attrib
      @@:
	test	al,al
	jnz	tireadlabel_loop
	pop	rsi
	push16	es
	invoke	inientryid,ssbx,ID_ATTRIB
	pop16	es
	mov	rcx,1
	jz	tireadlabel_break
    tireadlabel_attrib:
	mov	rbx,rax
	add	rax,2
	push	rax
	mov	rax,[rbx]
	or	rax,2020h
	cmp	al,'x'
	jne	tireadlabel_bg
	mov	al,ah
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
      @@:
	mov	rbx,tinfo
	mov	ah,[rbx].S_TEDIT.ti_stat
	and	ah,0F0h
	or	al,ah
	jmp	tireadlabel_stoat
    tireadlabel_getat:
	push16	es
	push	rcx
      ifdef __f__
	invoke	xtol,ebx
      else
	invoke	xtol,dx::bx
      endif
	pop	rcx
	pop16	es
	jmp	tireadlabel_stoat
    tireadlabel_bg:
	cmp	ah,'x'
	jne	tireadlabel_getat
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
      @@:
	shl	al,4
	mov	rbx,tinfo
	mov	ah,[rbx].S_TEDIT.ti_stat
	and	ah,0Fh
	or	al,ah
    tireadlabel_stoat:
	stosb
	pop	rbx
      @@:
	mov	ah,[rbx]
	inc	rbx
	cmp	ah,' '
	je	@B
	dec	rbx
	cmp	rsi,ST_ATTRIB
	je	tireadlabel_char
	mov	rsi,rcx
	inc	rsi
	mov	rax,rbx
	jmp	tireadlabel_start
    tireadlabel_label:
	cmp	rsi,100
	je	tireadlabel_break
	mov	rdx,rsi
	inc     rsi
	push16	es
	invoke	inientryid,addr [rbp].S_RDST.st_label,rdx
	pop16	es
	jz	tireadlabel_break
    tireadlabel_start:
	mov	rbx,rsi
	mov	rcx,[rbp].S_RDST.st_eof
	mov	rsi,rax
	cmp	byte ptr [rsi],0
	je	tireadlabel_endcopy
    tireadlabel_copy:
	lodsb
	cmp	rdi,rcx
	jae	tireadlabel_endcopy
	cmp	al,' '
	jne	@F
	mov	al,0
	stosb
	jmp	tireadlabel_copy
      @@:
	stosb
	test	al,al
	jnz	tireadlabel_copy
    tireadlabel_endcopy:
	mov	rsi,rbx
	jmp	tireadlabel_label
    tireadlabel_char:
	mov	rsi,tinfo
	mov	[rsi].S_TEDIT.ti_stat,al
	test	ah,ah
	jz	tireadlabel_break
	push16	es
	invoke	xtol,ssbx
	pop16	es
	mov	[rsi].S_TEDIT.ti_stch,al
	stosb
    tireadlabel_break:
	sub	rax,rax
	cmp	PEDI[-1],al
	je	@F
	stosb
      @@:
	stosb
	mov	WORDP [rbp].S_RDST.st_sp,rdi
	inc	rax
    tireadlabel_end:
	pop	rdi
	pop	rsi
	ret

tidosection:
	push	rsi
	push	rdi
	sub	rsp,64
	mov	rdi,rsp
	invoke	memcpy,ssdi,addr [rbp].S_RDST.st_section,64
	xor	rsi,rsi
    tidosection_do:
	mov	rdx,rsi
	inc     rsi
	invoke	inientryid,addr [rbp].S_RDST.st_section,rdx
	jz	tidosection_end
	mov	rdi,rax
	mov	al,[rdi]
	cmp	al,'['
	jne	tidosection_label
	mov	rbx,rsi
	mov	rdx,rdi
	mov	rsi,rdi
	inc	rsi
	lea	rdi,[rbp].S_RDST.st_section
      @@:
	lodsb
	stosb
	test	al,al
	jz	@F
	cmp	al,']'
	jne	@B
      @@:
	dec	rdi
	sub	rax,rax
	stosb
	mov	rsi,rbx
	mov	rdi,rdx
	call	tidosection
	mov	rdx,rsp
      ifdef __f__
	invoke	memcpy,addr [ebp].S_RDST.st_section,edx,64
      else
	invoke	memcpy,addr [bp].S_RDST.st_section,ss::dx,64
      endif
	jmp	tidosection_do
    tidosection_label:
	lea	rax,[rbp].S_RDST.st_label
      ifdef __f__
	invoke	strcpy,eax,edi
      else
	invoke	strcpy,dx::ax,dx::di
      endif
	call	tireadlabel
	jmp	tidosection_do
    tidosection_end:
	add	rsp,64
	pop	rdi
	pop	rsi
	ret

ifdef __f__
tireadstyle proc
else
tireadstyle PROC PASCAL public
endif
local	rdst:S_RDST
	push	rsi
	push	rdi
	push	rbx
	push	rbp
	lea	rbp,rdst
	lea	rax,[rbp].S_RDST.st_style
	mov	WORDP [rbp].S_RDST.st_sp,rax
	mov16	word ptr [bp].S_RDST.st_sp[2],ss
	push16	ss
	pop16	es
	mov	rdi,rax
	add	rax,STYLESIZE-4
	mov	[rbp].S_RDST.st_eof,rax
	xor	rax,rax
	cld?
	mov	rcx,STYLESIZE/2
	rep	stosw
	mov	rsi,offset cp_defaultfile
	lea	rdi,[rbp].S_RDST.st_section
	push16	ss
	pop16	es
	mov	rcx,11
	rep	movsb
	mov	rsi,tinfo
	dec	rdi
	invoke	strfn,[rsi].S_TEDIT.ti_file	; name || name.ext
	invoke	strcpy,ssdi,dxax
	lea	rax,[rbp].S_RDST.st_section
	invoke	inientryid,dxax,0
	jnz	tireadstyle_do
	invoke	strext,[rsi].S_TEDIT.ti_file	; *.ext
	jz	@F
	mov	byte ptr [rdi],'*'
	inc	rdi
	invoke	strcpy,ssdi,dxax
	invoke	inientryid,addr [rbp].S_RDST.st_section,0
	jnz	tireadstyle_do
      @@:
	invoke	strcpy,addr [rbp].S_RDST.st_section,addr cp_defaultfile
    tireadstyle_do:
	call	tidosection
	LPES	rdi,[rbp].S_RDST.st_sp
	xor	rax,rax
	stosw
	lea	rsi,[rbp].S_RDST.st_style
	sub	rdi,rsi
	cmp	rdi,STYLESIZE
	ja	tireadstyle_end
	invoke	malloc,rdi
	mov	rbx,tinfo
	stom	[rbx].S_TEDIT.ti_style
	test	rax,rax
	jz	tireadstyle_end
	invoke	memcpy,dxax,dssi,rdi
    tireadstyle_end:
	pop	rbp
	pop	rbx
	pop	rdi
	pop	rsi
	ret
tireadstyle ENDP
endif
	END
